<?php
// api/status.php - Return real-time account connection status (JSON)
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';

require_login(); // Enforce session login

header('Content-Type: application/json');

// Fetch active accounts
$stmt = $pdo->query("SELECT id, host, port, encryption, username, password_encrypted FROM accounts WHERE active = 1");
$accounts = $stmt->fetchAll();

$results = [];

foreach ($accounts as $acc) {
    $password = decrypt_data($acc['password_encrypted']);
    
    $status = 'inactive';
    $error = '';

    if ($password !== false && $password !== null) {
        // Build mailbox string
        $mailbox = '{' . $acc['host'] . ':' . $acc['port'] . '/imap/' . $acc['encryption'] . '/novalidate-cert}INBOX';
        
        // Timeout 5 seconds to prevent hanging
        $connection = @imap_open($mailbox, $acc['username'], $password, 0, 1);
        
        if ($connection) {
            $status = 'active';
            imap_close($connection);
        } else {
            $error = imap_last_error();
            // Optional: log persistent errors
            if (strpos($error, 'authentication failed') !== false) {
                log_action('error', "Authentication failed for account #{$acc['id']}", $acc['id']);
            }
        }
    }

    $results[] = [
        'id' => (int)$acc['id'],
        'username' => htmlspecialchars($acc['username']),
        'status' => $status
    ];
}

// Output JSON
echo json_encode($results);
exit;