<?php
// api/test_account.php - Robust IMAP Connection Test for All Servers
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/functions.php';

// Prevent any accidental HTML output
ob_clean();
header('Content-Type: application/json');
http_response_code(200);

require_login();

$response = ['success' => false, 'message' => 'Invalid request'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $host = trim($_POST['host'] ?? '');
    $port = (int)($_POST['port'] ?? 993);
    $encryption = strtolower($_POST['encryption'] ?? 'ssl');
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($host) || empty($username) || empty($password)) {
        $response['message'] = 'Host, username, and password are required.';
    } else {

        // FIXED: Removed invalid spaces inside mailbox strings
        $variants = [
            "{{$host}:{$port}/imap/{$encryption}/novalidate-cert}INBOX",
            "{{$host}:{$port}/imap/{$encryption}}INBOX",
            "{{$host}:{$port}/imap/{$encryption}/novalidate-cert}Inbox",
            "{{$host}:{$port}/imap/{$encryption}}Inbox",
            "{{$host}:{$port}/imap/{$encryption}/novalidate-cert}",
            "{{$host}:{$port}/imap/{$encryption}}",
            "{{$host}:{$port}/imap/notls/novalidate-cert}INBOX",
            "{{$host}:{$port}/imap/notls}INBOX",
        ];

        $connected = false;
        $last_error = '';

        foreach ($variants as $mailbox) {

            $conn = @imap_open($mailbox, $username, $password, OP_HALFOPEN, 1);

            if ($conn) {
                imap_close($conn);

                $connected = true;
                $response = [
                    'success' => true,
                    'message' => "Connection successful using: $mailbox"
                ];
                break;
            } else {
                $last_error = imap_last_error();
            }
        }

        if (!$connected) {
            $response['message'] =
                "All connection attempts failed. Last error: " . htmlspecialchars($last_error);
            $response['debug'] = "Tried: " . implode(', ', $variants);
        }
    }
}

echo json_encode($response);
exit;
