<?php
ob_start();
session_start();

if (empty($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    ob_end_clean();
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Login required']);
    exit;
}

require_once '../config.php';
require_once '../includes/PHPMailer/PHPMailer.php';
require_once '../includes/PHPMailer/SMTP.php';
require_once '../includes/PHPMailer/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;

function json($data) {
    ob_end_clean();
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    json(['success' => false, 'message' => 'POST only']);
}

// Get all fields
$host            = trim($_POST['host'] ?? '');
$port            = (int)($_POST['port'] ?? 587);
$encryption      = strtolower(trim($_POST['encryption'] ?? 'tls'));
$username        = trim($_POST['username'] ?? '');
$password        = $_POST['password'] ?? '';
$sender_name     = trim($_POST['sender_name'] ?? 'SMTP Test');
$sender_email    = trim($_POST['sender_email'] ?? $username);
$test_recipient  = trim($_POST['test_recipient'] ?? '');

if (empty($host) || empty($test_recipient)) {
    json(['success' => false, 'message' => 'Host and test recipient are required']);
}

$mail = new PHPMailer(true);

// HOSTINGER RELAY BYPASS
$mail->SMTPOptions = [
    'ssl' => [
        'verify_peer' => false,
        'verify_peer_name' => false,
        'allow_self_signed' => true
    ]
];
$mail->SMTPAutoTLS = false;

try {
    $mail->isSMTP();
    $mail->Host       = $host;
    $mail->Port       = $port;
    $mail->SMTPAuth   = !empty($username);
    $mail->Username   = $username;
    $mail->Password   = $password;

    // Encryption
    if ($encryption === 'ssl') {
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
    } elseif ($encryption === 'tls') {
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    } else {
        $mail->SMTPSecure = '';
    }

    // Sender
    $mail->setFrom($sender_email, $sender_name);
    $mail->addReplyTo($sender_email, $sender_name);

    // Recipient
    $mail->addAddress($test_recipient);

    $mail->isHTML(true);
    $mail->Subject = 'SMTP Test - Your Configuration Works!';
    $mail->Body    = "
        <h2>SMTP Test Successful!</h2>
        <p>Your SMTP settings are working perfectly.</p>
        <hr>
        <p><strong>Sent from:</strong> {$sender_name} &lt;{$sender_email}&gt;<br>
        <strong>SMTP Server:</strong> {$host}:{$port} ({$encryption})</p>
        <p><small>Sent at: " . date('Y-m-d H:i:s') . "</small></p>
    ";
    $mail->AltBody = "SMTP Test Successful!\nSent from: {$sender_name} <{$sender_email}>";

    $mail->send();

    json([
        'success' => true,
        'message' => 'Test email sent successfully to ' . htmlspecialchars($test_recipient) . '!'
    ]);

} catch (Exception $e) {
    json([
        'success' => false,
        'message' => $mail->ErrorInfo ?: $e->getMessage()
    ]);
}