// assets/js/script.js - Theme, Sidebar, AJAX Helpers

document.addEventListener('DOMContentLoaded', function () {
    // Theme Toggle
    const themeToggle = document.getElementById('themeToggle');
    const themeIcon = document.getElementById('themeIcon');
    const body = document.body;

    const savedTheme = localStorage.getItem('theme') || 'light';
    if (savedTheme === 'dark') {
        body.classList.add('dark-mode');
        themeIcon.classList.replace('bi-moon-stars-fill', 'bi-sun-fill');
    }

    themeToggle.addEventListener('click', () => {
        body.classList.toggle('dark-mode');
        const isDark = body.classList.contains('dark-mode');
        themeIcon.classList.toggle('bi-moon-stars-fill', !isDark);
        themeIcon.classList.toggle('bi-sun-fill', isDark);
        localStorage.setItem('theme', isDark ? 'dark' : 'light');
    });

    // Sidebar Toggle
    const sidebarToggle = document.getElementById('sidebarToggle');
    if (sidebarToggle) {
        sidebarToggle.addEventListener('click', event => {
            event.preventDefault();
            body.classList.toggle('sb-sidenav-toggled');
            localStorage.setItem('sb|sidebar-toggle', body.classList.contains('sb-sidenav-toggled'));
        });

        // Restore sidebar state
        if (localStorage.getItem('sb|sidebar-toggle') === 'true') {
            body.classList.add('sb-sidenav-toggled');
        }
    }

    // DataTables Default Config
    if (typeof $.fn.DataTable !== 'undefined') {
        $.extend(true, $.fn.dataTable.defaults, {
            language: { emptyTable: "No data available" },
            pageLength: 10,
            lengthMenu: [10, 25, 50, 100],
            responsive: true
        });
    }
});