<?php
// forwards.php - Manage Forwarding Email Addresses
require_once 'config.php';
require_once 'includes/db.php';
require_once 'includes/functions.php';
require_once 'includes/header.php';

$message = '';

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    if ($action === 'add') {
        $email = filter_var(trim($_POST['email'] ?? ''), FILTER_VALIDATE_EMAIL);
        if ($email) {
            $stmt = $pdo->prepare("INSERT IGNORE INTO forwards (email) VALUES (?)");
            $stmt->execute([$email]);
            $message = '<div class="alert alert-success">Forward email added!</div>';
        } else {
            $message = '<div class="alert alert-danger">Invalid email address.</div>';
        }
    } elseif ($action === 'delete') {
        $id = (int)$_POST['id'];
        $stmt = $pdo->prepare("DELETE FROM forwards WHERE id = ?");
        $stmt->execute([$id]);
        $message = '<div class="alert alert-success">Forward email removed.</div>';
    }
}

// Fetch forwards
$forwards = $pdo->query("SELECT * FROM forwards ORDER BY id DESC")->fetchAll();
?>

<h1 class="mt-4"><i class="bi bi-forward"></i> Forward To</h1>
<ol class="breadcrumb mb-4">
    <li class="breadcrumb-item"><a href="index.php">Dashboard</a></li>
    <li class="breadcrumb-item active">Forward To</li>
</ol>

<?= $message ?>

<div class="card mb-4">
    <div class="card-header">
        <i class="bi bi-plus-circle"></i> Add Forwarding Email
    </div>
    <div class="card-body">
        <form method="post" class="row g-3">
            <input type="hidden" name="action" value="add">
            <div class="col-md-8">
                <input type="email" name="email" class="form-control" placeholder="destination@example.com" required>
            </div>
            <div class="col-md-4">
                <button type="submit" class="btn btn-primary w-100">Add Email</button>
            </div>
        </form>
    </div>
</div>

<div class="card mb-4">
    <div class="card-header">
        <i class="bi bi-list-ul"></i> Current Forwarding Addresses (<?= count($forwards) ?>)
    </div>
    <div class="card-body">
        <?php if ($forwards): ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Email</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($forwards as $fwd): ?>
                            <tr>
                                <td><?= htmlspecialchars($fwd['email']) ?></td>
                                <td>
                                    <form method="post" class="d-inline">
                                        <input type="hidden" name="action" value="delete">
                                        <input type="hidden" name="id" value="<?= $fwd['id'] ?>">
                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Remove this email?')">
                                            <i class="bi bi-trash"></i> Remove
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p class="text-muted text-center">No forwarding emails configured yet.</p>
        <?php endif; ?>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>