<?php
// health_checker.php - Check account connections and disable if failed
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/functions.php';

if (php_sapi_name() !== 'cli') {
    die('CLI only');
}

$accounts = $pdo->query("SELECT * FROM accounts WHERE active = 1")->fetchAll();

foreach ($accounts as $acc) {
    $pass = decrypt_data($acc['password_encrypted']);
    if (!$pass) continue;

    $mailbox = '{' . $acc['host'] . ':' . $acc['port'] . '/imap/' . $acc['encryption'] . '/novalidate-cert}INBOX';
    $conn = @imap_open($mailbox, $acc['username'], $pass, 0, 1);

    if (!$conn) {
        $error = imap_last_error();
        log_action('error', "Health check failed - disabling account: $error", $acc['id']);
        $pdo->prepare("UPDATE accounts SET active = 0 WHERE id = ?")->execute([$acc['id']]);
    } else {
        imap_close($conn);
    }
}

echo "Health check completed\n";