<?php
// includes/db.php - Secure Database Connection
if (!defined('BASE_URL')) {
    // Prevent direct access
    http_response_code(403);
    die('Direct access not permitted');
}

try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES   => false,
        ]
    );
} catch (PDOException $e) {
    // In production, never expose raw error
    error_log("Database Connection Failed: " . $e->getMessage());
    die('<h3>Database connection failed. Check your config.</h3>');
}
?>