<?php
// includes/header.php - Dashboard Header & Sidebar (FIXED + CLEANED)
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/functions.php';
require_login(); // Force login
secure_session_start();
$current_page = basename($_SERVER['SCRIPT_NAME']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Forwarder Panel</title>
    
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
    <!-- DataTables -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/style.css">
</head>
<body class="sb-nav-fixed">  <!-- Proper fixed layout -->

    <!-- Top Navbar (Fixed) -->
    <nav class="sb-topnav navbar navbar-expand navbar-dark bg-dark fixed-top">
        <a class="navbar-brand ps-3" href="<?= BASE_URL ?>index.php">
            <i class="bi bi-envelope-arrow-up"></i> Forwarder Panel
        </a>
        
        <!-- Sidebar Toggle Button -->
        <button class="btn btn-link btn-sm order-1 order-lg-0 me-4 me-lg-0 text-white" id="sidebarToggle">
            <i class="bi bi-list fs-4"></i>
        </button>

        <!-- Right Side: User + Theme Toggle -->
        <ul class="navbar-nav ms-auto me-3">
            <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle text-white" id="navbarDropdown" href="#" role="button" data-bs-toggle="dropdown">
                    <i class="bi bi-person-circle"></i> <?= htmlspecialchars($_SESSION['username'] ?? 'Admin') ?>
                </a>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="<?= BASE_URL ?>logout.php">
                        <i class="bi bi-box-arrow-right"></i> Logout
                    </a></li>
                </ul>
            </li>
        </ul>

        <!-- Theme Toggle -->
        <button class="btn btn-outline-light me-3" id="themeToggle">
            <i class="bi bi-moon-stars-fill" id="themeIcon"></i>
        </button>
    </nav>

    <!-- Sidebar + Main Content Layout -->
    <div id="layoutSidenav">
        <!-- Left Sidebar (Fixed) -->
        <div id="layoutSidenav_nav">
            <nav class="sb-sidenav accordion sb-sidenav-dark" id="sidenavAccordion">
                <div class="sb-sidenav-menu">
                    <div class="nav">
                        <!-- Core -->
                        <div class="sb-sidenav-menu-heading">Core</div>
                        <a class="nav-link <?= $current_page === 'index.php' ? 'active' : '' ?>" href="<?= BASE_URL ?>index.php">
                            <div class="sb-nav-link-icon"><i class="bi bi-speedometer2"></i></div>
                            Dashboard
                        </a>

                        <!-- Configuration -->
                        <div class="sb-sidenav-menu-heading">Configuration</div>
                        <a class="nav-link <?= $current_page === 'accounts.php' ? 'active' : '' ?>" href="<?= BASE_URL ?>accounts.php">
                            <div class="sb-nav-link-icon"><i class="bi bi-mailbox2"></i></div>
                            Accounts
                        </a>
                        <a class="nav-link <?= $current_page === 'smtps.php' ? 'active' : '' ?>" href="<?= BASE_URL ?>smtps.php">
                            <div class="sb-nav-link-icon"><i class="bi bi-send"></i></div>
                            SMTP Config
                        </a>
                        <a class="nav-link <?= $current_page === 'forwards.php' ? 'active' : '' ?>" href="<?= BASE_URL ?>forwards.php">
                            <div class="sb-nav-link-icon"><i class="bi bi-forward"></i></div>
                            Forward To
                        </a>

                        <!-- Monitoring -->
                        <div class="sb-sidenav-menu-heading">Monitoring</div>
                        <a class="nav-link <?= $current_page === 'logs.php' ? 'active' : '' ?>" href="<?= BASE_URL ?>logs.php">
                            <div class="sb-nav-link-icon"><i class="bi bi-journal-text"></i></div>
                            Logs
                        </a>
                        <a class="nav-link <?= $current_page === 'settings.php' ? 'active' : '' ?>" href="<?= BASE_URL ?>settings.php">
                            <div class="sb-nav-link-icon"><i class="bi bi-gear"></i></div>
                            Settings
                        </a>
                    </div>
                </div>
                <!-- REMOVED: sb-sidenav-footer (duplicate "Logged in as") -->
            </nav>
        </div>

        <!-- Main Content Area -->
        <div id="layoutSidenav_content">
            <main class="container-fluid px-4 pt-4">  <!-- pt-4 for padding under fixed navbar -->