<?php
// logout.php - Secure Logout
require_once 'config.php';
require_once 'includes/functions.php';

secure_session_start();

// Log the logout
if (isset($_SESSION['username'])) {
    log_action('info', "User logged out: " . $_SESSION['username']);
}

// Destroy session
$_SESSION = [];
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}
session_destroy();

// Redirect to login
redirect('login.php');
?>