<?php
// smtps.php - YOUR ORIGINAL DESIGN + SENDER NAME + SENDER EMAIL + TEST RECIPIENT
require_once 'config.php';
require_once 'includes/db.php';
require_once 'includes/functions.php';
require_once 'includes/header.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require_once 'includes/PHPMailer/PHPMailer.php';
require_once 'includes/PHPMailer/SMTP.php';
require_once 'includes/PHPMailer/Exception.php';

$message = '';

// Handle rotation type change
if (isset($_POST['rotation_type'])) {
    $type = in_array($_POST['rotation_type'], ['round-robin', 'random', 'failover']) ? $_POST['rotation_type'] : 'round-robin';
    save_setting('rotation_type', $type);
    $message = '<div class="alert alert-success">SMTP rotation type updated to ' . htmlspecialchars($type) . '</div>';
}

// Handle form actions
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    $action = $_POST['action'];
    if ($action === 'add' || $action === 'edit') {
        $id              = (int)($_POST['id'] ?? 0);
        $host            = trim($_POST['host'] ?? '');
        $port            = (int)($_POST['port'] ?? 587);
        $encryption      = $_POST['encryption'] ?? 'tls';
        $username        = trim($_POST['username'] ?? '');
        $password        = $_POST['password'] ?? '';
        $sender_name     = trim($_POST['sender_name'] ?? 'Forwarder');
        $sender_email    = trim($_POST['sender_email'] ?? $username);
        $test_recipient  = trim($_POST['test_recipient'] ?? '');

        if (empty($host) || empty($port) || empty($test_recipient)) {
            $message = '<div class="alert alert-danger">Host, port and test recipient are required.</div>';
        } else {
            $encrypted_pass = !empty($password) ? encrypt_data($password) : null;

            if ($action === 'add') {
                $stmt = $pdo->prepare("INSERT INTO smtps 
                    (host, port, encryption, username, password_encrypted, sender_name, sender_email, test_recipient) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt->execute([$host, $port, $encryption, $username, $encrypted_pass, $sender_name, $sender_email, $test_recipient]);
                $message = '<div class="alert alert-success">SMTP added successfully!</div>';
            } elseif ($action === 'edit' && $id > 0) {
                if ($encrypted_pass) {
                    $stmt = $pdo->prepare("UPDATE smtps SET host=?, port=?, encryption=?, username=?, password_encrypted=?, 
                        sender_name=?, sender_email=?, test_recipient=? WHERE id=?");
                    $stmt->execute([$host, $port, $encryption, $username, $encrypted_pass, $sender_name, $sender_email, $test_recipient, $id]);
                } else {
                    $stmt = $pdo->prepare("UPDATE smtps SET host=?, port=?, encryption=?, username=?, 
                        sender_name=?, sender_email=?, test_recipient=? WHERE id=?");
                    $stmt->execute([$host, $port, $encryption, $username, $sender_name, $sender_email, $test_recipient, $id]);
                }
                $message = '<div class="alert alert-success">SMTP updated successfully!</div>';
            }
        }
    } elseif ($action === 'toggle') {
        $id = (int)$_POST['id'];
        $active = (int)$_POST['active'];
        $stmt = $pdo->prepare("UPDATE smtps SET active = ? WHERE id = ?");
        $stmt->execute([$active ? 0 : 1, $id]);
        $message = '<div class="alert alert-success">SMTP status updated.</div>';
    } elseif ($action === 'delete') {
        $id = (int)$_POST['id'];
        $stmt = $pdo->prepare("DELETE FROM smtps WHERE id = ?");
        $stmt->execute([$id]);
        $message = '<div class="alert alert-success">SMTP deleted.</div>';
    }
}

$smtps = $pdo->query("SELECT * FROM smtps ORDER BY id DESC")->fetchAll();
$rotation_type = get_setting('rotation_type', 'round-robin');
?>
<h1 class="mt-4">SMTP Configuration</h1>
<ol class="breadcrumb mb-4">
    <li class="breadcrumb-item"><a href="index.php">Dashboard</a></li>
    <li class="breadcrumb-item active">SMTP Config</li>
</ol>
<?= $message ?>

<div class="row">
    <div class="col-lg-6">
        <div class="card mb-4">
            <div class="card-header">SMTP Rotation Settings</div>
            <div class="card-body">
                <form method="post">
                    <label class="form-label">Rotation Type</label>
                    <select name="rotation_type" class="form-select mb-3">
                        <option value="round-robin" <?= $rotation_type === 'round-robin' ? 'selected' : '' ?>>Round-Robin</option>
                        <option value="random" <?= $rotation_type === 'random' ? 'selected' : '' ?>>Random</option>
                        <option value="failover" <?= $rotation_type === 'failover' ? 'selected' : '' ?>>Failover (try in order)</option>
                    </select>
                    <button type="submit" class="btn btn-primary">Save Rotation Type</button>
                </form>
                <small class="text-muted mt-3 d-block">
                    <strong>Note:</strong> A default fallback (PHP mail() or direct send) is always available if no SMTP is active.
                </small>
            </div>
        </div>
    </div>
</div>

<div class="card mb-4">
    <div class="card-header">
        Add SMTP Server
        <button class="btn btn-primary float-end" data-bs-toggle="modal" data-bs-target="#smtpModal">Add SMTP</button>
    </div>
</div>

<!-- SMTP Table -->
<div class="card mb-4">
    <div class="card-header">Configured SMTP Servers</div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover" id="smtpsTable">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Host</th>
                        <th>Port</th>
                        <th>Username</th>
                        <th>Sender Name</th>
                        <th>Sender Email</th>
                        <th>Test Recipient</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($smtps as $smtp): ?>
                        <tr>
                            <td><?= $smtp['id'] ?></td>
                            <td><?= htmlspecialchars($smtp['host']) ?></td>
                            <td><?= $smtp['port'] ?> (<?= strtoupper($smtp['encryption']) ?>)</td>
                            <td><?= htmlspecialchars($smtp['username'] ?? 'No Auth') ?></td>
                            <td><?= htmlspecialchars($smtp['sender_name'] ?? '-') ?></td>
                            <td><?= htmlspecialchars($smtp['sender_email'] ?? '-') ?></td>
                            <td><?= htmlspecialchars($smtp['test_recipient'] ?? '-') ?></td>
                            <td>
                                <form method="post" class="d-inline">
                                    <input type="hidden" name="action" value="toggle">
                                    <input type="hidden" name="id" value="<?= $smtp['id'] ?>">
                                    <input type="hidden" name="active" value="<?= $smtp['active'] ?>">
                                    <button type="submit" class="btn btn-sm <?= $smtp['active'] ? 'btn-success' : 'btn-secondary' ?>">
                                        <?= $smtp['active'] ? 'Active' : 'Inactive' ?>
                                    </button>
                                </form>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-warning edit-smtp-btn"
                                    data-id="<?= $smtp['id'] ?>"
                                    data-host="<?= htmlspecialchars($smtp['host']) ?>"
                                    data-port="<?= $smtp['port'] ?>"
                                    data-encryption="<?= $smtp['encryption'] ?>"
                                    data-username="<?= htmlspecialchars($smtp['username'] ?? '') ?>"
                                    data-sender-name="<?= htmlspecialchars($smtp['sender_name'] ?? '') ?>"
                                    data-sender-email="<?= htmlspecialchars($smtp['sender_email'] ?? '') ?>"
                                    data-test-recipient="<?= htmlspecialchars($smtp['test_recipient'] ?? '') ?>">
                                </button>
                                <form method="post" class="d-inline">
                                    <input type="hidden" name="action" value="delete">
                                    <input type="hidden" name="id" value="<?= $smtp['id'] ?>">
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Delete this SMTP?')"></button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Add/Edit Modal -->
<div class="modal fade" id="smtpModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="post" id="smtpForm">
                <div class="modal-header">
                    <h5 class="modal-title"><span id="smtpModalTitle">Add SMTP</span></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="action" value="add" id="smtpAction">
                    <input type="hidden" name="id" id="smtpId">

                    <div class="mb-3">
                        <label class="form-label">Preset SMTP Servers</label>
                        <select id="smtpPreset" class="form-select mb-2">
                            <option value="">-- Select preset --</option>
                            <option value="smtp.gmail.com|587|tls">Gmail / Google Workspace</option>
                            <option value="smtp.office365.com|587|tls">Outlook / Office365 / Hotmail</option>
                            <option value="smtp.mail.yahoo.com|465|ssl">Yahoo Mail</option>
                            <option value="smtp.zoho.com|587|tls">Zoho Mail</option>
                            <option value="smtp-relay.brevo.com|587|tls">Brevo (ex Sendinblue)</option>
                            <!-- Add more as you like -->
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">SMTP Host</label>
                        <input type="text" name="host" id="smtpHost" class="form-control" required>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Port</label>
                            <input type="number" name="port" id="smtpPort" class="form-control" value="587" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Encryption</label>
                            <select name="encryption" id="smtpEncryption" class="form-select">
                                <option value="tls">TLS</option>
                                <option value="ssl">SSL</option>
                                <option value="none">None</option>
                            </select>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Username (optional)</label>
                        <input type="text" name="username" id="smtpUsername" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Password (optional)</label>
                        <input type="password" name="password" id="smtpPassword" class="form-control">
                    </div>

                    <hr>
                    <div class="mb-3">
                        <label class="form-label">Sender Name</label>
                        <input type="text" name="sender_name" id="smtpSenderName" class="form-control" placeholder="John Doe" value="Forwarder">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Sender Email (From)</label>
                        <input type="email" name="sender_email" id="smtpSenderEmail" class="form-control" placeholder="john@example.com">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Test Recipient Email</label>
                        <input type="email" name="test_recipient" id="smtpTestRecipient" class="form-control" placeholder="test@yourdomain.com" required>
                    </div>

                    <div class="text-center">
                        <button type="button" class="btn btn-info" id="testSmtpBtn">Test SMTP Connection</button>
                        <div id="smtpTestResult" class="mt-2"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save SMTP</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    new DataTable('#smtpsTable');

    document.getElementById('smtpPreset').addEventListener('change', function() {
        if (this.value) {
            const [host, port, encryption] = this.value.split('|');
            document.getElementById('smtpHost').value = host;
            document.getElementById('smtpPort').value = port;
            document.getElementById('smtpEncryption').value = encryption;
        }
    });

    document.querySelectorAll('.edit-smtp-btn').forEach(btn => {
        btn.addEventListener('click', function () {
            document.getElementById('smtpModalTitle').textContent = 'Edit SMTP';
            document.getElementById('smtpAction').value = 'edit';
            document.getElementById('smtpId').value = this.dataset.id;
            document.getElementById('smtpHost').value = this.dataset.host;
            document.getElementById('smtpPort').value = this.dataset.port;
            document.getElementById('smtpEncryption').value = this.dataset.encryption;
            document.getElementById('smtpUsername').value = this.dataset.username;
            document.getElementById('smtpSenderName').value = this.dataset.senderName;
            document.getElementById('smtpSenderEmail').value = this.dataset.senderEmail;
            document.getElementById('smtpTestRecipient').value = this.dataset.testRecipient;
            new bootstrap.Modal(document.getElementById('smtpModal')).show();
        });
    });

    document.getElementById('testSmtpBtn').addEventListener('click', function () {
        const formData = new FormData(document.getElementById('smtpForm'));
        const resultEl = document.getElementById('smtpTestResult');
        resultEl.innerHTML = '<span class="text-info">Testing...</span>';

        fetch('api/test_smtp.php', {
            method: 'POST',
            body: formData
        })
        .then(r => r.json())
        .then(data => {
            let debug = data.debug ? '<pre class="text-muted small mt-2">' + data.debug.join("\n") + '</pre>' : '';
            resultEl.innerHTML = data.success 
                ? '<span class="text-success">SUCCESS! Test email sent.</span>' + debug
                : '<span class="text-danger">FAILED: ' + data.message + '</span>' + debug;
        })
        .catch(err => {
            resultEl.innerHTML = '<span class="text-danger">Request failed: ' + err.message + '</span>';
        });
    });
});
</script>
<?php require_once 'includes/footer.php'; ?>