<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class Attendance extends Model
{
    protected $guarded = [];

    public $timestamps = false;

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    // Mutator: Mengubah format tanggal sebelum disimpan ke database
    public function setAttendanceDateAttribute($value)
    {
        try {
            // Coba parsing otomatis (Paling fleksibel untuk Web & Mobile)
            $this->attributes['attendance_date'] = Carbon::parse($value)->format('Y-m-d');
        } catch (\Exception $e) {
            // Opsi cadangan: Jika parse gagal, coba paksa sesuai format .env (Jaga-jaga untuk Web lama)
            try {
                $this->attributes['attendance_date'] = Carbon::createFromFormat(env('Date_Format', 'Y-m-d'), $value)->format('Y-m-d');
            } catch (\Exception $ex) {
                // Jika masih gagal juga, simpan apa adanya (fail-safe)
                $this->attributes['attendance_date'] = $value;
            }
        }
    }
    
    // Accessor: Mengambil data dari database (Tidak perlu diubah)
    public function getAttendanceDateAttribute($value)
    {
        // Mengubah format tampilan sesuai settingan .env
        return Carbon::parse($value)->format(env('Date_Format', 'Y-m-d'));
    }
}