<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BPJSKes extends Model
{
    use HasFactory;

    protected $table = 'bpjs_kes';
    protected $fillable = ['company_id', 'name', 'company', 'employee', 'min_salary', 'max_salary'];
    protected $appends = ['min_salary_formatted', 'max_salary_formatted'];

    public function companies()
    {
        return $this->belongsTo(company::class, 'company_id');
    }

    public function getMinSalaryFormattedAttribute()
    {
        return number_format($this->attributes['min_salary'], 0, ',', '.');
    }

    public function getMaxSalaryFormattedAttribute()
    {
        return number_format($this->attributes['max_salary'], 0, ',', '.');
    }
}
