<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SalaryAllowance extends Model
{
	protected $guarded = [];
	protected $appends = ['allowance_amount_formatted'];

	public function employee()
	{
		return $this->hasOne('App\Employee', 'id', 'employee_id');
	}

	public function getAllowanceAmountFormattedAttribute()
	{
		return number_format($this->attributes['allowance_amount'], 0, ',', '.');
	}
}
