<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SalaryOvertime extends Model
{
    //
	protected $guarded=[];
	protected $appends = ['overtime_rate_formatted'];

	public function employee(){
		return $this->hasOne('App\Employee','id','employee_id');
	}
	public function getOvertimeRateFormattedAttribute()
	{
		return number_format($this->attributes['overtime_rate'], 0, ',', '.');
	}
}
