<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Travel extends Model
{
	protected $table = 'travels';

    protected $fillable = [
    		'description', 
    		'travel_type', // KEMBALI KE 'travel_type' (SESUAI DATABASE)
    		'status',
    		'company_id',
    		'travel_mode',
    		'employee_id',
    		'start_date',
    		'end_date',
    		'purpose_of_visit',
    		'place_of_visit',
    		'expected_budget',
    		'actual_budget'
    	];

	// Relasi Company
	public function company(){
		return $this->belongsTo('App\company', 'company_id', 'id');
	}

	// Relasi TravelType
	// Gunakan belongsTo karena Travel "memiliki" satu tipe (Foreign Key ada di tabel travels)
	public function travelType(){
		return $this->belongsTo('App\TravelType', 'travel_type_id', 'id');
	}

	// Relasi Employee
	public function employee(){
		return $this->belongsTo('App\Employee', 'employee_id', 'id');
	}

	// =========================================================================
	// PERHATIAN: SAYA MATIKAN MUTATOR TANGGAL DI BAWAH INI
	// =========================================================================
	// Alasannya: Flutter mengirim format "Y-m-d" (2025-12-03).
	// Kode di bawah ini memaksa format env('Date_Format') yang mungkin berbeda.
	// Ini menyebabkan CRASH 500 saat Carbon gagal memparsing tanggal dari Flutter.
	
	/*
	public function setStartDateAttribute($value)
	{
		$this->attributes['start_date'] = Carbon::createFromFormat(env('Date_Format'), $value)->format('Y-m-d');
	}

	public function getStartDateAttribute($value)
	{
		return Carbon::parse($value)->format(env('Date_Format'));
	}

	public function setEndDateAttribute($value)
	{
		$this->attributes['end_date'] = Carbon::createFromFormat(env('Date_Format'), $value)->format('Y-m-d');
	}

	public function getEndDateAttribute($value)
	{
		return Carbon::parse($value)->format(env('Date_Format'));
	}
	*/
}