<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class company extends Model
{
	protected $fillable = [
		'company_name', 'company_type','trading_name', 'registration_no','contact_no','email','website','tax_no','location_id','company_logo', 'start_cut_off_date', 'end_cut_off_date', 'leave_amount', 'employee_code'
	];

	public function companyHolidays(){
		return $this->hasMany(Holiday::class)
			->select('id','start_date','end_date','is_publish','company_id')
			->where('is_publish','=',1);
	}

	//public function Location(){
		//return $this->hasOne('App\location','id','location_id');
	//}
	
	// Define the relationship with location
    public function location()
    {
        return $this->belongsTo(location::class, 'location_id');
    }
	
	public function employees()
    {
        return $this->hasMany(Employee::class, 'company_id');
    }	
	
	public function coo_name()
    {
        return $this->belongsTo(Employee::class, 'coo');
    }
}
