<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class leave extends Model
{
    protected $fillable = [
        'leave_type_id','company_id','department_id','employee_id','start_date','end_date',
        'leave_reason','remarks','status','is_half','is_notify','total_days'
    ];

    // =========================================================================
    // RELATIONSHIPS (TIDAK ADA PERUBAHAN)
    // =========================================================================

    // leaves.company_id -> companies.id
    public function company(){
        return $this->belongsTo(\App\company::class, 'company_id', 'id');
    }

    // leaves.department_id -> departments.id
    public function department(){
        return $this->belongsTo(\App\department::class, 'department_id', 'id');
    }

    // leaves.leave_type_id -> leave_types.id
    public function LeaveType(){
        return $this->belongsTo(\App\LeaveType::class, 'leave_type_id', 'id');
    }

    // leaves.employee_id -> employees.id
    public function employee(){
        return $this->belongsTo(\App\Employee::class, 'employee_id', 'id');
    }

    // =========================================================================
    // MUTATOR (INPUT KE DATABASE)
    // =========================================================================

    public function setStartDateAttribute($value)
    {
        // Menggunakan Carbon::parse agar fleksibel menerima format apapun (d/m/Y atau Y-m-d)
        // lalu disimpan ke DB dalam format Y-m-d
        $this->attributes['start_date'] = Carbon::parse($value)->format('Y-m-d');
    }

    public function setEndDateAttribute($value)
    {
        $this->attributes['end_date'] = Carbon::parse($value)->format('Y-m-d');
    }

    // =========================================================================
    // ACCESSOR (OUTPUT KE JSON/WEB) - PERBAIKAN UTAMA DISINI
    // =========================================================================

    public function getStartDateAttribute($value)
    {
        // FIX: Return Y-m-d (Standar ISO) agar Flutter bisa membacanya.
        // Jangan gunakan env('Date_Format') jika formatnya mengandung garis miring (/).
        return Carbon::parse($value)->format('Y-m-d');
    }

    public function getEndDateAttribute($value)
    {
        // FIX: Return Y-m-d
        return Carbon::parse($value)->format('Y-m-d');
    }

    public function getCreatedAtAttribute($value)
    {
        // FIX: Menghapus string "--" yang menyebabkan error parsing di Flutter
        // Format menjadi: YYYY-MM-DD HH:MM
        return Carbon::parse($value)->format('Y-m-d H:i');
    }
}