<?php

namespace App\Exports;

use App\Company;
use App\BPJSTK;
use App\BPJSKes;
use App\Department;
use App\Employee;
use App\Holiday;
use App\leave;
use App\ReportAttendance;
use App\SalaryBasic;
use App\Payslip;
use App\Tax;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use App\Http\traits\TotalSalaryTrait;

class SlipExport implements FromView, ShouldAutoSize
{
    use TotalSalaryTrait;
    private $data;

    public function __construct($id, $month)
    {
        $this->id = $id;
		$this->month = $month;
    }

    public function view(): View
    {
        $request = request();
        $month_year = request('month', now()->format('F-Y'));
		if(!empty($this->month)){
			$month_year = $this->month;
		}
		$first_date = date('Y-m-d', strtotime('first day of ' . $month_year));
        $last_date = date('Y-m-d', strtotime('last day of ' . $month_year));
        $employee = Employee::with([
			'salaryBasic' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'kehadiran' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'allowances' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'commissions' => function ($query) use ($first_date) {
				$query->where('first_date', $first_date);
			},
			'loans' => function ($query) use ($first_date) {
				$query->where('first_date', '<=', $first_date)
                ->where('amount_remaining', '!=', 0)
					->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'deductions' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'otherPayments' => function ($query) use ($first_date) {
				$query->where('first_date', $first_date);
			},
			'overtimes' => function ($query) use ($month_year) {
				$query->where('month_year', $month_year);
			},
			'designation', 'department', 'user', 'setting',
			'employeeAttendance' => function ($query) use ($first_date, $last_date) {
				$query->whereBetween('attendance_date', [$first_date, $last_date]);
			},
            'user:id,username', 'company.Location.country',
			'department:id,department_name', 'designation:id,designation_name',
		])
        ->select('employees.id', 'employees.company_id', 'employees.first_name', 'employees.contact_no', 'employees.last_name', 'employees.basic_salary', 'employees.basic_salary_custom', 'employees.tunjangan_jabatan', 'employees.payslip_type', 'employees.designation_id', 'employees.department_id', 'employees.joining_date', 'employees.dependent', 'ptkp.value as ptkp')
        ->leftjoin('ptkp', [
                'employees.company_id' => 'ptkp.company_id',
                'employees.dependent' => 'ptkp.name'
        ])
		->findOrFail($this->id);

        foreach ($employee->salaryBasic as $salaryBasic) {
			if ($salaryBasic->first_date <= $first_date) {
				$basic_salary = $salaryBasic->basic_salary;
				$basic_salary_custom = $salaryBasic->basic_salary_custom;
				$tunjangan_jabatan = $salaryBasic->tunjangan_jabatan;

				if($salaryBasic->basic_salary_custom == 0)
				{
					$basic_salary_custom = $salaryBasic->basic_salary;
				}
				else
				{
					$basic_salary_custom = $salaryBasic->basic_salary_custom;
				}

				$total_gaji_tunjangan = $basic_salary+$tunjangan_jabatan;
				$payslip_type = $salaryBasic->payslip_type;
			}
		}

        $employee->basic_salary = $basic_salary;
        $prev_month = Carbon::createFromFormat('Y-m-d', $first_date)->subMonth();
        $cut_off_start = $prev_month->day(16);
        $cut_off_end = Carbon::createFromFormat('Y-m-d', $first_date)->day(15);
        $attendances = $employee->reportAttendances->where('attendance_date', '>=', $cut_off_start)->where('attendance_date', '<=', $cut_off_end);
        $work_days = $attendances->count();
		//TAMBAHAN UANG KEHADIRAN
		if (!$employee->kehadiran->isEmpty()) {
			foreach ($employee->kehadiran as $item) {
				if ($item->first_date <= $first_date) {
					$salary_kehadiran = $item->salary_kehadiran * $work_days;
				}
			}
		} else {
			$salary_kehadiran = 0;
		}
        $allowance_amount = $this->allowances($employee, $first_date, 'get_amount', $work_days);

        // $jht = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jht')->first();
        // $jkk = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkk')->first();
        // $jkm = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkm')->first();
        // $pensiun = BPJSTK::where('company_id', $employee->company_id)->where('type', 'pensiun')->first();
        // $bpjskes = BPJSKes::where('company_id', $employee->company_id)->where('name', 'Kesehatan')->first();
        // $nilai_jht = $basic_salary_custom*$jht->employee/100;
        // $nilai_jkk = $basic_salary_custom*$jkk->employee/100;
        // $nilai_jkm = $basic_salary_custom*$jkm->employee/100;
        // $nilai_pensiun = $basic_salary_custom*$pensiun->employee/100;
        // $nilai_kes = $basic_salary_custom*$bpjskes->employee/100;
        // $employee->bpjs_kes = $nilai_kes;
		// $employee->bpjs_jht = $nilai_jht;
		// $employee->bpjs_jkk = $nilai_jkk;
		// $employee->bpjs_jkm = $nilai_jkm;
		// $employee->bpjs_pensiun = $nilai_pensiun;

		$pph_monthly = $this->hitungPph($employee, $total_gaji_tunjangan);
		$jht = BPJSTK::where('id', 2)->where('type', 'jht')->first();   
		$jkk = BPJSTK::where('id', 4)->where('type', 'jkk')->first();
		$jkm = BPJSTK::where('id', 3)->where('type', 'jkm')->first();
		$pensiun = BPJSTK::where('id', 1)->where('type', 'pensiun')->first();
		$bpjskes = BPJSKes::where('id', 1)->first();
        
        $basicsalaryjht = $basic_salary_custom;
		if($jht->max_salary > 0 && $basicsalaryjht > $jht->max_salary)
		{
			$basicsalaryjht = $jht->max_salary;
		}

		$basicsalarykes = $basic_salary_custom;
		if($bpjskes->max_salary > 0 && $basicsalarykes > $bpjskes->max_salary)
		{
			$basicsalarykes = $bpjskes->max_salary;
		}
        
        $nilai_jht = $basicsalaryjht*($jht->employee ?? 0)/100;
        $nilai_jkk = $basic_salary_custom*($jkk->employee ?? 0)/100;
        $nilai_jkm = $basic_salary_custom*($jkm->employee ?? 0)/100;
        $nilai_pensiun = $basic_salary_custom*($pensiun->employee ?? 0)/100;
        $nilai_kes = $basicsalarykes*($bpjskes->employee ?? 0)/100;
        $pension_amount = $nilai_jht+$nilai_pensiun;

		$employee->bpjs_kes = $nilai_kes;
		$employee->bpjs_jht = $nilai_jht;
		$employee->bpjs_jkk = $nilai_jkk;
		$employee->bpjs_jkm = $nilai_jkm;
		$employee->bpjs_pensiun = $nilai_pensiun;

        $number_cut = $employee->reportAttendances->where('attendance_date', '>=', $cut_off_start)->where('attendance_date', '<=', $cut_off_end)->whereIn('status', ['TA1', 'TA2', 'TA3'])->where('is_checked', 0)->count();
        if($work_days == 0) {
            $employee->salary_cut_amount = 0;
        } else {
            $employee->salary_cut_amount = number_format($basic_salary/$work_days*$number_cut, 0, ',', '');
        }

		$pph_monthly = $this->hitungPph($employee, $total_gaji_tunjangan, $work_days, $first_date);
        $employee->pph_bulanan = $pph_monthly;

        $deduction_amount = 0;
		if (!$employee->deductions->isEmpty()) {
			foreach ($employee->deductions as $item) {
				if ($item->first_date <= $first_date) {
					$deduction_amount = 0;
					foreach ($employee->deductions as $value) {
						if ($value->first_date <= $first_date) {
							if ($item->first_date == $value->first_date) {
								$deduction_amount += $value->deduction_amount;
							}
						}
					}
				}
			}
		}
		$employee->salary_kehadiran = $salary_kehadiran;
        $employee->total_salary = number_format($this->totalSalary($employee, $payslip_type, $total_gaji_tunjangan, $allowance_amount, $deduction_amount, $employee->pph_bulanan, $employee->salary_cut_amount, $salary_kehadiran), 0, ',', '');
        return view('salary.payslip.export_xls', compact('employee', 'month_year', 'allowance_amount', 'work_days'));
    }
}
