<?php

namespace App\Http\Controllers\API;

//use Auth;
use App\BPJSTK;
use App\BPJSKes;
use App\Employee;
use App\company;
use App\department;
use App\leave;
use App\LeaveType;
use App\Holiday;
use App\office_shift;
use App\Http\Controllers\Controller;
use App\Http\Resources\EmployeeResource;
use App\Http\traits\TotalSalaryTrait;
use App\Payslip;
use App\PTKP;
use App\ReportAttendance;
use App\Reimbursement;
use App\ReimbursementType;
use App\SalaryBasic;
use App\SalaryLoan;
use App\Tax;
use App\Travel;
use App\TravelType;
use App\Notifications\ReimburseNotifyAdmin;
use App\Notifications\TravelNotifyAdmin;

use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Exception;
use Illuminate\Http\Request;
//Notification
use App\Notifications\EmployeeLeaveNotification; //Mail
use App\Notifications\LeaveNotification; //Database
use App\Notifications\LeaveNotificationToAdmin; //Database
use App\Notifications\ReimburseRequestNotify;
use App\Notifications\TravelRequestNotify;
use App\Notifications\EmployeeTravelStatus;
use App\User;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

use Illuminate\Support\Facades\Validator;
use Response;

class EmployeeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    use TotalSalaryTrait;
	 public function index()
    {
        $employee = Employee::withCount('attendances')->where('id', Auth::user()->id)->get();
        return response([ 'employee' => new 
        EmployeeResource($employee), 'success' => true], 200);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Employee  $employee
     * @return \Illuminate\Http\Response
     */
    public function show()
    {
		$employee = Employee::withCount('attendances')->where('id', Auth::user()->id)->get();
        return response([ 'employee' => new 
        EmployeeResource($employee), 'success' => true], 200);
    }

    public function payslip(Request $request) {
        $month_year = $request->filter_month_year;
		$first_date = date('Y-m-d', strtotime('first day of ' . $month_year));
		$last_date = date('Y-m-d', strtotime('last day of ' . $month_year));

        $employee = Employee::with([
			'salaryBasic' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'kehadiran' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'allowances' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'commissions' => function ($query) use ($first_date) {
				$query->where('first_date', $first_date);
			},
			'loans' => function ($query) use ($first_date) {
				$query->where('first_date', '<=', $first_date)
                ->where('amount_remaining', '!=', 0)
					->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'deductions' => function ($query) {
				$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
			},
			'otherPayments' => function ($query) use ($first_date) {
				$query->where('first_date', $first_date);
			},
			'overtimes' => function ($query) use ($month_year) {
				$query->where('month_year', $month_year);
			},
			'designation', 'department', 'user', 'setting',
			'employeeAttendance' => function ($query) use ($first_date, $last_date) {
				$query->whereBetween('attendance_date', [$first_date, $last_date]);
			},
            'user:id,username', 'company.Location.country',
			'department:id,department_name', 'designation:id,designation_name',
		])
        ->select('employees.id', 'employees.company_id', 'employees.first_name', 'employees.contact_no', 'employees.last_name', 'employees.basic_salary', 'employees.basic_salary_custom', 'employees.tunjangan_jabatan', 'employees.tunjangan_jabatan', 'employees.payslip_type', 'employees.designation_id', 'employees.department_id', 'employees.joining_date', 'employees.dependent', 'ptkp.value as ptkp')
        ->leftjoin('ptkp', [
                'employees.company_id' => 'ptkp.company_id',
                'employees.dependent' => 'ptkp.name'
        ])
		->findOrFail(Auth::user()->id);
        
        //payslip_type && salary_basic
		foreach ($employee->salaryBasic as $salaryBasic) {
			if ($salaryBasic->first_date <= $first_date) {
				// $basic_salary = $salaryBasic->basic_salary;
				// $tunjangan_jabatan = $salaryBasic->tunjangan_jabatan;
				// $basic_salary_custom = $salaryBasic->basic_salary_custom;
				// $total_gaji_tunjangan = $basic_salary+$tunjangan_jabatan;
				// $payslip_type = $salaryBasic->payslip_type;

				$basic_salary = $salaryBasic->basic_salary;
				$tunjangan_jabatan = $salaryBasic->tunjangan_jabatan;

				if($salaryBasic->basic_salary_custom == 0)
				{
					$basic_salary_custom = $salaryBasic->basic_salary;
				}
				else
				{
					$basic_salary_custom = $salaryBasic->basic_salary_custom;
				}

				$total_gaji_tunjangan = $basic_salary+$tunjangan_jabatan;
				$payslip_type = $salaryBasic->payslip_type;
			}
		}
        
		//dd($employee->salaryBasic);
		if($employee->salaryBasic->isEmpty()) {
			return response([ 'data' => 'Basic salary tidak ditemukan', 'success' => false], 404);
		}

        $prev_month = Carbon::createFromFormat('Y-m-d', $first_date)->subMonth();
        $cut_off_start = $prev_month->day(16);
        $cut_off_end = Carbon::createFromFormat('Y-m-d', $first_date)->day(15);
        $attendances = $employee->reportAttendances->where('attendance_date', '>=', $cut_off_start)->where('attendance_date', '<=', $cut_off_end);
		
        $work_days = $attendances->count();
        $number_cut = $employee->reportAttendances->where('attendance_date', '>=', $cut_off_start)->where('attendance_date', '<=', $cut_off_end)->whereIn('status', ['TA1', 'TA2', 'TA3'])->where('is_checked', 0)->count();
        if($work_days == 0) {
            $salary_cut_amount = 0;
        } else {
            $salary_cut_amount = $basic_salary/$work_days*$number_cut;
        }
		//TAMBAHAN UANG KEHADIRAN
		$salary_kehadiran = 0;
		if (!$employee->kehadiran->isEmpty()) {
			foreach ($employee->kehadiran as $item) {
				if ($item->first_date <= $first_date) {
					$salary_kehadiran = $item->salary_kehadiran * $work_days;
				}
			}
		} else {
			$salary_kehadiran = 0;
		}
		
        // $pph_monthly = $this->hitungPph($employee, $total_gaji_tunjangan);
        // $jht = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jht')->first();
        // $jkk = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkk')->first();
        // $jkm = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkm')->first();
        // $pensiun = BPJSTK::where('company_id', $employee->company_id)->where('type', 'pensiun')->first();
        // $bpjskes = BPJSKes::where('company_id', $employee->company_id)->first();
        // $nilai_jht = $basic_salary_custom*($jht->employee ?? 0)/100;
        // $nilai_jkk = $basic_salary_custom*($jkk->employee ?? 0)/100;
        // $nilai_jkm = $basic_salary_custom*($jkm->employee ?? 0)/100;
        // $nilai_pensiun = $basic_salary_custom*($pensiun->employee ?? 0)/100;
        // $nilai_kes = $basic_salary_custom*($bpjskes->employee ?? 0)/100;
        // $pension_amount = $nilai_jht+$nilai_pensiun;

		$pph_monthly = $this->hitungPph($employee, $total_gaji_tunjangan);
		$jht = BPJSTK::where('id', 2)->where('type', 'jht')->first();   
		$jkk = BPJSTK::where('id', 4)->where('type', 'jkk')->first();
		$jkm = BPJSTK::where('id', 3)->where('type', 'jkm')->first();
		$pensiun = BPJSTK::where('id', 1)->where('type', 'pensiun')->first();
		$bpjskes = BPJSKes::where('id', 1)->first();


        // $salary = $employee->salaryBasic[0];
		// if($salary->basic_salary_custom == 0)
		// {
		// 	$basic_salary_custom = $salary->basic_salary;
		// }
		// else
		// {
		// 	$basic_salary_custom = $salary->basic_salary_custom;
		// }

		$basicsalaryjht = $basic_salary_custom;
		if($jht->max_salary > 0 && $basicsalaryjht > $jht->max_salary)
		{
			$basicsalaryjht = $jht->max_salary;
		}

		$basicsalarykes = $basic_salary_custom;
		if($bpjskes->max_salary > 0 && $basicsalarykes > $bpjskes->max_salary)
		{
			$basicsalarykes = $bpjskes->max_salary;
		}

        $nilai_jht = $basicsalaryjht*($jht->employee ?? 0)/100;
        $nilai_jkk = $basic_salary_custom*($jkk->employee ?? 0)/100;
        $nilai_jkm = $basic_salary_custom*($jkm->employee ?? 0)/100;
        $nilai_pensiun = $basic_salary_custom*($pensiun->employee ?? 0)/100;
        $nilai_kes = $basicsalarykes*($bpjskes->employee ?? 0)/100;
        $pension_amount = $nilai_jht+$nilai_pensiun;

        //Pension Amount

		$type          = "getArray";
		$allowances    = $this->allowances($employee, $first_date, $type, $work_days);
		$deductions    = $this->deductions($employee, $first_date, $type);
		$data = [];
        $data['month_year'] = $month_year;
		$data['basic_salary'] = $salaryBasic->basic_salary;
		$data['tunjangan_jabatan'] = $tunjangan_jabatan;
		$data['basic_total']  = $total_gaji_tunjangan;
		// $data['salary_kehadiran']   = number_format($salary_kehadiran, '0', ',', '.');
		$data['salary_kehadiran']   = $salary_kehadiran;
		$data['allowances']   = $allowances;
		$data['work_days']   = $work_days;
		$data['commissions']  = $employee->commissions;
		$data['loans']        = $employee->loans;
		$data['deductions']   = $deductions;
		$data['overtimes']    = $employee->overtimes;
		$data['other_payments'] = $employee->otherPayments;
		$data['pension_type']   = 'Percentage';
		$data['bpjs_kes'] = number_format($nilai_kes, '0', ',', '.');
		$data['bpjs_jht'] = number_format($nilai_jht, '0', ',', '.');
		$data['bpjs_jkk'] = number_format($nilai_jkk, '0', ',', '.');
		$data['bpjs_jkm'] = number_format($nilai_jkm, '0', ',', '.');
		$data['bpjs_pensiun'] = number_format($nilai_pensiun, '0', ',', '.');
        $data['attendance_cut_amount'] = number_format($salary_cut_amount, '0', ',', '.');

		$data['employee_id']          = $employee->id;
		$data['employee_full_name']   = $employee->full_name;
		$data['employee_designation'] = $employee->designation->designation_name ?? '';
		$data['employee_department']  = $employee->department->department_name ?? '';
		$data['employee_join_date']   = $employee->joining_date;
		$data['employee_username']    = $employee->user->username;
		$data['employee_pp']          = $employee->user->profile_photo ?? '';

		$data['payslip_type'] = $payslip_type;

		if ($payslip_type == 'Hourly') {
			$total = 0;
			$total_hours_worked = $this->totalWorkedHours($employee);
			$data['monthly_worked_hours'] = $total_hours_worked;
			//formatting in hour:min and separating them
			sscanf($total_hours_worked, '%d:%d', $hour, $min);
			//converting in minute
			$total += $hour * 60 + $min;

			$data['monthly_worked_amount'] = ($basic_salary / 60) * $total;

			$data['basic_total'] = $data['monthly_worked_amount'];
		}

		$type              = "getAmount";
		$allowance_amount  = $this->allowances($employee, $first_date, $type, $work_days);
		
		$pph_monthly = $this->hitungPph($employee, $total_gaji_tunjangan, $work_days, $first_date);
		
		$deduction_amount  = $this->deductions($employee, $first_date, $type);
        $data['allowance_amount'] = $allowance_amount;
		if ($payslip_type == 'Monthly') {
            $data['pph_bulanan'] = $pph_monthly;
			$data['total_salary'] = number_format($this->totalSalary($employee, $payslip_type, $total_gaji_tunjangan, $allowance_amount, $deduction_amount, $pph_monthly, $salary_cut_amount, $salary_kehadiran), 0, ',', '.');
		}

        return response([ 'data' => $data, 'success' => true], 200);
    }

	public function reimbursement_type() {
		$types = ReimbursementType::all();
		return response([ 'data' => $types, 'success' => true], 200);
	}

	public function reimbursement(Request $request) {
		$validator = Validator::make(
			$request->only(
				'reimbursement_type_id',
				'amount',
				'description',
				'reimbursement_attachments',
			),
			[
				'reimbursement_type_id' => 'required',
				'amount' => 'required',
				'description' => 'required',
				'reimbursement_attachments' => 'nullable|file|max:10240|mimes:jpeg,png,jpg,gif,ppt,pptx,doc,docx,pdf',
			]
		);

		if ($validator->fails()) {
			return response()->json(['success' => false, 'errors' => $validator->errors()->all()]);
		}

		$data = [];
		$data['employee_id'] = Auth::user()->id;
		$data['reimbursement_type_id'] = $request->reimbursement_type_id;
		$data['amount'] = $request->amount;
		$data['description'] = $request->description;
		$data['status'] = $request->status ?? 'pending';
		$file = $request->reimbursement_attachments;
		$file_name = null;
		if (isset($file)) {
			if ($file->isValid()) {
				$file_name = 'reimbursement_' . time() . '.' . $file->getClientOriginalExtension();
				$file->storeAs('reimbursement_attachments', $file_name);
				$data['attachment'] = $file_name;
			}
		}
		Reimbursement::create($data);
		
		$requester = Employee::findOrFail($data['employee_id']);
		$department = department::with('DepartmentHead:id')->where('id', $requester->department_id)->first();
		$text = "A new reimbursement has been requested by ". $requester->first_name ." ".$requester->last_name;
		if(!empty($department->department_head)) {
			$notifiable = User::findOrFail($department->department_head);
			$notifiable->notify(new ReimburseRequestNotify($text)); //To Department Head
		}

		if(!empty($department->supervisor)) {
			$notifiable = User::findOrFail($department->supervisor);
			$notifiable->notify(new ReimburseRequestNotify($text)); //To Supervisor
		}
		
		// HR Company
		$employee_info = Employee::find(Auth::user()->id);
		$users_hr = User::where('role_users_id', 6)
				->whereJsonContains('company_ids', (int)$employee_info->company_id)
				->get();
				
		foreach ($users_hr as $hr) {
			$hr->notify(new ReimburseNotifyAdmin($text));
		}
		
		return response()->json(['success' => true, 'message' => __('Data Added successfully.')]);
	}

	public function reimbursement_history(Request $request) {
		$perPage = $request->input('limit', 10); // Default limit per page is 10
        $page = $request->input('page', 1); // Default page is 1

		$reimburse = Reimbursement::where('employee_id', Auth::user()->id)
						->paginate($perPage, ['*'], 'page', $page);
						
		return Response::json($reimburse, 200);
	}

	public function leave_type(Request $request) {
		$leave_types = LeaveType::all();
		return response([ 'data' => $leave_types, 'success' => true], 200);
	}

    public function leave_history(Request $request)
    {
        // Pagination default
        $perPage = (int) $request->input('limit', 10);
        $page    = (int) $request->input('page', 1);
    
        // Pastikan pakai Auth facade
        $userId = \Auth::user()->id;
    
        $leave = \App\leave::with([
            // kirim nested employee dengan alias camelCase agar cocok dengan model Flutter
            'employee' => function ($q) {
                $q->select(
                    'id',
                    \DB::raw('COALESCE(remaining_leave, 0) AS remainingLeave'),
                    \DB::raw('COALESCE(leave_debt, 0) AS leaveDebt')
                );
            },
            // opsional: type untuk tampilan nama jenis cuti di FE
            'LeaveType:id,leave_type',
        ])
        ->where('employee_id', $userId)
        ->orderByDesc('created_at')
        ->paginate(
            $perPage,
            [
                'id',
                'employee_id',
                'leave_type_id',
                'start_date',
                'end_date',
                'total_days',
                'is_half',
                'is_notify',
                'status',
                'leave_reason',
                'remarks',
                'created_at',
                'updated_at',
            ],
            'page',
            $page
        );
    
        return \Response::json($leave, 200);
    }


    public function ask_leaves(Request $request) {
            // [DEBUG] Start Logging
            Log::info('--- MULAI REQUEST PENGAJUAN CUTI (EmployeeController) ---');
            
            try {
                // 1. Validasi Input
                $validator = Validator::make(
                    $request->only('leave_type', 'start_date', 'end_date', 'total_days'),
                    [
                        'leave_type' => 'required',
                        'total_days' => 'required',
                        'start_date' => 'required',
                        'end_date'   => 'required|after_or_equal:start_date'
                    ]
                );
    
                if ($validator->fails()) {
                    return response()->json(['success' => false, 'errors' => $validator->errors()->all()]);
                }
    
                // 2. Ambil Data Employee
                $employee = Employee::find(Auth::user()->id);
                if (!$employee) {
                    return response()->json(['success' => false, 'errors' => ['Employee data not found.']]);
                }
    
                $leaveType = LeaveType::findOrFail($request->leave_type);
    
                // 3. Logic Hitung Durasi
                $diff_hidden = $request->input('diff_date_hidden');
                $req_total = $request->total_days;
                $current_leave_days = $diff_hidden ? (int)$diff_hidden : (int)$req_total;
    
                // 4. Cek History & Kuota
                $history_leaves = \App\leave::where('employee_id', $employee->id)
                                       ->where('leave_type_id', $request->leave_type)
                                       ->get();
                
                $grand_total_usage = $history_leaves->sum('total_days') + $current_leave_days;
    
                if ($leaveType->allocated_day != null) {
                    if ($leaveType->allocated_day < $grand_total_usage) {
                        $msg = 'Allocated quota for this leave type exceeded.';
                        if ($history_leaves->count() == 0) {
                             $msg = 'Allocated quota for this leave type is less then requested days.';
                        }
                        return response()->json(['success' => false, 'errors' => [$msg]]);
                    }
                }
    
                // 5. Cek Sisa Cuti
                if ($current_leave_days > $employee->remaining_leave) {
                    return response()->json(['success' => false, 'errors' => ["The employee's remaining leaves are insufficient"]]);
                }
    
                // 6. Simpan Data
                $data = [];
                $data['employee_id']   = $employee->id;
                $data['company_id']    = $employee->company_id;
                $data['department_id'] = $employee->department_id;
                $data['leave_type_id'] = $request->leave_type;
                $data['leave_reason']  = $request->leave_reason;
                $data['remarks']       = $request->remarks;
                $data['status']        = 'pending';
                $data['is_half']       = $request->is_half;
                $data['is_notify']     = $request->is_notify;
                $data['start_date']    = $request->start_date;
                $data['end_date']      = $request->end_date;
                $data['total_days']    = $current_leave_days; 
    
                $leave = \App\leave::create($data);
                Log::info('Data Cuti TERSIMPAN di DB. ID: ' . $leave->id);
    
                // 7. Notifikasi (Filtered: User, Manager, SPV, & HR Company)
                try {
                    if ($request->is_notify == 1 || $request->is_notify == true) {
                        $text = "A new leave-notification has been requested by ". $employee->first_name ." ".$employee->last_name;
                        
                        // A. Ke Diri Sendiri
                        $userSelf = User::find($data['employee_id']);
                        if($userSelf) $userSelf->notify(new LeaveNotification($text));
    
                        // B. Ke HRD (Hanya Role ID 6 & Sesuai Company)
                        // Kita tambahkan filter 'role_users_id' => 6 agar tidak kirim ke semua user
                        $HR_users = User::where('role_users_id', 6)
                                        ->whereJsonContains('company_ids', (int)$employee->company_id)
                                        ->get();
    
                        foreach($HR_users as $hr){
                            sleep(1); // Jeda aman untuk menghindari limit email
                            $hr->notify(new LeaveNotification($text));
                        }
    
                        // C. Ke Atasan (Manager & SPV)
                        $department = department::with('DepartmentHead:id,email')->where('id', $employee->department_id)->first();
                        if ($department) {
                            // Manager / Dept Head
                            if(!empty($department->department_head)) {
                                $head = User::find($department->department_head);
                                // Cek agar tidak kirim double jika Dept Head juga merangkap HR
                                if($head && $head->role_users_id != 6) { 
                                    sleep(1);
                                    $head->notify(new LeaveNotification($text));
                                }
                            }
                            
                            // Supervisor
                            if(!empty($department->supervisor)) {
                                $spv = User::find($department->supervisor);
                                // Cek agar tidak kirim double
                                if($spv && $spv->role_users_id != 6 && $spv->id != $department->department_head) { 
                                    sleep(1);
                                    $spv->notify(new LeaveNotification($text));
                                }
                            }
                        }
                    }
                } catch (\Throwable $eNotify) {
                    Log::error("Notifikasi Gagal (Data tetap aman): " . $eNotify->getMessage());
                }
    
                return response()->json(['success' => true, 'message' => 'Data Added successfully.']);
    
            } catch (\Exception $e) {
                Log::error("CRITICAL ERROR: " . $e->getMessage());
                return response()->json(['success' => false, 'errors' => ['Server Error: ' . $e->getMessage()]], 500);
            }
        }

	protected function allowances($employee, $first_date, $type, $work_days = 0)
	{
		if ($type == "getArray") {
            $allowances = array();
            if (!$employee->allowances->isEmpty()) {
					foreach ($employee->allowances as $key => $value) {
						if ($value->first_date <= $first_date) {
							//$allowances = array();
							$allowances[] =  $employee->allowances[$key];
						}
					}
			} else {
				$allowances = [];
			}
			return $allowances;
		} elseif ($type == "getAmount") {
			$allowance_amount = 0;
			if (!$employee->allowances->isEmpty()) {
				foreach ($employee->allowances as $item) {
					if ($item->first_date <= $first_date) {
						if ($item->is_taxable == 1)
						{
							$allowance_amount += $item->allowance_amount;
						}
						else
						{
							$allowance_amount += $item->allowance_amount*$work_days;
						}
					}
				}
			}
			return $allowance_amount;
		}
	}

	protected function deductions($employee, $first_date, $type)
	{
		if ($type == "getAmount") {
			$deduction_amount = 0;
			if (!$employee->deductions->isEmpty()) {
				foreach ($employee->deductions as $item) {
					if ($item->first_date <= $first_date) {
						$deduction_amount = 0;
						foreach ($employee->deductions as $value) {
							if ($value->first_date <= $first_date) {
								if ($item->first_date == $value->first_date) {
									$deduction_amount += $value->deduction_amount;
								}
							}
						}
					}
				}
			}
			return $deduction_amount;
		} elseif ($type == "getArray") {
			if (!$employee->deductions->isEmpty()) {
				foreach ($employee->deductions as $item) {
					if ($item->first_date <= $first_date) {
						$deductions = array();
						foreach ($employee->deductions as $key => $value) {
							if ($value->first_date <= $first_date) {
								if ($item->first_date == $value->first_date) {
									$deductions[] =  $employee->deductions[$key];
								}
							}
						}
					}
				}
			} else {
				$deductions = [];
			}
			return $deductions;
		}
	}
	
	// =========================
	// TRAVEL ENDPOINTS (FIXED)
	// =========================

	# Travel Types (OK)
	public function travel_type() {
		$types = TravelType::all();
		return response(['data' => $types, 'success' => true], 200);
	}

	# Travel Mode (OK)
	public function travel_mode() {
		$mode = ["By Bus", "By Train", "By Plane", "By Taxi", "By Rental Car", "By Other"];
		return response(['data' => $mode, 'success' => true], 200);
	}

	# Create Travel (FIX: pakai travel_type_id, company_id yang benar, status konsisten)
	public function travel(Request $request) {
		$validator = Validator::make(
			$request->only(
				'description',
				'travel_type_id',
				'travel_mode',
				'start_date',
				'end_date',
				'purpose_of_visit',
				'place_of_visit',
				'expected_budget',
				'actual_budget'
			),
			[
				'travel_type_id'   => 'required|integer|exists:travel_types,id',
				'place_of_visit'   => 'required|string',
				'purpose_of_visit' => 'required|string',
				'start_date'       => 'required|date',
				'end_date'         => 'required|date|after_or_equal:start_date',
			]
		);

		if ($validator->fails()) {
			return response()->json(['success' => false, 'errors' => $validator->errors()->all()]);
		}

		$userId   = Auth::id();
		$employee = Employee::findOrFail($userId);

		$data = [
			'employee_id'      => $userId,
			// gunakan company_id tunggal milik employee (bukan company_ids JSON di users)
			'company_id'       => (int) $employee->company_id,
			// >>> penting: simpan ke kolom *_id agar relasi travelType bekerja
			'travel_type_id'   => (int) $request->travel_type_id,
			'description'      => $request->description,
			'travel_mode'      => $request->travel_mode,
			'purpose_of_visit' => $request->purpose_of_visit,
			'place_of_visit'   => $request->place_of_visit,
			'expected_budget'  => (float) $request->expected_budget,
			'actual_budget'    => (float) $request->actual_budget,
			'status'           => 'pending', // konsisten lowercase
			'start_date'       => $request->start_date,
			'end_date'         => $request->end_date,
		];

		$travel = Travel::create($data);

		// Notifikasi status (opsional; biasanya pending tidak dikirim)
		if (strtolower((string) $travel->status) !== 'pending') {
			$notifiable = User::findOrFail($data['employee_id']);
			$notifiable->notify(new EmployeeTravelStatus($travel->status));
		}

		// Notifikasi ke atasan
		$department = department::with('DepartmentHead:id')
			->where('id', $employee->department_id)
			->first();

		$text = "A new travel-notification has been requested by {$employee->first_name} {$employee->last_name}";

		if (!empty($department->department_head)) {
			$head = User::find($department->department_head);
			if ($head) $head->notify(new TravelRequestNotify($text));
		}
		if (!empty($department->supervisor)) {
			$spv = User::find($department->supervisor);
			if ($spv) $spv->notify(new TravelRequestNotify($text));
		}

		// Notifikasi HR perusahaan
		$users_hr = User::where('role_users_id', 6)
			->whereJsonContains('company_ids', (int) $employee->company_id)
			->get();

		foreach ($users_hr as $hr) {
			$hr->notify(new TravelNotifyAdmin($text));
		}

		return response()->json(['success' => true, 'message' => __('Data Added successfully.')]);
	}

	# Travel History (FIX: eager-load relasi & bentuk { total, list })
    public function travel_history(Request $request)
    {
        $perPage = (int) $request->input('limit', 10);
        $page    = (int) $request->input('page', 1);
    
        $employeeId = auth()->user()->employee_id;
    
        $p = Travel::with(['travelType','company'])
            ->where('employee_id', $employeeId)
            ->orderByDesc('id')
            ->paginate($perPage, ['*'], 'page', $page);
    
        $items = collect($p->items())->map(function ($t) {
            return [
                'id'              => (int) $t->id,
                'travel_type'     => [
                    'id'               => (int) ($t->travelType->id ?? 0),
                    'arrangement_type' => (string) ($t->travelType->arrangement_type ?? '-'),
                ],
                'company_id'      => isset($t->company_id) ? (string) $t->company_id : null,
                'employee_id'     => (string) ($t->employee_id ?? ''),
                'description'     => (string) ($t->description ?? ''),
                'purpose_of_visit'=> (string) ($t->purpose_of_visit ?? ''),
                'place_of_visit'  => (string) ($t->place_of_visit ?? ''),
                'expected_budget' => (string) ($t->expected_budget ?? '0'),
                'actual_budget'   => (string) ($t->actual_budget ?? '0'),
                'travel_mode'     => (string) ($t->travel_mode ?? ''),
                'status'          => (string) ($t->status ?? 'pending'),
                'start_date'      => optional($t->start_date)->format('Y-m-d') ?? '',
                'end_date'        => optional($t->end_date)->format('Y-m-d') ?? '',
                'created_at'      => optional($t->created_at)->toIso8601String() ?? '',
                'updated_at'      => optional($t->updated_at)->toIso8601String() ?? '',
            ];
        })->values();
    
        return response()->json([
            'total' => $p->total(),
            'list'  => $items,
        ], 200);
    }


	
}
