<?php

namespace App\Http\Controllers\API;

use Auth;
use Carbon\Carbon;
use DateInterval;
use DatePeriod;
use DateTime;
use App\Http\Controllers\Controller;
use App\Http\Resources\ReportAttendanceResource;
use App\Attendance;
use App\company;
use App\Employee;
use App\office_shift;
use App\RawAttendance;
use App\ReportAttendance;
use Illuminate\Http\Request;
use Validator;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use KMLaravel\GeographicalCalculator\Facade\GeoFacade;

class ReportAttendanceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // Get the month and year from the query parameters, or default to the current month and year.
        $month = $request->input('month', now()->format('m')); // Default to current month if not provided.
        $year = $request->input('year', now()->format('Y'));  // Default to current year if not provided.

        // Get the perPage (limit) and page from the query parameters.
        $perPage = $request->input('limit', 10); // Default to 10 items per page if not provided.
        $page = $request->input('page', 1); // Default to page 1 if not provided.

        // Start building the query for attendance.
        $attendanceQuery = Attendance::whereMonth('attendance_date', $month)
            ->whereYear('attendance_date', $year)
            ->where('employee_id', Auth::user()->id)
            ->orderBy('attendance_date', 'DESC'); // Add ordering by attendance date

        // Apply pagination using the perPage and page parameters.
        $attendance_raw = $attendanceQuery->paginate($perPage, ['*'], 'page', $page);

        // Prepare the data to be returned
        $data = [];
        foreach ($attendance_raw as $attend) {
            $row['id'] = $attend->id;
            $row['employee_id'] = $attend->employee_id;
            $row['attendance_date'] = $attend->attendance_date;
            $row['office_shift_id'] = "0";  // Default to "0"
            $row['in_time'] = $attend->clock_in;
            $row['out_time'] = $attend->clock_out;
            $row['work_time'] = $attend->total_work;
            $row['status'] = '';   
            $row['is_checked'] = "0";
            $row['is_underwork'] = "1";

            $data[] = $row;
        }

        // Return the paginated response, including pagination details
        return response([
            'report_attendance' => new ReportAttendanceResource($data),
            'pagination' => [
                'total' => $attendance_raw->total(), // Total number of items
                'current_page' => $attendance_raw->currentPage(), // Current page number
                'last_page' => $attendance_raw->lastPage(), // Last page number
                'per_page' => $attendance_raw->perPage(), // Number of items per page
                'from' => $attendance_raw->firstItem(), // Index of the first item on the current page
                'to' => $attendance_raw->lastItem(), // Index of the last item on the current page
            ],
            'message' => 'Success'
        ], 200);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\ReportAttendance  $reportAttendance
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
		$attendance = ReportAttendance::whereMonth('attendance_date', $request->month)->whereYear('attendance_date', $request->year)->where('employee_id', Auth::user()->id)->get();
		return response([ 'report_attendance' => new 
        ReportAttendanceResource($attendance), 'success' => true], 200);
    }

    public function record_absen(Request $request)
    {
        // ====== START: metrik resource ======
        $t0 = microtime(true);
        $mem0 = memory_get_usage(true);
        \DB::enableQueryLog();
        // ====================================

        $validator = Validator::make(
            $request->all(),
            [
                'long' => 'required',
                'lat' => 'required',
                'attendance_date' => 'date|required',
                'attendance_time' => 'required',
                'photo' => 'required|image|mimes:jpeg,png,jpg'
            ]
        );
        if ($validator->fails()) {
            // log resource sebelum return
            $this->logRecordAbsenUsage($t0, $mem0, $request, null, null, null, null, [
                'stage' => 'validation_failed',
                'errors' => $validator->errors()->all(),
            ]);
            return response()->json(['success' => false, 'errors' => $validator->errors()->all()]);
        }

        $employee = Employee::find(Auth::user()->id);
        $company = company::find($employee->company_id);

        $distance = $this->hitungJarak($company->lat, $company->long, $request->lat, $request->long);

        if (empty($company->radius) || $company->radius <= 0) {
            $radius = 0;
        } else {
            $radius = $company->radius;
        }

        if ($distance <= $company->radius || $radius == 0) {
            $photo = $request->photo;
            $file_name = null;
            if (isset($photo)) {
                $username = Auth::user()->username;
                if ($photo->isValid()) {
                    $file_name = preg_replace('/\s+/', '', $username) . '_' . time() . '.' . $photo->getClientOriginalExtension();
                    $photo->storeAs('attendance_photos', $file_name);
                    $data['photos'] = $file_name;
                }
            }
            $data['attendance_date'] = $request->attendance_date;
            $data['employee_id'] = $employee->id;

            //getting the latest instance of employee_attendance
            $employee_attendance_last = Attendance::where('attendance_date', $request->attendance_date)
                ->where('employee_id', $employee->id)->orderBy('id', 'desc')->first() ?? null;

            $attendance_date = Carbon::createFromFormat('Y-m-d', $request->attendance_date)->format('Y-m-d');
            $yesterday_attendance_date = Carbon::createFromFormat('Y-m-d', $request->attendance_date)->subDay()->format('Y-m-d');
            $employee_attendance_yesterday = Attendance::where('attendance_date', $yesterday_attendance_date)->where('status', 'TA2')
                ->where('employee_id', $employee->id)->orderBy('id', 'desc')->first() ?? null;

            $day = Carbon::parse($attendance_date)->format('l');
            switch ($day) {
                case 'Sunday':
                    $clockInRange = $employee->officeShift::first()->sunday_range_in;
                    $clockOutRange = $employee->officeShift::first()->sunday_range_out;
                    $clockIn = $employee->officeShift::first()->sunday_in;
                    $clockOut = $employee->officeShift::first()->sunday_out;
                    break;
                case 'Monday':
                    $clockInRange = $employee->officeShift::first()->monday_range_in;
                    $clockOutRange = $employee->officeShift::first()->monday_range_out;
                    $clockIn = $employee->officeShift::first()->monday_in;
                    $clockOut = $employee->officeShift::first()->monday_out;
                    break;
                case 'Tuesday':
                    $clockInRange = $employee->officeShift::first()->tuesday_range_in;
                    $clockOutRange = $employee->officeShift::first()->tuesday_range_out;
                    $clockIn = $employee->officeShift::first()->tuesday_in;
                    $clockOut = $employee->officeShift::first()->tuesday_out;
                    break;
                case 'Wednesday':
                    $clockInRange = $employee->officeShift::first()->wednesday_range_in;
                    $clockOutRange = $employee->officeShift::first()->wednesday_range_out;
                    $clockIn = $employee->officeShift::first()->wednesday_in;
                    $clockOut = $employee->officeShift::first()->wednesday_out;
                    break;
                case 'Thursday':
                    $clockInRange = $employee->officeShift::first()->thursday_range_in;
                    $clockOutRange = $employee->officeShift::first()->thursday_range_out;
                    $clockIn = $employee->officeShift::first()->thursday_in;
                    $clockOut = $employee->officeShift::first()->thursday_out;
                    break;
                case 'Friday':
                    $clockInRange = $employee->officeShift::first()->friday_range_in;
                    $clockOutRange = $employee->officeShift::first()->friday_range_out;
                    $clockIn = $employee->officeShift::first()->friday_in;
                    $clockOut = $employee->officeShift::first()->friday_out;
                    break;
                default:
                    $clockInRange = $employee->officeShift::first()->saturday_range_in;
                    $clockOutRange = $employee->officeShift::first()->saturday_range_out;
                    $clockIn = $employee->officeShift::first()->saturday_in;
                    $clockOut = $employee->officeShift::first()->saturday_out;
            }

            $attendance_time = Carbon::createFromFormat('H:i', $request->attendance_time)->format('H:i');
            if (!empty($clockInRange)) {
                $clockInRange = Carbon::createFromTimeString($clockInRange)->format('H:i');
            } else {
                $clockInRange = Carbon::createFromTimeString($clockIn)->format('H:i');
            }

            if (!empty($clockOutRange)) {
                $clockOutRange = Carbon::createFromTimeString($clockOutRange)->format('H:i');
            } else {
                $clockOutRange = Carbon::createFromTimeString($clockOut)->format('H:i');
            }

            if (!empty($clockIn)) {
                $clockIn = Carbon::createFromTimeString($clockIn)->format('H:i');
            } else {
                $clockIn = null;
            }

            if (!empty($clockOut)) {
                $clockOut = Carbon::createFromTimeString($clockOut)->format('H:i');
            } else {
                $clockOut = null;
            }

            //if employee attendance record was not found
            // FOR CLOCK IN
            if (!$employee_attendance_last AND !$employee_attendance_yesterday) {

                // Absen pulang doang
                if ($attendance_time >= $clockOut AND $attendance_time <= $clockOutRange) {
                    $data['clock_out'] = $attendance_time;
                    $data['status'] = 'TA1';
                    $data['attendance_time'] = $attendance_time;
                    RawAttendance::create($data);
                    unset($data['attendance_time']);
                    unset($data['photos']);
                    Attendance::create($data);
                    $match = [
                        'employee_id' => $employee->id,
                        'attendance_date' => $attendance_date,
                    ];
                    ReportAttendance::updateOrCreate($match, [
                        'employee_id' => $employee->id,
                        'attendance_date' => $attendance_date,
                        'status' => $data['status'],
                    ]);

                    // log resource sebelum return
                    $this->logRecordAbsenUsage($t0, $mem0, $request, $employee, $company, $distance, $radius, [
                        'stage' => 'clock_out_only_success',
                        'status' => 'TA1',
                        'attendance_date' => $attendance_date,
                    ]);
                    return response(['data' => 'Terima kasih. Presensi pulang sukses', 'message' => 'Success'], 200);
                } else {
                    $data['attendance_time'] = $attendance_time;
                    RawAttendance::create($data);
                    unset($data['attendance_time']);
                    unset($data['photos']);
                    $data['clock_in'] = $attendance_time;
                    $data['status'] = 'TA2';
                    Attendance::create($data);
                    $match = [
                        'employee_id' => $employee->id,
                        'attendance_date' => $attendance_date,
                    ];
                    ReportAttendance::updateOrCreate($match, [
                        'employee_id' => $employee->id,
                        'attendance_date' => $attendance_date,
                        'status' => $data['status'],
                    ]);

                    $this->logRecordAbsenUsage($t0, $mem0, $request, $employee, $company, $distance, $radius, [
                        'stage' => 'clock_in_success',
                        'status' => 'TA2',
                        'attendance_date' => $attendance_date,
                    ]);
                    return response(['data' => 'Terima kasih. Presensi masuk sukses', 'message' => 'Success'], 200);
                }
            }
            // if shift berbeda hari, CLOCK OUT
            elseif ($employee_attendance_yesterday) {
                $day = Carbon::parse($yesterday_attendance_date)->format('l');
                switch ($day) {
                    case 'Sunday':
                        $clockInRange = $employee->officeShift::first()->sunday_range_in;
                        $clockOutRange = $employee->officeShift::first()->sunday_range_out;
                        $clockIn = $employee->officeShift::first()->sunday_in;
                        $clockOut = $employee->officeShift::first()->sunday_out;
                        break;
                    case 'Monday':
                        $clockInRange = $employee->officeShift::first()->monday_range_in;
                        $clockOutRange = $employee->officeShift::first()->monday_range_out;
                        $clockIn = $employee->officeShift::first()->monday_in;
                        $clockOut = $employee->officeShift::first()->monday_out;
                        break;
                    case 'Tuesday':
                        $clockInRange = $employee->officeShift::first()->tuesday_range_in;
                        $clockOutRange = $employee->officeShift::first()->tuesday_range_out;
                        $clockIn = $employee->officeShift::first()->tuesday_in;
                        $clockOut = $employee->officeShift::first()->tuesday_out;
                        break;
                    case 'Wednesday':
                        $clockInRange = $employee->officeShift::first()->wednesday_range_in;
                        $clockOutRange = $employee->officeShift::first()->wednesday_range_out;
                        $clockIn = $employee->officeShift::first()->wednesday_in;
                        $clockOut = $employee->officeShift::first()->wednesday_out;
                        break;
                    case 'Thursday':
                        $clockInRange = $employee->officeShift::first()->thursday_range_in;
                        $clockOutRange = $employee->officeShift::first()->thursday_range_out;
                        $clockIn = $employee->officeShift::first()->thursday_in;
                        $clockOut = $employee->officeShift::first()->thursday_out;
                        break;
                    case 'Friday':
                        $clockInRange = $employee->officeShift::first()->friday_range_in;
                        $clockOutRange = $employee->officeShift::first()->friday_range_out;
                        $clockIn = $employee->officeShift::first()->friday_in;
                        $clockOut = $employee->officeShift::first()->friday_out;
                        break;
                    default:
                        $clockInRange = $employee->officeShift::first()->saturday_range_in;
                        $clockOutRange = $employee->officeShift::first()->saturday_range_out;
                        $clockIn = $employee->officeShift::first()->saturday_in;
                        $clockOut = $employee->officeShift::first()->saturday_out;
                }
                if (!empty($clockInRange)) {
                    $clockInRange = Carbon::createFromTimeString($clockInRange)->format('H:i');
                } else {
                    $clockInRange = Carbon::createFromTimeString($clockIn)->format('H:i');
                }

                if (!empty($clockOutRange)) {
                    $clockOutRange = Carbon::createFromTimeString($clockOutRange)->format('H:i');
                } else {
                    $clockOutRange = Carbon::createFromTimeString($clockOut)->format('H:i');
                }

                if (!empty($clockIn)) {
                    $clockIn = Carbon::createFromTimeString($clockIn)->format('H:i');
                } else {
                    $clockIn = null;
                }

                if (!empty($clockOut)) {
                    $clockOut = Carbon::createFromTimeString($clockOut)->format('H:i');
                } else {
                    $clockOut = null;
                }
                // if employee is on time
                $data['clock_out'] = $attendance_time;
                $data['status'] = '';
                // calculating total work
                $employee_last_clock_in = new DateTime($employee_attendance_yesterday->clock_in);
                $prev_work = new DateTime($employee_attendance_yesterday->total_work);
                $total_work = $prev_work->add($employee_last_clock_in->diff(new DateTime($data['clock_out'])));
                $data['attendance_date'] = $yesterday_attendance_date;
                $minWorkTime = $employee->officeShift::first()->min_work_hour;
                if (Carbon::createFromTimeString($total_work->format('H:i'))->hour < $minWorkTime) {
                    $isUnderwork = true;
                } else {
                    $isUnderwork = false;
                }
                //updating record
                $data['total_work'] = $total_work->format('H:i');
                $data['attendance_time'] = $attendance_time;
                RawAttendance::create($data);
                unset($data['attendance_time']);
                unset($data['photos']);
                $attendance = Attendance::findOrFail($employee_attendance_yesterday->id);
                $attendance->update($data);
                $match = [
                    'employee_id' => $employee->id,
                    'attendance_date' => $yesterday_attendance_date,
                ];
                ReportAttendance::updateOrCreate($match, [
                    'employee_id' => $employee->id,
                    'attendance_date' => $yesterday_attendance_date,
                    'work_time' => $data['total_work'],
                    'status' => $data['status'],
                    'is_underwork' => $isUnderwork
                ]);

                $this->logRecordAbsenUsage($t0, $mem0, $request, $employee, $company, $distance, $radius, [
                    'stage' => 'cross_day_clock_out_success',
                    'attendance_date' => $yesterday_attendance_date,
                    'is_underwork' => $isUnderwork,
                ]);
                return response(['data' => 'Terima kasih. Presensi pulang sukses', 'message' => 'Success'], 200);
            }
            // if there is a record of employee attendance
            //FOR CLOCK OUT
            else {
                $data['clock_out'] = $attendance_time;
                $data['status'] = '';
                // calculating total work
                $employee_last_clock_in = new DateTime($employee_attendance_last->clock_in);
                $prev_work = new DateTime($employee_attendance_last->total_work);
                $total_work = $prev_work->add($employee_last_clock_in->diff(new DateTime($data['clock_out'])));
                $data['total_work'] = $total_work->format('H:i');
                $minWorkTime = $employee->officeShift::first()->min_work_hour;
                if (Carbon::createFromTimeString($total_work->format('H:i'))->hour < $minWorkTime) {
                    $isUnderwork = true;
                } else {
                    $isUnderwork = false;
                }
                $data['attendance_time'] = $attendance_time;
                RawAttendance::create($data);
                unset($data['attendance_time']);
                unset($data['photos']);
                //updating record
                $attendance = Attendance::findOrFail($employee_attendance_last->id);
                $attendance->update($data);
                $match = [
                    'employee_id' => $employee->id,
                    'attendance_date' => $attendance_date,
                ];
                ReportAttendance::updateOrCreate($match, [
                    'employee_id' => $employee->id,
                    'attendance_date' => $attendance_date,
                    'work_time' => $data['total_work'],
                    'status' => $data['status'],
                    'is_underwork' => $isUnderwork
                ]);

                $this->logRecordAbsenUsage($t0, $mem0, $request, $employee, $company, $distance, $radius, [
                    'stage' => 'clock_out_success',
                    'attendance_date' => $attendance_date,
                    'is_underwork' => $isUnderwork,
                ]);
                return response(['message' => 'Terima kasih. Presensi pulang sukses', 'success' => true], 200);
            }
        } else {
            $this->logRecordAbsenUsage($t0, $mem0, $request, $employee ?? null, $company ?? null, $distance, $radius, [
                'stage' => 'out_of_radius',
            ]);
            return response(['errors' => 'Mohon maaf, anda berada di luar radius. ('.$distance.' meter)', 'success' => false], 200);
        }
    }

    /**
     * Log metrik resource & konteks request untuk record_absen.
     */
    protected function logRecordAbsenUsage(
        float $t0,
        int $mem0,
        Request $request,
        ?Employee $employee,
        ?company $company,
        ?float $distance,
        ?float $radius,
        array $extra = []
    ): void {
        $elapsedMs = (microtime(true) - $t0) * 1000.0;

        $memNow = memory_get_usage(true);
        $memPeak = memory_get_peak_usage(true);
        $memDelta = $memNow - $mem0;

        // Query stats
        $queries = \DB::getQueryLog();
        $queryCount = is_array($queries) ? count($queries) : 0;
        $totalSqlMs = 0.0;
        if (is_array($queries)) {
            foreach ($queries as $q) {
                // Laravel query log time umumnya dalam ms
                if (isset($q['time'])) {
                    $totalSqlMs += floatval($q['time']);
                }
            }
        }

        // File & request size (best-effort)
        $photoSize = null;
        if ($request->file('photo') && $request->file('photo')->isValid()) {
            $photoSize = $request->file('photo')->getSize(); // bytes
        }
        $contentLength = $request->server('CONTENT_LENGTH'); // bytes (kadang null)

        // Identitas
        $userId = optional(Auth::user())->id;
        $employeeId = optional($employee)->id;
        $companyId = optional($company)->id;

        // Lokasi & radius
        $lat = $request->input('lat');
        $long = $request->input('long');

        // Build context
        $context = array_merge([
            'route' => $request->path(),
            'method' => $request->method(),
            'ip' => $request->ip(),
            'user_id' => $userId,
            'employee_id' => $employeeId,
            'company_id' => $companyId,

            'attendance_date' => $request->input('attendance_date'),
            'attendance_time' => $request->input('attendance_time'),
            'lat' => $lat,
            'long' => $long,
            'distance_m' => $distance,
            'radius_m' => $radius,

            'exec_time_ms' => round($elapsedMs, 2),
            'sql_count' => $queryCount,
            'sql_total_ms' => round($totalSqlMs, 2),

            'mem_start' => $this->bytesToHuman($mem0),
            'mem_now' => $this->bytesToHuman($memNow),
            'mem_peak' => $this->bytesToHuman($memPeak),
            'mem_delta' => $this->bytesToHuman(max($memDelta, 0)),

            'photo_size' => $photoSize !== null ? $this->bytesToHuman($photoSize) : null,
            'request_size' => $contentLength ? $this->bytesToHuman((int)$contentLength) : null,
            'user_agent' => $request->userAgent(),
        ], $extra);

        \Log::info('[ATTENDANCE][record_absen][RESOURCE]', $context);
    }

    /**
     * Ubah bytes jadi string human-readable.
     */
    protected function bytesToHuman(int $bytes): string
    {
        $units = ['B','KB','MB','GB','TB'];
        $i = 0;
        $val = (float) $bytes;
        while ($val >= 1024 && $i < count($units) - 1) {
            $val /= 1024;
            $i++;
        }
        return number_format($val, 2).' '.$units[$i];
    }



    protected function hitungJarak($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo, $earthRadius = 6371000)
    {
        // Validate input
        // if (abs($latitudeFrom) > 90 || abs($latitudeTo) > 90 || abs($longitudeFrom) > 180 || abs($longitudeTo) > 180) {
        //     return false; // Invalid latitude/longitude
        // }
    
        // Convert degrees to radians
        $latFrom = deg2rad($latitudeFrom);
        $lonFrom = deg2rad($longitudeFrom);
        $latTo = deg2rad($latitudeTo);
        $lonTo = deg2rad($longitudeTo);
        
        // Haversine formula
        $latDelta = $latTo - $latFrom;
        $lonDelta = $lonTo - $lonFrom;
    
        $a = sin($latDelta / 2) ** 2 + cos($latFrom) * cos($latTo) * sin($lonDelta / 2) ** 2;
        $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
    
        return $earthRadius * $c; // Distance in meters
    }

}
