<?php

namespace App\Http\Controllers;

use App\BPJSKes;
use App\company;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class BPJSKesController extends Controller
{
    public function index()
    {
        $logged_user = auth()->user();
        $companies = company::select('id', 'company_name')->get();

        if ($logged_user->can('view-bpjs-kes')) {
            if (request()->ajax()) {
                return datatables()->of(BPJSKes::with('companies')->get())
                    ->setRowId(function ($bpjs) {
                        return $bpjs->id;
                    })
                    ->addColumn('name', function ($row) {
                        return $row->name;
                    })
                    ->addColumn('company_name', function ($row) {
                        return $row->companies->company_name;
                    })
                    ->addColumn('company', function ($row) {
                        return $row->company . ' %';
                    })
                    ->addColumn('employee', function ($row) {
                        return $row->employee . ' %';
                    })
                    ->addColumn('action', function ($data) {
                        $button = '<button type="button" name="show" id="' . $data->id . '" class="show_new btn btn-success btn-sm"><i class="dripicons-preview"></i></button>';
                        $button .= '&nbsp;&nbsp;';
                        if (auth()->user()->can('edit-bpjs-kes')) {
                            $button .= '<button type="button" name="edit" id="' . $data->id . '" class="edit btn btn-primary btn-sm"><i class="dripicons-pencil"></i></button>';
                            $button .= '&nbsp;&nbsp;';
                        }
                        if (auth()->user()->can('delete-bpjs-kes')) {
                            $button .= '<button type="button" name="delete" id="' . $data->id . '" class="delete btn btn-danger btn-sm"><i class="dripicons-trash"></i></button>';
                        }

                        return $button;
                    })
                    ->rawColumns(['action'])
                    ->make(true);
            }

            return view('core_hr.bpjs_kes.index', compact('companies'));
        }

        return abort('403', __('You are not authorized'));
    }

    public function store(Request $request)
    {
        $logged_user = auth()->user();

        if ($logged_user->can('store-bpjs-kes')) {
            $validator = Validator::make(
                $request->only(
                    'company_id',
                    'name',
                    'min_salary',
                    'max_salary',
                ),
                [
                    'company_id' => 'required',
                    'name' => 'required',
                    'min_salary' => 'required',
                    'max_salary' => 'required',
                ]
            );


            if ($validator->fails()) {
                return response()->json(['errors' => $validator->errors()->all()]);
            }


            $data = [];

            $data['company_id'] = $request->company_id;
            $data['name'] = $request->name;
            $data['company'] = $request->company ?? 0;
            $data['employee'] = $request->employee ?? 0;
            $data['min_salary'] = $request->min_salary;
            $data['max_salary'] = $request->max_salary;
            BPJSKes::create($data);

            return response()->json(['success' => __('Data Added successfully.')]);
        }

        return response()->json(['success' => __('You are not authorized')]);
    }

    public function edit($id)
	{
		if (request()->ajax())
		{
			$data = BPJSKes::with('companies')->findOrFail($id);

			return response()->json(['data' => $data]);
		}
	}

    public function update(Request $request)
	{
		$logged_user = auth()->user();

		if ($logged_user->can('edit-bpjs-kes'))
		{
			$id = $request->hidden_id;

            $validator = Validator::make(
                $request->only(
                    'company_id',
                    'name',
                    'min_salary',
                    'max_salary'
                ),
                [
                    'company_id' => 'required',
                    'name' => 'required',
                    'min_salary' => 'required',
                    'max_salary' => 'required',
                ]
            );


			if ($validator->fails())
			{
				return response()->json(['errors' => $validator->errors()->all()]);
			}


			$data = [];

            $data['company_id'] = $request->company_id;
            $data['name'] = $request->name;
            $data['company'] = $request->company ?? 0;
            $data['employee'] = $request->employee ?? 0;
            $data['min_salary'] = $request->min_salary;
            $data['max_salary'] = $request->max_salary;

			BPJSKes::find($id)->update($data);

			return response()->json(['success' => __('Data is successfully updated')]);
		}
		return response()->json(['success' => __('You are not authorized')]);
	}

    public function destroy($id)
	{
		if(!env('USER_VERIFIED'))
		{
			return response()->json(['error' => 'This feature is disabled for demo!']);
		}
		$logged_user = auth()->user();

		if ($logged_user->can('delete-bpjs-kes'))
		{
			BPJSKes::whereId($id)->delete();

			return response()->json(['success' => __('Data is successfully deleted')]);
		}
		return response()->json(['success' => __('You are not authorized')]);
	}
    public function delete_by_selection(Request $request)
	{
		if(!env('USER_VERIFIED'))
		{
			return response()->json(['error' => 'This feature is disabled for demo!']);
		}
		$logged_user = auth()->user();

		if ($logged_user->can('delete-bpjs-kes'))
		{

			$bpjs_kes_id = $request['BPJSKesIdArray'];
			$bpjs_kes = BPJSKes::whereIntegerInRaw('id', $bpjs_kes_id);
			if ($bpjs_kes->delete())
			{
				return response()->json(['success' => __('Multi Delete', ['key' => __('BPJS TK')])]);
			} else
			{
				return response()->json(['error' => 'Error, selected BPJS TK can not be deleted']);
			}
		}
		return response()->json(['success' => __('You are not authorized')]);
	}
    public function show($id)
	{
		if (request()->ajax())
		{
			$data = BPJSKes::with('companies')->findOrFail($id);
			return response()->json(['data' => $data]);
		}
	}
}
