<?php

namespace App\Http\Controllers;

use App\Announcement;
use App\Attendance;
use App\Award;
use App\GeneralSetting;
use App\Client;
use App\company;
use App\DocumentType;
use App\Employee;
use App\EmployeeProject;
use App\EmployeeTask;
use App\EmployeeTicket;
use App\EmployeeWorkExperience;
use App\FinanceDeposit;
use App\FinanceExpense;
use App\Holiday;
use App\Http\traits\CalendarableModelTrait;
use App\Http\traits\ShiftTimingOnDay;
use App\Invoice;
use App\IpSetting;
use App\leave;
use App\LeaveType;
use App\location;
use App\Payslip;
use App\Project;
use App\QualificationEducationLevel;
use App\QualificationLanguage;
use App\QualificationSkill;
use App\ReimbursementType;
use App\SalaryBasic;
use App\status;
use App\SupportTicket;
use App\Trainer;
use App\TrainingType;
use App\TravelType;
use App\User;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Throwable;

class DashboardController extends Controller
{

	use CalendarableModelTrait;

	public function __construct()
	{
		$this->middleware(['auth']);
	}

	/**
	 * Show the application dashboard.
	 *
	 * @return Renderable
	 */
	public function index(Request $request)
	{
		$user = auth()->user();
		$companyId = [1];
		if($request->filter_gender != null) {
			$gender = array($request->filter_gender);
		} else {
			$gender = array('Male', 'Female', '');
		}
		
		if($request->filter_marital != null) {
			$marital = array($request->filter_marital);
		} else {
			$marital = array('divorced', 'married', 'single', '', null);
		}
		
		if($request->filter_religion != null) {
			$religion = array($request->filter_religion);
		} else {
			$religion = array('islam', 'kristen', 'katholik', 'hindu', 'budha', 'konghucu', 'lainnya', 'kepercayaan', '');
		}
		
		
		$employees = Employee::with('department:id,department_name', 'designation:id,designation_name')
			->select('id', 'department_id', 'designation_id', 'is_active', 'gender', 'company_id');

		if($request->filter_gender != null) {
			$employees = $employees->whereIn('gender', $gender);
		}

		if($request->filter_marital != null) {
			$employees = $employees->whereIn('marital_status', $marital);
		}

		if($request->filter_religion != null) {
			$employees = $employees->whereIn('religion', $religion);
		}

		$employees = $employees->where('is_active', '=', 1)
			->where('exit_date', NULL);

		$employeeCounts = [];
		$companies_data = company::all();
		foreach ($companies_data as $comp) {
			$employee_no = Employee::with('department:id,department_name', 'designation:id,designation_name')
			->select('id', 'department_id', 'designation_id', 'is_active', 'gender', 'company_id');

			if($request->filter_gender != null) {
				$employee_no = $employee_no->whereIn('gender', $gender);
			}

			if($request->filter_marital != null) {
				$employee_no = $employee_no->whereIn('marital_status', $marital);
			}

			if($request->filter_religion != null) {
				$employee_no = $employee_no->whereIn('religion', $religion);
			}

			$employee_no = $employee_no->where('is_active', '=', 1)
				->where('exit_date', NULL);

			$comp_arr = array($comp->id);
			$employeeCounts[$comp->id] = $employee_no
				->whereIn('company_id', $comp_arr)
				->count();
		}

		if ($user->role_users_id == 6) {
			if(!$request->session()->has('selected_company')) {
				$companyId = json_decode($user->company_ids);
			} else {
				$companyId = array(session('selected_company'));
			}
			$employees->whereIn('company_id', $companyId);
		}

		$employees = $employees->get();
		$employees_count = $employees->count();
		
		$endDate = $request->end_date ? Carbon::parse($request->end_date)->format('Y-m-d') :  now()->format('Y-m-d');
		$startDate = $request->start_date ? Carbon::parse($request->start_date)->format('Y-m-d') : now()->subMonth()->format('Y-m-d');
		
		$totalDays = Carbon::parse($endDate)->diffInDays(Carbon::parse($startDate)) + 1;

		$attendanceCount =  Attendance::whereBetween('attendance_date', [$startDate, $endDate]);
		if ($companyId) {
			$attendanceCount->whereHas('employee', function ($query) use ($companyId) {
				return $query->whereIn('company_id', $companyId);
			});
		}
		$attendanceCount = $attendanceCount->count();

		$absentCount = 0;
		$underWorkCount = 0;
		$lateCount = 0;
		$overWorkCount = 0;
		$inAfterEightCount = 0;
		$outBeforeFiveCount = 0;
		$inAfterThreeCount = 0;
		$outBeforeElevenCount = 0;
		$inAfterElevenCount = 0;
		$outBeforeEightCount = 0;
		$workStart = '09:00';
		$attendStart = '07:00';

		foreach ($employees as $employee) {
			if ($companyId == null) {
				$attendances = Attendance::whereHas('employee', function ($query) use ($companyId) {
					return $query->whereIn('company_id', $companyId);
				})->with('employee')->where('employee_id', $employee->id)->whereBetween('attendance_date', [$startDate, $endDate])->get();
			} else {
				$attendances = Attendance::where('employee_id', $employee->id)->whereBetween('attendance_date', [$startDate, $endDate])->get();
			}

			$absent = $totalDays - $attendances->where('total_work', '!=', '00:00')->count();
			$underWork = $attendances->where('total_work', '<', '09:00')->where('total_work', '!=', '00:00')->count();
			$late = $attendances->where('clock_in', '>', $workStart)->count();
			$overWork = $attendances->where('total_work', '>', '11:00')->count();
			$inAfterEight = $attendances->where('clock_in', '>', '08:15')->count();
			$outBeforeFive = $attendances->where('clock_out', '<', '17:15')->where('clock_out', '>=', $attendStart)->count();
			$inAfterThree = $attendances->where('clock_in', '>', '15:15')->count();
			$outBeforeEleven = $attendances->where('clock_out', '<', '23:15')->where('clock_out', '>=', $attendStart)->count();
			$inAfterEleven = $attendances->where('clock_in', '>', '23:15')->count();
			$outBeforeEight = $attendances->where('clock_out', '<', '08:15')->where('clock_out', '>=', $attendStart)->count();

			$absentCount += $absent;
			$underWorkCount += $underWork;
			$lateCount += $late;
			$overWorkCount += $overWork;
			$inAfterEightCount += $inAfterEight;
			$outBeforeFiveCount += $outBeforeFive;
			$inAfterThreeCount += $inAfterThree;
			$outBeforeElevenCount += $outBeforeEleven;
			$inAfterElevenCount += $inAfterEleven;
			$outBeforeEightCount += $outBeforeEight;
		}

		//dd($request->session()->all());
		return view('dashboard.admin_dashboard', [
			'employees' => $employees,
			'employee_no_get' => $employee_no,
			'attendance_count' => $attendanceCount,
			'employees_count' => $employeeCounts,
			'absent_count' => $absentCount,
			'under_work_count' => $underWorkCount,
			'late_count' => $lateCount,
			'over_work_count' => $overWorkCount,
			'in_after_eight_count' => $inAfterEightCount,
			'out_before_five_count' => $outBeforeFiveCount,
			'in_after_three_count' => $inAfterThreeCount,
			'out_before_eleven_count' => $outBeforeElevenCount,
			'in_after_eleven_count' => $inAfterElevenCount,
			'out_before_eight_count' => $outBeforeEightCount,
			'end_date' => $endDate,
			'start_date' => $startDate,
			'total_days' => $totalDays,
			'gender' => $gender,
			'marital' => $marital,
			'religion' => $religion,
		]);
	}
	
	public function set_company(Request $request)
	{
		$company_id = $request->company_id;
		//dd($company_id);
		$request->session()->put('selected_company', $company_id);
		$data = ['success' => 1, 'message' => 'Berhasil memilih company.'];
		return json_encode($data);
	}

	public function detail(Request $request)
	{
		$user = auth()->user();
		if ($user->role_users_id == 6) {
			if(!$request->session()->has('selected_company')) {
				$companyId = json_decode($user->company_ids);
			} else {
				$companyId = array(session('selected_company'));
			}
		}
		
		$employees = Employee::with('department:id,department_name', 'designation:id,designation_name')
			->select('id', 'first_name', 'last_name', 'department_id', 'designation_id', 'is_active')
			->where('is_active', '=', 1)->where('is_active', 1)
			->where('exit_date', NULL);

		if(!empty($companyId) && $companyId != '')
		{
			$employees = $employees->whereIn('company_id', $companyId);
		}

		$employees = $employees->get();
		
		$startDate = $request->start_date;
		$endDate = $request->end_date;
		$workStart = '09:00';
		$attendStart = '07:00';

		switch ($request->type) {
			case 'absent':
				$totalDays = Carbon::parse($endDate)->diffInDays(Carbon::parse($startDate)) + 1;
				$periods = CarbonPeriod::create($startDate, $endDate);
				$dates = [];
				foreach ($periods as $p) {
					$dates[] = $p->format('Y-m-d');
				}
				foreach ($employees as $employee) {
					$attendances = Attendance::where([['employee_id', '=', $employee->id], ['total_work', '!=', '00:00']])->whereBetween('attendance_date', [$startDate, $endDate])->get();
					$attendDates = $attendances->pluck('attendance_date')->toArray();

					$employee->total = $totalDays - $attendances->count();
					$employee->detail = array_values(array_diff($dates, $attendDates));
				}

				break;
			case 'under_work':
				foreach ($employees as $employee) {
					$attendances = Attendance::where([['employee_id', '=', $employee->id], ['total_work', '<', '09:00'], ['total_work', '!=', '00:00']])->whereBetween('attendance_date', [$startDate, $endDate])->get();

					$employee->total = $attendances->count();
					$employee->detail = $attendances->pluck('attendance_date')->toArray();
				}
				break;
			case 'late':
				foreach ($employees as $employee) {
					$attendances = Attendance::where([['employee_id', '=', $employee->id], ['clock_in', '>', $workStart]])->whereBetween('attendance_date', [$startDate, $endDate])->get();

					$employee->total = $attendances->count();
					$employee->detail = $attendances->pluck('attendance_date')->toArray();
				}
			case 'over_work':
				foreach ($employees as $employee) {
					$attendances = Attendance::where([['employee_id', '=', $employee->id], ['total_work', '>', '11:00']])->whereBetween('attendance_date', [$startDate, $endDate])->get();

					$employee->total = $attendances->count();
					$employee->detail = $attendances->pluck('attendance_date')->toArray();
				}
				break;
			case 'in_after_eight':
				foreach ($employees as $employee) {
					$attendances = Attendance::where([['employee_id', '=', $employee->id], ['clock_in', '>', '08:15']])->whereBetween('attendance_date', [$startDate, $endDate])->get();

					$employee->total = $attendances->count();
					$employee->detail = $attendances->pluck('attendance_date')->toArray();
				}
				break;
			case 'out_before_five':
				foreach ($employees as $employee) {
					$attendances = Attendance::where([['employee_id', '=', $employee->id], ['clock_out', '<', '17:15'], ['clock_out', '>=', $attendStart]])->whereBetween('attendance_date', [$startDate, $endDate])->get();

					$employee->total = $attendances->count();
					$employee->detail = $attendances->pluck('attendance_date')->toArray();
				}
				break;
			case 'in_after_three':
				foreach ($employees as $employee) {
					$attendances = Attendance::where([['employee_id', '=', $employee->id], ['clock_in', '>', '15:15']])->whereBetween('attendance_date', [$startDate, $endDate])->get();

					$employee->total = $attendances->count();
					$employee->detail = $attendances->pluck('attendance_date')->toArray();
				}
				break;
			case 'out_before_eleven':
				foreach ($employees as $employee) {
					$attendances = Attendance::where([['employee_id', '=', $employee->id], ['clock_out', '<', '23:15'], ['clock_out', '>=', $attendStart]])->whereBetween('attendance_date', [$startDate, $endDate])->get();

					$employee->total = $attendances->count();
					$employee->detail = $attendances->pluck('attendance_date')->toArray();
				}
				break;
			case 'in_after_eleven':
				foreach ($employees as $employee) {
					$attendances = Attendance::where([['employee_id', '=', $employee->id], ['clock_in', '>', '23:15']])->whereBetween('attendance_date', [$startDate, $endDate])->get();

					$employee->total = $attendances->count();
					$employee->detail = $attendances->pluck('attendance_date')->toArray();
				}
				break;
			case 'out_before_eight':
				foreach ($employees as $employee) {
					$attendances = Attendance::where([['employee_id', '=', $employee->id], ['clock_out', '<', '03:15'], ['clock_out', '>=', $attendStart]])->whereBetween('attendance_date', [$startDate, $endDate])->get();

					$employee->total = $attendances->count();
					$employee->detail = $attendances->pluck('attendance_date')->toArray();
				}
				break;
		}

		return datatables()->of($employees)
			->setRowId(function ($row) {
				return $row->id;
			})
			->addColumn('employee_name', function ($row) {
				return $row->first_name . ' ' . $row->last_name;
			})
			->addColumn('total', function ($row) {
				return $row->total;
			})
			->addColumn('detail', function ($row) {
				return $row->detail;
			})
			->make(true);
	}

	public function profile()
	{
		$user = auth()->user();

		$employee = Employee::find($user->id);

		if (!$employee) {
			if ($user->role_users_id == 3) {
				return view('profile.client_profile', compact('user'));
			}

			return view('profile.user_profile', compact('user'));
		} else {
			$statuses = status::select('id', 'status_title')->get();

			$countries = DB::table('countries')->select('id', 'name')->get();
			$document_types = DocumentType::select('id', 'document_type')->get();

			$education_levels = QualificationEducationLevel::select('id', 'name')->get();
			$language_skills = QualificationLanguage::select('id', 'name')->get();
			$general_skills = QualificationSkill::select('id', 'name')->get();

			$salary_basics = SalaryBasic::where('employee_id', $employee->id)
				->orderByRaw('DATE_FORMAT(first_date, "%y-%m")')
				->get();

			return view('profile.employee_profile', compact(
				'user',
				'employee',
				'statuses',
				'countries',
				'document_types',
				'education_levels',
				'language_skills',
				'general_skills',
				'salary_basics'
			));
		}
	}

	public function profile_update(Request $request, $id)
	{

		if (!env('USER_VERIFIED')) {
			return redirect()->back()->with('msg', 'This feature is disabled for demo!');
		}
		$user = User::findOrFail($id);

		$validator = Validator::make(
			$request->all(),
			[
				'first_name' => 'required|unique:users,first_name,' . $id,
				'last_name' => 'required|unique:users,last_name,' . $id,
				'username' => 'required|unique:users,username,' . $id,
				'email' => 'required|email|unique:users,email,' . $id,
				'contact_no' => 'required|unique:users,contact_no,' . $id,
				'profile_photo' => 'nullable|image|max:10240|mimes:jpeg,png,jpg,gif',
			]
		);


		if ($validator->fails()) {
			return redirect()->back()->withErrors($validator)->withInput();
		}
		$photo = $request->profile_photo;


		if (isset($photo)) {
			$new_user = $request->username;
			if ($photo->isValid()) {
				$file_name = preg_replace('/\s+/', '', $new_user) . '_' . time() . '.' . $photo->getClientOriginalExtension();
				$photo->storeAs('profile_photos', $file_name);
				$user->profile_photo = $file_name;
			}
		}

		$username = strtolower(trim($request->username));
		$contact_no = $request->contact_no;
		$email = strtolower(trim($request->email));

		$user->first_name = $request->first_name;
		$user->last_name = $request->last_name;
		$user->username = $username;
		$user->contact_no = $contact_no;
		$user->email = $email;

		$user->save();

		if ($user->role_users_id == 3) {
			Client::whereId($user->id)->update([
				'username' => $username, 'contact_no' => $contact_no,
				'email' => $email
			]);
			$this->setSuccessMessage(__('User Info Updated'));

			return redirect()->route('clientProfile');
		}

		$this->setSuccessMessage(__('User Info Updated'));

		return redirect()->route('profile');
	}

	public function employeeProfileUpdate(Request $request, $id)
	{

		$validator = Validator::make(
			$request->only(
				'first_name',
				'last_name',
				'email',
				'contact_no',
				'gender'
			),
			[
				'first_name' => 'required',
				'last_name' => 'required',
				'email' => 'required|email|unique:users,email,' . $id,
				'contact_no' => 'required|numeric|unique:users,contact_no,' . $id,
				'gender' => 'required',
			]
		);


		if ($validator->fails()) {
			return response()->json(['errors' => $validator->errors()->all()]);
		}

		$data = [];
		$data['first_name'] = $request->first_name;
		$data['last_name'] = $request->last_name;
		$data['gender'] = $request->gender;
		$data['marital_status'] = $request->marital_status;

		$data['address'] = $request->address;
		$data['city'] = $request->city;
		$data['state'] = $request->state;
		$data['country'] = $request->country;
		$data['zip_code'] = $request->zip_code;


		$data['email'] = strtolower(trim($request->email));
		$data['contact_no'] = $request->contact_no;


		$user = [];

		$user['email'] = strtolower(trim($request->email));
		$user['contact_no'] = $request->contact_no;


		DB::beginTransaction();
		try {
			User::whereId($id)->update($user);

			employee::whereId($id)->update($data);

			DB::commit();
		} catch (Exception $e) {
			DB::rollback();
			return response()->json(['error' =>  $e->getMessage()]);
		} catch (Throwable $e) {
			DB::rollback();
			return response()->json(['error' => $e->getMessage()]);
		}

		return response()->json(['success' => __('Data Added successfully.')]);
	}


	public function change_password(Request $request, $id)
	{

// 		if (!env('USER_VERIFIED')) {
// 			return redirect()->back()->with('msg', 'This feature is disabled for demo!');
// 		}

		$user = User::findOrFail($id);

		$validator = Validator::make(
			$request->all(),
			[
				'password' => [
					'required',
					'min:8',
					'confirmed',
					'regex:/^(?=.*[A-Z])(?=.*[a-z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{8,}$/'
				],
			],
			[
				'password.regex' => 'The password must be at least 8 characters long and include at least one uppercase letter, one lowercase letter, one number, and one symbol.',
			]
		);


		if ($validator->fails()) {
			return redirect()->back()->withErrors($validator)->withInput();
		}


		$user->password = bcrypt($request->password);
		$user->save();

		$this->setSuccessMessage(__('Password has been changed'));

		return redirect('login')->with(Auth::logout());
	}


	protected function getIp($ip)
	{
		$data  = [];
		$data  = str_split($ip);
		$length = strlen($ip) . '<br>';

		$count = 0;
		$get_ip = "";
		for ($i = 0; $i < $length; $i++) {
			if ($data[$i] == '.') {
				$count++;
			}
			$get_ip .= $data[$i];
			if ($count == 3) {
				break;
			}
		}

		return $get_ip;
	}


	public function employeeDashboard(Request $request)
	{
		// return EmployeeWorkExperience::where('employee_id', 52)->get();

		$user = auth()->user();
		$logged_user = auth()->user();
		if(empty($user->company_ids))
		{
			$staff_id = preg_replace('/\D/', '', $user->username);
			$get_employee = Employee::where('staff_id', $staff_id)->first();
			if(!empty($get_employee))
			{
				if(empty($get_employee->company_id))
				{
					return redirect('login')->with(Auth::logout());		
				}
			}
			else
			{
				return redirect('login')->with(Auth::logout());
			}
			
		}

		$employee = Employee::with('department:id,department_name', 'officeShift')->findOrFail($user->id);
		
		$current_day_in = strtolower(Carbon::now()->format('l')) . '_in';
		$current_day_out = strtolower(Carbon::now()->format('l')) . '_out';

		$shift_in = $employee->officeShift->$current_day_in;
		$shift_out = $employee->officeShift->$current_day_out;
		$shift_name = $employee->officeShift->shift_name;

		// $announcements = Announcement::where('start_date', '<=', now()->format('Y-m-d'))
		// 	->where('end_date', '>=', now()->format('Y-m-d'))->where('is_notify', 1)->select('id', 'title', 'summary')->latest()->take(3)->get();

		$employee = Employee::findOrFail($logged_user->id);
				$announcements = Announcement::with('company', 'department')
					->where('company_id', $employee->company_id)
					->where(function($query) use ($employee) {
						$query->where('department_id', $employee->department_id)
							->orWhereNull('department_id');
					})
					->get();

		$employee_award_count = Award::where('employee_id', $user->id)->count();

		$holidays = Holiday::where('is_publish', 1)
			->where('end_date', '>=', now()->format('Y-m-d'))
			->where('company_id', $employee->company_id)
			->select('id', 'event_name', 'start_date', 'end_date')->latest()->take(3)->get();

		$leave_types = LeaveType::select('id', 'leave_type', 'allocated_day')->get();
		$travel_types = TravelType::select('id', 'arrangement_type')->get();
		$reimbursement_types = ReimbursementType::select('id', 'name')->get();


		$assigned_projects = EmployeeProject::with(['assignedProjects' => function ($query) use ($employee) {
			$query->where('project_status', '!=', 'completed')->select('id', 'title', 'project_status');
		},])
			->where('employee_id', $employee->id)->get();
		// $assigned_projects_count = $assigned_projects->count();
		$assigned_projects_count = 0;
		foreach ($assigned_projects as $task) {
			if (count($task->assignedProjects) != 0) {
				$assigned_projects_count++;
			}
		}


		$assigned_tasks = EmployeeTask::with(['assignedTasks' => function ($query) use ($employee) {
			$query->where('task_status', '!=', 'completed')->select('id', 'task_name', 'task_status');
		},])
			->where('employee_id', $employee->id)->get();

		// $assigned_tasks_count = $assigned_tasks->count();
		$assigned_tasks_count = 0;
		foreach ($assigned_tasks as $task) {
			if (count($task->assignedTasks) != 0) {
				$assigned_tasks_count++;
			}
		}


		$assigned_tickets = EmployeeTicket::with(['assignedTickets' => function ($query) use ($employee) {
			$query->where('ticket_status', '=', 'open')->select('id', 'subject', 'ticket_code', 'ticket_status');
		},])
			->where('employee_id', $employee->id)->get();

		//$assigned_tickets_count = $assigned_tickets->count();
		$assigned_tickets_count = 0;
		foreach ($assigned_tickets as $ticket) {
			if (count($ticket->assignedTickets) != 0) {
				$assigned_tickets_count++;
			}
		}



		//checking if emoloyee has attendance on current day
		$employee_attendance = Attendance::where('attendance_date', now()->format('Y-m-d'))
			->where('employee_id', $employee->id)->orderBy('id', 'desc')->first() ?? null;

		//IP Check

		$ip_setting = IpSetting::get();

		if (count($ip_setting) == 0) {
			$ipCheck =  false;
		} else {
			foreach ($ip_setting as $key => $value) {
				$db_ip = $this->getIp($value->ip_address);

				$client_ip = $this->getIp($request->ip());

				if ($db_ip == $client_ip) {
					$ipCheck =  true;
					break;
				} else {
					$ipCheck =  false;
				}
			}
		}
		return view('dashboard.employee_dashboard', compact(
			'user',
			'employee',
			'employee_attendance',
			'shift_in',
			'shift_out',
			'shift_name',
			'announcements',
			'employee_award_count',
			'holidays',
			'leave_types',
			'travel_types',
			'reimbursement_types',
			'assigned_projects',
			'assigned_projects_count',
			'assigned_tasks',
			'assigned_tasks_count',
			'assigned_tickets',
			'assigned_tickets_count',
			'ipCheck'
		));
	}



	public function clientDashboard()
	{
		// Auth::logout();
		// return redirect()->back();

		$user = auth()->user();

		$client = Client::with('invoices', 'projects')->findOrFail($user->id);

		$paid_invoices = $client->invoices->where('status', 1);

		$paid_invoice_count = $paid_invoices->count();

		$unpaid_invoices = $client->invoices->where('status', 0);

		$unpaid_invoice_count = $unpaid_invoices->count();

		$completed_project_count = $client->projects->where('project_status', 'completed')->count();

		$in_progress_project_count = $client->projects->where('project_status', 'in_progress')->count();

		$invoice_paid_amount_raw = $paid_invoices->sum('grand_total');

		$invoice_unpaid_amount_raw = $unpaid_invoices->sum('grand_total');

		if (config('variable.currency_format') == 'suffix') {
			$invoice_paid_amount = $invoice_paid_amount_raw . config('variable.currency');
			$invoice_unpaid_amount = $invoice_unpaid_amount_raw . config('variable.currency');
		} else {
			$invoice_paid_amount = config('variable.currency') . $invoice_paid_amount_raw;
			$invoice_unpaid_amount = config('variable.currency') . $invoice_unpaid_amount_raw;
		}


		return view('dashboard.client_dashboard', compact(
			'user',
			'client',
			'paid_invoice_count',
			'unpaid_invoice_count',
			'completed_project_count',
			'in_progress_project_count',
			'invoice_paid_amount',
			'invoice_unpaid_amount'
		));
	}

	public function clientProfile()
	{
		$user = auth()->user();
		if ($user->role_users_id == 3) {
			return view('profile.client_profile', compact('user'));
		}

		return redirect('profile');
	}
}
