<?php

namespace App\Http\Controllers;

use App\company;
use App\department;
use App\designation;
use App\Employee;
use App\FinanceBankCash;
use App\JobCandidate;
use App\office_shift;
use App\SupportTicket;
use App\TaxType;
use App\PTKP;
use Illuminate\Http\Request;

class DynamicDependent extends Controller {

	public function fetchDepartment(Request $request)
	{
		$value = $request->get('value');
		$dependent = $request->get('dependent');
		$data = department::whereCompany_id($value)->groupBy('department_name')->get();
		$output = '';
		foreach ($data as $row)
		{
			$output .= '<option value=' . $row->id . '>' . $row->$dependent . '</option>';
		}

		return $output;
	}

	public function fetchOfficeShifts(Request $request)
	{
		$value = $request->get('value');
		$dependent = $request->get('dependent');
		$data = office_shift::whereCompany_id($value)->groupBy('shift_name')->get();
		$output = '';
		foreach ($data as $row)
		{
			$output .= '<option value=' . $row->id . '>' . $row->$dependent . '</option>';
		}
		
		$get_code = company::where('id', $value)->first();
        
        if(!empty($get_code->employee_code))
        {
            $resp['code'] = $get_code->employee_code;

			$employee = Employee::where('staff_id', 'LIKE', $get_code->employee_code . '%')
				->orderBy('staff_id', 'DESC')
				->first();

			$staffNumbers = null;
			if (preg_match('/^([A-Za-z]+)(\d+)$/', $employee->staff_id, $matches)) {
				$prefix = $matches[1];
				$number = (int)$matches[2];

				if ($staffNumbers === null || $number > $staffNumbers) {
					$staffNumbers = $number;
				}
			}
			$staffNumbers = $staffNumbers+1;
			$formattedStaffNumber = str_pad($staffNumbers, 5, '0', STR_PAD_LEFT);

			$resp['staff_number'] = $formattedStaffNumber;
        }
        else
        {
            $resp['code'] = '';
			$resp['staff_number'] = 1;
        }
		
		$resp['data'] = $output;
		
		return $resp;
	}

	public function fetchEmployee(Request $request)
	{
		$value = $request->get('value');
		$data = Employee::whereCompany_id($value)
                            ->where('is_active',1)
                            ->where('exit_date',NULL)
                            ->get();
		$output = '';
		foreach ($data as $row)
		{
			$output .= '<option value=' . $row->id . '>' . $row->full_name . '</option>';
		}

		return $output;
	}

	public function fetchEmployeeDepartment(Request $request)
	{
		$value = $request->get('value');
		$first_name = $request->get('first_name');
		$last_name = $request->get('last_name');
		$data = Employee::wheredepartment_id($value)
                    ->where('is_active',1)
                    ->where('exit_date',NULL)
                    ->get();
		$output = '';
		foreach ($data as $row)
		{
			$output .= '<option value=' . $row->id . '>' . $row->$first_name . ' ' . $row->$last_name . '</option>';
		}

		return $output;
	}

	public function fetchDesignationDepartment(Request $request)
	{
		$value = $request->get('value');
		$designation_name = $request->get('designation_name');
		$data = designation::wheredepartment_id($value)->groupBy('designation_name')->get();
		$output = '';

		foreach ($data as $row)
		{
			$output .= '<option value=' . $row->id . '>' . $row->$designation_name . '</option>';
		}

		return $output;
	}

	public function fetchBalance(Request $request)
	{
		$value = $request->get('value');
		$dependent = $request->get('dependent');
		$data = FinanceBankCash::whereId($value)->pluck('account_balance')->first();
		$output = '';
		$output .= '<p> (Available Balance ' . $data  .  ' )</p>';
		return $output;
	}

	public function companyEmployee(SupportTicket $ticket){
		$value = $ticket->company_id;
		$data = Employee::whereCompany_id($value)
                ->where('is_active',1)
                ->where('exit_date',NULL)
                ->get();
		$output = '';
		foreach ($data as $row)
		{
			$output .= '<option value=' . $row->id . '>' . $row->first_name . ' ' . $row->last_name . '</option>';
		}

		return $output;
	}


	public function getTaxRate(Request $request)
	{
		$value = $request->get('value');
		$qty = $request->get('qty');
		$unit_price = $request->get('unit_price');

		$data = TaxType::findorFail($value);
		$total_cost = $qty * $unit_price;
		if($data->type=='fixed')
		{
			$tax = $data->rate;
			$sub_total = $total_cost + $tax;
		}
		else {
			$tax = (($total_cost)*($data->rate/100));
			$sub_total = $total_cost + $tax;
		}

		return response()->json(['data'=>$data,'sub_total'=>$sub_total,'tax'=>$tax,'total_cost'=>$total_cost]);

	}


	public function fetchCandidate(Request $request)
	{
		$value = $request->get('value');

		$data = JobCandidate::whereJob_id($value)->groupBy('full_name')->get();
		$output = '';
		foreach ($data as $row)
		{
			$output .= '<option value=' . $row->id . '>' . $row->full_name . '</option>';
		}

		return $output;
	}

	public function fetchPtkp(Request $request)
	{
		$value = $request->get('value');

		$data = PTKP::where('company_id', $value)->get();
		$output = '';
		foreach ($data as $row)
		{
			$output .= '<option value=' . $row->name . '>' . $row->name . '</option>';
		}

		return $output;
	}

}
