<?php

namespace App\Http\Controllers;

use App\company;
use App\department;
use App\designation;
use App\DocumentType;
use App\Employee;
use App\EmployeeDocument;
use App\EmployeeImmigration;
use App\Exports\EmployeeLeavesExport;
use App\Exports\EmployeePositionExport;
use App\Imports\EmployeeImport;
use App\Imports\EmployeePositionImport;
use App\Imports\UsersImport;
use App\Notifications\EmployeeCreatedNotification;
use App\office_shift;
use App\PaidSalary;
use App\PTKP;
use App\QualificationEducationLevel;
use App\QualificationLanguage;
use App\QualificationSkill;
use App\salary;
use App\status;
use App\User;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Facades\Excel;
use Maatwebsite\Excel\Validators\ValidationException;
use Maatwebsite\Excel\Jobs\QueueImport;

use Spatie\Permission\Models\Role;
use Throwable;
use Barryvdh\DomPDF\Facade as PDF;

use App\SalaryBasic;
use Carbon\Carbon;
use Illuminate\Support\Facades\Notification;

use function PHPUnit\Framework\isEmpty;

class EmployeeController extends Controller
{


	public function index(Request $request)
	{
		$logged_user = auth()->user();
		$companyId = null;
		if ($logged_user->role_users_id == 6) {
			$companyId = json_decode($logged_user->company_ids);
		}

		$roleId = $logged_user->roles->pluck('id')->first();
		$isPayroll = Role::where('id', $roleId)->pluck('is_payroll')->first();
		$isCeo = Role::where('id', $roleId)->pluck('is_ceo')->first();
		$now = Carbon::now();

		if ($logged_user->can('view-details-employee')) {
			if ($logged_user->role_users_id == 6) {
				if(!$request->session()->has('selected_company')) {
					$companyId = json_decode($logged_user->company_ids);
				} else {
					$companyId = array(session('selected_company'));
				}
				$companies = company::select('id', 'company_name')->whereIn('id', $companyId)->get();
			}
			else if($logged_user->role_users_id == 1) {
				$companies = company::select('id', 'company_name')->get();
			}
			// $companies = company::select('id', 'company_name')->get();
			
			$roles = Role::where('id', '!=', 3)->where('is_active', 1)->select('id', 'name')->get();

			if (request()->ajax()) {
				if ($request->company_id && $request->department_id && $request->designation_id && $request->office_shift_id) {
					$employees = Employee::with('user:id,profile_photo,username', 'company:id,company_name', 'department:id,department_name', 'designation:id,designation_name', 'officeShift:id,shift_name', 'setting')
						->where('company_id', '=', $request->company_id)
						->where('department_id', '=', $request->department_id)
						->where('designation_id', '=', $request->designation_id)
						->where('office_shift_id', '=', $request->office_shift_id)
						->where('is_active', 1);
						// ->whereDate('exit_date', '>', $now)
						// ->orWhere('exit_date', '0000-00-00')
						// ->orWhere('exit_date', NULL);
				} elseif ($request->company_id && $request->department_id && $request->designation_id) {
					$employees = Employee::with('user:id,profile_photo,username', 'company:id,company_name', 'department:id,department_name', 'designation:id,designation_name', 'officeShift:id,shift_name')
						->where('company_id', '=', $request->company_id)
						->where('department_id', '=', $request->department_id)
						->where('designation_id', '=', $request->designation_id)
						->where('is_active', 1);
						// ->whereDate('exit_date', '>', $now)
						// ->orWhere('exit_date', '0000-00-00')
						// ->orWhere('exit_date', NULL);
				} elseif ($request->company_id && $request->department_id) {
					$employees = Employee::with('user:id,profile_photo,username', 'company:id,company_name', 'department:id,department_name', 'designation:id,designation_name', 'officeShift:id,shift_name')
						->where('company_id', '=', $request->company_id)
						->where('department_id', '=', $request->department_id)
						->where('is_active', 1);
						// ->whereDate('exit_date', '>', $now)
						// ->orWhere('exit_date', '0000-00-00')
						// ->orWhere('exit_date', NULL);
				} elseif ($request->company_id && $request->office_shift_id) {
					$employees = Employee::with('user:id,profile_photo,username', 'company:id,company_name', 'department:id,department_name', 'designation:id,designation_name', 'officeShift:id,shift_name')
						->where('company_id', '=', $request->company_id)
						->where('office_shift_id', '=', $request->office_shift_id)
						->where('is_active', 1);
						// ->whereDate('exit_date', '>', $now)
						// ->orWhere('exit_date', '0000-00-00')
						// ->orWhere('exit_date', NULL);
				} elseif ($request->company_id) {
					$employees = Employee::with('user:id,profile_photo,username', 'company:id,company_name', 'department:id,department_name', 'designation:id,designation_name', 'officeShift:id,shift_name')
						->where('company_id', '=', $request->company_id)
						->where('is_active', 1);
						// ->whereDate('exit_date', '>', $now)
						// ->orWhere('exit_date', '0000-00-00')
						// ->orWhere('exit_date', NULL);
				} else {
					$employees = Employee::with('user:id,profile_photo,username', 'company:id,company_name,trading_name', 'department:id,department_name', 'designation:id,designation_name', 'officeShift:id,shift_name')
						->orderBy('company_id')
						->where('is_active', 1);
						// ->whereDate('exit_date', '>', $now)
						// ->orWhere('exit_date', '0000-00-00')
						// ->orWhere('exit_date', NULL);
				}
				
				if ($companyId) {
					$employees->whereIn('company_id', $companyId);
				}
				
				$employees = $employees->get();

				return datatables()->of($employees)
					->setRowId(function ($row) {
						return $row->id;
					})
					->addColumn('name', function ($row) use ($isPayroll) {
						if ($row->user && $row->user->profile_photo) {
							$url = url("uploads/profile_photos/" . $row->user->profile_photo);
							$profile_photo = '<img src="' . $url . '" class="profile-photo md" style="height:35px;width:35px"/>';
						} else {
							$url = url("logo/avatar.jpg");
							$profile_photo = '<img src="' . $url . '" class="profile-photo md" style="height:35px;width:35px"/>';
						}
						$name  = '<span><a href="employees/' . $row->id . '" class="d-block text-bold" style="color:#24ABF2">' . $row->full_name . '</a></span>';
						$staff_id = "<span>" . __('file.Staff Id') . ": " . ($row->staff_id ?? '') . "</span>";

						if ($row->payslip_type) {
							$payslip_type = "<span>" . __('file.Payslip Type') . ": " . __('file.' . $row->payslip_type) . "</span>";
						} else {
							$payslip_type = " ";
						}
						if ($row->company) {
							$company_code = $row->company->trading_name;
						} else {
							$company_code = " ";
						}
						
						return "<div class='d-flex'>
                                        <div class='mr-2'>" . $profile_photo . "</div>
                                        <div>"
							. $name . '<br />' .$staff_id . '<br />' . $payslip_type.
							"</div></div>";
					})
					->addColumn('company', function ($row) {
						$company     = "<span class='text-bold'>" . strtoupper($row->company->trading_name ?? '') . "</span>";
						$department  = "<span>" . __('file.Department') . " : " . ($row->department->department_name ?? '') . "</span>";
						$designation = "<span>" . __('Position') . " : " . ($row->designation->designation_name ?? '') . "</span>";

						return $company . '</br>' . $department . '</br>' . $designation;
					})
					->addColumn('contacts', function ($row) {
						$date_end = $row->exit_date ? date("Y-m-d", strtotime($row->exit_date)) : "-";
						$email = "<i class='fa fa-envelope text-muted' title='Email'></i> " . $row->email;
						$contact_no = "<i class='text-muted fa fa-phone' title='Phone'></i> " . $row->contact_no;
						// $skype_id = "<i class='text-muted fa fa-skype' title='Skype'></i> " . $row->skype_id;
						// $whatsapp_id = "<i class='text-muted fa fa-whatsapp' title='Whats App'></i> " . $row->whatsapp_id;

						// return $email . '</br>' . $contact_no . '</br>' . $skype_id . '</br>' . $whatsapp_id;
						// return $email . '</br>' . $contact_no;
						return $date_end;
					})
					->addColumn('status', function ($row) {
						return $row->is_active;
					})
					->addColumn('action', function ($data) use ($isCeo) {
						$button = '';
						if (auth()->user()->can('view-details-employee')) {
							$button .= '<a href="employees/' . $data->id . '"  class="edit btn btn-primary btn-sm" data-toggle="tooltip" data-placement="top" title="View Details"><i class="dripicons-preview"></i></button></a>';
							$button .= '&nbsp;&nbsp;&nbsp;';
						}
						if (auth()->user()->can('modify-details-employee')) {
							if ($isCeo && !$data->is_active) {
								$button .= '<button type="button" name="accept" id="' . $data->id . '"  class="accept btn btn-success btn-sm" data-toggle="tooltip" data-placement="top" title="Accept"><i class="dripicons-checkmark"></i></button>';
								$button .= '&nbsp;&nbsp;&nbsp;';
							}

							if ($data->role_users_id != 1) {
								$button .= '<button type="button" name="delete" id="' . $data->id . '" class="delete btn btn-danger btn-sm" data-toggle="tooltip" data-placement="top" title="Delete"><i class="dripicons-trash"></i></button>';
								$button .= '&nbsp;&nbsp;&nbsp;';
							}

							$button .= '<a class="download btn-sm" style="background:#FF7588; color:#fff" title="PDF" href="' . route('employees.pdf', $data->id) . '"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
							$button .= '&nbsp;&nbsp;&nbsp;';
							$button .= '<button type="button" name="inactive" id="' . $data->id . '" class="inactive btn btn-primary btn-sm" style="background:#FF7588; color:#fff" title="Inactive"><i class="fa fa-ban" aria-hidden="true"></i></button>';
						}

						return $button;
					})
					->rawColumns(['name', 'company', 'contacts', 'action',])
					->make(true);
			}
			return view('employee.index', compact('companies', 'roles'));
		} else {
			return response()->json(['success' => __('You are not authorized')]);
		}
	}
	
	public function inactive(Request $request)
	{
		$logged_user = auth()->user();
		$companyId = null;


		$roleId = $logged_user->roles->pluck('id')->first();
		$isPayroll = Role::where('id', $roleId)->pluck('is_payroll')->first();
		$isCeo = Role::where('id', $roleId)->pluck('is_ceo')->first();
		$now = Carbon::now();
		
		if ($logged_user->can('view-details-employee')) {
			if ($logged_user->role_users_id == 6) {
				if(!$request->session()->has('selected_company')) {
					$companyId = json_decode($logged_user->company_ids);
				} else {
					$companyId = array(session('selected_company'));
				}
				$companies = company::select('id', 'company_name')->whereIn('id', $companyId)->get();
			}
			else
			{
				$companies = company::select('id', 'company_name')->get();
			}
			
			$roles = Role::where('id', '!=', 3)->where('is_active', 1)->select('id', 'name')->get();

			if (request()->ajax()) {
				if ($request->company_id && $request->department_id && $request->designation_id && $request->office_shift_id) {
					$employees = Employee::with('user:id,profile_photo,username', 'company:id,company_name', 'department:id,department_name', 'designation:id,designation_name', 'officeShift:id,shift_name', 'setting')
						->where('company_id', '=', $request->company_id)
						->where('department_id', '=', $request->department_id)
						->where('designation_id', '=', $request->designation_id)
						->where('office_shift_id', '=', $request->office_shift_id)
						->where('is_active', 0);
						// ->whereDate('exit_date', '>', $now)
						// ->orWhere('exit_date', '0000-00-00')
						// ->orWhere('exit_date', NULL);
				} elseif ($request->company_id && $request->department_id && $request->designation_id) {
					$employees = Employee::with('user:id,profile_photo,username', 'company:id,company_name', 'department:id,department_name', 'designation:id,designation_name', 'officeShift:id,shift_name')
						->where('company_id', '=', $request->company_id)
						->where('department_id', '=', $request->department_id)
						->where('designation_id', '=', $request->designation_id)
						->where('is_active', 0);
						// ->whereDate('exit_date', '>', $now)
						// ->orWhere('exit_date', '0000-00-00')
						// ->orWhere('exit_date', NULL);
				} elseif ($request->company_id && $request->department_id) {
					$employees = Employee::with('user:id,profile_photo,username', 'company:id,company_name', 'department:id,department_name', 'designation:id,designation_name', 'officeShift:id,shift_name')
						->where('company_id', '=', $request->company_id)
						->where('department_id', '=', $request->department_id)
						->where('is_active', 0);
						// ->whereDate('exit_date', '>', $now)
						// ->orWhere('exit_date', '0000-00-00')
						// ->orWhere('exit_date', NULL);
				} elseif ($request->company_id && $request->office_shift_id) {
					$employees = Employee::with('user:id,profile_photo,username', 'company:id,company_name', 'department:id,department_name', 'designation:id,designation_name', 'officeShift:id,shift_name')
						->where('company_id', '=', $request->company_id)
						->where('office_shift_id', '=', $request->office_shift_id)
						->where('is_active', 0);
						// ->whereDate('exit_date', '>', $now)
						// ->orWhere('exit_date', '0000-00-00')
						// ->orWhere('exit_date', NULL);
				} elseif ($request->company_id) {
					$employees = Employee::with('user:id,profile_photo,username', 'company:id,company_name', 'department:id,department_name', 'designation:id,designation_name', 'officeShift:id,shift_name')
						->where('company_id', '=', $request->company_id)
						->where('is_active', 0);
						// ->whereDate('exit_date', '>', $now)
						// ->orWhere('exit_date', '0000-00-00')
						// ->orWhere('exit_date', NULL);
				} else {
					$employees = Employee::with('user:id,profile_photo,username', 'company:id,company_name', 'department:id,department_name', 'designation:id,designation_name', 'officeShift:id,shift_name')
						->orderBy('company_id')
						->where('is_active', 0);
						// ->whereDate('exit_date', '>', $now)
						// ->orWhere('exit_date', '0000-00-00')
						// ->orWhere('exit_date', NULL);
				}

				if ($companyId) {
					$employees->whereIn('company_id', $companyId);
				}
				$employees = $employees->get();

				return datatables()->of($employees)
					->setRowId(function ($row) {
						return $row->id;
					})
					->addColumn('name', function ($row) use ($isPayroll) {
						if ($row->user && $row->user->profile_photo) {
							$url = url("uploads/profile_photos/" . $row->user->profile_photo);
							$profile_photo = '<img src="' . $url . '" class="profile-photo md" style="height:35px;width:35px"/>';
						} else {
							$url = url("logo/avatar.jpg");
							$profile_photo = '<img src="' . $url . '" class="profile-photo md" style="height:35px;width:35px"/>';
						}
						$name  = '<span><a href="/staff/employees/' . $row->id . '" class="d-block text-bold" style="color:#24ABF2">' . $row->full_name . '</a></span>';
						$username = "<span>" . __('file.Username') . ": " . ($row->user->username ?? '') . "</span>";
						$staff_id = "<span>" . __('file.Staff Id') . ": " . ($row->staff_id ?? '') . "</span>";
						$gender = '';
						if ($row->gender != null) {
							$gender = "<span>" . __('file.Gender') . ": " . __('file.' . $row->gender ?? '') . "</span></br>";
						}

						$shift = "<span>" . __('file.Shift') . ": " . ($row->officeShift->shift_name ?? '') . "</span>";
						if ($isPayroll) {
							if (config('variable.currency_format') == 'suffix') {
								$salary = "<span>" . __('file.Salary') . ": " . ($row->basic_salary ?? '') . " " . config('variable.currency') . "</span>";
							} else {
								$salary = "<span>" . __('file.Salary') . ": " . config('variable.currency') . " " . ($row->basic_salary ?? '') . "</span>";
							}
						} else {
							if (config('variable.currency_format') == 'suffix') {
								$salary = "<span>" . __('file.Salary') . ": " . "*****" . " " . config('variable.currency') . "</span>";
							} else {
								$salary = "<span>" . __('file.Salary') . ": " . config('variable.currency') . " " . "*****" . "</span>";
							}
						}

						if ($row->payslip_type) {
							$payslip_type = "<span>" . __('file.Payslip Type') . ": " . __('file.' . $row->payslip_type) . "</span>";
						} else {
							$payslip_type = " ";
						}


						return "<div class='d-flex'>
                                        <div class='mr-2'>" . $profile_photo . "</div>
                                        <div>"
							. $name . '</br>' . $username . '</br>' . $staff_id . '</br>' . $gender . $shift . '</br>' . $salary . '</br>' . $payslip_type .
							"</div></div>";
					})
					->addColumn('company', function ($row) {
						$company     = "<span class='text-bold'>" . strtoupper($row->company->company_name ?? '') . "</span>";
						$department  = "<span>" . __('file.Department') . " : " . ($row->department->department_name ?? '') . "</span>";
						$designation = "<span>" . __('file.Designation') . " : " . ($row->designation->designation_name ?? '') . "</span>";

						return $company . '</br>' . $department . '</br>' . $designation;
					})
					->addColumn('contacts', function ($row) {
						$up_date = "Update Date : " . date("Y-m-d H:i:s", strtotime($row->updated_at));
						$contact_no = "<i class='text-muted fa fa-phone' title='Phone'></i> " . $row->contact_no;
						$reason = "Reason : " .$row->reason;

						return $up_date . '</br>' . $contact_no . '</br>' . $reason;
					})
					->addColumn('status', function ($row) {
						return $row->is_active;
					})
					->addColumn('action', function ($data) use ($isCeo) {
						$button = '';
						$logged_user = auth()->user();
						if (auth()->user()->can('view-details-employee')) {
							$button .= '<a href="' . $data->id . '"  class="edit btn btn-primary btn-sm" data-toggle="tooltip" data-placement="top" title="View Details"><i class="dripicons-preview"></i></button></a>';
							$button .= '&nbsp;&nbsp;&nbsp;';
						}
						if (auth()->user()->can('modify-details-employee') && $logged_user->role_users_id == 1) {
							if ($isCeo && !$data->is_active) {
								$button .= '<button type="button" name="accept" id="' . $data->id . '"  class="accept btn btn-success btn-sm" data-toggle="tooltip" data-placement="top" title="Accept"><i class="dripicons-checkmark"></i></button>';
								$button .= '&nbsp;&nbsp;&nbsp;';
							}

							if ($data->role_users_id != 1) {
								$button .= '<button type="button" name="delete" id="' . $data->id . '" class="delete btn btn-danger btn-sm" data-toggle="tooltip" data-placement="top" title="Delete"><i class="dripicons-trash"></i></button>';
								$button .= '&nbsp;&nbsp;&nbsp;';
							}

							$button .= '<a class="download btn-sm" style="background:#FF7588; color:#fff" title="PDF" href="' . route('employees.pdf', $data->id) . '"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
						}

						return $button;
					})
					->rawColumns(['name', 'company', 'contacts', 'action',])
					->make(true);
			}
			return view('employee.inactive', compact('companies', 'roles'));
		} else {
			return response()->json(['success' => __('You are not authorized')]);
		}
	}

	//Set Inactive Employee Status
	public function employeeinactive(Request $request)
	{
		$data['is_active'] = 0;
		$data['reason'] = $request->reason;
		employee::find($request->id)->update($data);

		return response()->json(['success' => __('Data Set Inactive successfully.')]);
	}

	public function store(Request $request)
	{
		$logged_user = auth()->user();

		if ($logged_user->can('store-details-employee')) {
			if (request()->ajax()) {
				$validator = Validator::make(
					$request->only(
						'first_name',
						'last_name',
						'staff_id',
						'staff_letters',
						'staff_numbers',
						'email',
						'date_of_birth',
						'gender',
						'religion',
						'marital_status',
						'username',
						// 'role_users_id',
						'password',
						'password_confirmation',
						'company_id',
						'department_id',
						'designation_id',
						'office_shift_id',
						'attendance_type',
						'joining_date',
						// 'position',
						'identity_number',
						'npwp',
					),
					[
						'first_name' => 'required',
				// 		'last_name' => 'required',
						'staff_letters' => 'required',
						'staff_numbers' => 'required',
						'gender' => 'required',
						'marital_status' => 'required',
						'npwp' => 'required',
						// 'email'      => 'nullable|email|unique:users',
						// 'contact_no' => 'required|numeric|unique:users',
						'date_of_birth' => 'required',
						'company_id' => 'required',
						'department_id' => 'required',
						'designation_id' => 'required',
						'office_shift_id' => 'required',
						// 'username' => 'required|unique:users',
						// 'role_users_id' => 'required',
						// 'password' => 'required|min:4|confirmed',
						'attendance_type' => 'required',
						'joining_date' => 'required',
						'profile_photo' => 'nullable|image|max:10240|mimes:jpeg,png,jpg,gif',
						// 'position' => 'required',
					]
				);

				if ($validator->fails()) {
					return response()->json(['errors' => $validator->errors()->all()]);
				}
				
				//Checking Existing Staff id and auto increment
				$request->staff_id = $request->staff_letters.$request->staff_numbers;
				$check_employee = Employee::where('staff_id', $request->staff_id)->first();
				
				if(!empty($check_employee)){
					return response()->json(['error' => __('Staff ID Duplicate.')]);
				}
				// if($check_employee)
				// {
				// 	// Extract alphabetic part
				// 	preg_match('/[A-Za-z]+/', $request->staff_id, $alphaMatches);
				// 	$alphabeticPart = $alphaMatches[0];

				// 	// Extract the numeric part and increment it
				// 	preg_match('/\d+$/', $request->staff_id, $matches);
				// 	$numericPart = $matches[0];

				// 	// Increment the numeric part
				// 	$paddedNumericPart = ltrim($numericPart, '0'); // Remove leading zeros for calculations
				// 	$incrementedValue = (int)$paddedNumericPart + 1;
				// 	$lengthDiff = strlen($numericPart) - strlen($incrementedValue);
				// 	$incrementedNumericPart = str_repeat('0', $lengthDiff > 0 ? $lengthDiff : 0) . $incrementedValue;

				// 	$request->staff_id = $incrementedNumericPart;
				// }

				//Check Employee NIK
				$check_id_card = Employee::with('company:id,company_name')->where('identity_number', $request->identity_number)->first();
				if(!empty($check_id_card))
				{
					if($check_id_card->is_active == 1)
					{
						return response()->json(['error' => __('Identity Number Duplicate.')]);
					}
					else
					{
						// Active 0 then blacklist and have reason
						if(!empty($check_id_card->reason))
						{
							$reason = "Identity Number Blaclisted from ".$check_id_card->company->company_name.". Reason: ".$check_id_card->reason;
						}
						else
						{
							$reason = "Identity Number Blaclisted.";
						}
						return response()->json(['error' => $reason]);
					}
				}

				$data = [];
				$data['first_name'] = $request->first_name;
				$data['last_name'] = $request->last_name ?  $request->last_name : "";
				$data['staff_id'] = $request->staff_id;
				$data['date_of_birth'] = $request->date_of_birth;
				$data['joining_date'] = $request->joining_date;
				$data['gender'] = $request->gender;
				$data['marital_status'] = $request->marital_status;
				$data['religion'] = $request->religion;
				$data['identity_number'] = $request->identity_number;
				$data['npwp'] = $request->npwp;
				$data['department_id'] = $request->department_id;
				$data['company_id'] = $request->company_id;
				$data['designation_id'] = $request->designation_id;
				$data['office_shift_id'] = $request->office_shift_id;

				$data['email'] = strtolower(trim($request->email));
				// $data['role_users_id'] = $request->role_users_id;
				$data['role_users_id'] = 2;
				$data['attendance_type'] = $request->attendance_type;
				$data['following_company_id']    = empty($request->following_company_id) ? null : $request->following_company_id;
				$data['following_employee_id']    = empty($request->following_employee_id) ? null : $request->following_employee_id;
				$data['position'] = $request->position ?? 0;
				$data['is_dispensation'] = $request->is_dispensation ?? 0;
				$data['leave_debt']    = empty($request->leave_debt) ? null : $request->leave_debt;
				$data['is_active'] = 1;


				$user = [];
				$user['first_name'] = $request->first_name;
				$user['last_name'] = $request->last_name ?  $request->last_name : "";
				$user['username'] = strtolower(trim($request->staff_id));
				$user['email'] = strtolower(trim($request->email));
				$user['password'] = bcrypt($request->staff_id);
				// $user['role_users_id'] = $request->role_users_id;
				$user['role_users_id'] = 2;
				$user['contact_no'] = $request->contact_no;
				$user['is_active'] = 1;

				$photo = $request->profile_photo;
				$file_name = null;

				if (isset($photo)) {
					$new_user = $request->username;
					if ($photo->isValid()) {
						$file_name = preg_replace('/\s+/', '', $new_user) . '_' . time() . '.' . $photo->getClientOriginalExtension();
						$photo->storeAs('profile_photos', $file_name);
						$user['profile_photo'] = $file_name;
					}
				}

				DB::beginTransaction();
				try {
					$created_user = User::create($user);
					$created_user->syncRoles($request->role_users_id); //new

					$data['id'] = $created_user->id;

					employee::create($data);

					DB::commit();
				} catch (Exception $e) {
					DB::rollback();

					return response()->json(['error' => $e->getMessage()]);
				} catch (Throwable $e) {
					DB::rollback();

					return response()->json(['error' => $e->getMessage()]);
				}

				$notifiable = User::whereHas(
					'roles',
					function ($q) {
						$q->where('is_ceo', 1);
					}
				)->get();
				Notification::send($notifiable, new EmployeeCreatedNotification());
				
				return response()->json(['success' => __('Data Added successfully.')]);
			}
		}

		return response()->json(['success' => __('You are not authorized')]);
	}

	public function show(Employee $employee)
	{
		if (auth()->user()->can('view-details-employee')) {
			$companies = Company::select('id', 'company_name')->get();
			$departments = department::select('id', 'department_name')
				->where('company_id', $employee->company_id)
				->get();

			$designations = designation::select('id', 'designation_name')
				->where('department_id', $employee->department_id)
				->get();

			$office_shifts = office_shift::select('id', 'shift_name')
				->where('company_id', $employee->company_id)
				->get();

			$following_employees = Employee::select('id', 'first_name', 'last_name')
				->where('company_id', $employee->company_id)
				->get();

			$statuses = status::select('id', 'status_title')->get();
			// $roles = Role::select('id', 'name')->get();
			$countries = DB::table('countries')->select('id', 'name')->get();
			$document_types = DocumentType::select('id', 'document_type')->get();

			$education_levels = QualificationEducationLevel::select('id', 'name')->get();
			$language_skills = QualificationLanguage::select('id', 'name')->get();
			$general_skills = QualificationSkill::select('id', 'name')->get();

			$roles = Role::where('id', '!=', 3)->where('is_active', 1)->select('id', 'name')->get(); //--new--

			$dependents = PTKP::where('company_id', $employee->company_id)->pluck('name');

			return view('employee.dashboard', compact(
				'employee',
				'countries',
				'companies',
				'departments',
				'designations',
				'statuses',
				'office_shifts',
				'document_types',
				//'education_levels',
				'language_skills',
				'general_skills',
				'roles',
				'dependents',
				'following_employees'
			));
		} else {
			return response()->json(['success' => __('You are not authorized')]);
		}
	}


	public function destroy($id)
	{
		// if (!env('USER_VERIFIED')) {
		// 	return response()->json(['error' => 'This feature is disabled for demo!']);
		// }
		$logged_user = auth()->user();

		if ($logged_user->can('modify-details-employee')) {
 			DB::beginTransaction();
 			try {
				Employee::whereId($id)->delete();
				$this->unlink($id);
				
				$check_user = User::whereId($id)->first();
				if(!empty($check_user))
				{
					User::whereId($id)->delete();
				}

 				DB::commit();
 			} catch (Exception $e) {
 				DB::rollback();

 				return response()->json(['error' => $e->getMessage()]);
 			} catch (Throwable $e) {
 				DB::rollback();

 				return response()->json(['error' => $e->getMessage()]);
 			}

			return response()->json(['success' => __('Data is successfully deleted')]);
		}

		return response()->json(['success' => __('You are not authorized')]);
	}


	public function accept($id)
	{
		$logged_user = auth()->user();

		if ($logged_user->can('modify-details-employee')) {
			$employee = Employee::find($id);
			$employee->is_active = 1;
			$employee->save();
			return response()->json(['success' => __('Data is successfully deleted')]);
		}

		return response()->json(['success' => __('You are not authorized')]);
	}

	public function unlink($employee)
	{

		$user = User::findOrFail($employee);
		$file_path = $user->profile_photo;

		if ($file_path) {
			$file_path = public_path('uploads/profile_photos/' . $file_path);
			if (file_exists($file_path)) {
				unlink($file_path);
			}
		}
	}

	public function delete_by_selection(Request $request)
	{
		if (!env('USER_VERIFIED')) {
			return response()->json(['error' => 'This feature is disabled for demo!']);
		}
		$logged_user = auth()->user();

		if ($logged_user->can('modify-details-employee')) {
			$employee_id = $request['employeeIdArray'];

			foreach($employee_id as $e_id)
			{
				Employee::whereId($e_id)->delete();
				$this->unlink($e_id);
				
				$check_user = User::where('id', $e_id)->first();
				if(!empty($check_user))
				{
					User::whereId($e_id)->delete();
				}
			}
			
			// $user = User::whereIntegerInRaw('id', $employee_id)->where('role_users_id', '!=', 1);

			// if ($user->delete()) {
				return response()->json(['success' => __('Data is successfully deleted')]);
			// }
		}

		return response()->json(['success' => __('You are not authorized')]);
	}

	public function infoUpdate(Request $request, $employee)
	{
		// return response()->json($request->attendance_type);

		$logged_user = auth()->user();

		if ($logged_user->can('modify-details-employee')) {
			if (request()->ajax()) {

				if($logged_user->role_users_id == 1)
				{
					$validator = Validator::make(
						$request->only(
							'first_name',
							'last_name',
							'staff_id',
							'identity_number',
							'npwp',
							'email',
							'contact_no',
							'date_of_birth',
							'gender',
							'marital_status',
							'religion',
							'username',
							'role_users_id',
							'company_id',
							'department_id',
							'designation_id',
							'office_shift_id',
							'location_id',
							'status_id',
							'religion',
							'dependent',
							'joining_date',
							'permission_role_id',
							'address',
							'city',
							'state',
							'country',
							'zip_code',
							'attendance_type',
							'total_leave',
							'following_company_id',
							// 'position'
						),
						[
							'first_name' => 'required',
							'date_of_birth' => 'required',
							'company_id' => 'required',
							'department_id' => 'required',
							// 'designation_id' => 'required',
							'office_shift_id' => 'required',
							// 'role_users_id' => 'required',
							'attendance_type' => 'required',
							'total_leave' => 'numeric|min:0',
							'joining_date' => 'required',
							'exit_date' => 'nullable',
							// 'position' => 'required',
						]
					);
				}
				else
				{
					$validator = Validator::make(
						$request->only(
							'first_name',
							'last_name',
							'staff_id',
							'identity_number',
							'npwp',
							'email',
							'contact_no',
							'date_of_birth',
							'gender',
							'marital_status',
							'religion',
							'username',
							'role_users_id',
							'company_id',
							'department_id',
							'designation_id',
							'office_shift_id',
							'location_id',
							'status_id',
							'dependent',
							'joining_date',
							'permission_role_id',
							'address',
							'city',
							'state',
							'country',
							'zip_code',
							'attendance_type',
							'total_leave',
							'following_company_id',
							// 'position'
						),
						[
							'first_name' => 'required',
							// 'last_name' => 'required',
							// 'username' => 'required|unique:users,username,' . $employee,
							// 'staff_id' => 'required|numeric|unique:employees,staff_id,' . $employee,
							// 'identity_number' => 'required|numeric|unique:employees,identity_number,' . $employee,
							// 'email'      => 'nullable|email|unique:users,email,' . $employee,
							// 'contact_no' => 'required|numeric|unique:users,contact_no,' . $employee,
							'date_of_birth' => 'required',
							'company_id' => 'required',
							'department_id' => 'required',
							// 'designation_id' => 'required',
							'office_shift_id' => 'required',
							'role_users_id' => 'required',
							'attendance_type' => 'required',
							'total_leave' => 'numeric|min:0',
							'joining_date' => 'required',
							'exit_date' => 'nullable',
							// 'position' => 'required',
						]
					);
				}

				if ($validator->fails()) {
					return response()->json(['errors' => $validator->errors()->all()]);
				}

				// if(empty($request->dependent))
				// {
				// 	return response()->json(['errors' => ["Dependent cannot be null"]]);
				// }
                
                if(empty($request->joining_date))
                {
                    return response()->json(['errors' => ["Joining Date cannot be null"]]);
                }
                
                if(empty($request->status_id))
                {
                    return response()->json(['errors' => ["status cannot be null"]]);
                }

				$data = [];
				$data['first_name'] = $request->first_name;
				$data['last_name'] = $request->last_name ?  $request->last_name : "";
				$data['staff_id'] = $request->staff_id;
				$data['identity_number'] = $request->identity_number;
				$data['npwp'] = $request->npwp;
				$data['religion'] = $request->religion;
				$data['date_of_birth'] = $request->date_of_birth;
				$data['joining_date'] = $request->joining_date;
				$data['gender'] = $request->gender;
				$data['department_id'] = $request->department_id;
				$data['company_id'] = $request->company_id;

				if ($request->designation_id) {
					$data['designation_id'] = $request->designation_id;
				}

				$data['office_shift_id'] = $request->office_shift_id;
				$data['status_id'] = $request->status_id;
				$data['marital_status'] = $request->marital_status;
				$data['dependent'] = $request->dependent;
				if ($request->joining_date) {
					$data['joining_date'] = $request->joining_date;
				}

				if ($request->exit_date) {
					$data['exit_date'] = $request->exit_date;
				}
				// else {
				//     $data['exit_date'] = NULL;
				// }

				$data['address'] = $request->address;
				$data['city'] = $request->city;
				$data['state'] = $request->state;
				$data['country'] = $request->country;
				$data['zip_code'] = $request->zip_code;


				$data['email'] = strtolower(trim($request->email));
				$data['role_users_id'] = $request->role_users_id;
				$data['contact_no'] = $request->contact_no;
				$data['attendance_type'] = $request->attendance_type;
				$data['joining_date']    = $request->joining_date; //new
				$data['following_company_id']    = empty($request->following_company_id) ? null : $request->following_company_id;
				$data['following_employee_id']    = empty($request->following_employee_id) ? null : $request->following_employee_id;
				$data['position'] = $request->position ?? 0;
				$data['is_dispensation'] = $request->is_dispensation ?? 0;
				$data['leave_debt']    = empty($request->leave_debt) ? null : $request->leave_debt;

				if($request->exit_date)
				{
					if(date('Y-m-d') >= $request->exit_date)
					{
						$data['is_active'] = 0;
					}
					else
					{
						$data['is_active'] = 1;
					}
				}
				else
				{
					$data['is_active'] = 1;
				}

				//Leave Calculation
				$employee_leave_info = Employee::find($employee);
				if ($employee_leave_info->total_leave == 0) {
					$data['total_leave'] = $request->total_leave;
					$data['remaining_leave'] = $request->total_leave;
				} elseif ($request->total_leave > $employee_leave_info->total_leave) {
					$data['total_leave'] = $request->total_leave;
					$data['remaining_leave'] = $request->remaining_leave + ($request->total_leave - $employee_leave_info->total_leave);
				} elseif ($request->total_leave < $employee_leave_info->total_leave) {
					$data['total_leave'] = $request->total_leave;
					$data['remaining_leave'] = $request->remaining_leave - ($employee_leave_info->total_leave - $request->total_leave);
				} else {
					$data['total_leave'] = $request->total_leave;
					$data['remaining_leave'] = $employee_leave_info->remaining_leave;
				}
				//return response()->json($data['remaining_leave']);



				$user = [];
				$user['first_name'] = $request->first_name;
				$user['last_name'] = $request->last_name ?  $request->last_name : "";
				$user['username'] = strtolower(trim($request->username));
				$user['email'] = strtolower(trim($request->email));
				//$user['password'] = bcrypt($request->password);

				if($logged_user->role_users_id != 1){
					$user['role_users_id'] = $request->role_users_id;
				}
				
				$user['contact_no'] = $request->contact_no;
				$user['is_active'] = 1;

				DB::beginTransaction();
				try {
					$check_user = User::whereId($employee)->first();
				    
				    if(!empty($check_user))
				    {
				        User::whereId($employee)->update($user);    
				    }
					
					employee::find($employee)->update($data);

                    if(!empty($check_user))
				    {
    					$usertest = User::find($employee); //--new--
    					$usertest->syncRoles($data['role_users_id']); //--new--
				    }

					DB::commit();
				} catch (Exception $e) {
					DB::rollback();

					return response()->json(['error' => $e->getMessage()]);
				} catch (Throwable $e) {
					DB::rollback();

					return response()->json(['error' => $e->getMessage()]);
				}

				return response()->json(['success' => __('Data Added successfully.'), 'remaining_leave' => $data['remaining_leave']]);
			}
		}

		return response()->json(['success' => __('You are not authorized')]);
	}

	public function socialProfileShow(Employee $employee)
	{
		return view('employee.social_profile.index', compact('employee'));
	}

	public function storeSocialInfo(Request $request, $employee)
	{
		$logged_user = auth()->user();

		if ($logged_user->can('modify-details-employee') || $logged_user->id == $employee) {
			$data = [];
			$data['fb_id'] = $request->fb_id;
			$data['twitter_id'] = $request->twitter_id;
			$data['linkedIn_id'] = $request->linkedIn_id;
			$data['whatsapp_id'] = $request->whatsapp_id;
			$data['skype_id'] = $request->skype_id;

			Employee::whereId($employee)->update($data);

			return response()->json(['success' => __('Data is successfully updated')]);
		}

		return response()->json(['success' => __('You are not authorized')]);
	}

	public function indexProfilePicture(Employee $employee)
	{
		$logged_user = auth()->user();

		if ($logged_user->can('modify-details-employee')) {
			return view('employee.profile_picture.index', compact('employee'));
		}

		return response()->json(['success' => __('You are not authorized')]);
	}

	public function storeProfilePicture(Request $request, $employee)
	{
		$logged_user = auth()->user();

		if ($logged_user->can('modify-details-employee') || $logged_user->id == $employee) {

			$data = [];
			$photo = $request->profile_photo;
			$file_name = null;

			if (isset($photo)) {
				$new_user = $request->employee_username;
				if ($photo->isValid()) {
					$file_name = preg_replace('/\s+/', '', $new_user) . '_' . time() . '.' . $photo->getClientOriginalExtension();
					$photo->storeAs('profile_photos', $file_name);
					$data['profile_photo'] = $file_name;
				}
			}

			$this->unlink($employee);

			User::whereId($employee)->update($data);

			return response()->json(['success' => 'Data is successfully updated', 'profile_picture' => $file_name]);
		}

		return response()->json(['success' => __('You are not authorized')]);
	}

	public function setSalary(Employee $employee)
	{
		$logged_user = auth()->user();
		if ($logged_user->can('modify-details-employee')) {
			return view('employee.salary.index', compact('employee'));
		}

		return response()->json(['success' => __('You are not authorized')]);
	}

	public function storeSalary(Request $request, $employee)
	{
		$logged_user = auth()->user();

		if ($logged_user->can('modify-details-employee')) {

			$validator = Validator::make(
				$request->only(
					'payslip_type',
					'basic_salary'
				),
				[
					'basic_salary' => 'required|numeric',
					'payslip_type' => 'required',
				]
			);


			if ($validator->fails()) {
				return response()->json(['errors' => $validator->errors()->all()]);
			}


			DB::beginTransaction();
			try {
				Employee::updateOrCreate(['id' => $employee], [
					'payslip_type' => $request->payslip_type,
					'basic_salary' => $request->basic_salary
				]);
				DB::commit();
			} catch (Exception $e) {
				DB::rollback();

				return response()->json(['error' => $e->getMessage()]);
			} catch (Throwable $e) {
				DB::rollback();

				return response()->json(['error' => $e->getMessage()]);
			}

			return response()->json(['success' => __('Data Added successfully.')]);
		}

		return response()->json(['error' => __('You are not authorized')]);
	}

	public function employeesPensionUpdate(Request $request, $employee)
	{
		//return response()->json('ok');
		$logged_user = auth()->user();

		if ($logged_user->can('modify-details-employee')) {

			$validator = Validator::make(
				$request->only('pension_type', 'pension_amount'),
				[
					'pension_type'  => 'required',
					'pension_amount' => 'required|numeric',
				]
			);


			if ($validator->fails()) {
				return response()->json(['errors' => $validator->errors()->all()]);
			}

			DB::beginTransaction();
			try {
				Employee::updateOrCreate(['id' => $employee], [
					'pension_type' => $request->pension_type,
					'pension_amount' => $request->pension_amount
				]);
				DB::commit();
			} catch (Exception $e) {
				DB::rollback();

				return response()->json(['error' => $e->getMessage()]);
			} catch (Throwable $e) {
				DB::rollback();

				return response()->json(['error' => $e->getMessage()]);
			}

			return response()->json(['success' => __('Data Added successfully.')]);
		}
		return response()->json(['success' => __('You are not authorized')]);
	}

	public function import()
	{

		if (auth()->user()->can('import-employee')) {
			return view('employee.import');
		}

		return abort(404, __('You are not authorized'));
	}

	public function importPost()
	{

		if (!env('USER_VERIFIED')) {
			$this->setErrorMessage('This feature is disabled for demo!');
			return redirect()->back();
		}
		// try {
		// 	Excel::queueImport(new EmployeeImport(), request()->file('file'));
		// } catch (ValidationException $e) {
		// 	$failures = $e->failures();

		// 	return view('employee.importError', compact('failures'));
		// }
		$import = new EmployeeImport();

		// $errors = Excel::import($import, request()->file('file'));
		// if (!empty($errors)) {
		// 	return view('employee.importError', compact('errors'));
		// }
		try {
			// Queue the import job
			Excel::queueImport($import, request()->file('file'));
	
			// Dispatch the queued job explicitly
			dispatch(new QueueImport($import));
		} catch (\Throwable $e) {
			// Handle import exceptions
			$errors = [$e->getMessage()];

			$html = "";
			foreach($errors as $err)
			{
				$html .= $err;
			}
			// return view('employee.importError', compact('errors'));
			$this->setErrorMessage(__($html));
			return back();
		}
	

		$notifiable = User::whereHas(
			'roles',
			function ($q) {
				$q->where('is_ceo', 1);
			}
		)->get();
		Notification::send($notifiable, new EmployeeCreatedNotification());

		$this->setSuccessMessage(__('Imported Successfully'));

		return back();
	}

	public function employeePDF($id)
	{
		$employee = Employee::with('user:id,profile_photo,username', 'company:id,company_name', 'department:id,department_name', 'designation:id,designation_name', 'officeShift:id,shift_name', 'role:id,name')
			->where('id', $id)
			->first()
			->toArray();

		PDF::setOptions(['dpi' => 10, 'defaultFont' => 'sans-serif', 'tempDir' => storage_path('temp')]);
		$pdf = PDF::loadView('employee.pdf', $employee);
		return $pdf->stream();
	}

	public function importPosition()
	{
		if (auth()->user()->can('import-employee')) {
			return view('employee.import_position');
		}

		return abort(404, __('You are not authorized'));
	}

	public function exportPosition()
	{
		if (auth()->user()->can('import-employee')) {
			return Excel::download(new EmployeePositionExport, 'employee_positions.xlsx');
		}
		return abort(404, __('You are not authorized'));
	}

	public function importPositionPost()
	{

		if (!env('USER_VERIFIED')) {
			$this->setErrorMessage('This feature is disabled for demo!');
			return redirect()->back();
		}
		try {
			Excel::queueImport(new EmployeePositionImport(), request()->file('file'));
		} catch (ValidationException $e) {
			$failures = $e->failures();

			return view('employee.importError', compact('failures'));
		}

		$this->setSuccessMessage(__('Imported Successfully'));

		return back();
	}

	public function exportLeaves()
	{
		return Excel::download(new EmployeeLeavesExport, 'employee_leaves.xlsx');
	}
}
