<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Reimbursement;
use Illuminate\Http\Request;

class EmployeeReimbursementController extends Controller
{
    public function index($employee)
    {

        $logged_user = auth()->user();

        if ($logged_user->can('view-reimbursement') || $logged_user->id == $employee) {
            if (request()->ajax()) {
                return datatables()->of(Reimbursement::with(['employee', 'employee.company', 'reimbursementType'])->where('employee_id', $logged_user->id)->get())
                ->setRowId(function ($row)
                {
                    return $row->id;
                })
                ->addColumn('reimbursement_type', function ($row)
                {
                    return $row->reimbursementType->name ?? '';
                })
                ->addColumn('company', function ($row)
                {
                    return $row->employee->company->company_name ?? '';
                })
                ->addColumn('employee', function ($row)
                {
                    return $row->employee->full_name ?? '';
                })
                ->addColumn('amount', function ($row)
                {
                    return $row->amount_formatted;
                })
                ->addColumn('status', function ($row)
                {
                    return "<div class='badge badge-success'>" . $row->status . "</div>";
                })
                ->addColumn('action', function ($data)
                {
                    $button = '<button type="button" name="show" id="' . $data->id . '" class="show_reimbursement btn btn-success btn-sm"><i class="dripicons-preview"></i></button>';
                    $button .= '&nbsp;&nbsp;';
                    return $button;
                })
                ->rawColumns(['action', 'status'])
                ->make(true);
            }

            return view('employee.reimbursement.index');
        }

        return abort('403', __('You are not authorized'));
    }



	public function show($id)
	{
		if (request()->ajax())
		{
			$data = Reimbursement::with(['employee', 'employee.company', 'reimbursementType'])->findOrFail($id);

			return response()->json(['data' => $data]);
		}
	}
}
