<?php

namespace App\Http\Controllers;

use App\Employee;
use App\EmployeeSetting;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class EmployeeSettingController extends Controller
{
    public function show(Employee $employee)
    {
        return view('employee.general_setting.index', compact('employee'));
    }

    public function store(Request $request, $employeeId)
    {
        $logged_user = auth()->user();

        if ($logged_user->can('modify-details-employee') || $logged_user->id == $employeeId) {
            $setting = EmployeeSetting::where('employee_id', $employeeId)->first();
            if ($setting) {
                $setting->is_bpjs_tk_include = $request->is_bpjs_tk ?? 0;
                $setting->is_bpjs_kes_include = $request->is_bpjs_kes ?? 0;
                $setting->is_tax_include = $request->is_tax ?? 0;
                $setting->save();
            } else {
                EmployeeSetting::create([
                    'employee_id' => $employeeId,
                    'is_bpjs_tk_include' => $request->is_bpjs_tk ?? 0,
                    'is_bpjs_kes_include' => $request->is_bpjs_kes ?? 0,
                    'is_tax_include' => $request->is_tax ?? 0,
                ]);
            }

            return response()->json(['success' => __('Data is successfully updated')]);
        }

        return response()->json(['success' => __('You are not authorized')]);
    }
}
