<?php

namespace App\Http\Controllers\Requests;

use App\company;
use App\department;
use App\Employee;
use App\Reimbursement;
use App\ReimbursementType;
use App\User;
use App\Http\Controllers\Controller;
use App\Notifications\ReimburseNotify;
use App\Notifications\ReimburseRequestNotify;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Notifications\GeneralNotificationtoAdmin;

class ReimbursementController extends Controller
{

    public function index()
    {
        $logged_user = auth()->user();
        $companyId = null;
        if ($logged_user->role_users_id == 6) {
            $companyId = json_decode($logged_user->company_ids);
        }
        else
		{
			$companyId[] = $logged_user->company_ids;
		}
        
        $companies = company::select('id', 'company_name')->get();
        $reimbursement_types = ReimbursementType::select('id', 'name')->get();
        $employee = Employee::find($logged_user->id);

        if ($logged_user->can('view-reimbursement')) {
            if (request()->ajax()) {
                if ($logged_user->role_users_id == 6) {
                    $reimbursements = Reimbursement::with(['employee', 'employee.company', 'reimbursementType']);
                }
                else{
                    $reimbursements = Reimbursement::with(['employee', 'employee.company', 'reimbursementType'])
                        ->whereHas('employee.department', function ($query) use ($employee) {
                            $query->where(function($query) use ($employee) {
                                $query->where('department_head', $employee->id)
                                      ->orWhere('supervisor', $employee->id);
                            });
                        });
                }
                
                // $employee = Employee::find($logged_user->id);
                if ($companyId) {
                    $reimbursements = $reimbursements->whereHas('employee', function ($query) use ($companyId) {
                        return $query->whereIn('company_id', $companyId);
                    });
                }
                
                if ($logged_user->role_users_id == 6) {
                    $reimbursements = $reimbursements->whereHas('employee', function ($query) use ($companyId) {
                        return $query->whereIn('company_id', $companyId)->where('status', 'first level approval');
                    });
        		}
                else
                {
                    if(isset($employee->supervisor) AND ($employee->supervisor == 1)) {
                        $reimbursements = $reimbursements->whereHas('employee', function($query) use($employee) {
                            $query->where('dept_head', 0)->where('supervisor', 0)->where('coo', 0)->where('department_id', $employee->department_id);
                        });
                    }
            
                    if(isset($employee->dept_head) AND ($employee->dept_head == 1)) {
                        $reimbursements = $reimbursements->whereHas('employee', function($query) use($employee){
                            $query->where('dept_head', 0)->where('coo', 0)->where('department_id', $employee->department_id);
                        });
                    }
            
                    if(isset($employee->coo) AND ($employee->coo == 1)) {
                        $reimbursements = $reimbursements->whereHas('employee', function($query) use($employee) {
                            $query->where('coo', 0)->where('company_id', $employee->company_id);
                        });
                    }
                }

                return datatables()->of($reimbursements->orderBy('created_at', 'DESC')->get())
                    ->setRowId(function ($row) {
                        return $row->id;
                    })
                    ->addColumn('reimbursement_type', function ($row) {
                        return $row->reimbursementType->name ?? '';
                    })
                    ->addColumn('company', function ($row) {
                        return $row->employee->company->company_name ?? '';
                    })
                    ->addColumn('employee', function ($row) {
                        return $row->employee->full_name ?? '';
                    })
                    ->addColumn('amount', function ($row) {
                        return $row->amount_formatted;
                    })
                    ->addColumn('status', function ($row) {
                        return "<div class='badge badge-success'>" . $row->status . "</div>";
                    })
                    ->addColumn('action', function ($data) {
                        $button = '<button type="button" name="show" id="' . $data->id . '" class="show_reimbursement btn btn-success btn-sm"><i class="dripicons-preview"></i></button>';
                        $button .= '&nbsp;&nbsp;';
                        // if (auth()->user()->can('edit-reimbursement')) {
                            $button .= '<button type="button" name="edit" id="' . $data->id . '" class="edit btn btn-primary btn-sm"><i class="dripicons-pencil"></i></button>';
                            $button .= '&nbsp;&nbsp;';
                        // }
                        // if (auth()->user()->can('delete-reimbursement')) {
                            $button .= '<button type="button" name="delete" id="' . $data->id . '" class="delete btn btn-danger btn-sm"><i class="dripicons-trash"></i></button>';
                        // }

                        return $button;
                        return $button;
                    })
                    ->rawColumns(['action', 'status'])
                    ->make(true);
            }

            return view('requests.reimbursements.index', compact('companies', 'reimbursement_types', 'employee'));
        }

        return abort('403', __('You are not authorized'));
    }

    public function store(Request $request)
    {
        if (auth()->user()->can('store-reimbursement') || auth()->user()) {
            $validator = Validator::make(
                $request->only(
                    'employee_id',
                    'reimbursement_type_id',
                    'amount',
                    'description',
                    'reimbursement_attachments',
                ),
                [
                    'employee_id' => 'required',
                    'reimbursement_type_id' => 'required',
                    'amount' => 'required',
                    'description' => 'required',
                    'reimbursement_attachments' => 'nullable|file|max:10240|mimes:jpeg,png,jpg,gif,ppt,pptx,doc,docx,pdf',
                ]
            );


            if ($validator->fails()) {
                return response()->json(['errors' => $validator->errors()->all()]);
            }


            $data = [];

            $data['employee_id'] = $request->employee_id;
            $data['reimbursement_type_id'] = $request->reimbursement_type_id;
            $data['amount'] = $request->amount;
            $data['description'] = $request->description;
            $data['status'] = $request->status ?? 'pending';

            $file = $request->reimbursement_attachments;

            $file_name = null;

            if (isset($file)) {
                if ($file->isValid()) {
                    $file_name = 'reimbursement_' . time() . '.' . $file->getClientOriginalExtension();
                    $file->storeAs('reimbursement_attachments', $file_name);
                    $data['attachment'] = $file_name;
                }
            }
            
            Reimbursement::create($data);

            if ($data['status'] != 'pending') {
                $text = "Your reimbursement status has been ". $data['status'];
				$notifiable = User::findOrFail($data['employee_id']);
				$notifiable->notify(new ReimburseNotify($text));
			} else {
				$requester = Employee::findOrFail($data['employee_id']);
				$department = department::with('DepartmentHead:id')->where('id', $requester->department_id)->first();
				$text = "A new reimbursement has been requested by ". $requester->first_name ." ".$requester->last_name;
				if(!empty($department->department_head)) {
					$notifiable = User::findOrFail($department->department_head);
					$notifiable->notify(new ReimburseRequestNotify($text)); //To Department Head
				}

				if(!empty($department->supervisor)) {
					$notifiable = User::findOrFail($department->supervisor);
					$notifiable->notify(new ReimburseRequestNotify($text)); //To Supervisor
				}
			}

            return response()->json(['success' => __('Data Added successfully.')]);
        }

        return response()->json(['success' => __('You are not authorized')]);
    }

    public function show($id)
    {
        if (request()->ajax()) {
            $data = Reimbursement::with(['reimbursementType', 'employee', 'employee.company'])->findOrFail($id);

            return response()->json(['data' => $data]);
        }
    }

    public function edit($id)
    {
        if (request()->ajax()) {
            $data = Reimbursement::with(['reimbursementType', 'employee', 'employee.company'])->findOrFail($id);

            // $employees = Employee::select('id', 'first_name', 'last_name')
            //     ->where('company_id', $data->employee->company_id)->where('is_active', 1)->where('exit_date', NULL)->get();

            $employees = [];

            return response()->json(['data' => $data, 'employees' => $employees]);
        }
    }

    public function update(Request $request)
    {
        $logged_user = auth()->user();

        // if ($logged_user->can('edit-reimbursement')) {
            $id = $request->hidden_id;

            $validator = Validator::make(
                $request->only(
                    // 'employee_id',
                    'reimbursement_type_id',
                    'amount',
                    'description',
                ),
                [
                    // 'employee_id' => 'required',
                    'reimbursement_type_id' => 'required',
                    'amount' => 'required',
                    'description' => 'required',
                ]
            );


            if ($validator->fails()) {
                return response()->json(['errors' => $validator->errors()->all()]);
            }
            
            # Check Dept Head Or Supervisor
			$employee = Employee::where('staff_id', 'like', '%'.$logged_user->username.'%')->first();
			$check_dept = department::where('id', $employee->department_id)->first();
			if($check_dept->department_head != $logged_user->id and $check_dept->supervisor != $logged_user->id)
			{
				return response()->json(['success' => __('User not as Dept Head or Supervisor!')]);
			}
            
            $current_employee = Employee::find($logged_user->id);
            
            if ($request->employee_id) {
				$employee_id = $request->employee_id;
			} else {
				$employee_id = $request->employee_id_hidden;
			}
            
			$requester_employee = Employee::find($employee_id);
            $checking_reimburse = Reimbursement::find($id);
            if(!$logged_user->hasRole('admin')) {
                if($current_employee->dept_head == 1 && $checking_reimburse->status != "first level approval" && $requester_employee->supervisor != 1)
                {
                    return response()->json(['limit' => __('Manager allowed to approved first level approval and supervisor request')]);
                }
            }

            $data = [];
            // $data['employee_id'] = $request->employee_id;
            $data['reimbursement_type_id'] = $request->reimbursement_type_id;
            $data['amount'] = $request->amount;
            $data['description'] = $request->description;
            $data['status'] = $request->status ?? 'pending';

            Reimbursement::find($id)->update($data);
            $updated_data = Reimbursement::find($id);
            if ($data['status'] != 'pending') {
                $text = "Your travel request status is --- ".$updated_data->status;
                $notifiable = User::findOrFail($updated_data->employee_id);
                $notifiable->notify(new ReimburseNotify($text));

                //Notif HR
                $users_hr = User::where('role_users_id', 6)
                            ->whereJsonContains('company_ids', (int)$current_employee->company_id)
                            ->get();

                $route = route('reimbursements.index');
                foreach ($users_hr as $hr) {
                    $req_employee = Employee::find($checking_reimburse->employee_id);
                    if($request->status == 'approved')
                    {
                        $text = "A reimbursement ". $req_employee->first_name ." ". $req_employee->last_name . " has been approved";
                    }
                    elseif($request->status == 'rejected')
                    {
                        $text = "A reimbursement ". $req_employee->first_name ." ". $req_employee->last_name . " has been rejected";
                    }
                    
                    $hr->notify(new GeneralNotificationtoAdmin($text, $route));
                }
            }

            return response()->json(['success' => __('Data is successfully updated')]);
        // } else {

        //     return response()->json(['success' => __('You are not authorized')]);
        // }
    }

    public function destroy($id)
    {
        if (!env('USER_VERIFIED')) {
            return response()->json(['error' => 'This feature is disabled for demo!']);
        }
        $logged_user = auth()->user();

        if ($logged_user->can('delete-reimbursement')) {
            Reimbursement::whereId($id)->delete();

            return response()->json(['success' => __('Data is successfully deleted')]);
        }

        return response()->json(['success' => __('You are not authorized')]);
    }

    public function delete_by_selection(Request $request)
    {
        if (!env('USER_VERIFIED')) {
            return response()->json(['error' => 'This feature is disabled for demo!']);
        }
        $logged_user = auth()->user();

        if ($logged_user->can('delete-reimbursement')) {

            $reimbursement_id = $request['reimbursementIdArray'];
            $reimbursement = Reimbursement::whereIntegerInRaw('id', $reimbursement_id);
            if ($reimbursement->delete()) {
                return response()->json(['success' => 'Selected reimbursements has been deleted']);
            } else {
                return response()->json(['error' => 'Error, selected reimbursements can not be deleted']);
            }
        }

        return response()->json(['success' => __('You are not authorized')]);
    }
}
