<?php


namespace App\Http\traits;

use App\BPJSTK;
use App\BPJSKes;
use App\Tax;
use App\Employee;
use Carbon\Carbon;


Trait TotalSalaryTrait {

	public function totalSalary($employee, $payslip_type , $basicsalary, $allowance_amount, $deduction_amount, $pph, $attendance_salary_cut, $salary_kehadiran, $total_minutes = 0){
        // $jht = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jht')->first();
        // $jkk = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkk')->first();
        // $jkm = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jkm')->first();
        // $pensiun = BPJSTK::where('company_id', $employee->company_id)->where('type', 'pensiun')->first();
        // $bpjskes = BPJSKes::where('company_id', $employee->company_id)->where('name', 'Kesehatan')->first();

		$jht = BPJSTK::where('id', 2)->where('type', 'jht')->first();   
		$jkk = BPJSTK::where('id', 4)->where('type', 'jkk')->first();
		$jkm = BPJSTK::where('id', 3)->where('type', 'jkm')->first();
		$pensiun = BPJSTK::where('id', 1)->where('type', 'pensiun')->first();
		$bpjskes = BPJSKes::where('id', 1)->first();

		$salary = $employee->salaryBasic[0];
		if($salary->basic_salary_custom == 0)
		{
			$basic_salary_custom = $salary->basic_salary;
		}
		else
		{
			$basic_salary_custom = $salary->basic_salary_custom;
		}

		$tanggungan = $salary->tanggungan_kes;

		$basicsalaryjht = $basic_salary_custom;
		if($jht->max_salary > 0 && $basicsalaryjht > $jht->max_salary)
		{
			$basicsalaryjht = $jht->max_salary;
		}

		$basicsalarykes = $basic_salary_custom;
		if($bpjskes->max_salary > 0 && $basicsalarykes > $bpjskes->max_salary)
		{
			$basicsalarykes = $bpjskes->max_salary;
		}
		
		$basicsalaryjp = $basic_salary_custom;
		$current_date = date('Y-m-d');
		$birth_date = $employee->date_of_birth;
		$age = date_diff(date_create($birth_date), date_create($current_date))->y;
		if ($age < 60) {
			if($pensiun->max_salary > 0 && $basicsalaryjp >= $pensiun->max_salary)
			{
				$basicsalaryjp = $pensiun->max_salary;
			}
		}
		else {
			$basicsalaryjp = 0;
		}

        $nilai_jht = $basicsalaryjht*($jht->employee ?? 0)/100;
        $nilai_jkk = $basic_salary_custom*($jkk->employee ?? 0)/100;
        $nilai_jkm = $basic_salary_custom*($jkm->employee ?? 0)/100;
        $nilai_pensiun = $basicsalaryjp*($pensiun->employee ?? 0)/100;
        $nilai_kes = $basicsalarykes*($bpjskes->employee ?? 0)/100;

		$nilai_kes = $nilai_kes + ($nilai_kes * $tanggungan);

        $pension_amount = $nilai_jht+$nilai_pensiun;

        // $nilai_jht = $employee->basic_salary_custom * ($jht->employee ?? 0) / 100;
        // $nilai_jkk = $employee->basic_salary_custom * ($jkk->employee ?? 0) / 100;
        // $nilai_jkm = $employee->basic_salary_custom * ($jkm->employee ?? 0) / 100;
        // $nilai_pensiun = $employee->basic_salary_custom * ($pensiun->employee ?? 0) / 100;
        // $nilai_kes = $employee->basic_salary_custom * ($bpjskes->employee ?? 0) / 100;
        // $pension_amount = $nilai_jht+$nilai_pensiun;

		if($payslip_type == 'Monthly')
		{
			// $total = $basicsalary - $pph + $allowance_amount + $employee->commissions->sum('commission_amount')
			// 	- $employee->loans->sum('monthly_payable') - $deduction_amount - $pension_amount - $nilai_jkk - $nilai_jkm - $nilai_kes - $attendance_salary_cut// (basic_salary - pension_amount)
			// 	+ $employee->otherPayments->sum('other_payment_amount') + $employee->overtimes->sum('overtime_amount') + $salary_kehadiran;

			$total = $basicsalary - $pph + $allowance_amount + $employee->commissions->sum('commission_amount')
				- $employee->loans->sum('monthly_payable') - $deduction_amount - $pension_amount - $nilai_jkk - $nilai_jkm - $nilai_kes // (basic_salary - pension_amount)
				+ $employee->otherPayments->sum('other_payment_amount') + $employee->overtimes->sum('overtime_amount') + $salary_kehadiran;
		}
		else
		{
			$total =  ($basicsalary / 60) * $total_minutes + $allowance_amount +  $employee->commissions->sum('commission_amount')
				- $employee->loans->sum('monthly_payable') - $deduction_amount - $pension_amount // (basic_salary - pension_amount)
				+ $employee->otherPayments->sum('other_payment_amount') + $employee->overtimes->sum('overtime_amount') + $salary_kehadiran;
		}

		$arr = [
			"salary" => $basicsalary,
			"allowance" => $allowance_amount,
			"commision" => $employee->commissions->sum('commission_amount'),
			"other_payment" => $employee->otherPayments->sum('other_payment_amount'),
			"overtime" => $employee->overtimes->sum('overtime_amount'),
			"kehadiran" => $salary_kehadiran,
			"pph" => $pph,
			"loan" => $employee->loans->sum('monthly_payable'),
			"deduction" => $deduction_amount,
			"pension" => $pension_amount,
			"jkk" => $nilai_jkk,
			"jkm" => $nilai_jkm,
			"jht" => $nilai_jht,
			"jpension" => $nilai_pensiun,
			"kes" => $nilai_kes,
			"salary_cut" => $attendance_salary_cut
		  ];

        if($total<0)
        {
            $total=0;
        }
		return $total;
	}

    public function hitungPph($employee, $basicsalary, $work_days = 0, $first_date = null, $salary_kehadiran) {
        // $jht = BPJSTK::where('company_id', $employee->company_id)->where('type', 'jht')->first() ?? new BPJSTK();
        // $pensiun = BPJSTK::where('company_id', $employee->company_id)->where('type', 'pensiun')->first() ?? new BPJSTK();
		$jht = BPJSTK::where('id', 2)->where('type', 'jht')->first();
		$jkk = BPJSTK::where('id', 4)->where('type', 'jkk')->first();
		$jkm = BPJSTK::where('id', 3)->where('type', 'jkm')->first();
		$pensiun = BPJSTK::where('id', 1)->where('type', 'pensiun')->first();
        $bpjskes = BPJSKes::where('id', 1)->first();

		//check month from date
		$month = substr($first_date, 5, 2);
		$allowance_amount = $this->allowances_pph($employee, $first_date, $work_days);

		if($month >= 1 && $month <= 11)
		{
			if($employee->basic_salary_custom == 0)
			{
				$salary = $employee->basic_salary;
			}
			else
			{
				$salary = $employee->basic_salary_custom;
			}

			$tanggungan = $employee->tanggungan_kes;

			$basicsalaryjht = $salary;
			if($jht->max_salary > 0 && $basicsalaryjht > $jht->max_salary)
			{
				$basicsalaryjht = $jht->max_salary;
			}

			$basicsalarykes = $salary;
			if($bpjskes->max_salary > 0 && $basicsalarykes > $bpjskes->max_salary)
			{
				$basicsalarykes = $bpjskes->max_salary;
			}

			$nilai_jht = $basicsalaryjht * ($jht->employee ?? 0) / 100;
			$nilai_jkk = $salary*($jkk->company ?? 0)/100;
			$nilai_jkm = $salary*($jkm->company ?? 0)/100;
			$nilai_kes = $basicsalarykes*($bpjskes->employee ?? 0)/100;

			$nilai_kes = $nilai_kes + ($nilai_kes * $tanggungan);

			$nilai_pensiun = $salary * ($pensiun->employee ?? 0) / 100;
			$pension_amount = $nilai_jht + $nilai_pensiun;

			$biaya_jabatan = $basicsalary * 5 / 100;

			$net_salary_year = ($basicsalary + $allowance_amount + $salary_kehadiran) + ($nilai_jkk + $nilai_jkm);
			$tax_rates = $this->tax_rates();
			$tax_percentage = 0;

			$ptkp_category = "Category A"; //TK/0, TK/1, K/0
			if($employee->dependent == "K/1" || $employee->dependent == "K/2" || $employee->dependent == "TK/2" || $employee->dependent == "TK/3")
			{
				$ptkp_category = "Category B";
			}
			else if($employee->dependent == "K/3")
			{
				$ptkp_category = "Category C";
			}

			foreach ($tax_rates[$ptkp_category] as $range) {
				if ($net_salary_year >= $range['range'][0] && $net_salary_year <= $range['range'][1]) {
					$tax_percentage = $range['tax_rate'];
					break;
				}
			}

			$tax_amount = $net_salary_year * ($tax_percentage / 100);
			// $net_total = $net_salary_year  - $tax_amount;
			$net_total = $tax_amount;
		}
		else
		{
			$year = substr($first_date, 0, 4);
			$dates = [];
			$month_salary_start = substr($employee->salaryBasic[0]->first_date, 5, 2);
			for ($m = 1; $m <= 11; $m++) {

				if ($month_salary_start <= $m)
				{
					// Format month with leading zero if necessary
					$formattedMonth = str_pad($m, 2, '0', STR_PAD_LEFT);
					// Construct the date in yyyy-mm-dd format
					$dates[] = "$year-$formattedMonth-01";
				}
			}

			$calculation = [];
			foreach ($dates as $dt)
			{
				$formattedMonthYear = date('F-Y', strtotime($dt));
				
				// Calculate the start and end of the range
				$start_cut = "Y-m-".$employee->start_cut_off_date;
				$end_cut = "Y-m-".$employee->end_cut_off_date;
				$startOfRange = date($start_cut, strtotime('-1 month', strtotime($dt))); // 21st of the previous month
				$endOfRange = date($end_cut, strtotime($dt)); // 20th of the current month
				
				$employee = Employee::with([
					'salaryBasic' => function ($query) {
						$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
					},
					'kehadiran' => function ($query) {
						$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
					},
					'allowances' => function ($query) {
						$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
					},
					'commissions' => function ($query) use ($dt) {
						$query->where('first_date', $dt);
					},
					'loans' => function ($query) use ($dt) {
						$query->where('first_date', '<=', $dt)
						->where('amount_remaining', '!=', 0)
							->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
					},
					'deductions' => function ($query) {
						$query->orderByRaw('DATE_FORMAT(first_date, "%y-%m")');
					},
					'otherPayments' => function ($query) use ($dt) {
						$query->where('first_date', $dt);
					},
					'overtimes' => function ($query) use ($formattedMonthYear) {
						$query->where('month_year', $formattedMonthYear);
					},
					'designation', 'department', 'user', 'setting',
					'employeeAttendance' => function ($query) use ($startOfRange, $endOfRange) {
						$query->whereBetween('attendance_date', [$startOfRange, $endOfRange]);
					},
					'user:id,username', 'company.Location.country',
					'department:id,department_name', 'designation:id,designation_name',
				])
				->select('employees.id', 'employees.company_id', 'employees.first_name', 'employees.contact_no', 'employees.last_name', 'employees.basic_salary', 'employees.basic_salary_custom', 'employees.tunjangan_jabatan', 'employees.tunjangan_jabatan', 'employees.payslip_type', 'employees.designation_id', 'employees.department_id', 'employees.joining_date', 'employees.dependent', 'ptkp.value as ptkp', 'employees.date_of_birth')
				->leftjoin('ptkp', [
						'employees.company_id' => 'ptkp.company_id',
						'employees.dependent' => 'ptkp.name'
				])
				->findOrFail($employee->id);
				
				$tanggungan = 0;
				
				//payslip_type && salary_basic
				foreach ($employee->salaryBasic as $salaryBasic) {
					if ($salaryBasic->first_date <= $first_date) {
						$basic_salary = $salaryBasic->basic_salary;
						$tunjangan_jabatan = $salaryBasic->tunjangan_jabatan;
						$tanggungan = $salaryBasic->tanggungan_kes;
		
						if($salaryBasic->basic_salary_custom == 0)
						{
							$basic_salary_custom = $salaryBasic->basic_salary;
						}
						else
						{
							$basic_salary_custom = $salaryBasic->basic_salary_custom;
						}
		
						$total_gaji_tunjangan = $basic_salary+$tunjangan_jabatan;
						$payslip_type = $salaryBasic->payslip_type;
					}
				}
				
				$prev_month = Carbon::createFromFormat('Y-m-d', $dt)->subMonth();
				$cut_off_start = $prev_month->day($employee->start_cut_off_date);
				$cut_off_end = Carbon::createFromFormat('Y-m-d', $dt)->day($employee->end_cut_off_date);
				$attendances = $employee->reportAttendances->where('attendance_date', '>=', $cut_off_start)->where('attendance_date', '<=', $cut_off_end);
				
				$work_days = $attendances->count();
				$number_cut = $employee->reportAttendances->where('attendance_date', '>=', $cut_off_start)->where('attendance_date', '<=', $cut_off_end)->whereIn('status', ['TA1', 'TA2', 'TA3'])->where('is_checked', 0)->count();
				if($work_days == 0) {
					$salary_cut_amount = 0;
				} else {
					$salary_cut_amount = $basic_salary/$work_days*$number_cut;
				}
				//TAMBAHAN UANG KEHADIRAN
				$salary_kehadiran = 0;
				if (!$employee->kehadiran->isEmpty()) {
					foreach ($employee->kehadiran as $item) {
						if ($item->first_date <= $dt) {
							$salary_kehadiran = $item->salary_kehadiran * $work_days;
						}
					}
				} else {
					$salary_kehadiran = 0;
				}

				$tanggungan = $employee->tanggungan_kes;

				$basicsalaryjht = $basic_salary_custom;
				if($jht->max_salary > 0 && $basicsalaryjht > $jht->max_salary)
				{
					$basicsalaryjht = $jht->max_salary;
				}

				$basicsalarykes = $basic_salary_custom;
				if($bpjskes->max_salary > 0 && $basicsalarykes > $bpjskes->max_salary)
				{
					$basicsalarykes = $bpjskes->max_salary;
				}
				
				$basicsalaryjp = $basic_salary_custom;
				$current_date = date('Y-m-d');
				$birth_date = $employee->date_of_birth;
				$age = date_diff(date_create($birth_date), date_create($current_date))->y;
				if ($age < 60) {
					if($pensiun->max_salary > 0 && $basicsalaryjp >= $pensiun->max_salary)
					{
						$basicsalaryjp = $pensiun->max_salary;
					}
				}
				else {
					$basicsalaryjp = 0;
				}

				$nilai_jht = $basicsalaryjht * ($jht->employee ?? 0) / 100;
				$nilai_jkk = $basic_salary_custom*($jkk->company ?? 0)/100;
				$nilai_jkm = $basic_salary_custom*($jkm->company ?? 0)/100;
				$nilai_kes = $basicsalarykes*($bpjskes->employee ?? 0)/100;

				$nilai_kes = $nilai_kes + ($nilai_kes * $tanggungan);

				$nilai_pensiun = $basicsalaryjp * ($pensiun->employee ?? 0) / 100;
				$pension_amount = $nilai_jht + $nilai_pensiun;

				$biaya_jabatan = $basicsalary * 5 / 100;

				$net_salary_year = ($basicsalary + $allowance_amount + $salary_kehadiran) + ($nilai_jkk + $nilai_jkm);
				$tax_rates = $this->tax_rates();
				$tax_percentage = 0;

				$ptkp_category = "Category A"; //TK/0, TK/1, K/0
				if($employee->dependent == "K/1" || $employee->dependent == "K/2" || $employee->dependent == "TK/2" || $employee->dependent == "TK/3")
				{
					$ptkp_category = "Category B";
				}
				else if($employee->dependent == "K/3")
				{
					$ptkp_category = "Category C";
				}

				foreach ($tax_rates[$ptkp_category] as $range) {
					if ($net_salary_year >= $range['range'][0] && $net_salary_year <= $range['range'][1]) {
						$tax_percentage = $range['tax_rate'];
						break;
					}
				}

				$tax_amount = $net_salary_year * ($tax_percentage / 100);
				$net_total = $tax_amount;
				
				$row["total_bruto"] = $net_salary_year;
				$row["total_pph"] = $net_total;
				$row["pension"] = $nilai_pensiun;
				$calculation[] = $row;
			}
            
			$total_bruto = 0;
			$total_pph = 0;
			$total_pension = 0;
			if (count($calculation) > 0) {
				foreach ($calculation as $calculate) {
					$total_bruto += $calculate["total_bruto"];
					$total_pph += $calculate["total_pph"];
					$total_pension += $calculate["pension"];
				}
			}

			$taxBracketRates = $this->tarif_pemotongan_pajak(); // Call the function to get the tax rates
			$applicableTaxRate = null;

			foreach ($taxBracketRates as $rate) {
				// Check if total_bruto falls within this tax range
				if (
					$total_bruto >= $rate['total_min'] &&
					($total_bruto <= $rate['total_max'] || $rate['total_max'] == 0)
				) {
					$applicableTaxRate = $rate;
					break; // Exit loop once the correct range is found
				}
			}

			$positionAllowanceRate = 0.05; // Biaya Jabatan (5%)
			$positionAllowanceMax = 6000000; // Maksimum Rp6.000.000,00
			$pensionMonthly = $total_pension;
			$pphUntilNovember = $total_pph;
			$result_pph21 = $this->calculatePPhPasal21(
				$total_bruto,
				$positionAllowanceRate,
				$positionAllowanceMax,
				$pensionMonthly,
				$taxBracketRates,
				$pphUntilNovember,
				$employee->dependent
			);

			$net_total = $result_pph21["pphDecember"];
		}

		return $net_total;
    }

	protected function calculatePPhPasal21($grossIncomeYear, $positionAllowanceRate, $positionAllowanceMax, $pensionMonthly	, $taxBracketRates, $pphUntilNovember, $dependent) {
		// Step 1: Calculate Total Deductions
		$positionAllowance = min($grossIncomeYear * $positionAllowanceRate, $positionAllowanceMax);
		// $pensionDeduction = $pensionMonthly * 12;
		$pensionDeduction = $pensionMonthly;
		$totalDeductions = $positionAllowance + $pensionDeduction;
	
		// Step 2: Calculate Net Income
		$netIncomeYear = $grossIncomeYear - $totalDeductions;
	
		// Step 3: Calculate PTKP (Penghasilan Tidak Kena Pajak)
		$ptkp = $this->hitungPTKP($dependent, $this->ptkp());
	
		// Step 4: Calculate Taxable Income
		$taxableIncome = max($netIncomeYear - $ptkp, 0); // Ensure taxable income is not negative
	
		// Step 5: Calculate PPh Pasal 21 (using progressive tax brackets)
		$pphYearly = 0;
		foreach ($taxBracketRates as $rate) {
			if ($taxableIncome <= 0) break;

			$max = $rate["total_max"] == 0 ? $taxableIncome : min($rate["total_max"], $taxableIncome);
			$min = $rate["total_min"];

			if ($taxableIncome > $min) {
				$taxable_amount = $max - $min;
				$tax = $taxable_amount * ($rate["percentage"] / 100);
				$taxableIncome += $tax;

				$taxableIncome -= $taxable_amount;
			}
		}
	
		// Step 6: Calculate PPh for December
		if ($taxableIncome > 0) 
		{
		    $pphDecember = $taxableIncome - $pphUntilNovember;    
		}
		else
		{
		    $pphDecember = $taxableIncome;
		}
	    
	    $test = [
			"grossIncomeYear" => $grossIncomeYear,
			"positionAllowance" => $positionAllowance,
			"pensionDeduction" => $pensionDeduction,
			"totalDeductions" => $totalDeductions,
			"netIncomeYear" => $netIncomeYear,
			"ptkp" => $ptkp,
			"taxableIncome" => $taxableIncome,
			"pphYearly" => $pphYearly,
			"pphDecember" => $pphDecember,
		];
	    
		// Return breakdown of the calculations
		return [
			"grossIncomeYear" => $grossIncomeYear,
			"positionAllowance" => $positionAllowance,
			"pensionDeduction" => $pensionDeduction,
			"totalDeductions" => $totalDeductions,
			"netIncomeYear" => $netIncomeYear,
			"ptkp" => $ptkp,
			"taxableIncome" => $taxableIncome,
			"pphYearly" => $pphYearly,
			"pphDecember" => $pphDecember,
		];
	}

	protected function hitungPTKP($employee, $ptkp) {
		// Cek apakah nilai dependent sesuai dengan format yang ada dalam array PTKP
		if (isset($ptkp[$employee])) {
			// Mengambil nilai PTKP yang sesuai dengan status pernikahan dan jumlah tanggungan
			return $ptkp[$employee];
		} else {
			// Jika format dependent tidak ditemukan, kembalikan 0 atau nilai default
			return 0;
		}
	}

	protected function ptkp()
	{
		$ptkp = [
			"TK/0" => 54000000,   // Tidak Kawin Tanpa Tanggungan
			"TK/1" => 58500000,   // Tidak Kawin Dengan 1 Tanggungan
			"TK/2" => 63000000,   // Tidak Kawin Dengan 2 Tanggungan
			"TK/3" => 67500000,   // Tidak Kawin Dengan 3 Tanggungan
			"K/0"  => 58500000,   // Kawin Tanpa Tanggungan
			"K/1"  => 63000000,   // Kawin Dengan 1 Tanggungan
			"K/2"  => 67500000,   // Kawin Dengan 2 Tanggungan
			"K/3"  => 72000000,   // Kawin Dengan 3 Tanggungan
		];

		return $ptkp;
	}

	protected function tarif_pemotongan_pajak()
	{
		$taxRates = [
			[
				"total_min" => 0,
				"total_max" => 60000000,
				"percentage" => 5,
			],
			[
				"total_min" => 60000001,
				"total_max" => 250000000,
				"percentage" => 15,
			],
			[
				"total_min" => 250000001,
				"total_max" => 500000000,
				"percentage" => 25,
			],
			[
				"total_min" => 500000001,
				"total_max" => 5000000000,
				"percentage" => 30,
			],
			[
				"total_min" => 5000000001,
				"total_max" => 0,
				"percentage" => 35,
			],
		];	

		return $taxRates;
	}

	protected function checking_salary_per_month($employee, $first_date = null)
	{
		foreach ($employee->salaryBasic as $salaryBasic) {
			if ($salaryBasic->first_date <= $first_date) {
				$payslip_type = $salaryBasic->payslip_type;
				$basicsalary = $salaryBasic->basic_salary;
				$tunjangan_jabatan = $salaryBasic->tunjangan_jabatan;
				// $basicsalarycustom = $salaryBasic->basic_salary_custom;
				$total_gaji_tunjangan = $basicsalary+$tunjangan_jabatan;

				if($salaryBasic->basic_salary_custom == 0)
				{
					$basicsalarycustom = $salaryBasic->basic_salary;
				}
				else
				{
					$basicsalarycustom = $salaryBasic->basic_salary_custom;
				}
			}
		}
	}

	protected function allowances_pph($employee, $first_date, $work_days = 0)
	{
		$allowance_amount = 0;
		if (!$employee->allowances->isEmpty()) {
			foreach ($employee->allowances as $item) {
				if ($item->first_date <= $first_date) {
					if ($item->is_taxable == 1)
					{
						$allowance_amount += $item->allowance_amount;
					}
				}
			}
		}
		return $allowance_amount;
	}

    protected function allowances($employee, $first_date, $type, $work_days = 0)
	{
		// if ($type == "getArray") {
        //     $allowances = array();
        //     if (!$employee->allowances->isEmpty()) {
		// 		foreach ($employee->allowances as $item) {
		// 			if ($item->first_date <= $first_date) {
		// 				foreach ($employee->allowances as $key => $value) {
		// 					if ($value->first_date <= $first_date) {
		// 						//$allowances = array();
		// 						$allowances[] =  $employee->allowances[$key];
		// 					}
		// 				}
		// 			}
		// 		}
		// 	} else {
		// 		$allowances = [];
		// 	}
		// 	return $allowances;
		// } elseif ($type == "getAmount") {
		// 	$allowance_amount = 0;
		// 	if (!$employee->allowances->isEmpty()) {
		// 		foreach ($employee->allowances as $item) {
		// 			if ($item->first_date <= $first_date) {
		// 				//$allowance_amount = 0;
		// 				foreach ($employee->allowances as $value) {
		// 					if ($value->first_date <= $first_date) {
		// 						if ($value->is_taxable == 1)
		// 						{
		// 							$allowance_amount += $value->allowance_amount;
		// 						}
		// 						else
		// 						{
		// 							$allowance_amount += $value->allowance_amount*$work_days;
		// 						}
		// 					}
		// 				}
		// 			}
		// 		}
		// 	}

		// 	return $allowance_amount;
		// }

		if ($type == "getArray") {
            $allowances = array();
            if (!$employee->allowances->isEmpty()) {
					foreach ($employee->allowances as $key => $value) {
						if ($value->first_date <= $first_date) {
							//$allowances = array();
							$allowances[] =  $employee->allowances[$key];
						}
					}
			} else {
				$allowances = [];
			}
			return $allowances;
		} elseif ($type == "getAmount") {
			$allowance_amount = 0;
			if (!$employee->allowances->isEmpty()) {
				foreach ($employee->allowances as $item) {
					if ($item->first_date <= $first_date) {
						if ($item->is_taxable == 1)
						{
							$allowance_amount += $item->allowance_amount;
						}
						else
						{
							$allowance_amount += $item->allowance_amount*$work_days;
						}
					}
				}
			}
			return $allowance_amount;
		}
	}
	
	protected function tax_rates()
	{
		$taxRates = [
			"Category A" => [
				["range" => [0, 5400000], "tax_rate" => 0.00],
				["range" => [5400001, 5650000], "tax_rate" => 0.25],
				["range" => [5650001, 5800000], "tax_rate" => 0.50],
				["range" => [5800001, 5950000], "tax_rate" => 0.75],
				["range" => [5950001, 6300000], "tax_rate" => 1.00],
				["range" => [6300001, 6500000], "tax_rate" => 1.25],
				["range" => [6500001, 6750000], "tax_rate" => 1.50],
				["range" => [6750001, 6950000], "tax_rate" => 1.75],
				["range" => [6950001, 7150000], "tax_rate" => 2.00],
				["range" => [7150001, 7650000], "tax_rate" => 2.25],
				["range" => [7650001, 8150000], "tax_rate" => 2.50],
				["range" => [8150001, 8650000], "tax_rate" => 2.75],
				["range" => [8650001, 9150000], "tax_rate" => 3.00],
				["range" => [9150001, 9650000], "tax_rate" => 3.25],
				["range" => [9650001, 10500000], "tax_rate" => 3.50],
				["range" => [10500001, 11500000], "tax_rate" => 3.75],
				["range" => [11500001, 12500000], "tax_rate" => 4.00],
				["range" => [12500001, 13750000], "tax_rate" => 5.00],
				["range" => [13750001, 14750000], "tax_rate" => 6.00],
				["range" => [14750001, 15750000], "tax_rate" => 7.00],
				["range" => [15750001, 16750000], "tax_rate" => 8.00],
				["range" => [16750001, 19750000], "tax_rate" => 9.00],
				["range" => [19750001, 24500000], "tax_rate" => 10.00],
				["range" => [24500001, 27500000], "tax_rate" => 11.00],
				["range" => [27500001, 30450000], "tax_rate" => 12.00],
				["range" => [30450001, 33450000], "tax_rate" => 13.00],
				["range" => [33450001, 36450000], "tax_rate" => 14.00],
				["range" => [36450001, 39450000], "tax_rate" => 15.00],
				["range" => [39450001, 43850000], "tax_rate" => 16.00],
				["range" => [43850001, 47800000], "tax_rate" => 17.00],
				["range" => [47800001, 51400000], "tax_rate" => 18.00],
				["range" => [51400001, 56250000], "tax_rate" => 19.00],
				["range" => [56250001, 62650000], "tax_rate" => 20.00],
				["range" => [62650001, 69400000], "tax_rate" => 21.00],
				["range" => [69400001, 77500000], "tax_rate" => 22.00],
				["range" => [77500001, 89100000], "tax_rate" => 23.00],
				["range" => [89100001, 103000000], "tax_rate" => 24.00],
				["range" => [103000001, 125000000], "tax_rate" => 25.00],
				["range" => [125000001, 157000000], "tax_rate" => 26.00],
				["range" => [157000001, 337000000], "tax_rate" => 27.00],
				["range" => [337000001, 450000000], "tax_rate" => 28.00],
				["range" => [450000001, 595000000], "tax_rate" => 29.00],
				["range" => [595000001, 910000000], "tax_rate" => 30.00],
				["range" => [910000001, 1400000000], "tax_rate" => 31.00],
				["range" => [1400000001, PHP_INT_MAX], "tax_rate" => 34.00],
			],
			"Category B" => [
				["range" => [0, 6200000], "tax_rate" => 0.00],
				["range" => [6200001, 6500000], "tax_rate" => 0.25],
				["range" => [6500001, 6800000], "tax_rate" => 0.50],
				["range" => [6800001, 7200000], "tax_rate" => 0.75],
				["range" => [7200001, 7700000], "tax_rate" => 1.00],
				["range" => [7700001, 8200000], "tax_rate" => 1.25],
				["range" => [8200001, 8750000], "tax_rate" => 1.50],
				["range" => [8750001, 9250000], "tax_rate" => 1.75],
				["range" => [9250001, 9750000], "tax_rate" => 2.00],
				["range" => [9750001, 10250000], "tax_rate" => 2.25],
				["range" => [10250001, 10750000], "tax_rate" => 2.50],
				["range" => [10750001, 11250000], "tax_rate" => 2.75],
				["range" => [11250001, 11850000], "tax_rate" => 3.00],
				["range" => [11850001, 12600000], "tax_rate" => 3.25],
				["range" => [12600001, 13800000], "tax_rate" => 4.00],
				["range" => [13800001, 15500000], "tax_rate" => 5.00],
				["range" => [15500001, 18500000], "tax_rate" => 6.00],
				["range" => [18500001, 21850000], "tax_rate" => 7.00],
				["range" => [21850001, 26000000], "tax_rate" => 8.00],
				["range" => [26000001, 29750000], "tax_rate" => 9.00],
				["range" => [29750001, 31350000], "tax_rate" => 10.00],
				["range" => [31350001, 36500000], "tax_rate" => 11.00],
				["range" => [36500001, 41100000], "tax_rate" => 12.00],
				["range" => [41100001, 49800000], "tax_rate" => 13.00],
				["range" => [49800001, 53800000], "tax_rate" => 14.00],
				["range" => [53800001, 58500000], "tax_rate" => 15.00],
				["range" => [58500001, 64500000], "tax_rate" => 16.00],
				["range" => [64500001, 70500000], "tax_rate" => 17.00],
				["range" => [70500001, 78500000], "tax_rate" => 18.00],
				["range" => [78500001, 86000000], "tax_rate" => 19.00],
				["range" => [86000001, 93500000], "tax_rate" => 20.00],
				["range" => [93500001, 103500000], "tax_rate" => 21.00],
				["range" => [103500001, 114500000], "tax_rate" => 22.00],
				["range" => [114500001, 129500000], "tax_rate" => 23.00],
				["range" => [129500001, 154000000], "tax_rate" => 24.00],
				["range" => [154000001, PHP_INT_MAX], "tax_rate" => 25.00],
			],
			"Category C" => [
				["range" => [0, 6500000], "tax_rate" => 0.00],
				["range" => [6500001, 7000000], "tax_rate" => 0.25],
				["range" => [7000001, 7500000], "tax_rate" => 0.50],
				["range" => [7500001, 8000000], "tax_rate" => 0.75],
				["range" => [8000001, 8500000], "tax_rate" => 1.00],
				["range" => [8500001, 9000000], "tax_rate" => 1.25],
				["range" => [9000001, 9500000], "tax_rate" => 1.50],
				["range" => [9500001, 10000000], "tax_rate" => 1.75],
				["range" => [10000001, 10500000], "tax_rate" => 2.00],
				["range" => [10500001, 11000000], "tax_rate" => 2.25],
				["range" => [11000001, 11500000], "tax_rate" => 2.50],
				["range" => [11500001, 12000000], "tax_rate" => 2.75],
				["range" => [12000001, 12500000], "tax_rate" => 3.00],
				["range" => [12500001, 13000000], "tax_rate" => 3.25],
				["range" => [13000001, 14000000], "tax_rate" => 4.00],
				["range" => [14000001, 16000000], "tax_rate" => 5.00],
				["range" => [16000001, 18000000], "tax_rate" => 6.00],
				["range" => [18000001, 20000000], "tax_rate" => 7.00],
				["range" => [20000001, 22000000], "tax_rate" => 8.00],
				["range" => [22000001, 25000000], "tax_rate" => 9.00],
				["range" => [25000001, 28000000], "tax_rate" => 10.00],
				["range" => [28000001, 31000000], "tax_rate" => 11.00],
				["range" => [31000001, 34000000], "tax_rate" => 12.00],
				["range" => [34000001, 37000000], "tax_rate" => 13.00],
				["range" => [37000001, 40000000], "tax_rate" => 14.00],
				["range" => [40000001, 43000000], "tax_rate" => 15.00],
				["range" => [43000001, 46000000], "tax_rate" => 16.00],
				["range" => [46000001, 49000000], "tax_rate" => 17.00],
				["range" => [49000001, 52000000], "tax_rate" => 18.00],
				["range" => [52000001, 55000000], "tax_rate" => 19.00],
				["range" => [55000001, 60000000], "tax_rate" => 20.00],
				["range" => [60000001, 65000000], "tax_rate" => 21.00],
				["range" => [65000001, 70000000], "tax_rate" => 22.00],
				["range" => [70000001, 75000000], "tax_rate" => 23.00],
				["range" => [75000001, 80000000], "tax_rate" => 24.00],
				["range" => [80000001, 85000000], "tax_rate" => 25.00],
				["range" => [85000001, 90000000], "tax_rate" => 26.00],
				["range" => [90000001, 95000000], "tax_rate" => 27.00],
				["range" => [95000001, PHP_INT_MAX], "tax_rate" => 28.00],
			],
		];

		return $taxRates;
	}
}


