<?php


	namespace App\Imports;

	use App\company;
	use App\department;
	use App\designation;
	use App\Employee;
	use App\EmployeeBankAccount;
	use App\EmployeeSetting;
	use App\GeneralSetting;
	use App\office_shift;
	use App\SalaryBasic;
	use App\status;
	use App\User;
	use App\Role_User;
	use Illuminate\Contracts\Queue\ShouldQueue;
	use Illuminate\Support\Collection;
	use Illuminate\Support\Facades\DB;
	use Illuminate\Support\Facades\Hash;
	use Illuminate\Support\Facades\Validator;
    use Illuminate\Support\Facades\Schema;
	use Maatwebsite\Excel\Concerns\ToCollection;
	use Maatwebsite\Excel\Concerns\WithChunkReading;
	use Maatwebsite\Excel\Concerns\WithHeadingRow;
	use Maatwebsite\Excel\Validators\Failure;
	use Illuminate\Validation\ValidationException;

	use PhpOffice\PhpSpreadsheet\Cell\Cell;
	use PhpOffice\PhpSpreadsheet\Cell\DataType;
	use Maatwebsite\Excel\Concerns\WithCustomValueBinder;
	use Maatwebsite\Excel\DefaultValueBinder;

	class EmployeeImport extends DefaultValueBinder implements ToCollection, WithHeadingRow, ShouldQueue, WithChunkReading, WithCustomValueBinder
	{
		protected $errors = [];
		protected $headers = [];

		public function collection(Collection $rows)
		{
			$i = 2;

			foreach ($rows as $row) {
				$officeShiftId = null;
				if(!empty($row['first_name']) && $row['first_name'] != "")
				{
					// Check required fields and throw exceptions if not valid
					if (empty($row['first_name'])) {
						throw new \Exception("First Name is required in line '{$i}'");
					}
				
					if (empty($row['staff_id'])) {
						throw new \Exception("Staff ID is required in line '{$i}'");
					}
				
					if (empty($row['identity_number'])) {
						throw new \Exception("Identity Number is required in line '{$i}'");
					}
				
					if (empty($row['password'])) {
						throw new \Exception("Password is required in line '{$i}'");
					}
					
					// Password validation
                    $password = $row['password'];
                    if (!$this->isValidPassword($password)) {
                        throw new \Exception("Password does not meet the criteria in line '{$i}'");
                    }
				
					if (empty($row['joining_date'])) {
						throw new \Exception("Joining Date is required in line '{$i}'");
					}
				
					if (empty($row['gender'])) {
						throw new \Exception("Gender is required in line '{$i}'");
					}
				
					if (empty($row['date_of_birth'])) {
						throw new \Exception("Date of Birth is required in line '{$i}'");
					}
				
					if (empty($row['marital_status'])) {
						throw new \Exception("Marital Status is required in line '{$i}'");
					}
				
					if (!isset($row['dependent'])) {
						throw new \Exception("Dependent field is required in line '{$i}'");
					}

					// NPWP required
					if (!isset($row['npwp']) || $row['npwp'] === null || $row['npwp'] === '') {
						throw new \Exception("NPWP is required in line '{$i}'");
					}
				
					if (empty($row['company_name'])) {
						throw new \Exception("Company Name is required in line '{$i}'");
					}
				
					if (empty($row['department_name'])) {
						throw new \Exception("Department Name is required in line '{$i}'");
					}
				
					if (empty($row['designation_name'])) {
						throw new \Exception("Designation Name is required in line '{$i}'");
					}
				
					if (!isset($row['basic_salary_payslip'])) {
						throw new \Exception("Basic Salary Payslip is required in line '{$i}'");
					}
				
					if (empty($row['basic_salary'])) {
						throw new \Exception("Basic Salary is required in line '{$i}'");
					}
				
					if (empty($row['bank_account_title'])) {
						throw new \Exception("Bank Account Title is required in line '{$i}'");
					}
				
					if (empty($row['bank_account_number'])) {
						throw new \Exception("Bank Account Number is required in line '{$i}'");
					}
				
					if (empty($row['bank_name'])) {
						throw new \Exception("Bank Name is required in line '{$i}'");
					}
				
					if (!isset($row['include_bpjs_tk'])) {
						throw new \Exception("Include BPJS TK is required in line '{$i}'");
					}
				
					if (!isset($row['include_bpjs_kes'])) {
						throw new \Exception("Include BPJS Kes is required in line '{$i}'");
					}
				
					if (!isset($row['include_tax'])) {
						throw new \Exception("Include Tax is required in line '{$i}'");
					}

					$companyId = null;
					if (isset($row['company_name'])) {
						$companyData = company::where('company_name', $row['company_name'])->select('id')->first(); 
						if (!$companyData) {
							// $this->errors[] = "Company '{$row['company_name']}' not found for employee '{$row['first_name']}' in line '{$i}'";
							throw new \Exception("Company '{$row['company_name']}' not found for employee '{$row['first_name']}' in line '{$i}'");
							continue; // Skip this row
						}
						else
						{
							$companyId = $companyData->id;	
						}
						// $companyId = $companyData ? $companyData->id : null;
					}
					
					if (isset($row['shift_name'])) {
						$officeShiftData = office_shift::where('shift_name', $row['shift_name'])->where('company_id', $companyId)->select('id')->first();
						
						if (!$officeShiftData) {
							throw new \Exception("Shift '{$row['shift_name']}' in Company '{$row['company_name']}' not found in line '{$i}'");
							continue; // Skip this row
						}
						else
						{
							$officeShiftId = $officeShiftData ? $officeShiftData->id : null;
						}
					}

					$departmentId = null;
					if (isset($row['department_name'])) {
						$departmentData = department::where('department_name', $row['department_name'])->where('company_id', $companyId)->select('id')->first(); 
						$departmentId = $departmentData ? $departmentData->id : null;
					}
				
					$designationId = null;
					if (isset($row['designation_name'])) {
						$designation_data = designation::where('designation_name', $row['designation_name'])->where('company_id', $companyId)->where('department_id', $departmentId)->select('id')->first();
						$designationId = $designation_data ? $designation_data->id : null;
					}
					
					$statusId = null;
					if (isset($row['status'])) {
						$statusData = status::where('status_title', $row['status'])->select('id')->first();
						$statusId = $statusData ? $statusData->id : null;
				}

				// Resolve role id safely across schemas
				$roleId = $this->resolveRoleId($row['role_name'] ?? null);
		
					if (is_string($row['joining_date'])) {
						$joiningDate = date('Y-m-d', strtotime($row['joining_date']));
					} else {
						$joiningDate = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['joining_date'])->format('Y-m-d');
					}
					
					if (is_string($row['end_of_contract'])) {
						$exitDate = $row['end_of_contract'] ? date('Y-m-d', strtotime($row['end_of_contract'])) : null;
					} else {
						$exitDate = $row['end_of_contract'] ? \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['end_of_contract'])->format('Y-m-d') : null;
					}
					
					if (is_string($row['date_of_birth'])) {
						$birthDate = date('Y-m-d', strtotime($row['date_of_birth']));
					} else {
						$birthDate = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['date_of_birth'])->format('Y-m-d');
					}
		
					$position = isset($row['position']) && $row['position'] !== '' ? $row['position'] : 0;
					$dispensation = isset($row['dispensation']) && $row['dispensation'] !== '' ? $row['dispensation'] : 0;
					$religion = $this->normalizeReligion($row['religion'] ?? null);

					// Normalize and validate NPWP (15 digits)
					$npwpNorm = $this->normalizeNpwp($row['npwp'] ?? null);
					if ($npwpNorm === null) {
						throw new \Exception("NPWP must be fill (line '{$i}')");
					}

					// Normalize Identity Number (KTP)
					$identityNorm = $this->normalizeIdentity($row['identity_number'] ?? null);

					//Check Employee NIK
					$check_id_card = Employee::where('identity_number', $identityNorm)->first();
					if(!empty($check_id_card))
					{
						throw new \Exception("ID Number '{$row['identity_number']}' already registered in line '{$i}'");
						continue; // Skip this row
					}

					//Checking Existing Staff id
					$check_employee = Employee::where('staff_id', $row['staff_id'])->first();
					if($check_employee)
					{
						throw new \Exception("Staff ID '{$row['identity_number']}' already registered in line '{$i}'");
						continue; // Skip this row
					}
		
					if ($row['username'] != null && $row['username'] != '') {
						$user = User::create([
							'username' => $row['username'],
							'first_name' => $row['first_name'],
							'last_name' => $row['last_name'],
							'email' => $row['email'],
							// 'password' => Hash::make($row['password']),
							'password' => bcrypt($row['password']),
							'contact_no' => $row['contact_no'],
							'company_ids' => $companyId,
							'role_users_id' => $roleId,
							'is_active' => 1,
						]);
		
				// 		$employee = Employee::create([
				// 			'id' => $user->id,
				// 			'first_name' => $row['first_name'],
				// 			'last_name' => $row['last_name'],
				// 			'staff_id' => $row['staff_id'],
				// 			'email' => $row['email'],
				// 			// 'identity_number' => $row['identity_number'],
				// 			// 'npwp' => $row['npwp'],
				// 			'contact_no' => (string)$row['contact_no'],
				// 			'date_of_birth' => $birthDate,
				// 			'gender' => $row['gender'],
				// 			'office_shift_id' => (int)$officeShiftId,
				// 			'company_id' => $companyId,
				// 			'department_id' => $departmentId,
				// 			'designation_id' => $designationId,
				// 			'role_users_id' => 2,
				// 			'status_id' => $statusId,
				// 			'joining_date' => $joiningDate,
				// 			'exit_date' => $exitDate,
				// 			'religion' => $religion,
				// 			'marital_status' => strtolower($row['marital_status']),
				// 			'dependent' => $row['dependent'],
				// 			'address' => $row['address'],
				// 			'city' => $row['city'],
				// 			'state' => $row['state'],
				// 			'zip_code' => $row['zip'],
				// 			'attendance_type' => 'General',
				// 			'position' => $position,
				// 			'is_dispensation' => $dispensation,
				// 			'is_active' => 1,
				// 			'country' => 100,
				// 		]);
				
				        $formattedBirthDate = isset($birthDate) ? date('Y-m-d', strtotime($birthDate)) : null;
                        $formattedJoiningDate = isset($joiningDate) ? date('Y-m-d', strtotime($joiningDate)) : null;
                        $formattedExitDate = isset($exitDate) ? date('Y-m-d', strtotime($exitDate)) : null;
                    
                        // Insert and get ID
						// normalize marital status and dependent (PTKP code)
						$marital = $this->normalizeMarital($row['marital_status']);
						$dependentNormalized = $this->normalizeDependent($row['dependent'], $marital);

						$employeeId = DB::table('employees')->insertGetId([
                            'id' => $user->id,
                            'first_name' => $row['first_name'],
                            'last_name' => $row['last_name'],
                            'staff_id' => $row['staff_id'],
                            'email' => $row['email'],
							'identity_number' => $identityNorm,
                            'contact_no' => (string)$row['contact_no'],
                            'date_of_birth' => $formattedBirthDate,
                            'gender' => $row['gender'],
                            'office_shift_id' => (int)$officeShiftId,
                            'company_id' => $companyId,
                            'department_id' => $departmentId,
                            'designation_id' => $designationId,
							'role_users_id' => $roleId,
                            'status_id' => $statusId,
                            'joining_date' => $formattedJoiningDate,
                            'exit_date' => $formattedExitDate,
                            'religion' => $religion,
							'marital_status' => $marital,
							'dependent' => $dependentNormalized,
                            'address' => $row['address'],
                            'city' => $row['city'],
                            'state' => $row['state'],
                            'zip_code' => $row['zip'],
                            'attendance_type' => 'General',
                            'position' => $position,
                            'is_dispensation' => $dispensation,
                            'is_active' => 1,
                            'country' => 100,
							'npwp' => $npwpNorm,
                        ]);
                    
                        // Retrieve and return the inserted employee data
                        $employee = DB::table('employees')->where('id', $employeeId)->first();
                        
					} else {
						// normalize marital status and dependent (PTKP code)
						$marital = $this->normalizeMarital($row['marital_status']);
						$dependentNormalized = $this->normalizeDependent($row['dependent'], $marital);

						$employee = Employee::create([
							'first_name' => $row['first_name'],
							'last_name' => $row['last_name'],
							'staff_id' => $row['staff_id'],
							'email' => $row['email'],
							'identity_number' => $identityNorm,
							'npwp' => $npwpNorm,
							'contact_no' => (string)$row['contact_no'],
							'date_of_birth' => $birthDate,
							'gender' => $row['gender'],
							'office_shift_id' => (int)$officeShiftId,
							'company_id' => $companyId,
							'department_id' => $departmentId,
							'designation_id' => $designationId,
							'role_users_id' => $roleId,
							'status_id' => $statusId,
							'joining_date' => $joiningDate,
							'exit_date' => $exitDate,
							'religion' => $religion,
							'marital_status' => $marital,
							'dependent' => $dependentNormalized,
							'address' => $row['address'],
							'city' => $row['city'],
							'state' => $row['state'],
							'zip_code' => $row['zip'],
							'attendance_type' => 'General',
							'position' => $position,
							'is_dispensation' => $dispensation,
							'is_active' => 1,
							'country' => 100,
						]);
					}
		
					if ($row['basic_salary_month_year'] != null && $row['basic_salary_month_year'] != '') {
						$firstDate = date('Y-m-d', strtotime('first day of ' . $row['basic_salary_month_year']));
						SalaryBasic::create([
							'employee_id' => $employee->id,
							'month_year' => $row['basic_salary_month_year'],
							'first_date' => $firstDate,
							'payslip_type' => $row['basic_salary_payslip'],
							'basic_salary' => $row['basic_salary']
						]);
					}
		
					if ($row['bank_account_title'] != null && $row['bank_account_title'] != '') {
						EmployeeBankAccount::create([
							'employee_id' => $employee->id,
							'account_name' => $row['bank_account_title'],
							'account_number' => (string)$row['bank_account_number'],
							'bank_name' => $row['bank_name'],
							'bank_code' => $row['bank_code'],
							'bank_branch' => $row['bank_branch'],
						]);
					}
		
					EmployeeSetting::create([
						'employee_id' => $employee->id,
						'is_bpjs_tk_include' => $row['include_bpjs_tk'],
						'is_bpjs_kes_include' => $row['include_bpjs_kes'],
						'is_tax_include' => $row['include_tax'],
					]);

					if(!empty($employee))
					{
						$data['identity_number'] = $identityNorm;
						$data['npwp'] = $npwpNorm;
						employee::find($employee->id)->update($data);
					}
				}
				else
				{
					throw new \Exception("First Name is required in line '{$i}'");
				}
				
				$i++;
			}
			
			// return $this->errors;
		}
		
		/**
		 * Validate password complexity.
		 * 
		 * @param string $password
		 * @return bool
		 */
		private function isValidPassword($password)
		{
			$minLength = 8;
			$hasUppercase = preg_match('/[A-Z]/', $password);
			$hasLowercase = preg_match('/[a-z]/', $password);
			$hasNumber = preg_match('/[0-9]/', $password);
			$hasSpecialChar = preg_match('/[\W_]/', $password); // Matches special characters

			return strlen($password) >= $minLength && $hasUppercase && $hasLowercase && $hasNumber && $hasSpecialChar;
		}
		
		public function chunkSize(): int
		{
			return 500;
		}

		/**
		 * Force NPWP and identity_number columns to be treated as strings by PhpSpreadsheet
		 * to preserve all digits and avoid scientific notation / precision loss.
		 */
		public function bindValue(Cell $cell, $value)
		{
			$column = $cell->getColumn();
			$row = $cell->getRow();
			// Cache header names on row 1 to avoid accessing worksheet from binder
			if ($row === 1) {
				$this->headers[$column] = strtolower(trim((string)$value));
				return parent::bindValue($cell, $value);
			}

			$header = $this->headers[$column] ?? null;
			if ($header && in_array($header, ['npwp', 'identity_number', 'identity number', 'nik'])) {
				$cell->setValueExplicit((string)$value, DataType::TYPE_STRING);
				return true;
			}
			return parent::bindValue($cell, $value);
		}

		/**
		 * Normalize NPWP preserving leading zeros (assumes 15 digits when numeric).
		 */
		private function normalizeNpwp($value): ?string
		{
			if ($value === null || $value === '') return null;
			$raw = (string)$value;
			$digits = preg_replace('/\D+/', '', $raw);
			if ($digits === '') return null;
			// If Excel delivered it as a number, pad to 15
			if (ctype_digit($raw)) {
				$digits = str_pad($digits, 15, '0', STR_PAD_LEFT);
			}
			return $digits;
		}

		/**
		 * Normalize religion to lowercase canonical labels.
		 */
		private function normalizeReligion($value): ?string
		{
			if ($value === null || $value === '') return null;
			$val = strtolower(trim((string)$value));
			$map = [
				'islam' => 'islam',
				'muslim' => 'islam',
				'kristen' => 'christian',
				'protestan' => 'christian',
				'katolik' => 'catholic',
				'catholic' => 'catholic',
				'hindu' => 'hindu',
				'budha' => 'buddha',
				'buddha' => 'buddha',
				'konghucu' => 'confucianism',
				'confucianism' => 'confucianism',
			];
			return $map[$val] ?? $val;
		}

		/**
		 * Normalize marital status to expected English lowercase tokens.
		 */
		private function normalizeMarital($value): string
		{
			$val = strtolower(trim((string)$value));
			$map = [
				'single' => 'single',
				'lajang' => 'single',
				'belum menikah' => 'single',
				'tidak kawin' => 'single',
				'tk' => 'single',
				'married' => 'married',
				'menikah' => 'married',
				'kawin' => 'married',
				'k' => 'married',
				'divorced' => 'divorced',
				'cerai' => 'divorced',
				'widowed' => 'widowed',
				'janda' => 'widowed',
				'duda' => 'widowed',
				'janda/duda' => 'widowed',
			];
			return $map[$val] ?? $val;
		}

		/**
		 * Normalize dependent to PTKP code name (e.g., TK/0, K/1) when numbers are provided.
		 */
		private function normalizeDependent($value, string $marital): ?string
		{
			if ($value === null || $value === '') return null;
			$val = trim((string)$value);
			$upper = strtoupper($val);
			if (preg_match('/^(TK|K)\/[0-3]$/', $upper)) {
				return $upper;
			}
			if (is_numeric($val)) {
				$dep = (int)$val;
				if ($dep < 0) $dep = 0;
				if ($dep > 3) $dep = 3;
				return ($marital === 'married' ? 'K/' : 'TK/') . $dep;
			}
			return $val;
		}

		/**
		 * Normalize identity number (KTP) by removing non-digits and preserving all digits.
		 */
		private function normalizeIdentity($value): ?string
		{
			if ($value === null || $value === '') return null;
			$raw = (string)$value;
			$digits = preg_replace('/\D+/', '', $raw);
			return $digits ?: null;
		}

		/**
		 * Resolve role id from provided role name. Supports legacy role_users and spatie roles table.
		 */
		private function resolveRoleId(?string $roleName): int
		{
			$target = strtolower(trim($roleName ?? 'employee'));
			// Try legacy role_users
			if (Schema::hasTable('role_users')) {
				$found = DB::table('role_users')->whereRaw('LOWER(role_name) = ?', [$target])->select('id')->first();
				if ($found && isset($found->id)) return (int)$found->id;
				$found = DB::table('role_users')->whereRaw('LOWER(role_name) = ?', ['employee'])->select('id')->first();
				if ($found && isset($found->id)) return (int)$found->id;
			}
			// Try spatie roles
			if (Schema::hasTable('roles')) {
				$found = DB::table('roles')->whereRaw('LOWER(name) = ?', [$target])->select('id')->first();
				if ($found && isset($found->id)) return (int)$found->id;
				$found = DB::table('roles')->whereRaw('LOWER(name) = ?', ['employee'])->select('id')->first();
				if ($found && isset($found->id)) return (int)$found->id;
			}
			// Final fallback: 2 (commonly employee), else 1
			return 2;
		}
	}
