<?php

namespace App\Imports;

use App\Employee;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class EmployeePositionImport implements ToCollection, ShouldQueue, WithChunkReading, WithHeadingRow
{
    /**
     * @param Collection $collection
     */
    public function collection(Collection $rows)
    {
        foreach ($rows as $row) {
            $employee = Employee::find($row['employee_id']);
            $employee->position = $row['position'];
            $employee->save();
        }
    }

    public function rules(): array
    {
        return [
            'employee_id' => 'required',
            'position' => 'required',
        ];
    }


    public function chunkSize(): int
    {
        return 500;
    }
}
