<?php

namespace App\Imports;

use App\Attendance;
use App\Employee;
use App\leave;
use App\office_shift;
use App\RawAttendance;
use App\ReportAttendance;
use Carbon\Carbon;
use DateTime;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;

class NewAttendancesImport implements ToCollection, WithHeadingRow, ShouldQueue, WithChunkReading, WithBatchInserts, WithValidation
{
    /**
    * @param Collection $collection
    */
    public function collection(Collection $rows)
    {
		foreach ($rows as $row) 
        {
			if($row['jam_masuk'] != '') {
				list($attendance_date, $clock_in) = explode(' ', $row['jam_masuk']);
				$attendance_date = Carbon::createFromFormat('Y-m-d', $attendance_date)->format('Y-m-d');
				$clock_in = Carbon::createFromFormat('H:i:s', $clock_in)->format('H:i');
				list($attendance_date_out, $clock_out) = explode(' ', $row['jam_keluar']);
				$attendance_date_out = Carbon::createFromFormat('Y-m-d', $attendance_date_out)->format('Y-m-d');
				$clock_out = Carbon::createFromFormat('H:i:s', $clock_out)->format('H:i');
				$employee = Employee::with(['officeShift'])->where('staff_id', $row['id_karyawan'])->where('is_active', 1)->first();
				$minWorkTime = $employee->officeShift->min_work_hour;
				$inTime = Carbon::createFromTimeString($clock_in);
				$outTime = Carbon::createFromTimeString($clock_out);
				$status = null;
				$isUnderwork = false;
				
				$day = Carbon::parse($attendance_date)->format('l');
				switch ($day) {
					case 'Sunday':
						$clockInRange = $employee->officeShift::first()->sunday_range_in;
						$clockOutRange = $employee->officeShift::first()->sunday_range_out;
						$clockIn = $employee->officeShift::first()->sunday_in;
						$clockOut = $employee->officeShift::first()->sunday_out;
						break;
					case 'Monday':
						$clockInRange = $employee->officeShift::first()->monday_range_in;
						$clockOutRange = $employee->officeShift::first()->monday_range_out;
						$clockIn = $employee->officeShift::first()->monday_in;
						$clockOut = $employee->officeShift::first()->monday_out;
						break;
					case 'Tuesday':
						$clockInRange = $employee->officeShift::first()->tuesday_range_in;
						$clockOutRange = $employee->officeShift::first()->tuesday_range_out;
						$clockIn = $employee->officeShift::first()->tuesday_in;
						$clockOut = $employee->officeShift::first()->tuesday_out;
						break;
					case 'Wednesday':
						$clockInRange = $employee->officeShift::first()->wednesday_range_in;
						$clockOutRange = $employee->officeShift::first()->wednesday_range_out;
						$clockIn = $employee->officeShift::first()->wednesday_in;
						$clockOut = $employee->officeShift::first()->wednesday_out;
						break;
					case 'Thursday':
						$clockInRange = $employee->officeShift::first()->thursday_range_in;
						$clockOutRange = $employee->officeShift::first()->thursday_range_out;
						$clockIn = $employee->officeShift::first()->thursday_in;
						$clockOut = $employee->officeShift::first()->thursday_out;
						break;
					case 'Friday':
						$clockInRange = $employee->officeShift::first()->friday_range_in;
						$clockOutRange = $employee->officeShift::first()->friday_range_out;
						$clockIn = $employee->officeShift::first()->friday_in;
						$clockOut = $employee->officeShift::first()->friday_out;
						break;
					default:
						$clockInRange = $employee->officeShift::first()->saturday_range_in;
						$clockOutRange = $employee->officeShift::first()->saturday_range_out;
						$clockIn = $employee->officeShift::first()->saturday_in;
						$clockOut = $employee->officeShift::first()->saturday_out;
				}
				
				if ($attendance_date == $attendance_date_out) {
					$workTime = $outTime->diff($inTime)->format('%H:%I');
				} else {
					
				}
				
				if (Carbon::createFromTimeString($workTime)->hour < $minWorkTime) {
                    $isUnderwork = true;
                }
				
				$matchAttendance = [
					'employee_id' => $employee->id,
					'attendance_date' => $attendance_date,
				];
				
				Attendance::updateOrCreate($matchAttendance, [
					'employee_id' => $employee->id,
					'attendance_date' => $attendance_date,
					'clock_in' => $clock_in,
					'clock_out' => $clock_out,
					'total_work' => $workTime
				]);
				
				ReportAttendance::updateOrCreate($matchAttendance, [
					'employee_id' => $employee->id,
					'attendance_date' => $attendance_date,
					'work_time' => $workTime,
					'status' => $status,
					'is_underwork' => $isUnderwork
				]);
			} else {
			}
        }
    }
	
	public function rules(): array
    {
        return [
            'id_karyawan' => 'required',
            'jam_masuk' => 'required',
            'jam_keluar' => 'required',
        ];
    }

    public function chunkSize(): int
    {
        return 500;
    }

    public function batchSize(): int
    {
        return 500;
    }
}
