<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class JobPost extends Model
{
	protected $guarded=[];

	public function Company(){
		return $this->hasOne('App\company','id','company_id');
	}

	public function PostJobCategory(){
		return $this->hasOne('App\JobCategory','id','job_category_id');
	}



	public function getRouteKeyName()
	{
		return 'job_url'; // TODO: Change the autogenerated stub
	}

	public function setClosingDateAttribute($value)
	{
		$this->attributes['closing_date'] = Carbon::createFromFormat(env('Date_Format'), $value)->format('Y-m-d');
	}

	public function getClosingDateAttribute($value)
	{
		return Carbon::parse($value)->format(env('Date_Format'));
	}

	public function getCreatedAtAttribute($value)
	{
		return Carbon::parse($value)->format(env('Date_Format'));
	}

}
