<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SalaryBasic extends Model
{
  protected $fillable = ['employee_id', 'month_year', 'payslip_type', 'basic_salary', 'basic_salary_custom', 'tunjangan_jabatan'];
  protected $appends = ['basic_salary_formatted', 'basic_salary_custom_formatted', 'tunjangan_jabatan_formatted'];

  public function payslipMonthYear()
  {
    return $this->hasMany(Payslip::class, 'employee_id', 'employee_id');
  }

  public function getBasicSalaryFormattedAttribute()
  {
    return number_format($this->attributes['basic_salary'], 0, ',', '.');
  }
  
  public function getBasicSalaryCustomFormattedAttribute()
  {
    return number_format($this->attributes['basic_salary_custom'], 0, ',', '.');
  }
  
  public function getTunjanganJabatanFormattedAttribute()
  {
    return number_format($this->attributes['tunjangan_jabatan'], 0, ',', '.');
  }
}
