<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SalaryTunjanganKehadiran extends Model
{
    use HasFactory;
	  protected $fillable = ['employee_id', 'month_year', 'payslip_type', 'salary_kehadiran'];
	  protected $appends = ['salary_kehadiran_formatted'];

	  public function payslipMonthYear()
	  {
		return $this->hasMany(Payslip::class, 'employee_id', 'employee_id');
	  }

	  public function getSalaryKehadiranFormattedAttribute()
	  {
		return number_format($this->attributes['salary_kehadiran'], 0, ',', '.');
	  }
	  
}
