<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class leave extends Model
{
    protected $fillable = [
        'leave_type_id','company_id','department_id','employee_id','start_date','end_date',
        'leave_reason','remarks','status','is_half','is_notify','total_days'
    ];

    // leaves.company_id -> companies.id
    public function company(){
        return $this->belongsTo(\App\company::class, 'company_id', 'id');
    }

    // leaves.department_id -> departments.id
    public function department(){
        return $this->belongsTo(\App\department::class, 'department_id', 'id');
    }

    // leaves.leave_type_id -> leave_types.id
    public function LeaveType(){
        return $this->belongsTo(\App\LeaveType::class, 'leave_type_id', 'id');
    }

    // leaves.employee_id -> employees.id  (INI YANG DIPAKAI DI UI)
    public function employee(){
        return $this->belongsTo(\App\Employee::class, 'employee_id', 'id');
    }



    public function setStartDateAttribute($value)
    {
        $this->attributes['start_date'] = Carbon::createFromFormat(env('Date_Format'), $value)->format('Y-m-d');
    }

    public function getStartDateAttribute($value)
    {
        return Carbon::parse($value)->format(env('Date_Format'));
    }

    public function setEndDateAttribute($value)
    {
        $this->attributes['end_date'] = Carbon::createFromFormat(env('Date_Format'), $value)->format('Y-m-d');
    }

    public function getEndDateAttribute($value)
    {
        return Carbon::parse($value)->format(env('Date_Format'));
    }

    public function getCreatedAtAttribute($value)
    {
        return Carbon::parse($value)->format(env('Date_Format').'-- H:i');
    }
}
