<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RemoveSomeColumnsAttendances extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('attendances', function (Blueprint $table) {
            $table->dropColumn('clock_in_out');
            $table->dropColumn('time_late');
            $table->dropColumn('early_leaving');
            $table->dropColumn('overtime');
            $table->dropColumn('total_rest');
            $table->dropColumn('attendance_status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('attendances', function (Blueprint $table) {
            $table->tinyInteger('clock_in_out');
            $table->string('time_late');
            $table->string('early_leaving');
            $table->string('overtime');
            $table->string('total_rest');
            $table->string('attendance_status');
        });
    }
}
