<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnHeadDeptSupervisorCoo extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->integer('coo')->unsigned()->default(0)->after('following_employee_id');
            $table->integer('dept_head')->unsigned()->default(0)->after('coo');
            $table->integer('supervisor')->unsigned()->default(0)->after('dept_head');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employees');
    }
}
