@extends('layout.main')

@push('css')
<style>
    #page{
        padding-left: 30px;
        padding-right: 30px;
    }

    .side-navbar{
        background: rgb(173,187,175);
        background: linear-gradient(101deg, rgba(173,187,175,1) 10%, rgba(32,72,41,1) 70%);
    }
    
    .card-custom{
        /* margin-left: 20px; */
        color: white;
        width: 80%;
        border-radius: 20px !important;
        background: rgb(173,187,175);
        background: linear-gradient(101deg, rgba(173,187,175,1) 0%, rgba(32,72,41,1) 0%);
        margin: 0 auto;
    }

    .card-custom .btn{
        margin: 8px;
        border-radius: 20px;
    }

    .card-custom a{
        color: white;
    }

    .card-profile{
        color: white;
        background: rgb(185,64,45);
        background: linear-gradient(101deg, rgba(185,64,45,1) 10%, rgba(129,119,77,1) 98%);
        border-radius: 40px !important;
    }

    .card-profile span{
        color: white !important;
    }

    .card-profile p{
        color: white !important;
    }

    .card-profile .text-muted{
        color: white !important;
    }
    
    .notification-badge {
        background-color: red;   /* Red background for the notification */
        color: white;            /* White color for the text */
        border-radius: 50%;
        padding: 2px 5px;
        font-size: 12px;
        position: absolute;
        top: -5px;
        right: 5%;
        display: inline-block;   /* Ensure the badge is inline with the count number */
    }
    
    .fixed-size-img {
        width: 120px;
        height: 120px;
        object-fit: cover; /* Ensures the image is cropped properly without distortion */
    }
    
    @media(max-width: 1300px)
    {
        .text-board {
            padding-left: 40px !important;
        }
    }
</style>
@endpush

@section('content')

    <section>

        @include('shared.errors')



        <!-- Content -->
        <div class="container-fluid">
            <div class="row">

                <div class="col-12 col-md-6 mb-3">
                    <div class="card card-profile">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12 col-md-3 mb-3">
                                    <img src={{ URL::to('/uploads/profile_photos') }}/{{ $user->profile_photo ?? 'avatar.jpg' }}
                                        class='rounded-circle fixed-size-img'>
                                </div>

                                <div class="col-12 col-md-9 mb-3 text-board">
                                    <h4 class="font-weight-bold">{{ $employee->full_name }} <span class="text-muted font-weight-normal">
                                        ({{ $user->username }})</span>
                                    </h4>
                                    <div class="text-muted mb-2">{{ $employee->designation->designation_name ?? '' }},
                                        {{ $employee->department->department_name ?? '' }}</div>
                                    <p class="text-muted">{{ __('Last Login') }}: {{ date('d-m-Y H:i:s', strtotime(str_replace('--', ' ', $user->last_login_date))) }}</p>
                                    <p class="text-muted">{{ __('My Office Shift') }}:
                                        @if (!$shift_in)
                                            {{ __('No Shift Today') }}
                                        @else
                                            {{ \Carbon\Carbon::parse($shift_in)->format('H:i') }} - {{ \Carbon\Carbon::parse($shift_out)->format('H:i') }}
                                        @endif
                                        ({{ $shift_name }})
                                    </p>
                                    <a class="btn btn-default btn-sm" id="my_profile" href="{{ route('profile') }}">
                                        <i class="dripicons-user"></i> {{ trans('file.Profile') }}
                                    </a>
                                    @if (env('ENABLE_CLOCKIN_CLOCKOUT') != null)
                                        <form class="d-inline m1-2" action="{{ route('employee_attendance.post', $employee->id) }}"
                                            name="set_clocking" id="set_clocking" autocomplete="off" class="form" method="post"
                                            accept-charset="utf-8">
                                            @csrf

                                            <input type="hidden" value="{{ $shift_in }}" name="office_shift_in" id="shift_in">
                                            <input type="hidden" value="{{ $shift_out }}" name="office_shift_out" id="shift_out">
                                            <input type="hidden" value="" name="in_out_value" id="in_out">

                                            @if (!$employee_attendance || $employee_attendance->clock_in_out == 0)
                                                <button class="btn btn-success btn-sm" @if ($employee->attendance_type == 'ip_based' && $ipCheck != true) disabled @endif
                                                    type="submit" id="clock_in_btn"><i class="dripicons-enter"></i>
                                                    {{ __('Clock IN') }}</button>
                                            @else
                                                <button class="btn btn-danger btn-sm" @if ($employee->attendance_type == 'ip_based' && $ipCheck != true) disabled @endif
                                                    type="submit" id="clock_out_btn"><i class="dripicons-exit"></i>
                                                    {{ __('Clock OUT') }}</button>
                                            @endif
                                            {{-- <br> --}}
                                            @if ($employee->attendance_type == 'ip_based' && $ipCheck != true)
                                                <small class="text-danger"><i>[Please login with your office's internet to clock in or clock
                                                        out]</i></small>
                                            @endif
                                        </form>
                                    @endif
                                </div>
                            </div>

                        </div>   
                    </div>
                    
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">

                <div class="col-md-3 mt-4">
                    <div class="d-flex wrapper count-title">
                        <div class="icon blue-text ml-2 mr-3">
                            <!--<i class="dripicons-wallet display-5"></i>-->
                            <img src="{{ URL::to('/images') }}/Wallet.png" width='50'>
                        </div>
                        <a href="{{ route('profile') . '#Employee_Payslip' }}">
                            <div class="name">
                                <h5>{{ __('Payslip') }}</h5>
                            </div>
                            <p>{{ __('View Details') }}</p>
                        </a>
                    </div>
                </div>

                <div class="col-md-3 mt-4">
                    <div class="d-flex wrapper count-title">
                        <div class="icon purple-text ml-2 mr-3">
                            <!--<i class="dripicons-trophy"></i>-->
                            <img src="{{ URL::to('/images') }}/Trophy.png" width='50'>
                        </div>
                        <a href="{{ route('profile') . '#Employee_Core_hr' }}">
                            <div class="name">
                                <h5>
                                    <span class="notification-badge">{{ $employee_award_count }}</span>
                                    <!--{{ $employee_award_count }} -->
                                    {{ __('Award') }}</h5>
                            </div>
                            <p>{{ __('View Details') }}</p>
                        </a>
                    </div>
                </div>


                <div class="col-md-3 mt-4">
                    <div class="d-flex wrapper count-title">
                        <div class="icon orange-text ml-2 mr-3">
                            <!--<i class="dripicons-feed"></i>-->
                            <img src="{{ URL::to('/images') }}/Umbrella.png" width='50'>
                        </div>
                        <a href="{{ url('announcements/index') }}">
                            <div class="text-center">
                                <h5>
                                    <span class="notification-badge">{{ count($announcements) }}</span>
                                    <!--{{ count($announcements) }} -->
                                    {{ trans('file.Announcement') }}
                                </h5>
                                  
                            </div>
                            <p>{{ __('View Details') }}</p>
                        </a>
                    </div>
                </div>

                <div class="col-md-3 mt-4">
                    <div class="d-flex wrapper count-title">
                        <div class="icon green-text ml-2 mr-3">
                            <!--<i class="dripicons-gaming"></i>-->
                            <img src="{{ URL::to('/images') }}/Toa.png" width='50'>
                        </div>
                        <div id="holiday" class="" style="cursor: pointer;">
                            <h5>
                                <span class="notification-badge">{{ count($holidays) }}</span>
                                <!--{{ count($holidays) }} -->
                                <!--{{ __('Upcoming Holidays') }}-->
                                Holidays
                            </h5>
                            <p>{{ __('View Details') }}</p>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <div class="row">
            <div class="col-12 col-md-6 mt-4">
                <div class="card card-custom">
                    <div class="card-body">
                        <h3 class="text-center">Leave</h3>
                    </div>
                    <div class="d-flex d-flex flex-column flex-md-row justify-content-between">
                        <a class="btn btn-link btn-block" href="{{ route('profile') . '#Leave' }}">
                            {{ __(' View Leave Info') }}
                        </a>
                        <button class="btn btn-light btn-block mt-0" id="leave_request">{{ __('Request Leave') }}</button>
                    </div>
                </div>
            </div>


            <div class="col-12 col-md-6 mt-4">
                <div class="card card-custom">
                    <div class="card-body">
                        <h3 class="text-center">Travel</h3>
                    </div>
                    <div class="d-flex d-flex flex-column flex-md-row justify-content-between">
                        <a class="btn btn-link btn-block" href="{{ route('profile') . '#Employee_travel' }}">
                            {{ __('View Travel Info') }}
                        </a>
                        <button class="btn btn-light btn-block mt-0"
                            id="travel_request">{{ __('Request Travel') }}</button>
                    </div>
                </div>
            </div>


            <!-- <div class="col-md-6 mt-4">
                <div class="card">
                    <div class="card-body">
                        <h3 class="text-center">{{ __('Ticket') }}</h3>
                    </div>
                    <div class="d-flex justify-content-between">
                        <a class="btn btn-link btn-block" href="{{ route('profile') . '#Employee_ticket' }}">
                            {{ __('Ticket Info') }}
                        </a>
                        <button class="btn btn-light btn-block mt-0" id="ticket_request">{{ __('Open A Ticket') }}</button>
                    </div>
                </div>
            </div> -->
        </div>
        
        <div class="row">
            <div class="col-12 col-md-12 mt-4">
                <div class="card card-custom">
                    <div class="card-body">
                        <h3 class="text-center">{{ __('Reimbursement') }}</h3>
                    </div>
                    <div class="d-flex d-flex flex-column flex-md-row justify-content-between">
                        <a class="btn btn-link btn-block" href="{{ route('profile') . '#Employee_reimbursement' }}">
                            {{ __('View Reimbursement Info') }}
                        </a>
                        <button class="btn btn-light btn-block mt-0"
                            id="reimbursement_request">{{ __('Request Reimbursement') }}</button>
                    </div>
                </div>
            </div>

        </div>
        </div>


        <!-- <div class="container-fluid">
            <div class="row">

                <div class="col-md-4 mt-4">
                    <div class="card">
                        <div class="card-header">
                            <h4>{{ __('Assigned Projects') }} ({{ $assigned_projects_count }})</h4>
                        </div>
                        <div class="card-body list pt-0">
                            <table class="table">
                                <tbody>
                                    @foreach ($assigned_projects as $project)
                                        @if (count($project->assignedProjects) != 0)
                                            <tr>
                                                <td>
                                                    <a
                                                        href="{{ route('projects.show', $project->assignedProjects[0]->id) }}">
                                                        <h5>{{ $project->assignedProjects[0]->title }}</h5>
                                                    </a>
                                                </td>
                                            </tr>
                                        @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="col-md-4 mt-4">
                    <div class="card">
                        <div class="card-header">
                            <h4>{{ __('Assigned Tasks') }} ({{ $assigned_tasks_count }})</h4>
                        </div>
                        <div class="card-body list pt-0">
                            <table class="table">
                                <tbody>
                                    @foreach ($assigned_tasks as $task)
                                        @if (count($task->assignedTasks) != 0)
                                            <tr>
                                                <td>
                                                    <a href="{{ route('tasks.show', $task->assignedTasks[0]->id) }}">
                                                        <h5>{{ $task->assignedTasks[0]->task_name }}</h5>
                                                    </a>
                                                </td>
                                            </tr>
                                        @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="col-md-4 mt-4">
                    <div class="card">
                        <div class="card-header">
                            <h4>{{ __('Assigned Tickets') }} ({{ $assigned_tickets_count }})</h4>
                        </div>
                        <div class="card-body list pt-0">
                            <table class="table">
                                <tbody>
                                    @foreach ($assigned_tickets as $ticket)
                                        @if (count($ticket->assignedTickets) != 0)
                                            <tr>
                                                <td>
                                                    <a
                                                        href="{{ route('tickets.show', $ticket->assignedTickets[0]->ticket_code) }}">
                                                        <h5>{{ $ticket->assignedTickets[0]->subject }}</h5>
                                                    </a>
                                                </td>
                                            </tr>
                                        @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div> -->

        <div id="holidayModal" class="modal fade" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">

                    <div class="modal-header">
                        <h5 id="exampleModalLabel" class="modal-title">{{ __('Holidays') }}</h5>
                        <button type="button" data-dismiss="modal" id="close" aria-label="Close"
                            class="close"><span aria-hidden="true">×</span></button>
                    </div>

                    <div class="modal-body">
                        @foreach ($holidays as $holiday)
                            <div><strong
                                    class="name blue-text">{{ $holiday->event_name }}</strong> - {{ trans('file.From') }}
                                : {{ date("d-m-Y", strtotime($holiday->start_date)) }} {{ trans('file.To') }}: {{ date("d-m-Y", strtotime($holiday->end_date)) }}</div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        <div id="leaveModal" class="modal fade" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">

                    <div class="modal-header">
                        <h5 id="exampleModalLabel" class="modal-title">{{ __('Leave Request') }}</h5>
                        <button type="button" data-dismiss="modal" id="close" aria-label="Close"
                            class="close"><span aria-hidden="true">×</span></button>
                    </div>

                    <div class="modal-body">
                        <span id="leave_form_result"></span>
                        <form method="post" id="leave_sample_form" class="form-horizontal">

                            @csrf
                            <div class="row">

                                <div class="col-md-6 form-group">
                                    <label>{{ __('Your Remaining Leaves') }} (Year - {{ date('Y') }})</label><br>
                                    <div class="row">
                                        <input class="col-sm-6 ml-2" type="number" readonly name="remaining_leave"
                                            id="remaining_leave" autocomplete="off" class="form-control"
                                            value="{{ $employee->remaining_leave }}">
                                        <span class="ml-2">{{ __('Days') }}</span>
                                    </div>
                                    <small class="text-danger col-sm-4"><i>(Read Only)</i></small>
                                </div>

                                <div class="col-md-6 form-group">
                                    <label>{{ __('Leave Type') }}</label>
                                    <select name="leave_type" id="leave_type" class="form-control selectpicker "
                                        data-live-search="true" data-live-search-style="contains"
                                        title='{{ __('Selecting', ['key' => __('Leave Type')]) }}...'>
                                        @foreach ($leave_types as $leave_type)
                                            <option value="{{ $leave_type->id }}">{{ $leave_type->leave_type }}
                                                @if(!empty($leave_type->allocated_day) && $leave_type->allocated_day > 0)
                                                ({{ $leave_type->allocated_day }})
                                                @endif
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <div class="col-md-6 form-group">
                                    <label>Your Leave Debt (Year - {{ date('Y') }})</label><br>
                                    <div class="row">
                                        <input class="col-sm-6 ml-2" type="number" readonly name="leave_debt"
                                            id="leave_debt" autocomplete="off" class="form-control"
                                            value="{{ $employee->leave_debt }}">
                                        <span class="ml-2">{{ __('Days') }}</span>
                                    </div>
                                    <small class="text-danger col-sm-4"><i>(Read Only)</i></small>
                                </div>

                                <div class="col-md-6 form-group">
                                    <label>{{ __('Start Date') }}</label>
                                    <input type="text" name="start_date" id="leave_start_date"
                                        class="form-control date" value="" required>
                                </div>

                                <div class="col-md-6 form-group">
                                    <label>{{ __('End Date') }}</label>
                                    <input type="text" name="end_date" id="leave_end_date" class="form-control date"
                                        value="" required>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="leave_reason">{{ trans('file.Description') }}</label>
                                        <textarea class="form-control" id="leave_reason" name="leave_reason" rows="3"></textarea>
                                    </div>
                                </div>


                                <div class="col-md-6 form-group">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" name="is_half"
                                            id="leave_is_half" value="1">
                                        <label for="leave_is_half"
                                            class="custom-control-label">{{ __('Half Day') }}</label>

                                    </div>
                                </div>


                                <div class="container">
                                    <div class="form-group" align="center">
                                        <input type="hidden" name="company_id" value="{{ $employee->company_id }}" />
                                        <input type="hidden" name="department_id"
                                            value="{{ $employee->department_id }}" />
                                        <input type="hidden" name="employee_id" value="{{ $employee->id }}" />
                                        <input type="hidden" name="status" value="pending" />

                                        <input type="hidden" name="diff_date_hidden" id="diff_date_hidden" />
                                        <input type="submit" name="action_button" class="btn btn-warning"
                                            value={{ trans('file.Add') }} />
                                    </div>
                                </div>
                            </div>

                        </form>

                    </div>
                </div>
            </div>
        </div>

        <div id="travelModal" class="modal fade" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">

                    <div class="modal-header">
                        <h5 id="exampleModalLabel" class="modal-title">{{ __('Travel Request') }}</h5>
                        <button type="button" data-dismiss="modal" aria-label="Close" class="close"><span
                                aria-hidden="true">×</span></button>
                    </div>

                    <div class="modal-body">
                        <span id="travel_form_result"></span>
                        <form method="post" id="travel_sample_form" class="form-horizontal">

                            @csrf
                            <div class="row">


                                <div class="col-md-6 form-group">
                                    <label>{{ __('Arrangement Type') }}</label>
                                    <select name="travel_type_id" class="form-control selectpicker "
                                        data-live-search="true" data-live-search-style="contains"
                                        title='{{ __('Selecting', ['key' => trans('file.Arrangement')]) }}...'>
                                        @foreach ($travel_types as $travel_type)
                                            <option value="{{ $travel_type->id }}">{{ $travel_type->arrangement_type }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>


                                <div class="col-md-6 form-group">
                                    <label>{{ __('Purpose Of Visit') }} *</label>
                                    <input type="text" name="purpose_of_visit" class="form-control"
                                        placeholder="{{ __('Purpose Of Visit') }}">
                                </div>

                                <div class="col-md-6 form-group">
                                    <label>{{ __('Place Of Visit') }} *</label>
                                    <input type="text" name="place_of_visit" class="form-control"
                                        placeholder="{{ __('Place Of Visit') }}">
                                </div>


                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{ trans('file.Description') }}</label>
                                        <textarea class="form-control" name="description" rows="3"></textarea>
                                    </div>
                                </div>

                                <div class="col-md-6 form-group">
                                    <label>{{ __('Start Date') }} *</label>
                                    <input type="text" name="start_date" class="form-control date" autocomplete="off"
                                        value="">
                                </div>

                                <div class="col-md-6 form-group">
                                    <label>{{ __('End Date') }} *</label>
                                    <input type="text" name="end_date" class="form-control date" autocomplete="off"
                                        value="">
                                </div>

                                <div class="col-md-6 form-group">
                                    <label>{{ __('Expected Budget') }}</label>
                                    <input type="text" name="expected_budget" class="form-control">
                                </div>


                                <div class="col-md-6 form-group">
                                    <label>{{ __('Travel Mode') }}</label>
                                    <select name="travel_mode" class="form-control selectpicker " data-live-search="true"
                                        data-live-search-style="contains" title='{{ __('Travel Mode') }}'>
                                        <option value="By Bus">{{ __('By Bus') }}</option>
                                        >
                                        <option value="By Train">{{ __('By Train') }}</option>
                                        <option value="By Plane">{{ __('By Plane') }}</option>
                                        <option value="By Taxi">{{ __('By Taxi') }}</option>
                                        <option value="By Rental Car">{{ __('By Rental Car') }}</option>
                                        <option value="By Other">{{ __('By Other') }}</option>
                                    </select>
                                </div>


                                <div class="container">
                                    <div class="form-group" align="center">

                                        <input type="hidden" name="company_id" value="{{ $employee->company_id }}" />
                                        <input type="hidden" name="department_id"
                                            value="{{ $employee->department_id }}" />
                                        <input type="hidden" name="employee_id" value="{{ $employee->id }}" />
                                        <input type="hidden" name="status" value="pending" />

                                        <input type="submit" name="action_button" class="btn btn-warning"
                                            value={{ trans('file.Add') }} />
                                    </div>
                                </div>
                            </div>

                        </form>

                    </div>
                </div>
            </div>
        </div>

        <div id="ticketModal" class="modal fade" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">

                    <div class="modal-header">
                        <h5 id="exampleModalLabel" class="modal-title">{{ __('Open Ticket') }}</h5>
                        <button type="button" data-dismiss="modal" id="close" aria-label="Close"
                            class="close"><span aria-hidden="true">×</span></button>
                    </div>

                    <div class="modal-body">
                        <span id="ticket_form_result"></span>
                        <form method="post" id="ticket_sample_form" class="form-horizontal"
                            enctype="multipart/form-data">

                            @csrf

                            <div class="row">


                                <div class="col-md-6 form-group">
                                    <label>{{ trans('file.Priority') }}</label>
                                    <select name="ticket_priority" id="ticket_priority"
                                        class="form-control selectpicker " data-live-search="true"
                                        data-live-search-style="contains"
                                        title='{{ __('Selecting', ['key' => trans('file.Priority')]) }}...'>
                                        <option value="low">{{ trans('file.Low') }}</option>
                                        <option value="medium">{{ trans('file.Medium') }}</option>
                                        <option value="high">{{ trans('file.High') }}</option>
                                        <option value="critical">Critical</option>
                                    </select>
                                </div>

                                <div class="col-md-6 form-group">
                                    <label>{{ trans('file.Subject') }} *</label>
                                    <input type="text" name="subject" id="subject" class="form-control"
                                        placeholder="{{ trans('file.Subject') }}">
                                </div>

                                <div class="col-md-6 form-group">
                                    <label>{{ __('Ticket Note') }}</label>
                                    <input type="text" name="ticket_note" id="ticket_note" class="form-control"
                                        placeholder="{{ trans('file.Optional') }}">
                                </div>

                                <div class="col-md-6 form-group hide_edit">
                                    <label>{{ __('Ticket Attachments') }} </label>
                                    <input type="file" name="ticket_attachments" id="ticket_attachments"
                                        class="form-control">
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{ trans('file.Description') }}</label>
                                        <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                                    </div>
                                </div>


                                <div class="container">
                                    <div class="form-group" align="center">
                                        <input type="hidden" name="company_id" value="{{ $employee->company_id }}" />
                                        <input type="hidden" name="department_id"
                                            value="{{ $employee->department_id }}" />
                                        <input type="hidden" name="employee_id" value="{{ $employee->id }}" />
                                        <input type="hidden" name="ticket_status" value="pending" />

                                        <input type="submit" name="action_button" class="btn btn-warning"
                                            value={{ trans('file.Add') }} />

                                    </div>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>

        <div id="reimbursementModal" class="modal fade" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">

                    <div class="modal-header">
                        <h5 id="exampleModalLabel" class="modal-title">{{ __('Request Reimbursement') }}</h5>
                        <button type="button" data-dismiss="modal" id="close" aria-label="Close"
                            class="close"><span aria-hidden="true">×</span></button>
                    </div>

                    <div class="modal-body">
                        <span id="reimbursement_form_result"></span>
                        <form method="post" id="reimbursement_sample_form" class="form-horizontal"
                            enctype="multipart/form-data">

                            @csrf

                            <div class="row">

                                <div class="col-md-6 form-group">
                                    <label>{{ __('Reimbursement Type') }}</label>
                                    <select name="reimbursement_type_id" id="reimbursement_type_id"
                                        class="form-control selectpicker " data-live-search="true"
                                        data-live-search-style="contains"
                                        title='{{ __('Selecting', ['key' => __('Reimbursement Type')]) }}...'>
                                        @foreach ($reimbursement_types as $reimbursement_type)
                                            <option value="{{ $reimbursement_type->id }}">
                                                {{ $reimbursement_type->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>


                                <div class="col-md-6 form-group">
                                    <label>{{ __('Amount') }}</label>
                                    <input type="number" name="amount" id="amount" class="form-control"
                                        placeholder="{{ __('Amount') }}">
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{ trans('file.Description') }}</label>
                                        <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                                    </div>
                                </div>

                                <div class="col-md-6 form-group hide_edit">
                                    <label>{{ __('Reimbursement Attachments') }} </label>
                                    <input type="file" name="reimbursement_attachments" id="reimbursement_attachments"
                                        class="form-control">
                                </div>

                                <div class="container">
                                    <div class="form-group" align="center">
                                        <input type="hidden" name="company_id" value="{{ $employee->company_id }}" />
                                        <input type="hidden" name="department_id"
                                            value="{{ $employee->department_id }}" />
                                        <input type="hidden" name="employee_id" value="{{ $employee->id }}" />
                                        <input type="hidden" name="ticket_status" value="pending" />

                                        <input type="submit" name="action_button" class="btn btn-warning"
                                            value={{ trans('file.Add') }} />

                                    </div>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>


        <script>
            (function($) {
                "use strict";

                let date = $('.date');
                date.datepicker({
                    format: '{{ env('Date_Format_JS') }}',
                    autoclose: true,
                    todayHighlight: true
                });

                $('#holiday').on('click', function() {
                    $('#holidayModal').modal('show');
                });

                $('#leave_request').on('click', function() {
                    $('#leaveModal').modal('show');
                });

                $('#travel_request').on('click', function() {
                    $('#travelModal').modal('show');
                });

                $('#ticket_request').on('click', function() {
                    $('#ticketModal').modal('show');
                });

                $('#reimbursement_request').on('click', function() {
                    $('#reimbursementModal').modal('show');
                });

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                });

                $('#leave_sample_form').on('submit', function(event) {
                    event.preventDefault();

                    let start_date = $("#leave_start_date").datepicker('getDate');
                    let end_date = $("#leave_end_date").datepicker('getDate');
                    let remaining_leave = $("#remaining_leave").val();

                        $.ajax({
                            url: "{{ route('req_leave.store') }}",
                            method: "POST",
                            data: new FormData(this),
                            contentType: false,
                            cache: false,
                            processData: false,
                            dataType: "json",
                            success: function(data) {
                                console.log(data);
                                let html = '';
                                if (data.errors) {
                                    html = '<div class="alert alert-danger">';
                                    for (var count = 0; count < data.errors.length; count++) {
                                        html += '<p>' + data.errors[count] + '</p>';
                                    }
                                    html += '</div>';
                                }
                                if (data.limit) {
                                    html = '<div class="alert alert-danger">' + data.limit + '</div>';
                                }
                                
                                if (data.success) {
                                    html = '<div class="alert alert-success">' + data.success +
                                        '</div>';
                                    $('#leave_sample_form')[0].reset();
                                    $('select').selectpicker('refresh');
                                    $('.date').datepicker('update');
                                }
                                $('#leave_form_result').html(html).slideDown(300).delay(5000).slideUp(
                                    300);
                            }
                        });


                });

                $('#travel_sample_form').on('submit', function(event) {
                    event.preventDefault();

                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                    });


                    $.ajax({
                        url: "{{ route('req_travels.store') }}",
                        method: "POST",
                        data: new FormData(this),
                        contentType: false,
                        cache: false,
                        processData: false,
                        dataType: "json",
                        success: function(data) {
                            let html = '';
                            if (data.errors) {
                                html = '<div class="alert alert-danger">';
                                for (var count = 0; count < data.errors.length; count++) {
                                    html += '<p>' + data.errors[count] + '</p>';
                                }
                                html += '</div>';
                            }
                            if (data.error) {
                                html = '<div class="alert alert-danger">' + data.error + '</div>';
                            }
                            if (data.success) {
                                html = '<div class="alert alert-success">' + data.success + '</div>';
                                $('#travel_sample_form')[0].reset();
                                $('select').selectpicker('refresh');
                                $('.date').datepicker('update');
                            }
                            $('#travel_form_result').html(html).slideDown(300).delay(5000).slideUp(300);
                        }
                    })
                });


                $('#ticket_sample_form').on('submit', function(event) {
                    event.preventDefault();

                    $.ajax({
                        url: "{{ route('tickets.store') }}",
                        method: "POST",
                        data: new FormData(this),
                        contentType: false,
                        cache: false,
                        processData: false,
                        dataType: "json",
                        success: function(data) {
                            let html = '';
                            if (data.errors) {
                                html = '<div class="alert alert-danger">';
                                for (var count = 0; count < data.errors.length; count++) {
                                    html += '<p>' + data.errors[count] + '</p>';
                                }
                                html += '</div>';
                            }
                            if (data.success) {
                                html = '<div class="alert alert-success">' + data.success + '</div>';
                                $('#ticket_sample_form')[0].reset();
                                $('select').selectpicker('refresh');
                            }
                            $('#ticket_form_result').html(html).slideDown(300).delay(5000).slideUp(300);
                        }
                    })
                });

                
                $('#reimbursement_sample_form').on('submit', function(event) {
                    event.preventDefault();

                    $.ajax({
                        url: "{{ route('reimburse.store') }}",
                        method: "POST",
                        data: new FormData(this),
                        contentType: false,
                        cache: false,
                        processData: false,
                        dataType: "json",
                        success: function(data) {
                            let html = '';
                            if (data.errors) {
                                html = '<div class="alert alert-danger">';
                                for (var count = 0; count < data.errors.length; count++) {
                                    html += '<p>' + data.errors[count] + '</p>';
                                }
                                html += '</div>';
                            }
                            if (data.success) {
                                html = '<div class="alert alert-success">' + data.success + '</div>';
                                $('#reimbursement_sample_form')[0].reset();
                                $('select').selectpicker('refresh');
                            }
                            $('#reimbursement_form_result').html(html).slideDown(300).delay(5000).slideUp(300);
                        }
                    })
                });

            })(jQuery);
        </script>
    </section>
@endsection
