@extends('layout.main')
@section('content')
    <section>

        <div class="card animated fadeInRight mr-5 ml-5">
            <div class="card-header  with-border">
                <h3 class="card-title">{{ __('Import EXCEL/CSV file only') }}</h3>
                @include('shared.flash_message')
                <div id="form_result"></div>
            </div>
            <div class="card-body">
                <h6><a href="{{ route('employees.exportPosition') }}" class="btn btn-success"> <i
                            class="fa fa-download"></i> {{ __('Export Employee') }} </a></h6>
                <p class="card-text">The first line in downloaded sample file should remain as it is. Please do not change
                    the order of columns in file.</p>
                <form action="{{ route('employees.importPositionPost') }}" name="import_employee" id="import_employee"
                    autocomplete="off" enctype="multipart/form-data" method="post" accept-charset="utf-8">
                    @csrf
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <fieldset class="form-group">
                                    <label for="logo">{{ trans('file.Upload') }} {{ trans('file.File') }}</label>
                                    <input type="file" class="form-control-file" id="file" name="file"
                                        accept=".xlsx, .xls, .csv">
                                    <small>{{ __('Please select excel/csv') }} file (allowed file size 2MB)</small>
                                </fieldset>
                            </div>
                        </div>
                    </div>
                    <div class="mt-1">
                        <div class="form-actions box-footer">
                            <button name="import_form" type="submit" class="btn btn-primary"><i
                                    class="fa fa fa-check-square-o"></i> {{ trans('file.Save') }}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>


    </section>
@endsection
