@extends('layout.main')
@section('content')
@php
	$employees = App\Employee::all();
	$staffNumbers = null;
	foreach ($employees as $employee) {
		if (preg_match('/^([A-Za-z]+)(\d+)$/', $employee->staff_id, $matches)) {
			$prefix = $matches[1];
			$number = (int)$matches[2];

			if ($staffNumbers === null || $number > $staffNumbers) {
				$staffNumbers = $number;
			}
		}
	}
	$staffNumbers = $staffNumbers+1;
@endphp
    <section>

        <div class="container-fluid"><span id="general_result"></span></div>


        <div class="container-fluid mb-3">
            @can('store-details-employee')
                <button type="button" class="btn btn-info" name="create_record" id="create_record"><i class="fa fa-plus"></i>
                    {{ __('Add Employee') }}</button>
            @endcan
            @can('modify-details-employee')
                <button type="button" class="btn btn-danger" name="bulk_delete" id="bulk_delete"><i
                        class="fa fa-minus-circle"></i> {{ __('Bulk delete') }}</button>
            @endcan
            <button class="btn btn-primary" type="button" data-toggle="collapse" data-target="#collapseExample"
                aria-expanded="false" aria-controls="collapseExample">
                <i class="fa fa-filter" aria-hidden="true"></i> Filter
            </button>
            <a href="{{ route('employees.exportLeaves') }}">
                <button id="btn-export-leaves" class="btn btn-success" type="button">
                    <i class="fa fa-download" aria-hidden="true"></i> Export Employee Leaves
                </button>
            </a>
        </div>
        <div class="col-12">
            <!-- Filtering -->
            <div class="collapse" id="collapseExample">
                <div class="card card-body">
                    <form action="" method="GET" id="filter_form">
                        <div class="row">
                            <!-- Company -->
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="text-bold"><strong>{{ trans('file.Company') }}</strong></label>
                                    <select name="company_id" id="company_id_filter"
                                        class="form-control selectpicker dynamic" data-live-search="true"
                                        data-live-search-style="contains" data-shift_name="shift_name"
                                        data-dependent="department_name"
                                        title="{{ __('Selecting', ['key' => trans('file.Company')]) }}...">
                                        <option value=""></option>
                                        @foreach ($companies as $company)
                                            <option value="{{ $company->id }}">{{ $company->company_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <!--/ Company-->

                            <!-- Department-->
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="text-bold"><b>{{ trans('file.Department') }}</b></label>
                                    <select name="department_id" id="department_id_filter"
                                        class="selectpicker form-control designationFilter" data-live-search="true"
                                        data-live-search-style="contains" data-designation_name="designation_name"
                                        title="{{ __('Selecting', ['key' => trans('file.Department')]) }}...">
                                    </select>
                                </div>
                            </div>
                            <!--/ Department-->

                            <!-- Designation -->
                            <div class="col-md-3 form-group">
                                <label class="text-bold"><b>{{ trans('file.Position') }}</b></label>
                                <select name="designation_id" id="designation_id_filter" class="selectpicker form-control"
                                    data-live-search="true" data-live-search-style="contains"
                                    title="{{ __('Selecting', ['key' => trans('file.Position')]) }}...">
                                </select>
                            </div>
                            <!--/ Designation -->

                            <!-- Office Shift -->
                            <div class="col-md-2 form-group">
                                <label class="text-bold"><b>{{ __('Office Shift') }}</b></label>
                                <select name="office_shift_id" id="office_shift_id_filter" class="selectpicker form-control"
                                    data-live-search="true" data-live-search-style="contains"
                                    title="{{ __('Selecting Office Shift') }}...">
                                </select>
                            </div>
                            <!--/ Office Shift -->

                            <div class="col-md-1">
                                <label class="text-bold"></label><br>
                                <button type="button" class="btn btn-dark" id="filterSubmit">
                                    <i class="fa fa-arrow-right" aria-hidden="true"></i> &nbsp; GET
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!--/ Filtering -->
        </div>


        <div class="table-responsive">
            <table id="employee-table" class="table ">
                <thead>
                    <tr>
                        <th class="not-exported"></th>
                        <th>{{ trans('file.Employee') }}</th>
                        <th>{{ trans('file.Company') }}</th>
                        <th>{{ __('End Of Contract') }}</th>
                        <th>{{ trans('file.Status') }}</th>
                        <th class="not-exported">{{ trans('file.action') }}</th>
                    </tr>
                </thead>

            </table>
        </div>
    </section>



    <div id="formModal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 id="exampleModalLabel" class="modal-title">{{ __('Add Employee') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <span id="form_result"></span>
                    <form method="post" id="sample_form" class="form-horizontal" enctype="multipart/form-data">

                        @csrf
						<div class="row" id="company_selection">
							<div class="col-md-6">
                                <div class="form-group">
                                    <label class="text-bold">{{ trans('file.Company') }} <span
                                            class="text-danger">*</span></label>
                                    <select name="company_id" id="company_id" required
                                        class="form-control selectpicker dynamic" data-live-search="true"
                                        data-live-search-style="contains" data-shift_name="shift_name"
                                        data-dependent="department_name"
                                        title="{{ __('Selecting', ['key' => trans('file.Company')]) }}...">
                                        @foreach ($companies as $company)
                                            <option value="{{ $company->id }}">{{ $company->company_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="text-bold">{{ trans('file.Department') }} <span
                                            class="text-danger">*</span></label>
                                    <select name="department_id" id="department_id" required
                                        class="selectpicker form-control designation" data-live-search="true"
                                        data-live-search-style="contains" data-designation_name="designation_name"
                                        title="{{ __('Selecting', ['key' => trans('file.Department')]) }}...">
                                    </select>
                                </div>
                            </div>


                            <div class="col-md-6 form-group">
                                <label class="text-bold">{{ trans('file.Position') }} <span
                                        class="text-danger">*</span></label>
                                <select name="designation_id" id="designation_id" required
                                    class="selectpicker form-control" data-live-search="true"
                                    data-live-search-style="contains"
                                    title="{{ __('Selecting', ['key' => trans('file.Position')]) }}...">
                                </select>
                            </div>

                            <div class="col-md-6 form-group">
                                <label class="text-bold">{{ trans('file.Office_Shift') }} <span
                                        class="text-danger">*</span></label>
                                <select name="office_shift_id" id="office_shift_id" required
                                    class="selectpicker form-control" data-live-search="true"
                                    data-live-search-style="contains"
                                    title="{{ __('Selecting', ['key' => trans('file.Office_Shift')]) }}...">
                                </select>
                            </div>
							<div class="container">
                                <div class="form-group" align="center">
									<button onclick="next_step()" class="btn btn-primary">{{ __('Next') }}</button>
								</div>
							</div>
						</div>
						
                        <div class="row d-none" id="biodata">
                            <div class="col-md-6 form-group">
                                <label class="text-bold">{{ __('First Name') }} <span
                                        class="text-danger">*</span></label>
                                <input type="text" name="first_name" id="first_name"
                                    placeholder="{{ __('First Name') }}" required class="form-control">
                            </div>
                            <div class="col-md-6 form-group">
                                <label class="text-bold">{{ __('Last Name') }} 
                                    <!-- <span class="text-danger">*</span> -->
                                </label>
                                <input type="text" name="last_name" id="last_name"
                                    placeholder="{{ __('Last Name') }}" class="form-control">
                            </div>
                            <div class="col-md-6 form-group">
                                <label class="text-bold">{{ __('Staff Id') }} <span class="text-danger">*</span></label>
                                <div class="input-group">
									<input type="text" name="staff_letters" id="staff_letters" placeholder="Company Code"
										   required class="form-control" pattern="[A-Za-z]+" readonly>

									<input type="text" name="staff_numbers" id="staff_numbers" placeholder="Staff Numbers"
										   required class="form-control" value="{{ $staffNumbers }}">
								</div>
                            </div>
                            <div class="col-md-6 form-group">
                                <label class="text-bold">{{ trans('file.Email') }}</label>
                                <input type="email" name="email" id="email" placeholder="example@example.com"
                                    class="form-control">
                            </div>
							
                            <div class="col-md-6 form-group">
                                <label class="text-bold">{{ __('Nomor KTP') }} <span
                                        class="text-danger">*</span></label>
                                <input type="text" name="identity_number" id="identity_number"
                                    placeholder="{{ __('Nomor Identitas') }}" required class="form-control"
                                    value="{{ old('identity_number') }}" pattern="[0-9]{16}">
                            </div>
                            <div class="col-md-6 form-group">
                                <label class="text-bold">{{ __('NPWP') }} <span
                                        class="text-danger">*</span></label>
                                <input type="text" name="npwp" id="npwp"
                                    placeholder="{{ __('Nomor NPWP') }}" required class="form-control"
                                    value="{{ old('npwp') }}" pattern="[0-9]{16}">
                            </div>

                            <div class="col-md-6 form-group">
                                <label class="text-bold">{{ __('Date Of Birth') }} <span
                                        class="text-danger">*</span></label>
                                <input type="text" name="date_of_birth" id="date_of_birth" required
                                    autocomplete="off" class="form-control date" value="">
                            </div>

                            <div class="col-md-6 form-group">
                                <label class="text-bold">{{ trans('file.Gender') }} <span
                                        class="text-danger">*</span></label>
                                <select name="gender" id="gender" class="selectpicker form-control"
                                    data-live-search="true" data-live-search-style="contains"
                                    title="{{ __('Selecting', ['key' => trans('file.Gender')]) }}..." required>
                                    <option value="Male">{{ trans('file.Male') }}</option>
                                    <option value="Female">{{ trans('file.Female') }}</option>
                                </select>
                            </div>
							
                            <div class="col-md-6 form-group">
                                <label class="text-bold">{{ __('Marital Status') }} <span
                                        class="text-danger">*</span></label>
                                <select name="marital_status" id="marital_status" class="selectpicker form-control"
                                    data-live-search="true" data-live-search-style="contains"
                                    title="{{ __('Selecting', ['key' => __('Marital Status')]) }}..." required>
                                    <option value="single">{{ trans('file.Single') }}</option>
                                    <option value="married">{{ trans('file.Married') }}</option>
                                    <option value="divorced">{{ __('Divorced') }}</option>
                                </select>
                            </div>
							
                            <div class="col-md-6 form-group">
                                <label class="text-bold">{{ __('Religion') }} <span
                                        class="text-danger">*</span></label>
                                <select name="religion" id="religion" class="selectpicker form-control"
                                    data-live-search="true" data-live-search-style="contains"
                                    title="{{ __('Selecting', ['key' => __('Religion')]) }}..." required>
                                    <option value="islam">{{ __('Islam') }}</option>
                                    <option value="kristen">{{ __('Kristen') }}</option>
                                    <option value="katholik">{{ __('Katholik') }}</option>
                                    <option value="hindu">{{ __('Hindu') }}</option>
                                    <option value="budha">{{ __('Budha') }}</option>
                                    <option value="konghucu">{{ __('Konghucu') }}</option>
                                </select>
                            </div>

                            <!-- <div class="col-md-6 form-group">
                                <label class="text-bold">{{ trans('file.Role') }} <span
                                        class="text-danger">*</span></label>
                                <select name="role_users_id" id="role_users_id" required
                                    class="selectpicker form-control" data-live-search="true"
                                    data-live-search-style="contains"
                                    title="{{ __('Selecting', ['key' => trans('file.Role')]) }}...">
                                    @foreach ($roles as $item)
                                        <option value="{{ $item->id }}">{{ $item->name }}</option>
                                    @endforeach
                                    {{-- <option value="1">Admin</option>
                                    <option value="2">Employee</option> --}}
                                </select>
                            </div> -->

                            <div class="col-md-6 form-group">
                                <label class="text-bold">{{ __('Attendance Type') }} <span
                                        class="text-danger">*</span></label>
                                <select name="attendance_type" id="attendance_type" required
                                    class="selectpicker form-control" data-live-search="true"
                                    data-live-search-style="contains" title="{{ __('Select Attendance Type...') }}">
                                    <!--<option value="general">{{ __('General') }}</option>-->
                                    <option value="ip_based">{{ __('IP Based') }}</option>
                                </select>
                            </div>

                            <div class="col-md-6 form-group">
                                <label class="text-bold">{{ __('Date Of Joining') }} <span
                                        class="text-danger">*</span></label>
                                <input type="text" name="joining_date" id="joining_date" class="form-control date">
                            </div>

                            <div class="col-md-6 form-group">
                                <label for="profile_photo" class=""><strong>{{ __('Image') }}</strong></label>
                                <input type="file" id="profile_photo"
                                    class="form-control @error('photo') is-invalid @enderror" name="profile_photo"
                                    placeholder="{{ __('Upload', ['key' => trans('file.Photo')]) }}">
                            </div>


                            <!-- <div class="col-md-6">
                                <div class="form-group">
                                    <label class="text-bold">{{ __('Position') }}<span
                                            class="text-danger">*</span></label>
                                    <input type="number" name="position" id="position" class="form-control"
                                        placeholder="{{ __('Position') }}">
                                </div>
                            </div> -->

                            <div class="col-md-12 form-group">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="is_dispensation"
                                        id="is_dispensation" value="1">
                                    <label class="custom-control-label text-bold"
                                        for="is_dispensation">{{ __('Dispensation') }}</label>
                                </div>
                            </div>

                            {{-- <div class="col-md-6 form-group"  id="ipField"></div> --}}

                            <div class="container">
                                <div class="form-group" align="center">
                                    <input type="hidden" name="action" id="action" />
                                    <input type="hidden" name="hidden_id" id="hidden_id" />
                                    <button type="" id="prev_button" class="btn btn-warning" onclick="prev_step()">{{ __('Back') }}</button>
                                    <input type="submit" name="action_button" id="action_button"
                                        class="btn btn-warning" value="{{ trans('file.Add') }}" />
                                </div>
                            </div>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    </div>


    <div id="confirmModal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 class="modal-title">{{ trans('file.Confirmation') }}</h2>
                    <button type="button" class="employee-close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <h4 align="center" style="margin:0;">{{ __('Are you sure you want to remove this data?') }}</h4>
                </div>
                <div class="modal-footer">
                    <button type="button" name="ok_button" id="ok_button"
                        class="btn btn-danger">{{ trans('file.OK') }}</button>
                    <button type="button" class="close btn-default"
                        data-dismiss="modal">{{ trans('file.Cancel') }}</button>
                </div>
            </div>
        </div>
    </div>

    <!-- //Inactive Modal -->
    <div id="confirmModalActive" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form id="inactive-form">
                    <div class="modal-header">
                        <h2 class="modal-title">{{ trans('file.Confirmation') }}</h2>
                        <button type="button" class="employee-close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="modal-body" style="text-align: center;">
                        <h4 align="center" style="margin:0;">{{ __('Are you sure you want to set inactive this data?') }}</h4>
                        <textarea id="reason" name="reason" rows="4" cols="50" placeholder="reason"></textarea>
                    </div>
                    <div class="modal-footer">
                        <input type="hidden" id="inactive_id" value="">
                        <button type="button" name="inactive_button" id="inactive_button"
                            class="btn btn-danger">{{ trans('file.OK') }}</button>
                        <button type="button" class="close btn-default"
                            data-dismiss="modal">{{ trans('file.Cancel') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div id="confirmModalAcc" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 class="modal-title">{{ trans('file.Confirmation') }}</h2>
                    <button type="button" class="employee-close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <h4 align="center" style="margin:0;">{{ __('Are you sure you want to accept this data?') }}</h4>
                </div>
                <div class="modal-footer">
                    <button type="button" name="ok_button" id="ok_button_acc"
                        class="btn btn-danger">{{ trans('file.OK') }}</button>
                    <button type="button" class="close btn-default"
                        data-dismiss="modal">{{ trans('file.Cancel') }}</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('css')
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cleave.js/1.6.0/cleave.min.css">
@endpush
@push('scripts')
	<script src="https://cdnjs.cloudflare.com/ajax/libs/cleave.js/1.6.0/cleave.min.js"></script>
    <script type="text/javascript">
		var nomor_identitas = new Cleave('#identity_number', {
            blocks: [16], // Jumlah digit KTP
            numericOnly: true, // Hanya menerima input angka
            delimiter: ' ', // Karakter pemisah, misalnya spasi
        });
		
		var npwp = new Cleave('#npwp', {
            blocks: [16], // Jumlah digit NPWP
            numericOnly: true, // Hanya menerima input angka
            delimiter: ' ', // Karakter pemisah, misalnya spasi
        });
        $(document).ready(function() {

            if (window.location.href.indexOf('#formModal') != -1) {
                $('#formModal').modal('show');
            }

            var date = $('.date');
            date.datepicker({
                format: '{{ env('Date_Format_JS') }}',
                autoclose: true,
                todayHighlight: true
            });

            var table_table = $('#employee-table').DataTable({
                initComplete: function() {
                    this.api().columns([2, 4]).every(function() {
                        var column = this;
                        var select = $('<select><option value=""></option></select>')
                            .appendTo($(column.footer()).empty())
                            .on('change', function() {
                                var val = $.fn.dataTable.util.escapeRegex(
                                    $(this).val()
                                );

                                column
                                    .search(val ? '^' + val + '$' : '', true, false)
                                    .draw();
                            });

                        column.data().unique().sort().each(function(d, j) {
                            select.append('<option value="' + d + '">' + d +
                                '</option>');
                            $('select').selectpicker('refresh');
                        });
                    });
                },
                responsive: true,
                fixedHeader: {
                    header: true,
                    footer: true
                },
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('employees.index') }}",
                    type: 'GET',
                    data: function(d) {
                        d.company_id = $("#company_id_filter").val();
                        d.department_id = $('#department_id_filter').val();
                        d.designation_id = $('#designation_id_filter').val();
                        d.office_shift_id = $('#office_shift_id_filter').val();
                    }
                },

                columns: [

                    {
                        data: 'id',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'name',
                        name: 'name',

                    },
                    {
                        data: 'company',
                        name: 'company',
                    },
                    {
                        data: 'contacts',
                        name: 'contacts',
                    },
                    {
                        data: 'status',
                        name: 'status',
                        render: function(data) {
                            if (data == '1') {
                                return "<td><div class = 'badge badge-success'>{{ __('Active') }}</div>"
                            } else {
                                return "<td><div class = 'badge badge-danger'>{{ __('Inactive') }}</div>"
                            }
                        }
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false
                    }
                ],


                "order": [],
                'language': {
                    'lengthMenu': '_MENU_ {{ __('records per page') }}',
                    "info": '{{ trans('file.Showing') }} _START_ - _END_ (_TOTAL_)',
                    "search": '{{ trans('file.Search') }}',
                    'paginate': {
                        'previous': '{{ trans('file.Previous') }}',
                        'next': '{{ trans('file.Next') }}'
                    }
                },
                'columnDefs': [{
                        "orderable": false,
                        'targets': [0, 4],
                        "className": "text-left"
                    },
                    {
                        'render': function(data, type, row, meta) {
                            if (type == 'display') {
                                data =
                                    '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label class="text-bold"></label></div>';
                            }

                            return data;
                        },
                        'checkboxes': {
                            'selectRow': true,
                            'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label class="text-bold"></label></div>'
                        },
                        'targets': [0]
                    }
                ],


                'select': {
                    style: 'multi',
                    selector: 'td:first-child'
                },
                'lengthMenu': [
                    [10, 25, 50, -1],
                    [10, 25, 50, "All"]
                ],
                dom: '<"row"lfB>rtip',
                buttons: [{
                        extend: 'pdf',
                        text: '<i title="export to pdf" class="fa fa-file-pdf-o"></i>',
                        exportOptions: {
                            columns: ':visible:Not(.not-exported)',
                            rows: ':visible'
                        },
                    },
                    {
                        extend: 'csv',
                        text: '<i title="export to csv" class="fa fa-file-text-o"></i>',
                        exportOptions: {
                            columns: ':visible:Not(.not-exported)',
                            rows: ':visible'
                        },
                    },
                    // {
                    //     extend: 'csv',
                    //     text: '<i title="export for device" class="fa fa-tablet"></i>',
                    //     className: 'export-for-device',
                    //     exportOptions: {
                    //         columns: [1,2],
                    //         rows: ':visible',
                    //         format: {
                    //             body: function ( data, row, column, node ) {
                    //                 if (column === 0) {
                    //                     var id = data.match(/<span>Staff Id: (.*?)<\/span>/)[1];
                    //                     name = data.match(/<[a][^>]*>(.+?)<\/[a]>/)[1];
                    //                     return id;
                    //                 }
                    //                 else {
                    //                     return name;
                    //                 }
                    //             }
                    //         }
                    //     },
                    //     customize: function (csv) {
                    //         var csvRows = csv.split('\n');
                    //         csvRows[0] = csvRows[0].replace(['"Employee"', '"Company"'], ['"Staff Id"','"Name"']);
                    //         return csvRows.join('\n');
                    //     }
                    // },
                    {
                        extend: 'print',
                        text: '<i title="print" class="fa fa-print"></i>',
                        exportOptions: {
                            columns: ':visible:Not(.not-exported)',
                            rows: ':visible'
                        },
                    },
                    {
                        extend: 'colvis',
                        text: '<i title="column visibility" class="fa fa-eye"></i>',
                        columns: ':gt(0)'
                    },
                ],
            });
            new $.fn.dataTable.FixedHeader(table_table);

        });


        //-------------- Filter -----------------------

        $('#filterSubmit').on("click", function(e) {
            $('#employee-table').DataTable().draw(true);
            //$('#filter_form')[0].reset();
            //$('select').selectpicker('refresh');
        });
        //--------------/ Filter ----------------------


        $('#create_record').click(function() {

            $('.modal-title').text("Add Employee");
            $('#action_button').val('{{ trans('file.Add') }}');
            $('#action').val('{{ trans('file.Add') }}');
            $('#formModal').modal('show');
        });

		function next_step() {
		  $('#company_selection').addClass('d-none');
		  $('#biodata').removeClass('d-none');
		  $('#biodata').addClass('d-flex flex-row');
		}
		
		function prev_step() {
		  $('#company_selection').removeClass('d-none');
		  $('#biodata').addClass('d-none');
		  $('#biodata').removeClass('d-flex flex-row');
		}

        $('#sample_form').on('submit', function(event) {
            event.preventDefault();
            // var attendance_type = $("#attendance_type").val();
            // console.log(attendance_type);
			var staff_number = parseInt($('#staff_numbers').val());
            $.ajax({
                url: "{{ route('employees.store') }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                cache: false,
                processData: false,
                dataType: "json",
                success: function(data) {
                    console.log(data);
                    var html = '';
                    if (data.errors) {
                        html = '<div class="alert alert-danger">';
                        for (var count = 0; count < data.errors.length; count++) {
                            html += '<p>' + data.errors[count] + '</p>';
                        }
                        html += '</div>';
                    }
                    if (data.error) {
                        html = '<div class="alert alert-danger">' + data.error + '</div>';
                    }
                    if (data.success) {
                        html = '<div class="alert alert-success">' + data.success + '</div>';
                        $('#sample_form')[0].reset();
						$('#staff_numbers').val(staff_number+1);
                        $('select').selectpicker('refresh');
                        $('.date').datepicker('update');
                        
                        $('#company_selection').removeClass('d-none');
            		    $('#biodata').addClass('d-none');
            		    $('#biodata').removeClass('d-flex flex-row');
            		    
            		    $('#formModal').modal('hide');
                        
                        $('#employee-table').DataTable().ajax.reload();
                    }
                    $('#form_result').html(html).slideDown(300).delay(2000).slideUp(300);
                }
            });
        });


        let employee_delete_id;

        $(document).on('click', '.delete', function() {
            employee_delete_id = $(this).attr('id');
            $('#confirmModal').modal('show');
            $('.modal-title').text('{{ __('DELETE Record') }}');
            $('#ok_button').text('{{ trans('file.OK') }}');

        });

        let employee_acc_id;

        $(document).on('click', '.accept', function() {
            employee_acc_id = $(this).attr('id');
            $('#confirmModalAcc').modal('show');
            $('.modal-title').text('{{ __('ACCEPT Record') }}');
            $('#ok_button_acc').text('{{ trans('file.OK') }}');

        });


        $(document).on('click', '#bulk_delete', function() {

            var id = [];
            let table = $('#employee-table').DataTable();
            id = table.rows({
                selected: true
            }).ids().toArray();
            if (id.length > 0) {
                if (confirm('{{ __('Delete Selection', ['key' => trans('file.Employee')]) }}')) {
                    $.ajax({
                        url: '{{ route('mass_delete_employees') }}',
                        method: 'POST',
                        data: {
                            employeeIdArray: id
                        },
                        success: function(data) {
                            if (data.success) {
                                html = '<div class="alert alert-success">' + data.success + '</div>';
                            }
                            if (data.error) {
                                html = '<div class="alert alert-danger">' + data.error + '</div>';
                            }
                            table.ajax.reload();
                            table.rows('.selected').deselect();
                            $('#general_result').html(html).slideDown(300).delay(5000).slideUp(300);

                        }

                    });
                }
            } else {
                alert('{{ __('Please select atleast one checkbox') }}');
            }
        });


        $('#close').click(function() {
            $('#sample_form')[0].reset();
            $('select').selectpicker('refresh');
            $('.date').datepicker('update');
            $('#employee-table').DataTable().ajax.reload();
        });

        $('#ok_button').click(function() {
            let target = "{{ route('employees.index') }}/" + employee_delete_id + '/delete';
            $.ajax({
                url: target,
                beforeSend: function() {
                    $('#ok_button').text('{{ trans('file.Deleting...') }}');
                },
                success: function(data) {
                    if (data.success) {
                        html = '<div class="alert alert-success">' + data.success + '</div>';
                    }
                    if (data.error) {
                        html = '<div class="alert alert-danger">' + data.error + '</div>';
                    }
                    setTimeout(function() {
                        $('#general_result').html(html).slideDown(300).delay(5000).slideUp(300);
                        $('#confirmModal').modal('hide');
                        $('#employee-table').DataTable().ajax.reload();
                    }, 2000);
                }
            })
        });

        $('#ok_button_acc').click(function() {
            let target = "{{ route('employees.index') }}/" + employee_acc_id + '/accept';
            $.ajax({
                url: target,
                beforeSend: function() {
                    $('#ok_button').text('{{ __('Accepting') }}');
                },
                success: function(data) {
                    if (data.success) {
                        html = '<div class="alert alert-success">' + data.success + '</div>';
                    }
                    if (data.error) {
                        html = '<div class="alert alert-danger">' + data.error + '</div>';
                    }
                    setTimeout(function() {
                        $('#general_result').html(html).slideDown(300).delay(5000).slideUp(300);
                        $('#confirmModalAcc').modal('hide');
                        $('#employee-table').DataTable().ajax.reload();
                    }, 2000);
                }
            })
        });




        $('#confirm_pass').on('input', function() {

            if ($('input[name="password"]').val() != $('input[name="password_confirmation"]').val())
                $("#divCheckPasswordMatch").html('{{ __('Password does not match! please type again') }}');
            else
                $("#divCheckPasswordMatch").html('{{ __('Password matches!') }}');

        });


        $('.dynamic').change(function() {
            if ($(this).val() !== '') {
                let value = $(this).val();
                let dependent = $(this).data('dependent');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "{{ route('dynamic_department') }}",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        dependent: dependent
                    },
                    success: function(result) {

                        $('select').selectpicker("destroy");
                        $('#department_id').html(result);
                        $('select').selectpicker();

                    }
                });
            }
        });


        $('.dynamic').change(function() {
            if ($(this).val() !== '') {
                let value = $(this).val();
                let dependent = $(this).data('shift_name');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "{{ route('dynamic_office_shifts') }}",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        dependent: dependent
                    },
                    success: function(result) {
                        $('select').selectpicker("destroy");
                        $('#office_shift_id').html(result.data);
                        $('#staff_letters').val(result.code);
                        $('#staff_numbers').val(result.staff_number);
                        $('select').selectpicker();
                    }
                });
            }
        });

        $('.following_company').change(function() {
            if ($(this).val() !== '') {
                let value = $(this).val();
                let dependent = $(this).data('following_company');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "{{ route('dynamic_employee') }}",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        dependent: dependent
                    },
                    success: function(result) {
                        $('select').selectpicker("destroy");
                        $('#following_employee_id').html(result);
                        $('select').selectpicker();
                    }
                });
            }
        });

        $('.designation').change(function() {
            if ($(this).val() !== '') {
                let value = $(this).val();
                let designation_name = $(this).data('designation_name');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "{{ route('dynamic_designation_department') }}",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        designation_name: designation_name
                    },
                    success: function(result) {
                        $('select').selectpicker("destroy");
                        $('#designation_id').html(result);
                        $('select').selectpicker();

                    }
                });
            }
        });


        // Login Type Change
        // $('#login_type').change(function() {
        //     var login_type = $('#login_type').val();
        //     if (login_type=='ip') {
        //         data = '<label class="text-bold">{{ __('IP Address') }} <span class="text-danger">*</span></label>';
        //         data += '<input type="text" name="ip_address" id="ip_address" placeholder="Type IP Address" required class="form-control">';
        //         $('#ipField').html(data)
        //     }else{
        //         $('#ipField').empty();
        //     }
        // });



        //--------  Filter  ---------

        // Company--> Department
        $('.dynamic').change(function() {
            if ($(this).val() !== '') {
                let value = $('#company_id_filter').val();
                let dependent = $(this).data('dependent');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "{{ route('dynamic_department') }}",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        dependent: dependent
                    },
                    success: function(result) {

                        $('select').selectpicker("destroy");
                        $('#department_id_filter').html(result);
                        $('select').selectpicker();

                    }
                });
            }
        });

        //Department--> Designation
        $('.designationFilter').change(function() {
            if ($(this).val() !== '') {
                // let value = $(this).val();
                // let value = $('#company_id_filter').val();
                let value = $('#department_id_filter').val();
                let designation_name = $(this).data('designation_name');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "{{ route('dynamic_designation_department') }}",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        designation_name: designation_name
                    },
                    success: function(result) {
                        $('select').selectpicker("destroy");
                        $('#designation_id_filter').html(result);
                        $('select').selectpicker();

                    }
                });
            }
        });

        //Company--> Office Shift
        // $('.dynamic').change(function() {
        //     if ($(this).val() !== '') {
        //         // let value = $(this).val();
        //         let value = $('#company_id_filter').val();
        //         let dependent = $(this).data('shift_name');
        //         let _token = $('input[name="_token"]').val();
        //         $.ajax({
        //             url: "{{ route('dynamic_office_shifts') }}",
        //             method: "POST",
        //             data: {
        //                 value: value,
        //                 _token: _token,
        //                 dependent: dependent
        //             },
        //             success: function(result) {
        //                 $('select').selectpicker("destroy");
        //                 $('#office_shift_id_filter').html(result.data);
        //                 $('#staff_letters').val(result.code);
        //                 $('select').selectpicker();
        //             }
        //         });
        //     }
        // });

        //Set Inactive
        $(document).on('click', '.inactive', function() {
            employee_delete_id = $(this).attr('id');
            $('#confirmModalActive').modal('show');
            $('.modal-title').text('{{ __('Inactive Record') }}');
            $('#inactive_id').val(employee_delete_id);
            $('#inactive_button').text('{{ trans('file.OK') }}');

        });

        $(document).on('click', '#inactive_button', function() {
            let employee_id = $('#inactive_id').val();
            let _token = $('input[name="_token"]').val();

            let target = "{{ url('staff/employees/inactive') }}";
            $.ajax({
                url: target,
                method: "POST",
                data: {
                    id: employee_id,
                    _token: _token,
                    reason: $('#reason').val()
                },
                beforeSend: function() {
                    $('#inactive_button').text('{{ trans('file.Processing...') }}');
                },
                success: function(data) {
                    if (data.success) {
                        html = '<div class="alert alert-success">' + data.success + '</div>';
                    }
                    if (data.error) {
                        html = '<div class="alert alert-danger">' + data.error + '</div>';
                    }
                    setTimeout(function() {
                        $('#general_result').html(html).slideDown(300).delay(5000).slideUp(300);
                        $('#confirmModalActive').modal('hide');
                        $('#employee-table').DataTable().ajax.reload();
                    }, 2000);
                }
            })
        });
    </script>
@endpush
