<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
    <title>{{config('app.name')}}</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>


    <link rel="stylesheet" href="<?php echo asset('vendor/bootstrap/css/bootstrap.min.css') ?>" type="text/css">
</head>

<style>
    table {
      border-collapse: collapse;
    }
</style>

<body>
    <table width="100%">
        <tr>
            <td colspan="2" class="text-center">
                <img src="{{ asset('uploads/company_logo/'.$company['company_logo']) }}" width="75" height="75"/><h3>{{$company['company_name']}}</h3>
            </td>
        </tr>
        <tr>
            <td colspan="2" class="text-center">
                <h4>{{$month_year}}</h4>
                <hr>
            </td>
        </tr>
        <tr>
            <td>
                <strong>{{$first_name}} {{$last_name}}</strong>
                <br>
				@if(!empty($designation))
                <span>{{$designation['designation_name']}}</span>
				@endif
            </td>
        </tr>
        <tr>
            <td>
                <strong>Keterangan</strong>
            </td>
            <td>
                <strong>Jumlah</strong>
            </td>
        </tr>
        <tr>
            <td>
                <strong>Gaji Pokok</strong>
            </td>
            <td>
                <strong>Rp. {{ number_format($basic_salary, '0', ',', '.'); }}</strong>
            </td>
        </tr>
        <tr>
            <td>
                <strong>Tunjangan Jabatan</strong>
            </td>
            <td>
                <strong>Rp. {{ number_format($tunjangan_jabatan, '0', ',', '.'); }}</strong>
            </td>
        </tr>
        <tr>
            <td>
                <strong>Uang Kehadiran</strong>
            </td>
            <td>
                <strong>Rp. {{ number_format($salary_kehadiran, '0', ',', '.'); }}</strong>
            </td>
        </tr>
        @foreach($allowances as $allowance)
        <tr>
            <td>
                {{ $allowance->allowance_title }}
            </td>
            <td>
                Rp. {{ number_format($allowance->allowance_amount, '0', ',', '.'); }} x {{ $work_days }} hari kerja
            </td>
        </tr>
        @endforeach
        @foreach($overtimes as $overtime)
        <tr>
            <td>
                {{ $overtime->overtime_title }}
            </td>
            <td>
                Rp. {{ number_format($overtime->overtime_amount, '0', ',', '.'); }} ( {{ $overtime->hours }} jam )
            </td>
        </tr>
        @endforeach
        @foreach($commissions as $commision)
        <tr>
            <td>
                {{ $commision->commision_title }}
            </td>
            <td>
                Rp. {{ number_format($commision->commision_amount, '0', ',', '.'); }}
            </td>
        </tr>
        @endforeach
        @foreach($other_payments as $other)
        <tr>
            <td>
                {{ $other->$other_payment_title }}
            </td>
            <td>
                Rp. {{ number_format($other->other_payment_amount, '0', ',', '.'); }}
            </td>
        </tr>
        @endforeach
        <tr>
            <td>
                <strong>Total</strong>
            </td>
            <td style="border-bottom: 1pt solid black;">
                <strong>Rp. {{ number_format($basic_salary + $tunjangan_jabatan + $salary_kehadiran + $allowance_amount + $overtimes->sum('overtime_amount') + $commissions->sum('commision_amount') + $other_payments->sum('other_payment_amount'), '0', ',', '.') }}</strong>
            </td>
        </tr>
        <tr>
            <td colspan="2">&nbsp;&nbsp;</td>
        </tr>
        <tr>
            <td colspan="2">&nbsp;&nbsp;</td>
        </tr>
        <tr>
            <td>
                <strong>Potongan</strong>
            </td>
        </tr>
        <tr>
            <td>
                PPh
            </td>
            <td>
                Rp. {{ $pph_bulanan; }}
            </td>
        </tr>
        <tr>
            <td>
                BPJS Kesehatan
            </td>
            <td>
                Rp. {{ $bpjs_kes; }}
            </td>
        </tr>
        <tr>
            <td>
                BPJS Jaminan Hari Tua
            </td>
            <td>
                Rp. {{ $bpjs_jht; }}
            </td>
        </tr>
        <tr>
            <td>
                BPJS Pensiun
            </td>
            <td>
                Rp. {{ $bpjs_pensiun; }}
            </td>
        </tr>
        <tr>
            <td>
                BPJS Jaminan Kecelakaan Kerja
            </td>
            <td>
                Rp. {{ $bpjs_jkk; }}
            </td>
        </tr>
        <tr>
            <td>
                BPJS Jaminan Kematian
            </td>
            <td>
                Rp. {{ $bpjs_jkm; }}
            </td>
        </tr>
        <!--<tr>-->
        <!--    <td>-->
        <!--        Potongan Absen-->
        <!--    </td>-->
        <!--    <td>-->
        <!--        Rp. {{ number_format($attendance_cut_amount, '0', ',', '.');}}-->
        <!--    </td>-->
        <!--</tr>-->
        @foreach($deductions as $deduction)
        <tr>
            <td>
                {{ $deduction->deduction_title }}
            </td>
            <td>
                Rp. {{ number_format($deduction->deduction_amount, '0', ',', '.'); }}
            </td>
        </tr>
        @endforeach
        @foreach($loans as $loan)
        <tr>
            <td>
                {{ $loan->loan_title }}
            </td>
            <td>
                Rp. {{ number_format($loan->monthly_payable, '0', ',', '.'); }}
            </td>
        </tr>
        @endforeach
        <tr>
            <td colspan="2">&nbsp;&nbsp;</td>
        </tr>
        <tr>
            <td>
                <strong>Total Diterima</strong>
            </td>
            <td>
                <strong><u>Rp. {{ $total_salary; }}</u></strong>
            </td>
        </tr>
        <tr>
            <td colspan="2">&nbsp;&nbsp;</td>
        </tr>
        <tr>
            <td>Tanda Terima</td>
            <td>{{$company['location']['city']}},</td>
        </tr>
        <tr>
            <td colspan="2">&nbsp;&nbsp;</td>
        </tr>
        <tr>
            <td><strong>{{$first_name}} {{$last_name}}</strong></td>
            <td></td>
        </tr>
        <tr>
            <td colspan="2">&nbsp;&nbsp;</td>
        </tr>
    </table>
</body>

</html>

