<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\NotificationController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('/login', 'API\LoginController@login');

Route::get('/employee', 'API\EmployeeController@index')->middleware('auth:api');
Route::post('/employee/payslip', 'API\EmployeeController@payslip')->middleware('auth:api');

Route::get('/employee/leaves', 'API\EmployeeController@leave_history')->middleware('auth:api');
Route::post('/employee/ask_leave', 'API\EmployeeController@ask_leaves')->middleware('auth:api');
Route::post('/employee/leave_type', 'API\EmployeeController@leave_type')->middleware('auth:api');

Route::get('/employee/reimbursements', 'API\EmployeeController@reimbursement_history')->middleware('auth:api');
Route::post('/employee/reimbursement', 'API\EmployeeController@reimbursement')->middleware('auth:api');
Route::post('/employee/reimbursement_type', 'API\EmployeeController@reimbursement_type')->middleware('auth:api');

Route::get('/employee/travel_type', 'API\EmployeeController@travel_type')->middleware('auth:api');
Route::get('/employee/travel_mode', 'API\EmployeeController@travel_mode')->middleware('auth:api');
//Route::post('/employee/add-travel', 'API\EmployeeController@travel')->middleware('auth:api');
Route::get('/employee/list-travel', 'API\EmployeeController@travel_history')->middleware('auth:api');
Route::post('/employee/add-travel', 'API\TravelController@store')->middleware('auth:api');

Route::get('/reimbursements/list', 'API\ReimbursementController@list_approval')->middleware('auth:api');
Route::post('/reimbursements/approval', 'API\ReimbursementController@approve')->middleware('auth:api'); // approve hanya ubah status
Route::post('/reimbursements/reject', 'API\ReimbursementController@reject')->middleware('auth:api');   // reject hanya ubah status
Route::post('/reimbursements/type', 'API\ReimbursementController@reimbursement_type')->middleware('auth:api');

Route::get('/travels/list', 'API\TravelController@list_approval')->middleware('auth:api');
Route::post('/travels/approval', 'API\TravelController@update')->middleware('auth:api');
Route::post('/travels/type', 'API\TravelController@travel_type')->middleware('auth:api');
Route::post('/travels', 'API\TravelController@store')->middleware('auth:api');

Route::get('/attendance/report', 'API\ReportAttendanceController@index')->middleware('auth:api');
Route::post('/attendance/report', 'API\ReportAttendanceController@show')->middleware('auth:api');
Route::post('/attendance/record', 'API\ReportAttendanceController@record_absen')->middleware('auth:api');

Route::apiResource('/announcement', 'API\AnnouncementController')->middleware('auth:api');

Route::get('/leaves/list', 'API\LeaveController@list_approval')->middleware('auth:api');
Route::get('/leave/list_applications', 'API\LeaveController@list_applications')->middleware('auth:api');
Route::post('/leaves/approval', 'API\LeaveController@approve')->middleware('auth:api'); // ganti dari update -> approve (hanya ubah status)
Route::post('/leaves/reject', 'API\LeaveController@reject')->middleware('auth:api');     // endpoint baru untuk reject

Route::get('/notifications/list', 'API\NotificationController@index')->middleware('auth:api');
Route::get('/notifications', 'APificationController@index')->middleware('auth:api');

//Route::middleware('auth:api')->get('/user', function (Request $request) {
//    return $request->user();
//});
