
<?php $__env->startSection('content'); ?>
    <section>
        <div class="container-fluid">
            <div class="card mb-4">
                <div class="card-header with-border">
                    <h3 class="card-title text-center"> <?php echo e(__('Generate Payslip')); ?> </h3>
                </div>
                <span id="bulk_payment_result"></span>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <form method="post" id="filter_form" class="form-horizontal">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <select class="form-control ss selectpicker dynamic" name="filter_company" id="company_id" data-dependent="department_name" data-placeholder="Company"
                                                data-column="1" required tabindex="-1" aria-hidden="true">
                                                <option value="0"><?php echo e(__('All Companies')); ?></option>
                                                <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($company->id); ?>"><?php echo e($company->company_name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo e(csrf_field()); ?>

                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <select class="form-control selectpicker default_dept" name="filter_department" id="department_id" data-placeholder="Department" required tabindex="-1"
                                                aria-hidden="true">
                                                <option value="0"><?php echo e(__('All Departments')); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <input class="form-control month_year date" placeholder="<?php echo e(__('Select Month')); ?>" readonly id="month_year" name="month_year" type="text" value="">
                                        </div>
                                    </div>
                                </div>

                                <div class="text-center">
                                    <div class="form-group">
                                        <div class="form-actions">
                                            <button id="payroll_export" type="submit" name="export" class="filtering btn btn-primary"> <i class="fa fa-file-excel-o"></i> <?php echo e(__('DOWNLOAD EXCEL')); ?> </button>
                                            <button id="payslip_filter" type="submit" class="filtering btn btn-primary"> <i class="fa fa-search"></i> <?php echo e(trans('file.Search')); ?> </button>
                                            <button id="bulk_payment" type="submit" class="filtering btn btn-primary"> <i class="fa fa-check-square-o"></i> <?php echo e(__('BULK PAYMENT')); ?> </button>
                                        </div>
                                    </div>
                                </div>
								<div class="row d-flex justify-content-between">
									<div class="text-left">
										Total Gaji Bersih : <span id="total_salary_sum"></span><br />
										Total Pembayaran BPJS Tenaga Kerja : <span id="total_bpjs_tk_comp"></span><br />
										Total Pembayaran BPJS Kesehatan : <span id="total_bpjs_kes_comp"></span><br />
									</div>
									<div class="text-right">
										Total PPh : <span id="total_monthly_pph"></span><br />
										Total Potongan BPJS Tenaga Kerja : <span id="total_bpjs_tk"></span><br />
										Total Potongan BPJS Kesehatan : <span id="total_bpjs_kes"></span><br />
									</div>
								</div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-title text-center">
            <h3><?php echo e(__('Payment Info')); ?> <span id="details_month_year"></span></h3>
        </div>
        <div class="container-fluid"><span id="general_result"></span></div>
        <div class="table-responsive">
            <table id="pay_list-table" class="table">
                <thead>
                    <tr>
                        <th class="not-exported"></th>
                        <th><?php echo e(trans('file.Name')); ?></th>
                        <th><?php echo e(__('Payslip Type')); ?></th>
                        <th><?php echo e(__('Basic Salary')); ?></th>
                        <th><?php echo e(__('Tunjangan Jabatan')); ?></th>
                        <th><?php echo e(__('Uang Kehadiran')); ?></th>
                        <th><?php echo e(__('Net Salary')); ?></th>
                        <th><?php echo e(trans('file.Status')); ?></th>
                        <th class="not-exported"><?php echo e(trans('file.action')); ?></th>
                    </tr>
                </thead>
            </table>
        </div>

        <div class="modal fade" id="salary_model" tabindex="-1" role="dialog" aria-labelledby="basicModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="myModalLabel"><?php echo e(__('Salary Info')); ?></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="d-flex">
                                    <div id="employee_pp"></div>
                                    <div class="ml-3">
                                        <div class="h3 text-bold d-inline" id="employee_full_name"></div> (<span id="employee_username"></span>)
                                        <br>
                                        <span class="text-gray" id="employee_designation"></span>
                                        <span class="text-gray" id="employee_department"></span>
                                        <br>
                                        <a id="employee_id" href=""><?php echo e(__('View Profile')); ?></a>
                                        <strong>Jumlah hari kerja</strong> <span class="text-gray" id="work_days"></span> hari kerja
                                        <br />
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <h3 class="mt-5"><?php echo e(__('Salary Details')); ?></h3>
                                <hr>
                                <div class="card-block">
                                    <table class="table table-striped table-bordered dataTable no-footer">
                                        <tbody>
                                            <tr>
                                                <td>1</td><td><strong>Basic Salary</strong> <div class="float-right" id="basic_salary_amount"></div></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <table class="table table-striped table-bordered dataTable no-footer">
                                        <tbody>
                                            <tr>
                                                <td>2</td><td><strong>Tunjangan Jabatan</strong> <div class="float-right" id="tunjangan_jabatan_amount"></div></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <table class="table table-striped table-bordered dataTable no-footer">
                                        <tbody>
                                            <tr>
                                                <td>3</td><td><strong>Uang Kehadiran</strong> <div class="float-right" id="salary_kehadiran_amount"></div></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <table class="table table-striped table-bordered dataTable no-footer">
                                        <tbody id="allowance_info">
                                        </tbody>
                                    </table>
                                    <table class="table table-striped table-bordered dataTable no-footer">
                                        <tbody id="commission_info">
                                        </tbody>
                                    </table>
                                    <table class="table table-bordered mb-0">
                                        <thead>
                                            <tr><td>5</td><td colspan="4">Overtime</td></tr>
                                            <tr>
                                                <th>#</th>
                                                <th><?php echo e(__('Overtime Title')); ?></th>
                                                <th><?php echo e(__('Number of days')); ?></th>
                                                <th><?php echo e(trans('file.Hours')); ?></th>
                                                <th><?php echo e(trans('file.Rate')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody id="overtime_info">
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td colspan="4" align="right"><strong><?php echo e(trans('file.Total')); ?>:</strong></td>
                                                <td id="total_overtime"></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                                <h3 class="mt-5"><?php echo e(__('Tax and Insurance')); ?></h3>
                                <hr>
                                <div class="card-block">
                                    <table class="table table-striped table-bordered dataTable no-footer">
                                        <tbody>
                                            <tr>
                                                <td>1</td><td><strong>PPh</strong> <div class="float-right" id="total_pph"></div></td>
                                            </tr>
                                            <tr>
                                                <td>2</td><td><strong>BPJS Kesehatan</strong> <div class="float-right" id="bpjs_kesehatan"></div></td>
                                            </tr>
                                            <tr>
                                                <td>3</td><td><strong>BPJS Pensiun</strong> <div class="float-right" id="bpjs_pensiun"></div></td>
                                            </tr>
                                            <tr>
                                                <td>4</td><td><strong>BPJS Jaminan Hari Tua</strong> <div class="float-right" id="bpjs_jht"></div></td>
                                            </tr>
                                            <tr>
                                                <td>5</td><td><strong>BPJS Jaminan Kecelakaan Kerja</strong> <div class="float-right" id="bpjs_jkk"></div></td>
                                            </tr>
                                            <tr>
                                                <td>6</td><td><strong>BPJS Jaminan Kematian</strong> <div class="float-right" id="bpjs_jkm"></div></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <h3 class="mt-5"><?php echo e(__('Deduction')); ?></h3>
                                <hr>
                                <div class="card-block">
                                    <!--<table class="table table-striped table-bordered dataTable no-footer">-->
                                    <!--    <tbody>-->
                                    <!--        <tr>-->
                                    <!--            <td>1</td><td><strong>Attendance Cut</strong> <div class="float-right" id="attendance_cut_amount"></div></td>-->
                                    <!--        </tr>-->
                                    <!--    </tbody>-->
                                    <!--</table>-->
                                    <table class="table table-striped table-bordered dataTable no-footer">
                                        <tbody>
                                            <tr id="deduction_info"></tr>
                                        </tbody>
                                    </table>
                                    <table class="table table-striped table-bordered dataTable no-footer">
                                        <tbody>
                                            <tr id="loan_info"></tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="card-block">
                                    <div class="card-header">
                                        <strong class="text-dark"><?php echo e(__('Net Salary')); ?></strong> <strong class="float-right" id="total_salary"></strong>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(trans('file.Close')); ?></button>
                </div>
            </div>
        </div>

        <div class="modal fade" id="payslip_modal" tabindex="-1" role="dialog" aria-labelledby="basicModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="myModalLabel"><?php echo e(__('Payment Slip Info')); ?><span id="payment_month_year_show"></span></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    </div>
                    <div class="modal-body">
                        <span id="form_result"></span>
                        <form method="get" id="payslip_form" class="form-horizontal">

                            <input type="hidden" name="payslip_type" id="payslip_type_payment">

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('Basic Salary')); ?></label> &nbsp;&nbsp;&nbsp;&nbsp; <span id="payment_type_error"></span>
                                        <input type="text" name="basic_salary" id="basic_salary_payslip" class="form-control" value="0" readonly="readonly">
                                        <input type="hidden" value="0" name="month_year" id="hidden_month_year">
                                        <input type="hidden" value="" name="employee_id" id="employee_id">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('Tunjangan Jabatan')); ?></label>
                                        <input type="text" name="tunjangan_jabatan" id="tunjangan_jabatan_payslip" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('Uang Kehadiran')); ?></label> 
                                        <input type="text" name="salary_kehadiran" id="salary_kehadiran_payslip" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <h6>Allowance</h6>
                                </div>
                                
                                <div class="col-md-12">
                                    <div class="row allowance">

                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <h6>Deductions</h6>
                                </div>
                                
                                <div class="col-md-12">
                                    <div class="row deductions">
                                        <div class="col-md-6 hide-element">
                                            <div class="form-group">
                                                <label for="tax_pph_payslip"><?php echo e(__('Pajak PPh')); ?></label>
                                                <input type="text" readonly="readonly" name="tax_pph_payslip" id="tax_pph_payslip" class="form-control" value="">
                                            </div>
                                        </div>
                                        <div class="col-md-6 hidden-element">
                                            <div class="form-group">
                                                <label for="bpjs_payslip"><?php echo e(__('BPJS Kesehatan')); ?></label>
                                                <input type="text" readonly="readonly" name="bpjs_kes_payslip" id="bpjs_kes_payslip" class="form-control" value="">
                                            </div>
                                        </div>
                                        <div class="col-md-6 hidden-element">
                                            <div class="form-group">
                                                <label for="bpjs_tk_payslip"><?php echo e(__('BPJS Jaminan Kecelakaan Kerja')); ?></label>
                                                <input type="text" readonly="readonly" name="bpjs_jkk_payslip" id="bpjs_jkk_payslip" class="form-control" value="">
                                            </div>
                                        </div>
                                        <div class="col-md-6 hidden-element">
                                            <div class="form-group">
                                                <label for="bpjs_tk_payslip"><?php echo e(__('BPJS Jaminan Kematian')); ?></label>
                                                <input type="text" readonly="readonly" name="bpjs_jkm_payslip" id="bpjs_jkm_payslip" class="form-control" value="">
                                            </div>
                                        </div>
                                        <div class="col-md-6 hidden-element">
                                            <div class="form-group">
                                                <label for="bpjs_tk_payslip"><?php echo e(__('BPJS Jaminan Hari Tua')); ?></label>
                                                <input type="text" readonly="readonly" name="bpjs_jht_payslip" id="bpjs_jht_payslip" class="form-control" value="">
                                            </div>
                                        </div>
                                        <div class="col-md-6 hidden-element">
                                            <div class="form-group">
                                                <label for="bpjs_tk_payslip"><?php echo e(__('BPJS Pensiun')); ?></label>
                                                <input type="text" readonly="readonly" name="bpjs_pensiun_payslip" id="bpjs_pensiun_payslip" class="form-control" value="0">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                               <!-- <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('Pension Amount')); ?></label>
                                        <input type="text" name="pension_amount" id="pension_amount_payslip" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>-->

                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('Net Salary')); ?></label>
                                        <input type="text" readonly="readonly" name="net_salary" id="net_salary_payslip" class="form-control" value="0">
                                    </div>
                                </div>
                                

                                <div class="form-actions px-3"> <button type="submit" class="btn btn-warning"><i class="fa fa fa-check-square-o"></i> <?php echo e(trans('file.Pay')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="payment_model" tabindex="-1" role="dialog" aria-labelledby="basicModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="myModalLabel"><?php echo e(__('Payment Info')); ?>--- <span id="payment_month_year_show"></span></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    </div>
                    <div class="modal-body">
                        <span id="form_result"></span>
                        <form method="get" id="payment_form" class="form-horizontal">

                            <input type="hidden" name="payslip_type" id="payslip_type_payment">

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('Basic Salary')); ?></label> &nbsp;&nbsp;&nbsp;&nbsp; <span id="payment_type_error"></span>
                                        <input type="text" name="basic_salary" id="basic_salary_payment" class="form-control" value="0" readonly="readonly">
                                        <input type="hidden" value="" name="month_year" id="hidden_month_year_pay">
                                        <input type="hidden" value="" name="employee_id" id="employee_id_pay">
                                        <input type="hidden" value="" name="pension_amount" id="pension_amount">
                                    </div>
                                </div>

                                <div class="col-md-6 hide-element">
                                    <div class="form-group">
                                        <label for="worked_hours"><?php echo e(__('Total Hours(This Month)')); ?></label>
                                        <input type="text" readonly="readonly" name="worked_hours" id="worked_hours" class="form-control" value="0">
                                    </div>
                                </div>

                                <div class="col-md-6 hide-element">
                                    <div class="form-group">
                                        <label for="worked_amount"><?php echo e(__('Amount')); ?></label> <a href="#" data-toggle="popover" data-placement="top"
                                            data-content="If you don't set this month's amount, the last month's amount will be treated as this month"><i class="fa fa-exclamation-circle text-warning"
                                                aria-hidden="true"></i></a>
                                        <input type="text" readonly="readonly" name="worked_amount" id="worked_amount" class="form-control" value="0">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('Total Allowance')); ?></label> <a href="#" data-toggle="popover" data-placement="top"
                                            data-content="If you don't set this month's amount, the last month's amount will be treated as this month"><i class="fa fa-exclamation-circle text-warning"
                                                aria-hidden="true"></i></a>
                                        <input type="text" name="total_allowance" id="total_allowance_payment" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>
								
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('Tunjangan Jabatan')); ?></label> <a href="#" data-toggle="popover" data-placement="top"
                                            data-content="If you don't set this month's amount, the last month's amount will be treated as this month"><i class="fa fa-exclamation-circle text-warning"
                                                aria-hidden="true"></i></a>
                                        <input type="text" name="total_allowance" id="total_allowance_payment" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('Uang Kehadiran')); ?></label> <a href="#" data-toggle="popover" data-placement="top"
                                            data-content="If you don't set this month's amount, the last month's amount will be treated as this month"><i class="fa fa-exclamation-circle text-warning"
                                                aria-hidden="true"></i></a>
                                        <input type="text" name="total_allowance" id="total_allowance_payment" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(trans('Commissions')); ?></label> <a href="#" data-toggle="popover" data-placement="top"
                                            data-content="If you don't set this month's amount, 0 amount will be treated as this month"><i class="fa fa-exclamation-circle text-warning"
                                                aria-hidden="true"></i></a>
                                        <input type="text" name="total_commission" id="total_commission_payment" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('Total Overtime')); ?></label> <a href="#" data-toggle="popover" data-placement="top"
                                            data-content="If you don't set this month's amount, 0 amount will be treated as this month"><i class="fa fa-exclamation-circle text-warning"
                                                aria-hidden="true"></i></a>
                                        <input type="text" name="total_overtime" id="total_overtime_payment" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('Other Payment')); ?></label> <a href="#" data-toggle="popover" data-placement="top"
                                            data-content="If you don't set this month's amount, 0 amount will be treated as this month"><i class="fa fa-exclamation-circle text-warning"
                                                aria-hidden="true"></i></a>
                                        <input type="text" name="total_other_payment" id="total_other_payment_payment" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('Statutory deductions')); ?></label> <a href="#" data-toggle="popover" data-placement="top"
                                            data-content="If you don't set this month's amount, the last month's amount will be treated as this month"><i class="fa fa-exclamation-circle text-warning"
                                                aria-hidden="true"></i></a>
                                        <input type="text" name="total_deduction" id="total_deduction_payment" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('Monthly Payable')); ?></label>
                                        <input type="text" name="monthly_payable" id="monthly_payable" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('Loan Remaining')); ?></label>
                                        <input type="text" name="amount_remaining" id="amount_remaining" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('PPh')); ?></label>
                                        <input type="text" name="pph" id="pph" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('BPJS Kesehatan')); ?></label>
                                        <input type="text" name="bpjs_kesehatan" id="bpjs_kesehatan" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('BPJS Pensiun')); ?></label>
                                        <input type="text" name="bpjs_pensiun" id="bpjs_pensiun" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('BPJS Jaminan Hari Tua')); ?></label>
                                        <input type="text" name="bpjs_jht" id="bpjs_jht" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('BPJS Jaminan Kecelakaan Kerja')); ?></label>
                                        <input type="text" name="bpjs_jkk" id="bpjs_jkk" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('BPJS Jaminan Kematian')); ?></label>
                                        <input type="text" name="bpjs_jkm" id="bpjs_jkm" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('Potongan Kehadiran')); ?></label>
                                        <input type="text" name="attendance_cut" id="attendance_cut" class="form-control" value="0" readonly="readonly">
                                    </div>
                                </div>



                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('Net Salary')); ?></label>
                                        <input type="text" readonly="readonly" name="net_salary" id="net_salary_payment" class="form-control" value="0">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name"><?php echo e(__('Payment Amount')); ?></label>
                                        <input type="text" readonly="readonly" name="payment_amount" id="total_salary_payment" class="form-control">
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="form-group">
                                        <span><strong><?php echo e(trans('file.NOTE')); ?>:</strong>
                                            <?php echo e(__('Total Allowance,Commissions,Total Loan,Total Overtime,Statutory deductions,Other Payment, Pension are not editable.')); ?></span>
                                    </div>
                                </div>

                                <div class="form-actions"> <button type="submit" class="btn btn-primary"><i class="fa fa fa-check-square-o"></i> <?php echo e(trans('file.Pay')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade" id="salary_pdf" tabindex="-1" role="dialog" aria-labelledby="basicModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="myModalLabel"><?php echo e(__('PDF Slip Gaji')); ?>--- <span id="payment_month_year_show"></span></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    </div>
                    <div class="modal-body">
                        <div id="results"></div>
                        <div id="pdf_viewer"></div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="https://unpkg.com/pdfobject@2.2.12/pdfobject.min.js"></script>
    <script type="text/javascript">
        (function($) {
            "use strict";

            $(document).ready(function() {

                let date = $('.date');
                date.datepicker({
                    format: "MM-yyyy",
                    startView: "months",
                    minViewMode: 1,
                    autoclose: true,
                }).datepicker("setDate", new Date());

                fill_datatable();

                function fill_datatable(filter_company = '', filter_department = '', filter_month_year = '') {
                    $('#details_month_year').html($('#month_year').val());
                    let table_table = $('#pay_list-table').DataTable({
						
                        initComplete: function(settings, json) {
							console.log(json);
							$('#total_salary_sum').html(json.total_salary_sum);
							$('#total_monthly_pph').html(json.pph_monthly_sum);
							$('#total_bpjs_tk').html(json.bpjs_tk_sum);
							$('#total_bpjs_kes').html(json.bpjs_kes_sum);
							$('#total_bpjs_tk_comp').html(json.bpjs_tk_sum_comp);
							$('#total_bpjs_kes_comp').html(json.bpjs_kes_sum_comp);
                            this.api().columns([1]).every(function(data) {
                                console.log("DATA: ", data);
                                var column = this;
                                var select = $('<select><option value=""></option></select>')
                                    .appendTo($(column.footer()).empty())
                                    .on('change', function() {
                                        var val = $.fn.dataTable.util.escapeRegex(
                                            $(this).val()
                                        );

                                        column
                                            .search(val ? '^' + val + '$' : '', true, false)
                                            .draw();
                                    });

                                column.data().unique().sort().each(function(d, j) {
                                    select.append('<option value="' + d + '">' + d + '</option>');
                                    $('select').selectpicker('refresh');
                                });
                            });
                        },
                        responsive: true,
                        fixedHeader: {
                            header: true,
                            footer: true
                        },
                        processing: true,
                        serverSide: true,
                        ajax: {
                            url: "<?php echo e(route('payroll.index')); ?>",
                            data: {
                                filter_company: filter_company,
                                filter_department: filter_department,
                                filter_month_year: filter_month_year,
                                "_token": "<?php echo e(csrf_token()); ?>"
                            }
                        },

                        columns: [{
                                data: 'id',
                                orderable: false,
                                searchable: false
                            },
                            {
                                data: 'employee_name',
                                name: 'employee_name'
                            },
                            {
                                data: 'payslip_type',
                                name: 'payslip_type'
                            },
                            {
                                data: 'basic_salary',
                                name: 'basic_salary',
                                render: function(data) {
                                    if ('<?php echo e(config('variable.currency_format') == 'suffix'); ?>') {
                                        return data + ' <?php echo e(config('variable.currency')); ?>';
                                    } else {
                                        return '<?php echo e(config('variable.currency')); ?> ' + data;

                                    }
                                }
                            },
                            {
                                data: 'tunjangan_jabatan',
                                name: 'tunjangan_jabatan',
                                render: function(data) {
                                    if ('<?php echo e(config('variable.currency_format') == 'suffix'); ?>') {
                                        return data + ' <?php echo e(config('variable.currency')); ?>';
                                    } else {
                                        return '<?php echo e(config('variable.currency')); ?> ' + data;

                                    }
                                }
                            },
                            {
                                data: 'salary_kehadiran',
                                name: 'salary_kehadiran',
                                render: function(data) {
                                    if ('<?php echo e(config('variable.currency_format') == 'suffix'); ?>') {
                                        return data + ' <?php echo e(config('variable.currency')); ?>';
                                    } else {
                                        return '<?php echo e(config('variable.currency')); ?> ' + data;

                                    }
                                }
                            },
                            {
                                data: 'net_salary',
                                name: 'net_salary',
                                render: function(data) {
                                    if ('<?php echo e(config('variable.currency_format') == 'suffix'); ?>') {
                                        return data + ' <?php echo e(config('variable.currency')); ?>';
                                    } else {
                                        return '<?php echo e(config('variable.currency')); ?> ' + data;

                                    }
                                }
                            },
                            {
                                data: 'status',
                                name: 'status',
                                render: function(data) {
                                    if (data == 1) {
                                        return "<td><div class = 'badge badge-success'><?php echo e(trans('file.Paid')); ?></div>"
                                    } else {
                                        return "<td><div class = 'badge badge-danger'><?php echo e(trans('file.Unpaid')); ?></div>"
                                    }
                                }
                            },
                            {
                                data: 'action',
                                name: 'action',
                                orderable: false
                            }
                        ],


                        "order": [],
                        'language': {
                            'lengthMenu': '_MENU_ <?php echo e(__('records per page')); ?>',
                            "info": '<?php echo e(trans('file.Showing')); ?> _START_ - _END_ (_TOTAL_)',
                            "search": '<?php echo e(trans('file.Search')); ?>',
                            'paginate': {
                                'previous': '<?php echo e(trans('file.Previous')); ?>',
                                'next': '<?php echo e(trans('file.Next')); ?>'
                            }
                        },
                        'columnDefs': [{
                                "orderable": false,
                                'targets': [0],
                            },
                            {
                                'render': function(data, type, row, meta) {
                                    if (type == 'display') {
                                        data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                                    }

                                    return data;
                                },
                                'checkboxes': {
                                    'selectRow': true,
                                    'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>'
                                },
                                'targets': [0]
                            }
                        ],

                        'select': {
                            style: 'multi',
                            selector: 'td:first-child'
                        },
                        'lengthMenu': [
                            [10, 25, 50, -1],
                            [10, 25, 50, "All"]
                        ],
                        dom: '<"row"lfB>rtip',
                        buttons: [{
                                extend: 'pdf',
                                text: '<i title="export to pdf" class="fa fa-file-pdf-o"></i>',
                                exportOptions: {
                                    columns: ':visible:Not(.not-exported)',
                                    rows: ':visible'
                                },
                            },
                            {
                                extend: 'csv',
                                text: '<i title="export to csv" class="fa fa-file-text-o"></i>',
                                exportOptions: {
                                    columns: ':visible:Not(.not-exported)',
                                    rows: ':visible'
                                },
                            },
                            {
                                extend: 'print',
                                text: '<i title="print" class="fa fa-print"></i>',
                                exportOptions: {
                                    columns: ':visible:Not(.not-exported)',
                                    rows: ':visible'
                                },
                            },
                            {
                                extend: 'colvis',
                                text: '<i title="column visibility" class="fa fa-eye"></i>',
                                columns: ':gt(0)'
                            },
                        ],
                    });
                }

                new $.fn.dataTable.FixedHeader($('#pay_list-table').DataTable());

                $('#filter_form').on('submit', function(e) {
                    e.preventDefault();
                    var filter_company = $('#company_id').val();
                    var filter_department = $('#department_id').val();
                    var filter_month_year = $('#month_year').val();
                    if (filter_company !== '' && filter_department !== '' && filter_month_year !== '') {
                        $('#pay_list-table').DataTable().destroy();
                        fill_datatable(filter_company, filter_department, filter_month_year);
                    } else {
                        alert('<?php echo e(__('Select Both filter option')); ?>');
                    }
                });
            });

            $(document).on('click', '.exports', function(){
                let id = $(this).attr('id');
                let export_type = $(this).attr('data-export');
                let filter_month_year = $('#month_year').val();

                //target contains payslip.show
                // let target = '<?php echo e(route('paySlip.index')); ?>/' + id;
                let url = '<?php echo e(route('paySlip.show')); ?>?id='+id+'&export=pdf&filter_month_year='+filter_month_year;
                    $('#salary_pdf').modal('show');
                    var options = {
		                pdfOpenParams: {
			                navpanes: 1,
			                toolbar: 1,
			                statusbar: 1,
			                pagemode: "none",
			                view: "FitV",
		                },
		                height: "21rem",
		                forcePDFJS: false,
		                PDFJS_URL: "<?php echo e(asset('pdfjs/viewer.html')); ?>"
	                };
	                var myPDF = PDFObject.embed(url, "#pdf_viewer", options);
                    //var el = document.querySelector("#results");
                    //el.setAttribute("class", (myPDF) ? "success" : "fail");
                    //el.innerHTML = (myPDF) ? "PDF generate successful!" : "Uh-oh, PDF gagal ditampilkan.";
            });

            $(document).on('click', '.exports_xls', function(){
                let id = $(this).attr('id');
                let export_type = $(this).attr('data-export');
                let filter_month_year = $('#month_year').val();

                let target = '<?php echo e(route('paySlip.show')); ?>?id='+id+'&export=excel&filter_month_year='+filter_month_year;
                window.location = target;

            });

            function formatNumberWithDots(value) {
                return new Intl.NumberFormat('id-ID', { maximumFractionDigits: 0 }).format(value);
            }

            $(document).on('click', '.details', function() {
                //individual salary id from pay_list table
                let id = $(this).attr('id');
                let export_type = $(this).attr('data-export');
                let filter_month_year = $('#month_year').val();
                let currency_format = '<?php echo e(config('variable.currency_format')); ?>';

                //target contains payslip.show
                // let target = '<?php echo e(route('paySlip.index')); ?>/' + id;
                let target = '<?php echo e(route('paySlip.show')); ?>';

                $.ajax({
                    url: target,
                    // dataType: "json",
                    type: "GET",
                    data: {
                        id: id,
                        export: export_type,
                        filter_month_year: filter_month_year
                    },
                    success: function(result) {
                        console.log(result.data);
                        // console.log(result.data.allowances[0]);

                        $('#employee_username').html(result.data.employee_username);
                        $('#total_pph').html(formatNumberWithDots(result.data.pph_bulanan));
                        $('#bpjs_kesehatan').html(result.data.bpjs_kes);
                        $('#bpjs_pensiun').html(result.data.bpjs_pensiun);
                        $('#bpjs_jht').html(result.data.bpjs_jht);
                        $('#bpjs_jkk').html(result.data.bpjs_jkk);
                        $('#bpjs_jkm').html(result.data.bpjs_jkm);
                        $('#work_days').html(result.data.work_days);
                        $('#attendance_cut_amount').html(formatNumberWithDots(result.data.attendance_cut_amount));
                        $('#employee_full_name').html(result.data.employee_full_name);
                        if (result.data.employee_designation == '') {
                            $('#employee_designation').html(result.data.employee_designation);
                        } else {
                            $('#employee_designation').html(result.data.employee_designation + ', ');
                        }
                        $('#employee_department').html(result.data.employee_department);
                        $('#employee_join_date').html(result.data.employee_join_date);
                        $('#employee_id').attr("href", "<?php echo e(url('staff/employees/')); ?>/" + result.data.employee_id);
                        if (result.data.employee_pp == '') {
                            $('#employee_pp').html("<img src=<?php echo e(URL::to('/public')); ?>/uploads/profile_photos/avatar.jpg  width='100'  class='rounded-circle' />");
                        } else {
                            $('#employee_pp').html("<img src=<?php echo e(URL::to('/public')); ?>/uploads/profile_photos/" + result.data.employee_pp +
                                " width='100'  class='rounded-circle' />");
                        }
                        $('#pension_type').html(result.data.pension_type);

                        let total_allowance = 0;
                        $('#allowance_info').html('<tr><td>4</td><td><strong><?php echo e(trans('file.Total')); ?> Allowances:</strong> <span id="total_allowance" class="pull-right"><?php echo e(config('variable.currency')); ?> '+total_allowance+'</span></td></tr>');
                        (result.data.allowances).forEach(function(a) {
                            
                            if(a.is_taxable == 1)
                            {
                                total_allowance = total_allowance + parseFloat(a.allowance_amount*result.data.work_days);
                                $('#allowance_info').append('<tr><td></td><td>' + a.allowance_title + '<div class="float-right">' + formatNumberWithDots(a.allowance_amount) +
                                ' x '+result.data.work_days+'</div></td></tr>');
                            }
                            else
                            {
                                total_allowance = total_allowance + parseFloat(a.allowance_amount);
                                $('#allowance_info').append('<tr><td></td><td>' + a.allowance_title + '<div class="float-right">' + formatNumberWithDots(a.allowance_amount) +
                                '</div></td></tr>');
                            }
                        });

                        let total_commission = 0;
                        $('#commission_info').html('<tr><td>5</td><td><strong><?php echo e(trans('file.Total')); ?> Commission:</strong> <span id="total_allowance" class="pull-right"><?php echo e(config('variable.currency')); ?> '+total_commission+'</span></td></tr>');
                        (result.data.commissions).forEach(function(a) {
                            total_commission = total_commission + parseFloat(a.commission_amount);
                            $('#commission_info').append('<tr><td></td><td><strong>' + a.commission_title + '---</strong><span class="pull-right">' + formatNumberWithDots(a.commission_amount) +
                                '</span></td></tr>');
                        });

                        $('#loan_info').html('');
                        let total_loan = 0;
                        (result.data.loans).forEach(function(a) {
                            total_loan = total_loan + parseFloat(a.monthly_payable);
                            $('#loan_info').append('<tr>' +
                                '<td><strong>Total Loan---     </strong> <div class="float-right">' + formatNumberWithDots(a.loan_amount) + '</div></td>' +
                                '<td><strong>Monthly Payable---     </strong> <div class="float-right">' + a.monthly_payable + '</div></td>' +
                                '<td><strong>Installment Remaining---     </strong> <div class="float-right">' + a.time_remaining + '</div></td>' +
                                '<td><strong>Amount Remaining---     </strong> <div class="float-right">' + a.amount_remaining + '</div></td>' +
                                '</tr>');
                        });

                        let count = 0;
                        let total_overtime = 0;
                        (result.data.overtimes).forEach(function(a) {
                            count = count + 1;
                            total_overtime = total_overtime + (parseFloat(a.overtime_rate) * parseInt(a.overtime_hours));
                            $('#overtime_info').append(
                                '<tr>' +
                                '<td><strong>' + count + '</strong></td>' +
                                '<td><strong>' + a.overtime_title + '</strong></td>' +
                                '<td><strong>' + a.no_of_days + '</strong></td>' +
                                '<td><strong>' + a.overtime_hours + '</strong></td>' +
                                '<td><strong>' + a.overtime_rate + '</strong></td>' +
                                '</tr>'
                            );
                        });

                        let total_deduction = 0;
                        (result.data.deductions).forEach(function(a) {
                            total_deduction = total_deduction + parseFloat(a.deduction_amount);
                            $('#deduction_info').append('<tr><td><strong>' + a.deduction_title + '---</strong> <span class="float-right">' + formatNumberWithDots(a.deduction_amount) +
                                '</span></td></tr>');
                        });

                        let total_other_payment = 0;
                        (result.data.other_payments).forEach(function(a) {
                            total_other_payment = total_other_payment + parseFloat(a.other_payment_amount);
                            $('#other_payment_info').append('<tr><td><strong>' + a.other_payment_title + '---</strong><div class="float-right">' + formatNumberWithDots(a.other_payment_amount) +
                                '</div></td></tr>');
                        });

                        let total_salary = result.data.total_salary;

                        if (total_salary < 0) {
                            total_salary = 0;
                        }

                        if (result.data.payslip_type == 'Monthly') {

                            $('#payslip_type').html('<?php echo e(__('Monthly Payslip')); ?>');
                            $('#monthly_hourly').html('<?php echo e(__('Basic Salary')); ?>');
                            $('.hide-div').hide();
                            $('#hours_worked').html('');
                            $('#total_hours_worked').html('');
                            $('#hours_worked_amount').html('');
                            $('#total_hours_worked_amount').html('');
                        } else {
                            $('.hide-div').show();
                            $('#payslip_type').html('<?php echo e(__('Hourly Payslip')); ?>');
                            $('#monthly_hourly').html('<?php echo e(__('Per Hour Salary')); ?>');
                            $('#hours_worked').html('<?php echo e(__('Total Hours Worked This Month')); ?>');
                            $('#total_hours_worked').html(result.data.monthly_worked_hours);
                            $('#hours_worked_amount').html('<?php echo e(__('Total Amount')); ?>');
                            $('#total_hours_worked_amount').html(result.data.monthly_worked_amount);
                        }

                        if (currency_format == 'suffix') {

                            $('#basic_salary_amount').html(formatNumberWithDots(result.data.basic_salary) + ' <?php echo e(config('variable.currency')); ?>');
                            $('#tunjangan_jabatan_amount').html(formatNumberWithDots(result.data.tunjangan_jabatan) + ' <?php echo e(config('variable.currency')); ?>');
                            $('#salary_kehadiran_amount').html(formatNumberWithDots(result.data.salary_kehadiran) + ' <?php echo e(config('variable.currency')); ?>');
                            $('#pension_amount').html(formatNumberWithDots(result.data.pension_amount) + ' <?php echo e(config('variable.currency')); ?>');
                            $('#total_allowance').html(formatNumberWithDots(total_allowance) + ' <?php echo e(config('variable.currency')); ?>');
                            $('#total_commission').html(formatNumberWithDots(total_commission) + ' <?php echo e(config('variable.currency')); ?>');
                            $('#total_loan').html(formatNumberWithDots(total_loan) + ' <?php echo e(config('variable.currency')); ?>');
                            $('#total_overtime').html(formatNumberWithDots(total_overtime) + ' <?php echo e(config('variable.currency')); ?>');
                            $('#total_deduction').html(formatNumberWithDots(total_deduction) + ' <?php echo e(config('variable.currency')); ?>');
                            $('#total_other_payment').html(formatNumberWithDots(total_other_payment) + ' <?php echo e(config('variable.currency')); ?>');
                            $('#total_salary').html(total_salary + ' <?php echo e(config('variable.currency')); ?>');
                        } else {
                            $('#basic_salary_amount').html('<?php echo e(config('variable.currency')); ?> ' + formatNumberWithDots(result.data.basic_salary));
                            $('#tunjangan_jabatan_amount').html('<?php echo e(config('variable.currency')); ?> ' + formatNumberWithDots(result.data.tunjangan_jabatan));
                            $('#salary_kehadiran_amount').html('<?php echo e(config('variable.currency')); ?> ' + formatNumberWithDots(result.data.salary_kehadiran));
                            $('#pension_amount').html('<?php echo e(config('variable.currency')); ?> ' + formatNumberWithDots(result.data.pension_amount));
                            $('#total_allowance').html('<?php echo e(config('variable.currency')); ?> ' + formatNumberWithDots(total_allowance));
                            $('#total_commission').html('<?php echo e(config('variable.currency')); ?> ' + formatNumberWithDots(total_commission));
                            $('#total_loan').html('<?php echo e(config('variable.currency')); ?> ' + formatNumberWithDots(total_loan));
                            $('#total_overtime').html('<?php echo e(config('variable.currency')); ?> ' + formatNumberWithDots(total_overtime));
                            $('#total_deduction').html('<?php echo e(config('variable.currency')); ?> ' + formatNumberWithDots(total_deduction));
                            $('#total_other_payment').html('<?php echo e(config('variable.currency')); ?> ' + formatNumberWithDots(total_other_payment));
                            $('#total_salary').html('<?php echo e(config('variable.currency')); ?> ' + total_salary);
                        }

                        $('#salary_model').modal('show');
                    }
                });
            });

            $(document).on('click', '.payment_slip', function() {
                //individual salary id from pay_list table
                let id = $(this).attr('id');
                let filter_month_year = $('#month_year').val();
                let currency_format = '<?php echo e(config('variable.currency_format')); ?>';

                //target contains payslip.show
                // let target = '<?php echo e(route('paySlip.index')); ?>/' + id;
                let target = '<?php echo e(route('paySlip.show')); ?>';

                $.ajax({
                    url: target,
                    // dataType: "json",
                    type: "GET",
                    data: {
                        id: id,
                        filter_month_year: filter_month_year
                    },
                    success: function(result) {
                        console.log(result.employee);
                        $('.allowance').html('')

                        $('#basic_salary_payslip').val(result.data.basic_salary)
                        $('#tunjangan_jabatan_payslip').val(result.data.tunjangan_jabatan)
                        $('#salary_kehadiran_payslip').val(result.data.salary_kehadiran)
                        $('#pension_amount_payslip').val(result.data.pension_amount)
                        $('#net_salary_payslip').val(result.data.total_salary)

                        if (result.data.allowances.length > 0) {
                            result.data.allowances.forEach(element => {
                                $('.allowance').append(`
                                    <div class="col-md-6 hide-element">
                                        <div class="form-group">
                                            <label for="worked_hours"><?php echo e(__('${element.allowance_title}')); ?></label>
                                            <input type="text" readonly="readonly" name="worked_hours" id="allowance_details" class="form-control" value="${element.allowance_amount}">
                                        </div>
                                    </div>
                                `)
                            });
                        }

                        if (result.employee.setting && result.employee.setting != null) {
                            if (result.employee.setting && result.employee.setting.is_tax_include != undefined && result.employee.setting.is_tax_include != null && result.employee
                                .setting.is_tax_include == 1) {
                                $('#tax_pph_payslip').val("51000")
                            }

                            if (result.employee.setting.is_bpjs_kes_include != null && result.employee.setting.is_bpjs_kes_include == 1) {
                                $('#bpjs_payslip').val("60000")
                            }

                            if (result.employee.setting.is_bpjs_tk_include != null && result.employee.setting.is_bpjs_tk_include == 1) {
                                $('#bpjs_tk_payslip').val("120000")
                            }
                        }

                        $('#payslip_modal').modal('show');
                    }
                });
            });

            $(document).on('click', '.payment_slip_exp', function() {
                //individual salary id from pay_list table
                let id = $(this).attr('id');
                let filter_month_year = $('#month_year').val();
                let currency_format = '<?php echo e(config('variable.currency_format')); ?>';

                //target contains payslip.show
                // let target = '<?php echo e(route('paySlip.index')); ?>/' + id;
                let target = '<?php echo e(route('paySlip.show')); ?>';

                $.ajax({
                    url: target,
                    // dataType: "json",
                    type: "GET",
                    data: {
                        id: id,
                        filter_month_year: filter_month_year
                    },
                    success: function(result) {
                        console.log(result.employee);
                        $('.allowance').html('')

                        $('#basic_salary_payslip').val(result.data.basic_salary)
                        $('#pension_amount_payslip').val(result.data.pension_amount)
                        $('#net_salary_payslip').val(result.data.total_salary)
                        $('#tunjangan_jabatan_payslip').val(result.data.tunjangan_jabatan)
                        $('#salary_kehadiran_payslip').val(result.data.salary_kehadiran)
                        if (result.data.allowances.length > 0) {
                            result.data.allowances.forEach(element => {
                                $('.allowance').append(`
                                    <div class="col-md-6 hide-element">
                                        <div class="form-group">
                                            <label for="worked_hours"><?php echo e(__('${element.allowance_title}')); ?></label>
                                            <input type="text" readonly="readonly" name="worked_hours" id="allowance_details" class="form-control" value="${element.allowance_amount}">
                                        </div>
                                    </div>
                                `)
                            });
                        }

                        if (result.employee.setting && result.employee.setting != null) {
                            if (result.employee.setting && result.employee.setting.is_tax_include != undefined && result.employee.setting.is_tax_include != null && result.employee
                                .setting.is_tax_include == 1) {
                                $('#tax_pph_payslip').val("51000")
                            }

                            if (result.employee.setting.is_bpjs_kes_include != null && result.employee.setting.is_bpjs_kes_include == 1) {
                                $('#bpjs_payslip').val("60000")
                            }

                            if (result.employee.setting.is_bpjs_tk_include != null && result.employee.setting.is_bpjs_tk_include == 1) {
                                $('#bpjs_tk_payslip').val("120000")
                            }
                        } else {
							$('#tax_pph_payslip').val(result.data.pph_bulanan)
							$('#bpjs_kes_payslip').val(result.data.bpjs_kes)
							$('#bpjs_jkk_payslip').val(result.data.bpjs_jkk)
							$('#bpjs_jkm_payslip').val(result.data.bpjs_jkm)
							$('#bpjs_jht_payslip').val(result.data.bpjs_jht)
							$('#bpjs_pensiun_payslip').val(result.data.bpjs_pensiun)
						}

                        $('#payslip_modal').modal('show');
                    }
                });
            });

            $(document).on('click', '.generate_payment', function(event) {
                event.preventDefault();
                //individual salary id from pay_list table
                let id = $(this).attr('id');
                $('#payment_month_year_show').html($('#month_year').val());
                let filter_month_year = $('#month_year').val();

                //target contains payslip.show
                // let target = '<?php echo e(route('paySlip.index')); ?>/generate/' + id;
                let target = '<?php echo e(route('paySlip.generate')); ?>';

                $.ajax({
                    url: target,
                    // dataType: "json",
                    type: "GET",
                    data: {
                        id: id,
                        filter_month_year: filter_month_year
                    },
                    success: function(result) {
                        console.log(result.data);
                        if (result.data.payslip_type == 'Hourly') {
                            $('.hide-element').show();
                            $('#worked_hours').val(result.data.total_hours);
                            $('#worked_amount').val(result.data.worked_amount);
                        } else {
                            $('.hide-element').hide();
                            $('#worked_hours').val('');
                            $('#worked_amount').val('');
                        }
                        $('#hidden_month_year_pay').val(filter_month_year);
                        $('#payslip_type_payment').val(result.data.payslip_type);
                        $('#basic_salary_payment').val(result.data.basic_salary);
                        $('#total_allowance_payment').val(result.data.total_allowance);
                        $('#total_commission_payment').val(result.data.total_commission);
                        $('#monthly_payable').val(result.data.monthly_payable);
                        $('#amount_remaining').val(result.data.amount_remaining);
                        $('#total_deduction_payment').val(result.data.total_deduction);
                        $('#total_other_payment_payment').val(result.data.total_other_payment);
                        $('#total_overtime_payment').val(result.data.total_overtime);
                        $('#total_salary_payment').val(result.data.total_salary);
                        $('#net_salary_payment').val(result.data.total_salary);

                        $('#pph').val(result.data.pph_bulanan);
                        $('input#bpjs_kesehatan').val(result.data.bpjs_kes);
                        $('input#bpjs_pensiun').val(result.data.bpjs_pensiun);
                        $('input#bpjs_jht').val(result.data.bpjs_jht);
                        $('input#bpjs_jkk').val(result.data.bpjs_jkk);
                        $('input#bpjs_jkm').val(result.data.bpjs_jkm);
                        $('input#attendance_cut').val(result.data.attendance_cut_amount);

                        $('#pension_amount_payment').val(result.data.pension_amount);

                        $('#employee_id').val(result.data.employee);

                        $('#payment_model').modal('show');
                    }
                });
            });

            $('#payment_form').on('submit', function(event) {
                event.preventDefault();
                //individual salary id from pay_list table
                let id = $('#employee_id').val();

                $('#hidden_month_year').val($('#month_year').val());

                //target contains payslip.pay
                let target = '<?php echo e(route('paySlip.index')); ?>/pay/' + id;
                $.ajax({
                    url: target,
                    method: "POST",
                    data: new FormData(this),
                    contentType: false,
                    cache: false,
                    processData: false,
                    dataType: "json",
                    success: function(data) {
                        console.log(data);
                        let html = '';
                        if (data.payment_type_error) {
                            html = '<div class="alert alert-danger">' + data.payment_type_error + '</div>';
                            $('#payment_type_error').html(html).slideDown(300).delay(5000).slideUp(300);
                        }
                        if (data.error) {
                            html = '<div class="alert alert-danger">' + data.error + '</div>';
                        }
                        if (data.success) {
                            html = '<div class="alert alert-success">' + data.success + '</div>';
                            $('#pay_list-table').DataTable().ajax.reload();
                            $('#payment_model').modal('hide').delay(3000);
                        }
                        $('#bulk_payment_result').html(html).slideDown(300).delay(5000).slideUp(300);
                    }
                });

            });

            $('#payslip_form').on('submit', function(event) {
                event.preventDefault();
                //individual salary id from pay_list table
                let id = $('#employee_id').val();

                $('#hidden_month_year').val($('#month_year').val());

                //target contains payslip.pay
                let target = '<?php echo e(route('paySlip.index')); ?>/pay/' + id;
                let html = '';
                html = '<div class="alert alert-success">' + "Payslip success" + '</div>';
                $('#pay_list-table').DataTable().ajax.reload();
                $('#payslip_modal').modal('hide').delay(3000);
                // $.ajax({
                //     url: target,
                //     method: "POST",
                //     data: new FormData(this),
                //     contentType: false,
                //     cache: false,
                //     processData: false,
                //     dataType: "json",
                //     success: function(data) {
                //         console.log(data);
                //         let html = '';
                //         if (data.payment_type_error) {
                //             html = '<div class="alert alert-danger">' + data.payment_type_error + '</div>';
                //             $('#payment_type_error').html(html).slideDown(300).delay(5000).slideUp(300);
                //         }
                //         if (data.error) {
                //             html = '<div class="alert alert-danger">' + data.error + '</div>';
                //         }
                //         if (data.success) {
                //             html = '<div class="alert alert-success">' + data.success + '</div>';
                //             $('#pay_list-table').DataTable().ajax.reload();
                //             $('#payment_model').modal('hide').delay(3000);
                //         }
                //         $('#bulk_payment_result').html(html).slideDown(300).delay(5000).slideUp(300);
                //     }
                // });

            });

            $('#payroll_export').on('click', function(event) {
                event.preventDefault();
                var month_year = $("#month_year").val();
                var filter_company = $("#company_id").val();
                var filter_department = $("#department_id").val();
                let target = '<?php echo e(route('paySlip.export_excel')); ?>';
                window.location = target+'?month_year='+month_year+'&filter_company='+filter_company+'&filter_department='+filter_department;
            })

            $('#bulk_payment').on('click', function(event) {
                event.preventDefault();

                // var filter_company = $("#filter_company").val();
                // var filter_department = $("#filter_department").val();
                var month_year = $("#month_year").val();

                var allCheckboxId = [];
                let table = $('#pay_list-table').DataTable();
                allCheckboxId = table.rows({
                    selected: true
                }).ids().toArray();

                //console.log(allCheckboxId);

                let target = '<?php echo e(route('paySlip.bulk_pay')); ?>';

                $.ajax({
                    url: target,
                    method: "POST",
                    data: {
                        all_checkbox_id: allCheckboxId,
                        month_year: month_year
                    },
                    // data: new FormData(document.getElementById("filter_form")),
                    // contentType: false,
                    // cache: false,
                    // processData: false,
                    // dataType: "json",
                    success: function(data) {
                        console.log(data);
                        let html = '';
                        if (data.payment_type_error) {
                            html = '<div class="alert alert-danger">' + data.payment_type_error + '</div>';
                        }
                        if (data.error) {
                            html = '<div class="alert alert-danger">' + data.error + '</div>';
                        }
                        if (data.success) {
                            html = '<div class="alert alert-success">' + data.success + '</div>';
                        }
                        $('#bulk_payment_result').html(html).slideDown(300).delay(5000).slideUp(300);
                        $('#pay_list-table').DataTable().rows('.selected').deselect();
                        $('#pay_list-table').DataTable().ajax.reload();
                    }
                });

            });


            $('.dynamic').change(function() {
                if ($(this).val() !== '') {
                    let value = $(this).val();
                    let dependent = $(this).data('dependent');
                    let _token = $('input[name="_token"]').val();
                    $.ajax({
                        url: "<?php echo e(route('dynamic_department')); ?>",
                        method: "POST",
                        data: {
                            value: value,
                            _token: _token,
                            dependent: dependent
                        },
                        success: function(result) {
                            $('select').selectpicker("destroy");
                            $('#department_id').html(result);
                            $('.default_dept').prepend('<option value="0" selected><?php echo e(__('All Departments')); ?></option>');
                            $('select').selectpicker();
                        }
                    });
                }
            });

            $('.payment_dynamic').change(function() {
                if ($(this).val() !== '') {
                    let value = $(this).val();
                    let dependent = $(this).data('dependent');
                    let _token = $('input[name="_token"]').val();
                    $.ajax({
                        url: "<?php echo e(route('dynamic_department')); ?>",
                        method: "POST",
                        data: {
                            value: value,
                            _token: _token,
                            dependent: dependent
                        },
                        success: function(result) {
                            $('select').selectpicker("destroy");
                            $('#payment_department_id').html(result);
                            $('.payment_default_dept').prepend('<option value="0" selected><?php echo e(__('All Departments')); ?></option>');
                            $('select').selectpicker();
                        }
                    });
                }
            });


            $(document).on('click', '.delete', function() {
                //individual salary id from pay_list table
                let id = $(this).attr('id');


                $.ajax({
                    url: "<?php echo e(route('paySlip.index')); ?>/delete/" + id,
                    success: function(data) {
                        let html = '';
                        if (data.error) {
                            html = '<div class="alert alert-danger">' + data.error + '</div>';
                        }
                        if (data.success) {
                            html = '<div class="alert alert-success">' + data.success + '</div>';
                        }
                        $('#pay_list-table').DataTable().ajax.reload();
                        $('#general_result').html(html).slideDown(300).delay(5000).slideUp(300);
                    }
                });
            });



            $('.close').on('click', function() {
                $('#allowance_info').html('');
                $('#commission_info').html('');
                $('#loan_info').html('');
                $('#deduction_info').html('');
                $('#overtime_info').html('');
                $('#other_payment_info').html('');
                $('#total_salary').html('');
                $('#total_deduction').html('');
                $('#total_allowance').html('');
                $('#total_loan').html('');
                $('#total_overtime').html('');
                $('#total_other_payment').html('');
                $('#total_commission').html('');
                $('#pay_list-table').DataTable().ajax.reload();

            });
        })(jQuery);


        $(document).ready(function() {
            $('[data-toggle="popover"]').popover();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/credibug/timas.credibug.cloud/resources/views/salary/pay_list/index.blade.php ENDPATH**/ ?>