$('#employee_reimbursement-table').DataTable().clear().destroy();
var date = $('.date');
date.datepicker({
    format: '<?php echo e(env('
    Date_Format_JS ')); ?>',
    autoclose: true,
    todayHighlight: true
});




let table_table = $('#employee_reimbursement-table').DataTable({
            responsive: true,
            fixedHeader: {
                header: true,
                footer: true
            },
            processing: true,
            serverSide: true,
            ajax: {
                url: "<?php echo e(route('employee_reimbursement.index', $employee->id)); ?>",
            },

            columns: [
                    {
                        data: 'reimbursement_type',
                        name: 'reimbursement_type',
                    },
                    {
                        data: 'company',
                        name: 'company',
                    },
                    {
                        data: 'employee',
                        name: 'employee',
                    },
                    {
                        data: 'amount',
                        name: 'amount',
                    },
                    {
                        data: 'status',
                        name: 'status',
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false
                    }
                ],
                "order": [],
                'language': {
                    'lengthMenu': '_MENU_ <?php echo e(__('records per page ')); ?>',
                    "info": '<?php echo e(__('Showing ')); ?> _START_ - _END_ (_TOTAL_)',
                    "search": '<?php echo e(__('Search ')); ?>',
                    'paginate': {
                        'previous': '<?php echo e(__('Previous ')); ?>',
                        'next': '<?php echo e(__('Next ')); ?>'
                    }
                },
                'columnDefs': [{
                    "orderable": false,
                    'targets': [0, 5],
                }, ],


                'select': {
                    style: 'multi',
                    selector: 'td:first-child'
                },
                'lengthMenu': [
                    [10, 25, 50, -1],
                    [10, 25, 50, "All"]
                ],

            }); new $.fn.dataTable.FixedHeader(table_table);

            $(document).on('click', '.show_reimbursement', function () {

                let id = $(this).attr('id');
        
                let target = '<?php echo e(route('employee_reimbursement.details')); ?>/' + id;
        
                $.ajax({
                    url: target,
                    dataType: "json",
                    success: function (result) {
                        $('#reimbursement_type_show').html(result.data.reimbursement_type.name);
                        $('#reimbursement_employee_show').html(result.data.employee.first_name + ' ' + result.data.employee.last_name);
                        $('#reimbursement_company_show').html(result.data.employee.company.company_name);
                        $('#reimbursement_amount_show').html(result.data.amount_formatted);
                        $('#reimbursement_description_show').html(result.data.description);
                        $('#reimbursement_status_show').html(result.data.status);
                        $('#reimbursement_attachment_show').attr('src', result.data.attachment_url);
        
                        $('#employee_reimbursement_modal').modal('show');
                        $('.modal-title').text("<?php echo e(__('Reimbursement Info')); ?>");
                    }
                });
            });
<?php /**PATH /home/credibug/timas.credibug.cloud/resources/views/employee/core_hr/reimbursement/index_js.blade.php ENDPATH**/ ?>