<?php $__env->startSection('content'); ?>
    <section>
        <div class="container-fluid">
            <div class="card mb-4">
                <div class="card-header with-border">
                    <h3 class="card-title text-center"> <?php echo e(__('Full Report Attendance')); ?> </h3>
                </div>
                <div class="card-body">
                    <a href="<?php echo e(route('report_attendance.export')); ?>"> <button class="btn btn-success"><i
                                class="fa fa-file"></i>
                            <?php echo e(__('Download Excel')); ?>

                        </button> </a>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table id="report_attendance-table" class="table ">
            </table>
        </div>

    </section>
    <script type="text/javascript">
        (function($) {
            "use strict";

            fill_datatable();

            function fill_datatable() {
                $.ajax({
                    url: "<?php echo e(route('full_report_attendance.header')); ?>",
                    data: {
                        date: "<?php echo e($date); ?>",
                        "_token": "<?php echo e(csrf_token()); ?>",
                    },
                    success: function(data) {
                        var lastMonth = getLastMonth()
                        var columns = [];
                        columns.push({
                            "data": "employee_name",
                            "title": "Employee"
                        })
                        columns.push({
                            "data": "remaining_leave_last_month",
                            "title": "Remaining Leaves " + lastMonth
                        })
                        columns.push({
                            "data": "department",
                            "title": "Department"
                        })
                        for (var i in data['dates']) {
                            columns.push({
                                "data": data['dates'][i],
                                "title": data['dates'][i]
                            })
                        }
                        columns.push({
                            "data": "total_s",
                            "title": "Total S"
                        })
                        columns.push({
                            "data": "total_i",
                            "title": "Total I"
                        })
                        columns.push({
                            "data": "total_c",
                            "title": "Total C"
                        })
                        columns.push({
                            "data": "total_m",
                            "title": "Total M"
                        })
                        columns.push({
                            "data": "total_c1",
                            "title": "Total C1"
                        })
                        columns.push({
                            "data": "total_c2",
                            "title": "Total C2"
                        })
                        columns.push({
                            "data": "total_c3",
                            "title": "Total C3"
                        })
                        columns.push({
                            "data": "total_c4",
                            "title": "Total C4"
                        })
                        columns.push({
                            "data": "total_dl",
                            "title": "Total DL"
                        })
                        columns.push({
                            "data": "total_ik1",
                            "title": "Total IK1"
                        })
                        columns.push({
                            "data": "total_ik2",
                            "title": "Total IK2"
                        })
                        columns.push({
                            "data": "total_it1",
                            "title": "Total IT1"
                        })
                        columns.push({
                            "data": "total_it2",
                            "title": "Total IT2"
                        })
                        columns.push({
                            "data": "total_ip",
                            "title": "Total IP"
                        })
                        columns.push({
                            "data": "total_ta1",
                            "title": "Total TA1"
                        })
                        columns.push({
                            "data": "total_ta2",
                            "title": "Total TA2"
                        })
                        columns.push({
                            "data": "total_ta3",
                            "title": "Total TA3"
                        })
                        columns.push({
                            "data": "total_dis",
                            "title": "Total DIS"
                        })
                        columns.push({
                            "data": "total_pg",
                            "title": "Total PG"
                        })
                        columns.push({
                            "data": "remaining_leave",
                            "title": "Remaining Leaves"
                        })
                        let holidays = data['holidays'];
                        let table_table = $('#report_attendance-table').DataTable({
                            processing: true,
                            serverSide: true,
                            ajax: {
                                url: "<?php echo e(url('timesheet/full_report_attendances/data')); ?>",
                                type: 'POST',
                                data: {
                                    company_id: "<?php echo e($companies); ?>",
                                    date: "<?php echo e($date); ?>",
                                    "_token": "<?php echo e(csrf_token()); ?>"
                                },
                            },
                            columns: columns,
                            createdRow: (row, data, dataIndex, cells) => {
                                holidays.forEach(element => {
                                    $(cells[element]).css('background-color', '#FFFF00')
                                });
                            },
                            'language': {
                                'lengthMenu': '_MENU_ <?php echo e(__('records per page')); ?>',
                                "info": '<?php echo e(trans('file.Showing')); ?> _START_ - _END_ (_TOTAL_)',
                                "search": '<?php echo e(trans('file.Search')); ?>',
                                'paginate': {
                                    'previous': '<?php echo e(trans('file.Previous')); ?>',
                                    'next': '<?php echo e(trans('file.Next')); ?>'
                                }
                            },
                            'lengthMenu': [
                                [10, 25, 50, -1],
                                [10, 25, 50, "All"]
                            ],
                            scrollY: "400px",
                            scrollX: true,
                            scrollCollapse: true,
                            paging: false,
                            dom: 'Bfrtip',
                            buttons: [{
                                text: 'Excel',
                                extend: 'excelHtml5'
                            }]
                        });
                    }
                });
            }

            function getLastMonth() {
                const monthNames = ["January", "February", "March", "April", "May", "June",
                    "July", "August", "September", "October", "November", "December"
                ];

                var date = "<?php echo e($date); ?>";
                let d;
                if (date == undefined) {
                    d = new Date();
                } else {
                    var dates = date.split("-");
                    d = new Date(parseInt(dates[0]), parseInt(dates[1], 10) - 1, parseInt(dates[2], 10));
                }
                if (d.getMonth == 0) {
                    return "December";
                }
                return monthNames[d.getMonth() - 1];
            }
        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u1606895/public_html/hr-timas/resources/views/timesheet/report_attendances/full.blade.php ENDPATH**/ ?>