<?php $__env->startSection('content'); ?>
    <section>

        <div class="container-fluid"><span id="general_result"></span></div>


        <div class="container-fluid mb-3">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('modify-details-employee')): ?>
                <button type="button" class="btn btn-danger" name="bulk_delete" id="bulk_delete"><i
                        class="fa fa-minus-circle"></i> <?php echo e(__('Bulk delete')); ?></button>
            <?php endif; ?>
            <button class="btn btn-primary" type="button" data-toggle="collapse" data-target="#collapseExample"
                aria-expanded="false" aria-controls="collapseExample">
                <i class="fa fa-filter" aria-hidden="true"></i> Filter
            </button>
            <a href="<?php echo e(route('employees.exportLeaves')); ?>">
                <button id="btn-export-leaves" class="btn btn-success" type="button">
                    <i class="fa fa-download" aria-hidden="true"></i> Export Employee Leaves
                </button>
            </a>
        </div>
        <div class="col-12">
            <!-- Filtering -->
            <div class="collapse" id="collapseExample">
                <div class="card card-body">
                    <form action="" method="GET" id="filter_form">
                        <div class="row">
                            <!-- Company -->
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="text-bold"><strong><?php echo e(trans('file.Company')); ?></strong></label>
                                    <select name="company_id" id="company_id_filter"
                                        class="form-control selectpicker dynamic" data-live-search="true"
                                        data-live-search-style="contains" data-shift_name="shift_name"
                                        data-dependent="department_name"
                                        title="<?php echo e(__('Selecting', ['key' => trans('file.Company')])); ?>...">
                                        <option value=""></option>
                                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($company->id); ?>"><?php echo e($company->company_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <!--/ Company-->

                            <!-- Department-->
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="text-bold"><b><?php echo e(trans('file.Department')); ?></b></label>
                                    <select name="department_id" id="department_id_filter"
                                        class="selectpicker form-control designationFilter" data-live-search="true"
                                        data-live-search-style="contains" data-designation_name="designation_name"
                                        title="<?php echo e(__('Selecting', ['key' => trans('file.Department')])); ?>...">
                                    </select>
                                </div>
                            </div>
                            <!--/ Department-->

                            <!-- Designation -->
                            <div class="col-md-3 form-group">
                                <label class="text-bold"><b><?php echo e(trans('file.Designation')); ?></b></label>
                                <select name="designation_id" id="designation_id_filter" class="selectpicker form-control"
                                    data-live-search="true" data-live-search-style="contains"
                                    title="<?php echo e(__('Selecting', ['key' => trans('file.Designation')])); ?>...">
                                </select>
                            </div>
                            <!--/ Designation -->

                            <!-- Office Shift -->
                            <div class="col-md-2 form-group">
                                <label class="text-bold"><b><?php echo e(__('Office Shift')); ?></b></label>
                                <select name="office_shift_id" id="office_shift_id_filter" class="selectpicker form-control"
                                    data-live-search="true" data-live-search-style="contains"
                                    title="<?php echo e(__('Selecting Office Shift')); ?>...">
                                </select>
                            </div>
                            <!--/ Office Shift -->

                            <div class="col-md-1">
                                <label class="text-bold"></label><br>
                                <button type="button" class="btn btn-dark" id="filterSubmit">
                                    <i class="fa fa-arrow-right" aria-hidden="true"></i> &nbsp; GET
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!--/ Filtering -->
        </div>


        <div class="table-responsive">
            <table id="employee-table" class="table ">
                <thead>
                    <tr>
                        <th class="not-exported"></th>
                        <th><?php echo e(trans('file.Employee')); ?></th>
                        <th><?php echo e(trans('file.Company')); ?></th>
                        <th><?php echo e(trans('file.Contact')); ?></th>
                        <th><?php echo e(trans('file.Status')); ?></th>
                        <th class="not-exported"><?php echo e(trans('file.action')); ?></th>
                    </tr>
                </thead>

            </table>
        </div>
    </section>

    <div id="confirmModal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 class="modal-title"><?php echo e(trans('file.Confirmation')); ?></h2>
                    <button type="button" class="employee-close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <h4 align="center" style="margin:0;"><?php echo e(__('Are you sure you want to remove this data?')); ?></h4>
                </div>
                <div class="modal-footer">
                    <button type="button" name="ok_button" id="ok_button"
                        class="btn btn-danger"><?php echo e(trans('file.OK')); ?></button>
                    <button type="button" class="close btn-default"
                        data-dismiss="modal"><?php echo e(trans('file.Cancel')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <div id="confirmModalAcc" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 class="modal-title"><?php echo e(trans('file.Confirmation')); ?></h2>
                    <button type="button" class="employee-close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <h4 align="center" style="margin:0;"><?php echo e(__('Are you sure you want to accept this data?')); ?></h4>
                </div>
                <div class="modal-footer">
                    <button type="button" name="ok_button" id="ok_button_acc"
                        class="btn btn-danger"><?php echo e(trans('file.OK')); ?></button>
                    <button type="button" class="close btn-default"
                        data-dismiss="modal"><?php echo e(trans('file.Cancel')); ?></button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">
        $(document).ready(function() {

            var date = $('.date');
            date.datepicker({
                format: '<?php echo e(env('Date_Format_JS')); ?>',
                autoclose: true,
                todayHighlight: true
            });

            var table_table = $('#employee-table').DataTable({
                initComplete: function() {
                    this.api().columns([2, 4]).every(function() {
                        var column = this;
                        var select = $('<select><option value=""></option></select>')
                            .appendTo($(column.footer()).empty())
                            .on('change', function() {
                                var val = $.fn.dataTable.util.escapeRegex(
                                    $(this).val()
                                );

                                column
                                    .search(val ? '^' + val + '$' : '', true, false)
                                    .draw();
                            });

                        column.data().unique().sort().each(function(d, j) {
                            select.append('<option value="' + d + '">' + d +
                                '</option>');
                            $('select').selectpicker('refresh');
                        });
                    });
                },
                responsive: true,
                fixedHeader: {
                    header: true,
                    footer: true
                },
                processing: true,
                serverSide: true,
                ajax: {
                    url: "<?php echo e(route('employees.inactive')); ?>",
                    type: 'GET',
                    data: function(d) {
                        d.company_id = $("#company_id_filter").val();
                        d.department_id = $('#department_id_filter').val();
                        d.designation_id = $('#designation_id_filter').val();
                        d.office_shift_id = $('#office_shift_id_filter').val();
                    }
                },

                columns: [

                    {
                        data: 'id',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'name',
                        name: 'name',

                    },
                    {
                        data: 'company',
                        name: 'company',
                    },
                    {
                        data: 'contacts',
                        name: 'contacts',
                    },
                    {
                        data: 'status',
                        name: 'status',
                        render: function(data) {
                            if (data == '1') {
                                return "<td><div class = 'badge badge-success'><?php echo e(__('Active')); ?></div>"
                            } else {
                                return "<td><div class = 'badge badge-danger'><?php echo e(__('Inactive')); ?></div>"
                            }
                        }
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false
                    }
                ],


                "order": [],
                'language': {
                    'lengthMenu': '_MENU_ <?php echo e(__('records per page')); ?>',
                    "info": '<?php echo e(trans('file.Showing')); ?> _START_ - _END_ (_TOTAL_)',
                    "search": '<?php echo e(trans('file.Search')); ?>',
                    'paginate': {
                        'previous': '<?php echo e(trans('file.Previous')); ?>',
                        'next': '<?php echo e(trans('file.Next')); ?>'
                    }
                },
                'columnDefs': [{
                        "orderable": false,
                        'targets': [0, 4],
                        "className": "text-left"
                    },
                    {
                        'render': function(data, type, row, meta) {
                            if (type == 'display') {
                                data =
                                    '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label class="text-bold"></label></div>';
                            }

                            return data;
                        },
                        'checkboxes': {
                            'selectRow': true,
                            'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label class="text-bold"></label></div>'
                        },
                        'targets': [0]
                    }
                ],


                'select': {
                    style: 'multi',
                    selector: 'td:first-child'
                },
                'lengthMenu': [
                    [10, 25, 50, -1],
                    [10, 25, 50, "All"]
                ],
                dom: '<"row"lfB>rtip',
                buttons: [{
                        extend: 'pdf',
                        text: '<i title="export to pdf" class="fa fa-file-pdf-o"></i>',
                        exportOptions: {
                            columns: ':visible:Not(.not-exported)',
                            rows: ':visible'
                        },
                    },
                    {
                        extend: 'csv',
                        text: '<i title="export to csv" class="fa fa-file-text-o"></i>',
                        exportOptions: {
                            columns: ':visible:Not(.not-exported)',
                            rows: ':visible'
                        },
                    },
                    // {
                    //     extend: 'csv',
                    //     text: '<i title="export for device" class="fa fa-tablet"></i>',
                    //     className: 'export-for-device',
                    //     exportOptions: {
                    //         columns: [1,2],
                    //         rows: ':visible',
                    //         format: {
                    //             body: function ( data, row, column, node ) {
                    //                 if (column === 0) {
                    //                     var id = data.match(/<span>Staff Id: (.*?)<\/span>/)[1];
                    //                     name = data.match(/<[a][^>]*>(.+?)<\/[a]>/)[1];
                    //                     return id;
                    //                 }
                    //                 else {
                    //                     return name;
                    //                 }
                    //             }
                    //         }
                    //     },
                    //     customize: function (csv) {
                    //         var csvRows = csv.split('\n');
                    //         csvRows[0] = csvRows[0].replace(['"Employee"', '"Company"'], ['"Staff Id"','"Name"']);
                    //         return csvRows.join('\n');
                    //     }
                    // },
                    {
                        extend: 'print',
                        text: '<i title="print" class="fa fa-print"></i>',
                        exportOptions: {
                            columns: ':visible:Not(.not-exported)',
                            rows: ':visible'
                        },
                    },
                    {
                        extend: 'colvis',
                        text: '<i title="column visibility" class="fa fa-eye"></i>',
                        columns: ':gt(0)'
                    },
                ],
            });
            new $.fn.dataTable.FixedHeader(table_table);

        });


        //-------------- Filter -----------------------

        $('#filterSubmit').on("click", function(e) {
            $('#employee-table').DataTable().draw(true);
            //$('#filter_form')[0].reset();
            //$('select').selectpicker('refresh');
        });
        //--------------/ Filter ----------------------


        $('#create_record').click(function() {

            $('.modal-title').text("Add Employee");
            $('#action_button').val('<?php echo e(trans('file.Add')); ?>');
            $('#action').val('<?php echo e(trans('file.Add')); ?>');
            $('#formModal').modal('show');
        });

        $('#sample_form').on('submit', function(event) {
            event.preventDefault();
            // var attendance_type = $("#attendance_type").val();
            // console.log(attendance_type);

            $.ajax({
                url: "<?php echo e(route('employees.store')); ?>",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                cache: false,
                processData: false,
                dataType: "json",
                success: function(data) {
                    console.log(data);
                    var html = '';
                    if (data.errors) {
                        html = '<div class="alert alert-danger">';
                        for (var count = 0; count < data.errors.length; count++) {
                            html += '<p>' + data.errors[count] + '</p>';
                        }
                        html += '</div>';
                    }
                    if (data.error) {
                        html = '<div class="alert alert-danger">' + data.error + '</div>';
                    }
                    if (data.success) {
                        html = '<div class="alert alert-success">' + data.success + '</div>';
                        $('#sample_form')[0].reset();
                        $('select').selectpicker('refresh');
                        $('.date').datepicker('update');
                        $('#employee-table').DataTable().ajax.reload();
                    }
                    $('#form_result').html(html).slideDown(300).delay(2000).slideUp(300);
                }
            });
        });


        let employee_delete_id;

        $(document).on('click', '.delete', function() {
            employee_delete_id = $(this).attr('id');
            $('#confirmModal').modal('show');
            $('.modal-title').text('<?php echo e(__('DELETE Record')); ?>');
            $('#ok_button').text('<?php echo e(trans('file.OK')); ?>');

        });

        let employee_acc_id;

        $(document).on('click', '.accept', function() {
            employee_acc_id = $(this).attr('id');
            $('#confirmModalAcc').modal('show');
            $('.modal-title').text('<?php echo e(__('ACCEPT Record')); ?>');
            $('#ok_button_acc').text('<?php echo e(trans('file.OK')); ?>');

        });


        $(document).on('click', '#bulk_delete', function() {

            var id = [];
            let table = $('#employee-table').DataTable();
            id = table.rows({
                selected: true
            }).ids().toArray();
            if (id.length > 0) {
                if (confirm('<?php echo e(__('Delete Selection', ['key' => trans('file.Employee')])); ?>')) {
                    $.ajax({
                        url: '<?php echo e(route('mass_delete_employees')); ?>',
                        method: 'POST',
                        data: {
                            employeeIdArray: id
                        },
                        success: function(data) {
                            if (data.success) {
                                html = '<div class="alert alert-success">' + data.success + '</div>';
                            }
                            if (data.error) {
                                html = '<div class="alert alert-danger">' + data.error + '</div>';
                            }
                            table.ajax.reload();
                            table.rows('.selected').deselect();
                            $('#general_result').html(html).slideDown(300).delay(5000).slideUp(300);

                        }

                    });
                }
            } else {
                alert('<?php echo e(__('Please select atleast one checkbox')); ?>');
            }
        });


        $('#close').click(function() {
            $('#sample_form')[0].reset();
            $('select').selectpicker('refresh');
            $('.date').datepicker('update');
            $('#employee-table').DataTable().ajax.reload();
        });

        $('#ok_button').click(function() {
            let target = "<?php echo e(route('employees.index')); ?>/" + employee_delete_id + '/delete';
            $.ajax({
                url: target,
                beforeSend: function() {
                    $('#ok_button').text('<?php echo e(trans('file.Deleting...')); ?>');
                },
                success: function(data) {
                    if (data.success) {
                        html = '<div class="alert alert-success">' + data.success + '</div>';
                    }
                    if (data.error) {
                        html = '<div class="alert alert-danger">' + data.error + '</div>';
                    }
                    setTimeout(function() {
                        $('#general_result').html(html).slideDown(300).delay(5000).slideUp(300);
                        $('#confirmModal').modal('hide');
                        $('#employee-table').DataTable().ajax.reload();
                    }, 2000);
                }
            })
        });

        $('#ok_button_acc').click(function() {
            let target = "<?php echo e(route('employees.index')); ?>/" + employee_acc_id + '/accept';
            $.ajax({
                url: target,
                beforeSend: function() {
                    $('#ok_button').text('<?php echo e(__('Accepting')); ?>');
                },
                success: function(data) {
                    if (data.success) {
                        html = '<div class="alert alert-success">' + data.success + '</div>';
                    }
                    if (data.error) {
                        html = '<div class="alert alert-danger">' + data.error + '</div>';
                    }
                    setTimeout(function() {
                        $('#general_result').html(html).slideDown(300).delay(5000).slideUp(300);
                        $('#confirmModalAcc').modal('hide');
                        $('#employee-table').DataTable().ajax.reload();
                    }, 2000);
                }
            })
        });




        $('#confirm_pass').on('input', function() {

            if ($('input[name="password"]').val() != $('input[name="password_confirmation"]').val())
                $("#divCheckPasswordMatch").html('<?php echo e(__('Password does not match! please type again')); ?>');
            else
                $("#divCheckPasswordMatch").html('<?php echo e(__('Password matches!')); ?>');

        });


        $('.dynamic').change(function() {
            if ($(this).val() !== '') {
                let value = $(this).val();
                let dependent = $(this).data('dependent');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "<?php echo e(route('dynamic_department')); ?>",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        dependent: dependent
                    },
                    success: function(result) {

                        $('select').selectpicker("destroy");
                        $('#department_id').html(result);
                        $('select').selectpicker();

                    }
                });
            }
        });


        $('.dynamic').change(function() {
            if ($(this).val() !== '') {
                let value = $(this).val();
                let dependent = $(this).data('shift_name');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "<?php echo e(route('dynamic_office_shifts')); ?>",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        dependent: dependent
                    },
                    success: function(result) {
                        $('select').selectpicker("destroy");
                        $('#office_shift_id').html(result);
                        $('select').selectpicker();
                    }
                });
            }
        });

        $('.following_company').change(function() {
            if ($(this).val() !== '') {
                let value = $(this).val();
                let dependent = $(this).data('following_company');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "<?php echo e(route('dynamic_employee')); ?>",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        dependent: dependent
                    },
                    success: function(result) {
                        $('select').selectpicker("destroy");
                        $('#following_employee_id').html(result);
                        $('select').selectpicker();
                    }
                });
            }
        });

        $('.designation').change(function() {
            if ($(this).val() !== '') {
                let value = $(this).val();
                let designation_name = $(this).data('designation_name');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "<?php echo e(route('dynamic_designation_department')); ?>",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        designation_name: designation_name
                    },
                    success: function(result) {
                        $('select').selectpicker("destroy");
                        $('#designation_id').html(result);
                        $('select').selectpicker();

                    }
                });
            }
        });


        // Login Type Change
        // $('#login_type').change(function() {
        //     var login_type = $('#login_type').val();
        //     if (login_type=='ip') {
        //         data = '<label class="text-bold"><?php echo e(__('IP Address')); ?> <span class="text-danger">*</span></label>';
        //         data += '<input type="text" name="ip_address" id="ip_address" placeholder="Type IP Address" required class="form-control">';
        //         $('#ipField').html(data)
        //     }else{
        //         $('#ipField').empty();
        //     }
        // });



        //--------  Filter  ---------

        // Company--> Department
        $('.dynamic').change(function() {
            if ($(this).val() !== '') {
                let value = $('#company_id_filter').val();
                let dependent = $(this).data('dependent');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "<?php echo e(route('dynamic_department')); ?>",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        dependent: dependent
                    },
                    success: function(result) {

                        $('select').selectpicker("destroy");
                        $('#department_id_filter').html(result);
                        $('select').selectpicker();

                    }
                });
            }
        });

        //Department--> Designation
        $('.designationFilter').change(function() {
            if ($(this).val() !== '') {
                // let value = $(this).val();
                // let value = $('#company_id_filter').val();
                let value = $('#department_id_filter').val();
                let designation_name = $(this).data('designation_name');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "<?php echo e(route('dynamic_designation_department')); ?>",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        designation_name: designation_name
                    },
                    success: function(result) {
                        $('select').selectpicker("destroy");
                        $('#designation_id_filter').html(result);
                        $('select').selectpicker();

                    }
                });
            }
        });

        //Company--> Office Shift
        $('.dynamic').change(function() {
            if ($(this).val() !== '') {
                // let value = $(this).val();
                let value = $('#company_id_filter').val();
                let dependent = $(this).data('shift_name');
                let _token = $('input[name="_token"]').val();
                $.ajax({
                    url: "<?php echo e(route('dynamic_office_shifts')); ?>",
                    method: "POST",
                    data: {
                        value: value,
                        _token: _token,
                        dependent: dependent
                    },
                    success: function(result) {
                        $('select').selectpicker("destroy");
                        $('#office_shift_id_filter').html(result);
                        $('select').selectpicker();
                    }
                });
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u1606895/public_html/hr-timas/resources/views/employee/inactive.blade.php ENDPATH**/ ?>