
<?php $__env->startSection('content'); ?>
    <section>
        <div class="container-fluid">
            <div class="d-flex justify-content-between mb-30px">
                <div>
                    <h1 class="thin-text"><?php echo e(trans('file.Welcome')); ?> <?php echo e(auth()->user()->username); ?></h1>
                </div>
                <div>
                    <h4 class="thin-text"><?php echo e(__('Today is')); ?> <?php echo e(now()->englishDayOfWeek); ?>

                        <?php echo e(now()->format(env('Date_Format'))); ?></h4>
                </div>
            </div>

            <div class="card">
                <div class="card-body">
                    <form method="post" action="<?php echo e(url('admin/dashboard')); ?>" id="filter_form" class="form-horizontal">
                        <?php echo csrf_field(); ?>
                        <div class="row align-items-center">
                            <div class="col-md-3">
                                <div class="form-group mb-0">
                                    <input class="form-control date" placeholder="<?php echo e(__('Start Date')); ?>" readonly=""
                                        id="start_date" name="start_date" type="text" required
                                        value="<?php echo e($start_date); ?>">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group mb-0">
                                    <input class="form-control date" placeholder="<?php echo e(__('End Date')); ?>" readonly=""
                                        id="end_date" name="end_date" type="text" required value="<?php echo e($end_date); ?>">
                                </div>
                            </div>
							<div class="col-md-3">
                                <div class="form-group mb-0">
                                    <div class="form-group">
										<select class="form-control ss selectpicker dynamic" name="filter_gender" id="filter_gender" data-placeholder="Gender"
											data-column="1" tabindex="-1" aria-hidden="true">
											<option value=""><?php echo e(__('Gender')); ?></option>
											<option value="Male"><?php echo e(__('Male')); ?></option>
											<option value="Female"><?php echo e(__('Female')); ?></option>
											<?php echo e(csrf_field()); ?>

										</select>
									</div>
                                </div>
                            </div>
							<div class="col-md-3">
                                <div class="form-group mb-0">
                                    <div class="form-group">
										<select class="form-control ss selectpicker dynamic" name="filter_marital" id="filter_marital" data-placeholder="Marital Status"
											data-column="1" tabindex="-1" aria-hidden="true">
											<option value=""><?php echo e(__('Marital Status')); ?></option>
											<option value="married"><?php echo e(__('Married')); ?></option>
											<option value="single"><?php echo e(__('Single')); ?></option>
											<option value="divorced"><?php echo e(__('Divorced')); ?></option>
											<?php echo e(csrf_field()); ?>

										</select>
									</div>
                                </div>
                            </div>
							<div class="col-md-3">
                                <div class="form-group mb-0">
                                    <div class="form-group">
										<select class="form-control ss selectpicker dynamic" name="filter_religion" id="filter_religion" data-placeholder="Religion"
											data-column="1" tabindex="-1" aria-hidden="true">
											<option value=""><?php echo e(__('Religion')); ?></option>
											<option value="islam"><?php echo e(__('Islam')); ?></option>
											<option value="kristen"><?php echo e(__('Kristen')); ?></option>
											<option value="katholik"><?php echo e(__('Katholik')); ?></option>
											<option value="hindu"><?php echo e(__('Hindu')); ?></option>
											<option value="budha"><?php echo e(__('Budha')); ?></option>
											<option value="konghucu"><?php echo e(__('Konghucu')); ?></option>
											<option value="lainnya"><?php echo e(__('Lainnya')); ?></option>
											<option value="kepercayaan"><?php echo e(__('Kepercayaan Terhadap Tuhan YME')); ?></option>
											<?php echo e(csrf_field()); ?>

										</select>
									</div>
                                </div>
                            </div>
                        </div>
						<div class="clearfix">&nbsp;</div>
						<div class="row align-items-center">
							
                            <div class="col-md-3">
                                <button type="submit" class="filtering btn btn-primary">
                                    <?php echo e(__('Filter')); ?>

                                </button>
                            </div>
                            <div class="col-md-3">
                                <h3><?php echo e(__('Employee Amount')); ?> : <?php echo e($employees->count()); ?></h3>
                            </div>
						</div>
                    </form>
                </div>
            </div>
			<div class="row">
				<?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<div class="col-md-3 align-items-center">
						<div class="card card-item" id="card_absent">
							<div class="card-body">
								<div class="row">
									<div class="col-md-6">
										<h3 id="employee_count"><?php echo e($company->employees()->where('is_active', 1)->whereNull('exit_date')->whereIn('gender', $gender)->whereIn('marital_status', $marital)->whereIn('religion', $religion)->count()); ?></h3>
										<p class="mb-0"><?php echo e($company->company_name); ?></p>
										<br>
									</div>
									<div class="col-md-6">
										<?php if($company->company_logo != null): ?>
											<img class="card-img-top" src="<?php echo e(asset('uploads/company_logo')); ?>/<?php echo e($company->company_logo); ?>" alt="Company Logo">
										<?php else: ?>
											<img class="card-img-top" src="<?php echo e(asset('logo/avatar.jpg')); ?>" alt="Card image">
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</div>
			<div class="row">
				<?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<?php
					$companies = $location->companies;
					$totalEmployeeCount = 0;
					foreach ($companies as $company) {
						$employeeCount = $company->employees()->where('is_active', 1)->whereNull('exit_date')->whereIn('gender', $gender)->whereIn('marital_status', $marital)->whereIn('religion', $religion)->count();
						$totalEmployeeCount += $employeeCount;
					}
					?>
					<div class="col-md-3 align-items-center">
						<div class="card card-item" id="card_absent">
							<div class="card-body">
								<div class="row">
									<div class="col-md-6">
										<h3 id="absent_count"><?php echo e($location->employees_count); ?></h3>
										<p class="mb-0"><?php echo e($location->location_name); ?></p>
										<br>
									</div>
									<div class="col-md-6">
										<img class="card-img-top" src="<?php echo e(asset('logo/avatar.jpg')); ?>" alt="Card image">
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</div>
            <div class="row">
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_absent">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="absent_count"><?php echo e($absent_count); ?></h3>
                                    <p class="mb-0"><?php echo e(__('Absent')); ?></p>
                                    <br>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="absentChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_under_work">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="under_work_count"><?php echo e($under_work_count); ?></h3>
                                    <p class="mb-0"><?php echo e(__('Work Time < 9 Hours')); ?></p>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="underWorkChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_late">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="late_count"><?php echo e($late_count); ?></h3>
                                    <p class="mb-0"><?php echo e(__('Late')); ?></p>
                                    <br>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="lateChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_over_work">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="over_work_count"><?php echo e($over_work_count); ?></h3>
                                    <p class="mb-0"><?php echo e(__('Work Time > 11 Hours')); ?></p>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="overWorkChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_in_after_eight">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="in_after_eight_count"><?php echo e($in_after_eight_count); ?></h3>
                                    <p class="mb-0"><?php echo e(__('Clock In After 08:15')); ?></p>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="inAfterEightChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_out_before_five">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="out_before_five_count"><?php echo e($out_before_five_count); ?></h3>
                                    <p class="mb-0"><?php echo e(__('Clock Out Before 17:15')); ?></p>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="outBeforeFiveChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_in_after_three">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="out_before_five_count"><?php echo e($in_after_three_count); ?></h3>
                                    <p class="mb-0"><?php echo e(__('Clock In After 15:15')); ?></p>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="inAfterThreeChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_out_before_eleven">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="out_before_five_count"><?php echo e($out_before_eleven_count); ?></h3>
                                    <p class="mb-0"><?php echo e(__('Clock Out Before 23:15')); ?></p>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="outBeforeElevenChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_in_after_eleven">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="in_after_eleven_count"><?php echo e($in_after_eleven_count); ?></h3>
                                    <p class="mb-0"><?php echo e(__('Clock In After 23:15')); ?></p>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="inAfterElevenChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 align-items-center">
                    <div class="card card-item" id="card_out_before_eight">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h3 id="out_before_eight_count"><?php echo e($out_before_eight_count); ?></h3>
                                    <p class="mb-0"><?php echo e(__('Clock Out Before 08:15')); ?></p>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="outBeforeEightChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div id="modal_detail" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 id="exampleModalLabel" class="modal-title"><?php echo e(__('Add Employee')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <div class="table-responsive">
                        <table id="dashboard-table" class="table ">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Employee')); ?></th>
                                    <th><?php echo e(__('Total')); ?></th>
                                    <th><?php echo e(__('Detail')); ?></th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        (function($) {
            "use strict";
            $(document).ready(function() {

                let date = $('.date');
                date.datepicker({
                    format: '<?php echo e(env('Date_Format_JS')); ?>',
                    autoclose: true,
                    todayHighlight: true,
                    endDate: new Date()
                });

            });
        })(jQuery);

        $('.card-item').click(function() {
            $('#modal_detail').modal('show');
            var title = $(this).find('p:first').text();
            var id = $(this).attr('id');
            $('.modal-title').text("<?php echo e(__('Detail')); ?>" + ' ' + title);
            var startDate = $('#start_date').val();
            var endDate = $('#end_date').val();
            var type;
            switch (id) {
                case 'card_absent':
                    type = 'absent';
                    break;
                case 'card_under_work':
                    type = 'under_work';
                    break;
                case 'card_late':
                    type = 'late';
                    break;
                case 'card_over_work':
                    type = 'over_work';
                    break;
                case 'card_in_after_eight':
                    type = 'in_after_eight';
                    break;
                case 'card_out_before_five':
                    type = 'out_before_five';
                    break;
                case 'card_in_after_three':
                    type = 'in_after_three';
                    break;
                case 'card_out_before_eleven':
                    type = 'out_before_eleven';
                    break;
                case 'card_in_after_eleven':
                    type = 'in_after_eleven';
                    break;
                case 'card_out_before_eight':
                    type = 'out_before_eight';
                    break;
                default:
                    type = 'absent';
            }
            fill_datatable(startDate, endDate, type);
        });

        function fill_datatable(startDate = '', endDate = '', type = 'absent') {

            let table_table = $('#dashboard-table').DataTable({
                responsive: true,
                fixedHeader: {
                    header: true,
                },
                processing: true,
                serverSide: true,
                bDestroy: true,
                ajax: {
                    url: "<?php echo e(url('admin/dashboard/detail')); ?>",
                    data: {
                        type: type,
                        start_date: startDate,
                        end_date: endDate,
                        "_token": "<?php echo e(csrf_token()); ?>"
                    }
                },

                columns: [{
                        data: 'employee_name',
                        name: 'employee_name'
                    },
                    {
                        data: 'total',
                        name: 'total',
                    },
                    {
                        data: 'detail',
                        name: 'detail'
                    },
                ],


                "order": [],
                'language': {
                    'lengthMenu': '_MENU_ <?php echo e(__('records per page')); ?>',
                    "info": '<?php echo e(trans('file.Showing')); ?> _START_ - _END_ (_TOTAL_)',
                    "search": '<?php echo e(trans('file.Search')); ?>',
                    'paginate': {
                        'previous': '<?php echo e(trans('file.Previous')); ?>',
                        'next': '<?php echo e(trans('file.Next')); ?>'
                    }
                },

                'columnDefs': [{
                    "orderable": true,
                }],

                'select': {
                    style: 'multi',
                    selector: 'td:first-child'
                },
                'lengthMenu': [
                    [10, 25, 50, -1],
                    [10, 25, 50, "All"]
                ],
            });
            new $.fn.dataTable.FixedHeader(table_table);
        }

        let charts = ['absentChart', 'underWorkChart', 'lateChart', 'overWorkChart', 'inAfterEightChart',
            'outBeforeFiveChart', 'inAfterThreeChart', 'outBeforeElevenChart', 'inAfterElevenChart',
            'outBeforeEightChart'
        ];
        let chartLabels = ["<?php echo e(__('Absent')); ?>", "<?php echo e(__('Work Time < 9 Hours')); ?>", "<?php echo e(__('Late')); ?>",
            "<?php echo e(__('Work Time > 11 Hours')); ?>", "<?php echo e(__('Clock In After 08:15')); ?>",
            "<?php echo e(__('Clock Out Before 17:15')); ?>", "<?php echo e(__('Clock In After 15:15')); ?>",
            "<?php echo e(__('Clock Out Before 23:15')); ?>", "<?php echo e(__('Clock In After 23:15')); ?>",
            "<?php echo e(__('Clock Out Before 08:15')); ?>"
        ];
        let chartData = [
            "<?php echo e($absent_count); ?>" / ("<?php echo e($employees->count()); ?>" * "<?php echo e($total_days); ?>"),
            "<?php echo e($under_work_count); ?>" / "<?php echo e($attendance_count != 0 ? $attendance_count : '1'); ?>",
            "<?php echo e($late_count); ?>" / "<?php echo e($attendance_count != 0 ? $attendance_count : '1'); ?>",
            "<?php echo e($over_work_count); ?>" / "<?php echo e($attendance_count != 0 ? $attendance_count : '1'); ?>",
            "<?php echo e($in_after_eight_count); ?>" / "<?php echo e($attendance_count != 0 ? $attendance_count : '1'); ?>",
            "<?php echo e($out_before_five_count); ?>" / "<?php echo e($attendance_count != 0 ? $attendance_count : '1'); ?>",
            "<?php echo e($in_after_three_count); ?>" / "<?php echo e($attendance_count != 0 ? $attendance_count : '1'); ?>",
            "<?php echo e($out_before_eleven_count); ?>" / "<?php echo e($attendance_count != 0 ? $attendance_count : '1'); ?>",
            "<?php echo e($in_after_eleven_count); ?>" / "<?php echo e($attendance_count != 0 ? $attendance_count : '1'); ?>",
            "<?php echo e($out_before_eight_count); ?>" / "<?php echo e($attendance_count != 0 ? $attendance_count : '1'); ?>"
        ];
        let chartColors = ["#e3342f", "#3490dc", "#6c757d", "#ffed4a", "#6cb2eb", "#e3342f", "#3490dc", "#6c757d",
            "#ffed4a", "#6cb2eb"
        ];

        for (let i = 0; i < charts.length; i++) {
            new Chart(charts[i], {
                type: 'doughnut',
                data: {
                    datasets: [{
                        label: chartLabels[i],
                        percent: (chartData[i] * 100).toFixed(0),
                        backgroundColor: [chartColors[i]]
                    }]
                },
                plugins: [{
                        beforeInit: (chart) => {
                            const dataset = chart.data.datasets[0];
                            chart.data.labels = [dataset.label];
                            dataset.data = [dataset.percent, 100 - dataset.percent];
                        }
                    },
                    {
                        beforeDraw: (chart) => {
                            var width = chart.chart.width,
                                height = chart.chart.height,
                                ctx = chart.chart.ctx;
                            ctx.restore();
                            var fontSize = (height / 75).toFixed(2);
                            ctx.font = fontSize + "em sans-serif";
                            ctx.fillStyle = "#9b9b9b";
                            ctx.textBaseline = "middle";
                            var text = chart.data.datasets[0].percent + "%",
                                textX = Math.round((width - ctx.measureText(text).width) / 2),
                                textY = height / 2;
                            ctx.fillText(text, textX, textY);
                            ctx.save();
                        }
                    }
                ],
                options: {
                    maintainAspectRatio: false,
                    cutoutPercentage: 70,
                    legend: {
                        display: false,
                    },
                    tooltips: {
                        filter: tooltipItem => tooltipItem.index == 0
                    }
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\hr-management\resources\views/dashboard/admin_dashboard.blade.php ENDPATH**/ ?>