<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
    <title><?php echo e(config('app.name')); ?></title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>


    <link rel="stylesheet" href="<?php echo asset('vendor/bootstrap/css/bootstrap.min.css') ?>" type="text/css">
</head>

<style>
    table {
      border-collapse: collapse;
    }
</style>

<body>
    <table width="100%">
        <tr>
            <td colspan="2" class="text-center">
                <img src="<?php echo e(asset('uploads/company_logo/'.$company['company_logo'])); ?>" width="75" height="75"/><h3><?php echo e($company['company_name']); ?></h3>
            </td>
        </tr>
        <tr>
            <td colspan="2" class="text-center">
                <h4><?php echo e($month_year); ?></h4>
                <hr>
            </td>
        </tr>
        <tr>
            <td>
                <strong><?php echo e($first_name); ?> <?php echo e($last_name); ?></strong>
                <br>
				<?php if(!empty($designation)): ?>
                <span><?php echo e($designation['designation_name']); ?></span>
				<?php endif; ?>
            </td>
        </tr>
        <tr>
            <td>
                <strong>Keterangan</strong>
            </td>
            <td>
                <strong>Jumlah</strong>
            </td>
        </tr>
        <tr>
            <td>
                <strong>Gaji Pokok</strong>
            </td>
            <td>
                <strong>Rp. <?php echo e(number_format($basic_salary, '0', ',', '.')); ?></strong>
            </td>
        </tr>
        <tr>
            <td>
                <strong>Tunjangan Jabatan</strong>
            </td>
            <td>
                <strong>Rp. <?php echo e(number_format($tunjangan_jabatan, '0', ',', '.')); ?></strong>
            </td>
        </tr>
        <tr>
            <td>
                <strong>Uang Kehadiran</strong>
            </td>
            <td>
                <strong>Rp. <?php echo e(number_format($salary_kehadiran, '0', ',', '.')); ?></strong>
            </td>
        </tr>
        <?php $__currentLoopData = $allowances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allowance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
                <?php echo e($allowance->allowance_title); ?>

            </td>
            <td>
                Rp. <?php echo e(number_format($allowance->allowance_amount, '0', ',', '.')); ?> x <?php echo e($work_days); ?> hari kerja
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php $__currentLoopData = $overtimes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $overtime): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
                <?php echo e($overtime->overtime_title); ?>

            </td>
            <td>
                Rp. <?php echo e(number_format($overtime->overtime_amount, '0', ',', '.')); ?> ( <?php echo e($overtime->hours); ?> jam )
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php $__currentLoopData = $commissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commision): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
                <?php echo e($commision->commision_title); ?>

            </td>
            <td>
                Rp. <?php echo e(number_format($commision->commision_amount, '0', ',', '.')); ?>

            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php $__currentLoopData = $other_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $other): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
                <?php echo e($other->$other_payment_title); ?>

            </td>
            <td>
                Rp. <?php echo e(number_format($other->other_payment_amount, '0', ',', '.')); ?>

            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
                <strong>Total</strong>
            </td>
            <td style="border-bottom: 1pt solid black;">
                <strong>Rp. <?php echo e(number_format($basic_salary + $tunjangan_jabatan + $salary_kehadiran + $allowance_amount + $overtimes->sum('overtime_amount') + $commissions->sum('commision_amount') + $other_payments->sum('other_payment_amount'), '0', ',', '.')); ?></strong>
            </td>
        </tr>
        <tr>
            <td colspan="2">&nbsp;&nbsp;</td>
        </tr>
        <tr>
            <td colspan="2">&nbsp;&nbsp;</td>
        </tr>
        <tr>
            <td>
                <strong>Potongan</strong>
            </td>
        </tr>
        <tr>
            <td>
                PPh
            </td>
            <td>
                Rp. <?php echo e(number_format($pph_bulanan, '0', ',', '.')); ?>

            </td>
        </tr>
        <tr>
            <td>
                BPJS Kesehatan
            </td>
            <td>
                Rp. <?php echo e($bpjs_kes); ?>

            </td>
        </tr>
        <tr>
            <td>
                BPJS Jaminan Hari Tua
            </td>
            <td>
                Rp. <?php echo e($bpjs_jht); ?>

            </td>
        </tr>
        <tr>
            <td>
                BPJS Pensiun
            </td>
            <td>
                Rp. <?php echo e($bpjs_pensiun); ?>

            </td>
        </tr>
        <tr>
            <td>
                BPJS Jaminan Kecelakaan Kerja
            </td>
            <td>
                Rp. <?php echo e($bpjs_jkk); ?>

            </td>
        </tr>
        <tr>
            <td>
                BPJS Jaminan Kematian
            </td>
            <td>
                Rp. <?php echo e($bpjs_jkm); ?>

            </td>
        </tr>
        <tr>
            <td>
                Potongan Absen
            </td>
            <td>
                Rp. <?php echo e($attendance_cut_amount); ?>

            </td>
        </tr>
        <?php $__currentLoopData = $deductions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deduction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
                <?php echo e($deduction->deduction_title); ?>

            </td>
            <td>
                Rp. <?php echo e($deduction->deduction_amount); ?>

            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
                <?php echo e($loan->loan_title); ?>

            </td>
            <td>
                Rp. <?php echo e($loan->monthly_payable); ?>

            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td colspan="2">&nbsp;&nbsp;</td>
        </tr>
        <tr>
            <td>
                <strong>Total Diterima</strong>
            </td>
            <td>
                <strong><u>Rp. <?php echo e($total_salary); ?></u></strong>
            </td>
        </tr>
        <tr>
            <td colspan="2">&nbsp;&nbsp;</td>
        </tr>
        <tr>
            <td>Tanda Terima</td>
            <td><?php echo e($company['location']['city']); ?>,</td>
        </tr>
        <tr>
            <td colspan="2">&nbsp;&nbsp;</td>
        </tr>
        <tr>
            <td><strong><?php echo e($first_name); ?> <?php echo e($last_name); ?></strong></td>
            <td></td>
        </tr>
        <tr>
            <td colspan="2">&nbsp;&nbsp;</td>
        </tr>
    </table>
</body>

</html>

<?php /**PATH C:\laragon\www\hr-timas\resources\views/salary/payslip/export.blade.php ENDPATH**/ ?>