<?php

namespace App\Console\Commands;

use App\Employee;
use Carbon\Carbon;
use Illuminate\Console\Command;

class NewEmployeeLeave extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'leave:newEmployee';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Set new employee leave';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $now = Carbon::now();
        $month = $now->month();
        if ($month == 1) {
            return;
        }
        $lastYear = $now->year() - 1;
        $employees = Employee::with('company')->whereYear('joining_date', '=', $lastYear)
            ->whereMonth('joining_date', '=', $month)->get();
        foreach ($employees as $employee) {
            $employee->remaining_leave = $employee->company->leave_amount - $month + 1;
            $employee->save();
        }
    }
}
