<?php

namespace App\Console\Commands;

use App\Attendance;
use App\Employee;
use App\GeneralSetting;
use App\RawAttendance;
use App\ReportAttendance;
use Carbon\Carbon;
use Illuminate\Console\Command;

class ProcessRawAttendance extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rawAttendance:process';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Process raw attendances';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
		$employees = Employee::where('is_active', 1)->where('id', 93)->get();
		$today = now()->format('Y-m-d');
		//echo 'updating '.$today.'<br />';
		foreach($employees as $employee) {
			$day = Carbon::parse($today)->format('l');
			$holidays = $employee->company->companyHolidays;
			$dateToCheck = Carbon::parse($today);
			$isHoliday = false;
			foreach ($holidays as $holiday) {
				$startDate = Carbon::parse($holiday['start_date']);
				$endDate = Carbon::parse($holiday['end_date']);
				if ($dateToCheck->between($startDate, $endDate)) {
					$isHoliday = true;
					break;
				}
			}
			$attendances = RawAttendance::where('attendance_date', $today)->where('employee_id', $employee->id)->get();
			if($attendances->isEmpty() AND $isHoliday == false AND $day != 'Saturday' AND $day != 'Sunday') {
				Attendance::updateOrCreate(
				[
					'employee_id' => $employee->id,
					'attendance_date' => $today
				],
				[
					'employee_id' => $employee->id,
					'attendance_date' => $today,
					'clock_in' => '00:00',
					'clock_out' => '00:00',
					'total_work' => '00:00',
					'status' => 'TA3',
				]);
				ReportAttendance::updateOrCreate(
				[
					'employee_id' => $employee->id,
					'attendance_date' => $today
				], 
				[
					'employee_id' => $employee->id,
					'attendance_date' => $today,
					'work_time' => '00:00',
					'status' => 'TA3',
					'office_shift_id' => $employee->office_shift_id,
					'is_underwork' => false,
				]);
			} elseif($attendances->isEmpty() AND $isHoliday == true) {
				echo 'Hari libur<br />';
			} elseif($attendances->isEmpty() AND $day == 'Saturday') {
				echo 'Hari Sabtu<br />';
			} elseif($attendances->isEmpty() AND $day == 'Sunday') {
				echo 'Hari Minggu<br />';
			} else {
				foreach($attendances as $attendance) {
					if(isset($employee->officeShift))
					{
						switch ($day) {
							case 'Sunday':
								$clockInRange = $employee->officeShift->sunday_range_in;
								$clockOutRange = $employee->officeShift->sunday_range_out;
								$clockIn = $employee->officeShift->sunday_in;
								$clockOut = $employee->officeShift->sunday_out;
								break;
							case 'Monday':
								$clockInRange = $employee->officeShift->monday_range_in;
								$clockOutRange = $employee->officeShift->monday_range_out;
								$clockIn = $employee->officeShift->monday_in;
								$clockOut = $employee->officeShift->monday_out;
								break;
							case 'Tuesday':
								$clockInRange = $employee->officeShift->tuesday_range_in;
								$clockOutRange = $employee->officeShift->tuesday_range_out;
								$clockIn = $employee->officeShift->tuesday_in;
								$clockOut = $employee->officeShift->tuesday_out;
								break;
							case 'Wednesday':
								$clockInRange = $employee->officeShift->wednesday_range_in;
								$clockOutRange = $employee->officeShift->wednesday_range_out;
								$clockIn = $employee->officeShift->wednesday_in;
								$clockOut = $employee->officeShift->wednesday_out;
								break;
							case 'Thursday':
								$clockInRange = $employee->officeShift->thursday_range_in;
								$clockOutRange = $employee->officeShift->thursday_range_out;
								$clockIn = $employee->officeShift->thursday_in;
								$clockOut = $employee->officeShift->thursday_out;
								break;
							case 'Friday':
								$clockInRange = $employee->officeShift->friday_range_in;
								$clockOutRange = $employee->officeShift->friday_range_out;
								$clockIn = $employee->officeShift->friday_in;
								$clockOut = $employee->officeShift->friday_out;
								break;
							default:
								$clockInRange = $employee->officeShift->saturday_range_in;
								$clockOutRange = $employee->officeShift->saturday_range_out;
								$clockIn = $employee->officeShift->saturday_in;
								$clockOut = $employee->officeShift->saturday_out;
						}
					}
					$clockInRange = Carbon::createFromTimeString($clockInRange);
					$time = $attendance->attendance_time;
					$clockOutRange = Carbon::createFromTimeString($clockOutRange);
					$clockIn = Carbon::createFromTimeString($clockIn);
					$clockOut = Carbon::createFromTimeString($clockOut);
					$minWorkTime = $employee->officeShift->min_work_hour;
					$inTime = Carbon::createFromTimeString($time);
					$employeeClock = Carbon::createFromTimeString($time)->format('H:i');
					$noon = Carbon::createFromTimeString('12:00:00');
					echo 'hari '.$day.'  ';
					echo 'in time '.$inTime.' : clock in range '.$clockInRange.' and clock out range '.$clockOutRange.PHP_EOL;
					if($employee->officeShift->shift_name == 'Non Shift') {
						if($inTime->greaterThanOrEqualTo($clockInRange) AND $inTime->lessThanOrEqualTo($noon)) {
							echo $employeeClock.'<br />';
							Attendance::updateOrCreate(
							[
								'employee_id' => $employee->id,
								'attendance_date' => $today
							], 		
							[
								'employee_id' => $employee->id,
								'attendance_date' => $today,
								'clock_in' => $employeeClock,
								'clock_out' => '00:00',
								'total_work' => '00:00',
								'status' => 'TA2',
							]);
							
							ReportAttendance::updateOrCreate(
							[
								'employee_id' => $employee->id,
								'attendance_date' => $today
							], 
							[
								'employee_id' => $employee->id,
								'attendance_date' => $today,
								'work_time' => '00:00',
								'status' => 'TA2',
								'office_shift_id' => $employee->office_shift_id,
								'is_underwork' => false,
							]);
							echo 'update absen masuk'.PHP_EOL;
						} elseif($inTime->greaterThanOrEqualTo($noon) AND $inTime->lessThanOrEqualTo($clockOutRange)) {
							$employee_now = Employee::find($employee->id);
							$attendance_now = $employee_now->employeeAttendance->where('attendance_date', $today)->first();
							if(!empty($attendance_now)) {
								$workTime = Carbon::createFromTimeString($inTime)->diff(Carbon::createFromTimeString($attendance_now['clock_in']))->format('%H:%I');
								$status = '';
								$clock_in = $attendance_now['clock_in'];
							} else {
								$status = 'TA1';
								$clock_in = '00:00';
								$workTime = '00:00';
							}
							if (Carbon::createFromTimeString($workTime)->hour < $minWorkTime) {
								$isUnderwork = true;
							} else {
								$isUnderwork = false;
							}
							Attendance::updateOrCreate(
							[
								'employee_id' => $employee->id,
								'attendance_date' => $today
							],
							[
								'employee_id' => $employee->id,
								'attendance_date' => $today,
								'clock_in' => $clock_in,
								'clock_out' => $employeeClock,
								'total_work' => $workTime,
								'status' => $status,
								'is_underwork' => $isUnderwork,
							]);
							
							ReportAttendance::updateOrCreate(
							[
								'employee_id' => $employee->id,
								'attendance_date' => $today
							],
							[
								'employee_id' => $employee->id,
								'attendance_date' => $today,
								'work_time' => $workTime,
								'status' => $status,
								'office_shift_id' => $employee->office_shift_id,
								'is_underwork' => $isUnderwork,
							]);
							echo 'update absen pulang'.PHP_EOL;
						} else {
							
						}
					} else {
						if($clockInRange == $clockOutRange) {
							echo 'Update Shift 24 jam'.PHP_EOL;
							$employee_now = Employee::find($employee->id);
							$attendance_now = $employee_now->employeeAttendance->where('attendance_date', $today)->first();
							if(!empty($attendance_now)) {
								$clock_in = $attendance_now['clock_in'];
								echo 'Udah ada record'.PHP_EOL;
								$jam_masuk = Carbon::createFromTimeString($attendance_now['clock_in'])->format('H');
								$jam_keluar = Carbon::createFromTimeString($attendance_now['clock_out'])->format('H');
								$jam_absen = Carbon::createFromTimeString($employeeClock)->format('H');
								if($jam_masuk == $jam_absen) {
									Attendance::updateOrCreate(
									[
										'employee_id' => $employee->id,
										'attendance_date' => $today
									],
									[
										'employee_id' => $employee->id,
										'attendance_date' => $today,
										'clock_in' => $employeeClock,
									]);
								} else {
									$workTime = Carbon::createFromTimeString($inTime)->diff(Carbon::createFromTimeString($attendance_now['clock_in']))->format('%H:%I');
									Attendance::updateOrCreate(
									[
										'employee_id' => $employee->id,
										'attendance_date' => $today
									],
									[
										'employee_id' => $employee->id,
										'attendance_date' => $today,
										'clock_in' => $clock_in,
										'clock_out' => $employeeClock,
										'total_work' => $workTime,
										'status' => '',
									]);
									ReportAttendance::updateOrCreate(
									[
										'employee_id' => $employee->id,
										'attendance_date' => $today
									], 
									[
										'employee_id' => $employee->id,
										'attendance_date' => $today,
										'work_time' => $workTime,
										'status' => '',
										'office_shift_id' => $employee->office_shift_id,
										'is_underwork' => false,
									]);
								}
									
							} else {
								echo 'Belum ada record <br />';
								Attendance::updateOrCreate(
								[
									'employee_id' => $employee->id,
									'attendance_date' => $today
								],
								[
									'employee_id' => $employee->id,
									'attendance_date' => $today,
									'clock_in' => $employeeClock,
									'clock_out' => '00:00',
									'total_work' => '00:00',
									'status' => 'TA2',
								]);
								ReportAttendance::updateOrCreate(
								[
									'employee_id' => $employee->id,
									'attendance_date' => $today
								], 
								[
									'employee_id' => $employee->id,
									'attendance_date' => $today,
									'work_time' => '00:00',
									'status' => 'TA2',
									'office_shift_id' => $employee->office_shift_id,
									'is_underwork' => false,
								]);
							}
						} else {
							echo 'Shift 123<br />';
							if($clockIn > $clockOut) {
								$clockOut->addHours(24);
							}
							$halfIn = $clockIn->addHours(4);
							$halfOut = $clockOut->subHours(4);
							if($inTime->greaterThanOrEqualTo($clockInRange) AND $inTime->lessThanOrEqualTo($halfIn)) {
								echo $employeeClock.'<br />';
								Attendance::updateOrCreate(
								[
									'employee_id' => $employee->id,
									'attendance_date' => $today
								], 		
								[
									'employee_id' => $employee->id,
									'attendance_date' => $today,
									'clock_in' => $employeeClock,
									'clock_out' => '00:00',
									'total_work' => '00:00',
									'status' => 'TA2',
								]);
								
								ReportAttendance::updateOrCreate(
								[
									'employee_id' => $employee->id,
									'attendance_date' => $today
								], 
								[
									'employee_id' => $employee->id,
									'attendance_date' => $today,
									'work_time' => '00:00',
									'status' => 'TA2',
									'office_shift_id' => $employee->office_shift_id,
									'is_underwork' => false,
								]);
							} elseif($inTime->greaterThanOrEqualTo($halfOut) AND $inTime->lessThanOrEqualTo($clockOutRange)) {
								$employee_now = Employee::find($employee->id);
								$attendance_now = $employee_now->employeeAttendance->where('attendance_date', $today)->first();
								//dump($attendance_now);
								if(!empty($attendance_now)) {
									$workTime = Carbon::createFromTimeString($inTime)->diff(Carbon::createFromTimeString($attendance_now['clock_in']))->format('%H:%I');
									$status = '';
									$clock_in = $attendance_now['clock_in'];
								} else {
									$status = 'TA1';
									$clock_in = '00:00';
									$workTime = '00:00';
								}
								if (Carbon::createFromTimeString($workTime)->hour < $minWorkTime) {
									$isUnderwork = true;
								} else {
									$isUnderwork = false;
								}
								Attendance::updateOrCreate(
								[
									'employee_id' => $employee->id,
									'attendance_date' => $today
								],
								[
									'employee_id' => $employee->id,
									'attendance_date' => $today,
									'clock_in' => $clock_in,
									'clock_out' => $employeeClock,
									'total_work' => $workTime,
									'status' => $status,
								]);
								
								ReportAttendance::updateOrCreate(
								[
									'employee_id' => $employee->id,
									'attendance_date' => $today
								],
								[
									'employee_id' => $employee->id,
									'attendance_date' => $today,
									'work_time' => $workTime,
									'status' => $status,
									'office_shift_id' => $employee->office_shift_id,
									'is_underwork' => $isUnderwork,
								]);
								echo 'update absen<br />';
							} else {
								
							}
						}
					}
				}
			}
		}
        /*$skip = false;
        $cronTime = GeneralSetting::first()->cron_job_attendance_time;
        $now = (int) Carbon::now()->format('d');
        $rows = RawAttendance::whereHas('employee.company', function ($query) use ($now, $cronTime) {
            return $query->where('end_cut_off_date', '=', $now + $cronTime);
        })->get();
		echo $rows->count();
        foreach ($rows as $key => $row) {
            $date = $row['attendance_date'];
            $time = $row['attendance_time'];

            $employee = Employee::with(['officeShift'])->find($row['employee_id']);

            $day = Carbon::parse($date)->format('l');

            switch ($day) {
                case 'Sunday':
                    $clockInRange = $employee->officeShift::first()->sunday_range_in;
                    $clockOutRange = $employee->officeShift::first()->sunday_range_out;
                    $clockIn = $employee->officeShift::first()->sunday_in;
                    $clockOut = $employee->officeShift::first()->sunday_out;
                    break;
                case 'Monday':
                    $clockInRange = $employee->officeShift::first()->monday_range_in;
                    $clockOutRange = $employee->officeShift::first()->monday_range_out;
                    $clockIn = $employee->officeShift::first()->monday_in;
                    $clockOut = $employee->officeShift::first()->monday_out;
                    break;
                case 'Tuesday':
                    $clockInRange = $employee->officeShift::first()->tuesday_range_in;
                    $clockOutRange = $employee->officeShift::first()->tuesday_range_out;
                    $clockIn = $employee->officeShift::first()->tuesday_in;
                    $clockOut = $employee->officeShift::first()->tuesday_out;
                    break;
                case 'Wednesday':
                    $clockInRange = $employee->officeShift::first()->wednesday_range_in;
                    $clockOutRange = $employee->officeShift::first()->wednesday_range_out;
                    $clockIn = $employee->officeShift::first()->wednesday_in;
                    $clockOut = $employee->officeShift::first()->wednesday_out;
                    break;
                case 'Thursday':
                    $clockInRange = $employee->officeShift::first()->thursday_range_in;
                    $clockOutRange = $employee->officeShift::first()->thursday_range_out;
                    $clockIn = $employee->officeShift::first()->thursday_in;
                    $clockOut = $employee->officeShift::first()->thursday_out;
                    break;
                case 'Friday':
                    $clockInRange = $employee->officeShift::first()->friday_range_in;
                    $clockOutRange = $employee->officeShift::first()->friday_range_out;
                    $clockIn = $employee->officeShift::first()->friday_in;
                    $clockOut = $employee->officeShift::first()->friday_out;
                    break;
                default:
                    $clockInRange = $employee->officeShift::first()->saturday_range_in;
                    $clockOutRange = $employee->officeShift::first()->saturday_range_out;
                    $clockIn = $employee->officeShift::first()->saturday_in;
                    $clockOut = $employee->officeShift::first()->saturday_out;
            }

            $match = [
                'employee_id' => $row['employee_id'],
                'attendance_date' => $date,
            ];
            $matchRaw = [
                'employee_id' => $row['employee_id'],
                'attendance_date' => $date,
                'attendance_time' => $time
            ];
            $matchAttendance = [
                'employee_id' => $row['employee_id'],
                'attendance_date' => $date,
            ];

            RawAttendance::updateOrCreate($matchRaw, [
                'employee_id' => $row['employee_id'],
                'attendance_date' => $date,
                'attendance_time' => $time
            ]);

            $clockInRange = Carbon::createFromTimeString($clockInRange);
            $clockOutRange = Carbon::createFromTimeString($clockOutRange);
            $clockIn = Carbon::createFromTimeString($clockIn);
            $clockOut = Carbon::createFromTimeString($clockOut);
            $minWorkTime = Employee::with('officeShift')->find($row['employee_id'])->officeShift->min_work_hour;

            if ($skip) {
                $skip = false;
                continue;
            }

            $in = $row;
            $inTimeString = $in['attendance_time'];
            if (isset($rows[$key + 1])) {
                $out = $rows[$key + 1];
                $match = [
                    'employee_id' => $in['employee_id'],
                    'attendance_date' => $date,
                ];
                $outTimeString = $out['attendance_time'];
                $outDate = $out['attendance_date'];
                $inTime = Carbon::createFromTimeString($inTimeString);
                $outTime = Carbon::createFromTimeString($outTimeString);
                $workTime = '00:00';
                $employeeClockIn = Carbon::createFromTimeString($inTimeString)->format('H:i');
                $employeeClockOut = Carbon::createFromTimeString($outTimeString)->format('H:i');
                $status = null;
                $isUnderwork = false;

                if ($in['employee_id'] == $out['employee_id']) {
                    if ($date == $outDate) {
                        $workTime = $outTime->diff($inTime)->format('%H:%I');
                    } else {
                        $diffSec = $outTime->diffInSeconds($inTime);
                        $workTime = Carbon::createFromTimeString('00:00')->subSeconds($diffSec)->format('H:i');
                        if ($inTime->greaterThan($clockIn)) {
                            $employeeClockOut = $employeeClockIn;
                            $employeeClockIn = '';
                            $status = 'TA1';
                            $workTime = '00:00';
                        } else if ($inTime->greaterThanOrEqualTo($clockInRange) && $inTime->lessThan($clockIn)) {
                            if ($outTime->greaterThanOrEqualTo($clockInRange)) {
                                $status = 'TA2';
                                $workTime = '00:00';
                                $employeeClockOut = '';
                            } else {
                                $skip = true;
                            }
                        } else if ($outTime->greaterThanOrEqualTo($clockInRange)) {
                            $status = 'TA2';
                        } else {
                            $employeeClockOut = Carbon::createFromTimeString($outTimeString)->format('H:i');
                            $skip = true;
                        }
                    }
                } else {
                    $status = 'TA2';
                }

                if (Carbon::createFromTimeString($workTime)->hour < $minWorkTime) {
                    $isUnderwork = true;
                }

                Attendance::updateOrCreate($matchAttendance, [
                    'employee_id' => $in['employee_id'],
                    'attendance_date' => $date,
                    'clock_in' => $employeeClockIn,
                    'clock_out' => $employeeClockOut,
                    'total_work' => $workTime
                ]);

                ReportAttendance::updateOrCreate($match, [
                    'employee_id' => $in['employee_id'],
                    'attendance_date' => $date,
                    'work_time' => $workTime,
                    'status' => $status,
                    'is_underwork' => $isUnderwork
                ]);
            } else {
                $checkAttendance = Attendance::where([['employee_id', '=', $in['employee_id']], ['attendance_date', '=', $date]])->first();
                if ($checkAttendance != null) {
                    return;
                }

                $time = Carbon::createFromTimeString($inTimeString);
                $workTime = '00:00';
                $employeeClockIn = '';
                $employeeClockOut = '';
                $status = null;
                $isUnderwork = false;

                if ($time->greaterThan($clockIn)) {
                    $employeeClockOut = $time->format('H:i');
                    $status = 'TA1';
                } else {
                    $employeeClockIn = $time->format('H:i');
                    $status = 'TA2';
                }

                Attendance::updateOrCreate($matchAttendance, [
                    'employee_id' => $in['employee_id'],
                    'attendance_date' => $date,
                    'clock_in' => $employeeClockIn,
                    'clock_out' => $employeeClockOut,
                    'total_work' => $workTime
                ]);

                ReportAttendance::updateOrCreate($match, [
                    'employee_id' => $in['employee_id'],
                    'attendance_date' => $date,
                    'work_time' => $workTime,
                    'status' => $status,
                    'is_underwork' => $isUnderwork
                ]);
            }
            //Following attendance
            // $employee = Employee::find($in['employee_id']);
            // $followingEmployees = Employee::where('following_employee_id', $employee->following_employee_id)->get();
            // foreach ($followingEmployees as $followingEmployee) {
            //     Attendance::updateOrCreate([
            //         'employee_id' => $followingEmployee->id,
            //         'attendance_date' => $date,
            //         'clock_in' => Carbon::createFromTimeString($in['attendance_time'])->format('H:i'),
            //         'clock_out' => $clockOut,
            //         'total_work' => $workTime
            //     ]);
            // }
        }*/
    }
}
